/*
 * Decompiled with CFR 0.152.
 */
package piman.recievermod.items.animations;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.Event;
import piman.recievermod.capabilities.itemdata.ItemDataProvider;
import piman.recievermod.items.ItemPropertyWrapper;
import piman.recievermod.items.guns.ItemGun;
import piman.recievermod.util.handlers.RenderPartialTickHandler;

public interface IAnimationController {
    public List<ItemPropertyWrapper> getProperties();

    public void update(ItemStack var1, World var2, PlayerEntity var3, int var4, boolean var5, CompoundNBT var6, ItemGun var7);

    public static ItemPropertyWrapper booleanProperty(String name, boolean showInInvenotry) {
        return new ItemPropertyWrapper(name, (stack, worldIn, entity) -> {
            if (worldIn == null && showInInvenotry) {
                worldIn = Minecraft.func_71410_x().field_71441_e;
            }
            if (!stack.func_77942_o() || worldIn == null) {
                return 0.0f;
            }
            return ((Float)worldIn.getCapability(ItemDataProvider.ITEMDATA_CAP).map(iItemData -> {
                CompoundNBT nbt = iItemData.getItemData().func_74775_l(stack.func_196082_o().func_74779_i("UUID"));
                CompoundNBT oldNBT = nbt.func_74775_l("prev");
                float pt = RenderPartialTickHandler.renderPartialTick;
                return Float.valueOf((oldNBT.func_74767_n(name) ? 1.0f : 0.0f) * (1.0f - pt) + (nbt.func_74767_n(name) ? 1.0f : 0.0f) * pt);
            }).orElse((Object)Float.valueOf(0.0f))).floatValue();
        });
    }

    public static ItemPropertyWrapper stringProperty(String name, boolean showInInvenotry) {
        return new ItemPropertyWrapper(name, (stack, worldIn, entity) -> {
            if (worldIn == null && showInInvenotry) {
                worldIn = Minecraft.func_71410_x().field_71441_e;
            }
            if (!stack.func_77942_o() || worldIn == null) {
                return 0.0f;
            }
            return ((Float)worldIn.getCapability(ItemDataProvider.ITEMDATA_CAP).map(iItemData -> {
                CompoundNBT nbt = iItemData.getItemData().func_74775_l(stack.func_196082_o().func_74779_i("UUID"));
                CompoundNBT oldNBT = nbt.func_74775_l("prev");
                float pt = RenderPartialTickHandler.renderPartialTick;
                return Float.valueOf((oldNBT.func_74779_i(name).isEmpty() ? 0.0f : 1.0f) * (1.0f - pt) + (nbt.func_74779_i(name).isEmpty() ? 0.0f : 1.0f) * pt);
            }).orElse((Object)Float.valueOf(0.0f))).floatValue();
        });
    }

    public static ItemPropertyWrapper floatProperty(String name, boolean showInInvenotry) {
        return new ItemPropertyWrapper(name, (stack, worldIn, entity) -> {
            if (worldIn == null && showInInvenotry) {
                worldIn = Minecraft.func_71410_x().field_71441_e;
            }
            if (!stack.func_77942_o() || worldIn == null) {
                return 0.0f;
            }
            return ((Float)worldIn.getCapability(ItemDataProvider.ITEMDATA_CAP).map(iItemData -> {
                CompoundNBT nbt = iItemData.getItemData().func_74775_l(stack.func_196082_o().func_74779_i("UUID"));
                CompoundNBT oldNBT = nbt.func_74775_l("prev");
                float pt = RenderPartialTickHandler.renderPartialTick;
                return Float.valueOf(oldNBT.func_74760_g(name) * (1.0f - pt) + nbt.func_74760_g(name) * pt);
            }).orElse((Object)Float.valueOf(0.0f))).floatValue();
        });
    }

    public static ItemPropertyWrapper integerProperty(String name, boolean showInInvenotry) {
        return new ItemPropertyWrapper(name, (stack, worldIn, entity) -> {
            if (worldIn == null && showInInvenotry) {
                worldIn = Minecraft.func_71410_x().field_71441_e;
            }
            if (!stack.func_77942_o() || worldIn == null) {
                return 0.0f;
            }
            return ((Float)worldIn.getCapability(ItemDataProvider.ITEMDATA_CAP).map(iItemData -> {
                CompoundNBT nbt = iItemData.getItemData().func_74775_l(stack.func_196082_o().func_74779_i("UUID"));
                CompoundNBT oldNBT = nbt.func_74775_l("prev");
                float pt = RenderPartialTickHandler.renderPartialTick;
                return Float.valueOf((float)oldNBT.func_74762_e(name) * (1.0f - pt) + (float)nbt.func_74762_e(name) * pt);
            }).orElse((Object)Float.valueOf(0.0f))).floatValue();
        });
    }

    public static ItemPropertyWrapper listCountProperty(String name, int type, boolean showInInvenotry) {
        return new ItemPropertyWrapper(name, (stack, worldIn, entity) -> {
            if (worldIn == null && showInInvenotry) {
                worldIn = Minecraft.func_71410_x().field_71441_e;
            }
            if (!stack.func_77942_o() || worldIn == null) {
                return 0.0f;
            }
            return ((Float)worldIn.getCapability(ItemDataProvider.ITEMDATA_CAP).map(iItemData -> {
                CompoundNBT nbt = iItemData.getItemData().func_74775_l(stack.func_196082_o().func_74779_i("UUID"));
                CompoundNBT oldNBT = nbt.func_74775_l("prev");
                float pt = RenderPartialTickHandler.renderPartialTick;
                return Float.valueOf((float)oldNBT.func_150295_c(name, type).size() * (1.0f - pt) + (float)nbt.func_150295_c(name, type).size() * pt);
            }).orElse((Object)Float.valueOf(0.0f))).floatValue();
        });
    }

    public static class AnimationEvent
    extends Event {
        private final ItemStack stack;
        private final World world;
        private final PlayerEntity player;
        private final int itemSlot;
        private final boolean isSelected;
        private final CompoundNBT nbt;
        private final ItemGun gun;

        public AnimationEvent(ItemStack stack, World world, PlayerEntity player, int itemSlot, boolean isSelected, CompoundNBT nbt, ItemGun gun) {
            this.stack = stack;
            this.world = world;
            this.player = player;
            this.itemSlot = itemSlot;
            this.isSelected = isSelected;
            this.nbt = nbt;
            this.gun = gun;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public World getWorld() {
            return this.world;
        }

        public PlayerEntity getPlayer() {
            return this.player;
        }

        public int getItemSlot() {
            return this.itemSlot;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public CompoundNBT getNbt() {
            return this.nbt;
        }

        public ItemGun getGun() {
            return this.gun;
        }

        public boolean isCancelable() {
            return true;
        }
    }
}

