/*
 * Decompiled with CFR 0.152.
 */
package piman.recievermod.items.crafting;

import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import piman.recievermod.init.ModBlocks;
import piman.recievermod.init.ModRecipeSerializers;
import piman.recievermod.util.handlers.RegistryEventHandler;

public class BulletCrafterRecipe
implements IRecipe<IInventory> {
    private ResourceLocation location;
    private Ingredient casing;
    private Ingredient primer;
    private Ingredient propellant;
    private Ingredient bullet;
    private ItemStack result;

    public BulletCrafterRecipe(ResourceLocation location, PacketBuffer buffer) {
        this.location = location;
        this.casing = Ingredient.func_199566_b((PacketBuffer)buffer);
        this.primer = Ingredient.func_199566_b((PacketBuffer)buffer);
        this.propellant = Ingredient.func_199566_b((PacketBuffer)buffer);
        this.bullet = Ingredient.func_199566_b((PacketBuffer)buffer);
        this.result = buffer.func_150791_c();
    }

    public BulletCrafterRecipe(ResourceLocation location, Ingredient casing, Ingredient primer, Ingredient propellant, Ingredient bullet, ItemStack result) {
        this.location = location;
        this.casing = casing;
        this.primer = primer;
        this.propellant = propellant;
        this.bullet = bullet;
        this.result = result;
    }

    public void toPacketBuffer(PacketBuffer buffer) {
        this.casing.func_199564_a(buffer);
        this.primer.func_199564_a(buffer);
        this.propellant.func_199564_a(buffer);
        this.bullet.func_199564_a(buffer);
        buffer.func_150788_a(this.result);
    }

    public boolean func_77569_a(@Nonnull IInventory inv, @Nonnull World worldIn) {
        return this.matchesStack(this.casing, inv.func_70301_a(0), worldIn) && this.matchesStack(this.primer, inv.func_70301_a(1), worldIn) && this.matchesStack(this.propellant, inv.func_70301_a(2), worldIn) && this.matchesStack(this.bullet, inv.func_70301_a(3), worldIn);
    }

    public NonNullList<Ingredient> func_192400_c() {
        return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{this.casing, this.primer, this.propellant, this.bullet});
    }

    public boolean matchesStack(Ingredient ingredient, ItemStack itemStack, World worldIn) {
        ItemStack[] itemStacks;
        for (ItemStack itemStack1 : itemStacks = ingredient.func_193365_a()) {
            if (!ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)itemStack1) || itemStack.func_190916_E() < itemStack1.func_190916_E()) continue;
            return true;
        }
        return false;
    }

    public ItemStack reduceStack(Ingredient ingredient, ItemStack itemStack, World worldIn) {
        ItemStack[] itemStacks;
        for (ItemStack itemStack1 : itemStacks = ingredient.func_193365_a()) {
            if (!ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)itemStack1) || itemStack.func_190916_E() < itemStack1.func_190916_E()) continue;
            itemStack.func_190918_g(itemStack1.func_190916_E());
            break;
        }
        return itemStack;
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull IInventory inv) {
        return this.result.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return this.result;
    }

    @Nonnull
    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)ModBlocks.BULLET_CRAFTER);
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.location;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return ModRecipeSerializers.BULLET_CRAFTER;
    }

    @Nonnull
    public IRecipeType<?> func_222127_g() {
        return RegistryEventHandler.BULLET_CRAFTER;
    }
}

