/*
 * Decompiled with CFR 0.152.
 */
package piman.recievermod.items.guns;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import piman.recievermod.capabilities.itemdata.IItemData;
import piman.recievermod.capabilities.itemdata.ItemDataProvider;
import piman.recievermod.init.ModItemGroups;
import piman.recievermod.items.IItemInit;
import piman.recievermod.items.animations.IAnimationController;
import piman.recievermod.items.bullets.ItemBullet;
import piman.recievermod.items.mags.ItemMag;
import piman.recievermod.keybinding.KeyInputHandler;
import piman.recievermod.network.NetworkHandler;
import piman.recievermod.network.messages.MessageShoot;
import piman.recievermod.network.messages.MessageUpdateNBT;
import piman.recievermod.util.handlers.ClientEventHandler;

public abstract class ItemGun
extends Item
implements IItemInit {
    private static final IItemPropertyGetter BULLET_CHAMBERED_GETTER = new IItemPropertyGetter(){

        @OnlyIn(value=Dist.CLIENT)
        public float call(ItemStack stack, @Nullable World worldIn, @Nullable LivingEntity entityIn) {
            if (worldIn == null) {
                worldIn = Minecraft.func_71410_x().field_71441_e;
            }
            LazyOptional lazyOptional = worldIn.getCapability(ItemDataProvider.ITEMDATA_CAP, null);
            if (worldIn == null || !lazyOptional.isPresent() || !stack.func_77942_o()) {
                return 0.0f;
            }
            CompoundNBT nbt = ((IItemData)lazyOptional.orElse(null)).getItemData().func_74775_l(stack.func_196082_o().func_74779_i("UUID"));
            float j = !nbt.func_74779_i("BulletChambered").isEmpty() ? 1.0f : 0.0f;
            return j;
        }
    };
    protected double spreadY;
    protected double spreadX;
    protected double drift;
    protected float accuracy;
    protected List<IAnimationController> animationControllers = new ArrayList<IAnimationController>();
    public Supplier<ItemBullet> ammo;
    public Supplier<ItemBullet> casing;
    public Supplier<ItemMag> mag;

    public ItemGun(Item.Properties properties) {
        super(properties.func_200917_a(1).func_200916_a(ModItemGroups.GUNS));
        this.func_185043_a(new ResourceLocation("chambered"), BULLET_CHAMBERED_GETTER);
    }

    @Override
    public void Init() {
        ArrayList itemProperties = new ArrayList();
        this.animationControllers.forEach(controller -> itemProperties.addAll(controller.getProperties()));
        itemProperties.forEach(property -> this.func_185043_a(property.getName(), property.getOverride()));
    }

    public boolean Shoot(CompoundNBT nbt, LivingEntity entityLiving, double damage, float entityAccuracy, float gunAccuracy, int bullets) {
        return this.Shoot(nbt, entityLiving, damage, entityAccuracy, gunAccuracy, bullets, 1200);
    }

    public boolean Shoot(CompoundNBT nbt, LivingEntity entityLiving, double damage, float entityAccuracy, float gunAccuracy, int bullets, int life) {
        if (entityLiving instanceof PlayerEntity) {
            int i;
            PlayerEntity player = (PlayerEntity)entityLiving;
            World world = player.field_70170_p;
            boolean flag1 = player.func_184812_l_();
            if (world.field_72995_K) {
                NetworkHandler.sendToServer(new MessageShoot(nbt, damage, entityAccuracy, gunAccuracy, life, bullets));
            }
            if ((i = ForgeEventFactory.onArrowLoose((ItemStack)player.func_184614_ca(), (World)world, (PlayerEntity)player, (int)20, (flag1 || !nbt.func_74779_i("BulletChambered").isEmpty() ? 1 : 0) != 0)) < 0) {
                return false;
            }
            if (flag1 || !nbt.func_74779_i("BulletChambered").isEmpty()) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(nbt.func_74779_i("BulletChambered")));
                boolean flag = false;
                if (!(item instanceof ItemBullet) && player.func_184812_l_()) {
                    item = this.ammo.get();
                    flag = true;
                }
                if (item instanceof ItemBullet) {
                    ItemBullet itemBullet = (ItemBullet)item;
                    if (!world.field_72995_K) {
                        itemBullet.fire(world, player, entityAccuracy, gunAccuracy, life);
                    }
                    if (flag) {
                        nbt.func_74778_a("BulletChambered", "");
                    } else {
                        nbt.func_74778_a("BulletChambered", itemBullet.getCasing().getRegistryName().toString());
                    }
                }
                player.field_70125_A = (float)((double)player.field_70125_A + (world.field_73012_v.nextGaussian() * this.spreadY - this.drift));
                player.field_70177_z = (float)((double)player.field_70177_z + world.field_73012_v.nextGaussian() * this.spreadX);
                return true;
            }
        }
        return false;
    }

    public abstract SoundEvent getShootSound();

    public abstract float getDefaultZoomFactor(ItemStack var1);

    public float getAccuracy() {
        return this.accuracy;
    }

    public boolean hasAccessories(ItemStack stack) {
        return false;
    }

    public boolean hasAccessory(ItemStack stack, int type) {
        return stack.func_190925_c("Accessories").func_150297_b(Integer.valueOf(type).toString(), 8) && !stack.func_190925_c("Accessories").func_74779_i(Integer.valueOf(type).toString()).isEmpty();
    }

    private int[] getAccessoryTransformInts(int type) {
        int[] ints = new int[16];
        Matrix4f m = this.getAccessoryTransform(type);
        for (int i = 0; i < 16; ++i) {
            ints[i] = Float.floatToIntBits(m.getElement(i / 4, i % 4));
        }
        return ints;
    }

    public Matrix4f getAccessoryTransform(int type) {
        Matrix4f m = new Matrix4f();
        m.setIdentity();
        return m;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (worldIn.field_72995_K && entityIn instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entityIn;
            if (player.func_184614_ca().equals(stack) && KeyInputHandler.isKeyDown(KeyInputHandler.KeyPresses.Shift)) {
                ClientEventHandler.cancleBob();
            }
            worldIn.getCapability(ItemDataProvider.ITEMDATA_CAP).ifPresent(cap -> {
                CompoundNBT baseTag = cap.getItemData();
                CompoundNBT nbt = baseTag.func_74775_l(stack.func_196082_o().func_74779_i("UUID"));
                CompoundNBT oldnbt = nbt.func_74737_b();
                oldnbt.func_82580_o("prev");
                nbt.func_218657_a("prev", (INBT)oldnbt);
                this.animationControllers.forEach(controller -> controller.update(stack, worldIn, player, itemSlot, isSelected, nbt, (ItemGun)stack.func_77973_b()));
                NetworkHandler.sendToServer(new MessageUpdateNBT(stack, itemSlot, nbt));
            });
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        boolean flag = false;
        if (oldStack.func_77973_b() instanceof ItemGun && newStack.func_77973_b() instanceof ItemGun) {
            flag = oldStack.func_196082_o().func_74779_i("UUID").equals(newStack.func_196082_o().func_74779_i("UUID"));
        }
        return slotChanged || !flag;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new StringTextComponent("ID: " + stack.func_196082_o().func_74779_i("UUID")));
    }

    public int findAmmo(PlayerEntity player) {
        for (int i = -1; i < player.field_71071_by.func_70302_i_() - 1; ++i) {
            int k = i < 0 ? player.field_71071_by.func_70302_i_() - 1 : i;
            ItemStack itemstack = player.field_71071_by.func_70301_a(k);
            if (!this.isAmmo(itemstack)) continue;
            return k;
        }
        return -1;
    }

    public int findMag(PlayerEntity player) {
        for (int i = -1; i < player.field_71071_by.func_70302_i_() - 1; ++i) {
            int k = i < 0 ? player.field_71071_by.func_70302_i_() - 1 : i;
            ItemStack itemstack = player.field_71071_by.func_70301_a(k);
            if (!this.isMag(itemstack)) continue;
            return k;
        }
        return -1;
    }

    public int findFullestMag(PlayerEntity player, CompoundNBT baseTag) {
        TreeMap<Integer, Pair> mags = new TreeMap<Integer, Pair>();
        ItemStack itemstack = player.field_71071_by.func_70301_a(player.field_71071_by.func_70302_i_() - 1);
        if (this.isMag(itemstack)) {
            return player.field_71071_by.func_70302_i_() - 1;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_() - 1; ++i) {
            ItemStack itemstack2 = player.field_71071_by.func_70301_a(i);
            if (!this.isMag(itemstack2)) continue;
            mags.put(baseTag.func_74775_l(itemstack2.func_196082_o().func_74779_i("UUID")).func_150295_c("bullets", 8).size(), Pair.of((Object)itemstack2, (Object)i));
        }
        if (!mags.isEmpty()) {
            return (Integer)((Pair)mags.lastEntry().getValue()).getValue();
        }
        return -1;
    }

    public boolean isMag(ItemStack stack) {
        return stack.func_77973_b() == this.mag.get();
    }

    private boolean isAmmo(ItemStack stack) {
        return stack.func_77973_b() == this.ammo.get();
    }
}

