/*
 * Decompiled with CFR 0.152.
 */
package piman.recievermod.items.mags;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import piman.recievermod.capabilities.itemdata.ItemDataProvider;
import piman.recievermod.init.ModItemGroups;
import piman.recievermod.items.ItemPropertyWrapper;
import piman.recievermod.items.animations.IAnimationController;
import piman.recievermod.keybinding.KeyInputHandler;
import piman.recievermod.network.NetworkHandler;
import piman.recievermod.network.messages.MessageAddToInventory;
import piman.recievermod.network.messages.MessageUpdateNBT;

public class ItemMag
extends Item {
    protected int maxAmmo;
    protected Supplier<Item> ammo;

    public ItemMag(Item.Properties properties, int maxAmmo, Supplier<Item> ammo) {
        super(properties.func_200916_a(ModItemGroups.GUNS).func_200917_a(1));
        this.maxAmmo = maxAmmo;
        this.ammo = ammo;
        ItemPropertyWrapper bullets = IAnimationController.listCountProperty("bullets", 8, true);
        this.func_185043_a(bullets.getName(), bullets.getOverride());
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new StringTextComponent("ID: " + stack.func_196082_o().func_74779_i("UUID")));
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof PlayerEntity && worldIn.field_72995_K) {
            PlayerEntity player = (PlayerEntity)entityIn;
            worldIn.getCapability(ItemDataProvider.ITEMDATA_CAP).ifPresent(itemData -> {
                CompoundNBT nbt;
                if (itemData.getItemData().func_74764_b(stack.func_196082_o().func_74779_i("UUID"))) {
                    nbt = itemData.getItemData().func_74775_l(stack.func_196082_o().func_74779_i("UUID"));
                } else {
                    nbt = new CompoundNBT();
                    itemData.getItemData().func_218657_a(stack.func_196082_o().func_74779_i("UUID"), (INBT)nbt);
                }
                CompoundNBT old = nbt.func_74737_b();
                old.func_82580_o("prev");
                nbt.func_218657_a("prev", (INBT)old);
                if (!nbt.func_150297_b("bullets", 9)) {
                    nbt.func_218657_a("bullets", (INBT)new ListNBT());
                }
                if (player.func_184614_ca().equals(stack)) {
                    ItemStack ammo;
                    if (KeyInputHandler.isKeyPressed(KeyInputHandler.KeyPresses.AddBullet) && nbt.func_150295_c("bullets", 8).size() < this.maxAmmo && !(ammo = this.findAmmo(player)).func_190926_b()) {
                        nbt.func_150295_c("bullets", 8).add((Object)new StringNBT(ammo.func_77973_b().getRegistryName().toString()));
                        NetworkHandler.sendToServer(new MessageAddToInventory(ammo, -1));
                    }
                    if (KeyInputHandler.isKeyPressed(KeyInputHandler.KeyPresses.RemoveBullet) && nbt.func_150295_c("bullets", 8).size() > 0) {
                        nbt.func_150295_c("bullets", 8).remove(nbt.func_150295_c("bullets", 8).size() - 1);
                        NetworkHandler.sendToServer(new MessageAddToInventory(this.ammo.get(), 1));
                    }
                }
                NetworkHandler.sendToServer(new MessageUpdateNBT(stack, itemSlot, nbt));
            });
        }
    }

    public ItemStack findAmmo(PlayerEntity player) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.isBullet(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public boolean isBullet(ItemStack stack) {
        return stack.func_77973_b() == this.ammo.get();
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        boolean flag = false;
        if (oldStack.func_77973_b() instanceof ItemMag && newStack.func_77973_b() instanceof ItemMag) {
            flag = oldStack.func_196082_o().func_74779_i("UUID").equals(newStack.func_196082_o().func_74779_i("UUID"));
        }
        return slotChanged || !flag;
    }
}

