/*
 * Decompiled with CFR 0.152.
 */
package piman.recievermod.keybinding;

import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.glfw.GLFW;
import piman.recievermod.Main;
import piman.recievermod.items.guns.ItemGun;
import piman.recievermod.keybinding.Keybinds;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber
public class KeyInputHandler {
    static Screen currentScreen = null;
    static Screen prevScreen = null;
    static GameSettings gs = Minecraft.func_71410_x().field_71474_y;
    static KeyBinding[] Keys = new KeyBinding[]{Keybinds.addBullet, Keybinds.removeBullet, Keybinds.removeMag, Keybinds.slideLock, Keybinds.safety, Keybinds.hammer, KeyInputHandler.gs.field_74312_F, KeyInputHandler.gs.field_74313_G, KeyInputHandler.gs.field_74311_E};
    static int scroll = 0;
    static final int NUMKEYS = Keys.length;
    static final int OLD = 1;
    static final int NEW = 0;
    private static boolean[][] States = new boolean[2][NUMKEYS];
    private static boolean scrollCancle = false;
    private static long windowId = Minecraft.func_71410_x().field_195558_d.func_198092_i();

    @SubscribeEvent
    public static void onClientTickEvent(TickEvent.ClientTickEvent event) {
        if (Minecraft.func_71410_x().field_71439_g != null) {
            if (event.phase == TickEvent.Phase.START) {
                prevScreen = currentScreen;
                currentScreen = Minecraft.func_71410_x().field_71462_r;
                KeyInputHandler.checkKeys();
            } else if (event.phase == TickEvent.Phase.END) {
                scroll = 0;
            }
        }
    }

    @SubscribeEvent
    public static void onInput(InputEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && player.func_184614_ca().func_77973_b() instanceof ItemGun && !KeyInputHandler.gs.field_151444_V.func_151470_d()) {
            KeyBinding.func_197980_a((InputMappings.Input)KeyInputHandler.gs.field_74312_F.getKey(), (boolean)false);
            while (KeyInputHandler.gs.field_74312_F.func_151468_f()) {
            }
            KeyBinding.func_197980_a((InputMappings.Input)KeyInputHandler.gs.field_74313_G.getKey(), (boolean)false);
            while (KeyInputHandler.gs.field_74313_G.func_151468_f()) {
            }
        }
    }

    @SubscribeEvent
    public static void resetScrollCancle(InputUpdateEvent event) {
        scrollCancle = false;
    }

    @SubscribeEvent
    public static void onMouseEvent(InputEvent.MouseScrollEvent event) {
        if (scrollCancle) {
            event.setCanceled(true);
        }
        scroll += Main.sign(event.getScrollDelta());
    }

    private static void checkKeys() {
        for (int i = 0; i < NUMKEYS; ++i) {
            KeyInputHandler.getStates()[1][i] = KeyInputHandler.getStates()[0][i];
            InputMappings.Input key = Keys[i].getKey();
            KeyInputHandler.getStates()[0][i] = key.func_197938_b() == InputMappings.Type.MOUSE ? GLFW.glfwGetMouseButton((long)windowId, (int)key.func_197937_c()) != 0 && !KeyInputHandler.gs.field_151444_V.func_151470_d() : GLFW.glfwGetKey((long)windowId, (int)key.func_197937_c()) != 0;
        }
    }

    public static boolean isKeyPressed(KeyPresses key) {
        if (prevScreen != null) {
            return false;
        }
        return KeyInputHandler.getStates()[0][key.ordinal()] && !KeyInputHandler.getStates()[1][key.ordinal()];
    }

    public static boolean isKeyDown(KeyPresses key) {
        if (prevScreen != null) {
            return false;
        }
        return KeyInputHandler.getStates()[0][key.ordinal()];
    }

    public static boolean isKeyUnpressed(KeyPresses key) {
        if (prevScreen != null) {
            return false;
        }
        return !KeyInputHandler.getStates()[0][key.ordinal()] && KeyInputHandler.getStates()[1][key.ordinal()];
    }

    public static int getScroll() {
        return scroll;
    }

    public static void cancleScroll(boolean cancle) {
        scrollCancle = cancle;
    }

    public static boolean[][] getStates() {
        return States;
    }

    public static void setStates(boolean[][] states) {
        States = states;
    }

    public static enum KeyPresses {
        AddBullet,
        RemoveBullet,
        RemoveMag,
        SlideLock,
        Safety,
        Hammer,
        LeftClick,
        RightClick,
        Shift;

    }
}

