/*
 * Decompiled with CFR 0.152.
 */
package piman.recievermod.network;

import java.lang.reflect.InvocationTargetException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import piman.recievermod.network.messages.MessageAddToInventory;
import piman.recievermod.network.messages.MessageBase;
import piman.recievermod.network.messages.MessageDamageParticles;
import piman.recievermod.network.messages.MessageEject;
import piman.recievermod.network.messages.MessageEntityPosVelUpdate;
import piman.recievermod.network.messages.MessageFlashClient;
import piman.recievermod.network.messages.MessageFlashServer;
import piman.recievermod.network.messages.MessagePlaySound;
import piman.recievermod.network.messages.MessageShoot;
import piman.recievermod.network.messages.MessageUpdateNBT;

public class NetworkHandler {
    private static SimpleChannel INSTANCE;
    private static int i;

    public static void init() {
        INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("receiver", "main_network"), () -> "1.0.0", "1.0.0"::equals, "1.0.0"::equals);
        NetworkHandler.registerMessage(MessageAddToInventory.class);
        NetworkHandler.registerMessage(MessageUpdateNBT.class);
        NetworkHandler.registerMessage(MessagePlaySound.class);
        NetworkHandler.registerMessage(MessageEject.class);
        NetworkHandler.registerMessage(MessageShoot.class);
        NetworkHandler.registerMessage(MessageFlashServer.class);
        NetworkHandler.registerMessage(MessageFlashClient.class);
        NetworkHandler.registerMessage(MessageEntityPosVelUpdate.class);
        NetworkHandler.registerMessage(MessageDamageParticles.class);
    }

    public static <T extends MessageBase<T>> void registerMessage(Class<T> messageClass) {
        try {
            MessageBase messageInstance = (MessageBase)messageClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            INSTANCE.registerMessage(i++, messageClass, messageInstance::toBytes, messageInstance::fromBytes, messageInstance::onMessage);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void sendToServer(MessageBase<?> message) {
        INSTANCE.sendToServer(message);
    }

    public static void sendToClient(MessageBase<?> message, ServerPlayerEntity player) {
        INSTANCE.sendTo(message, player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void sendToAll(MessageBase<?> message) {
        INSTANCE.send(PacketDistributor.ALL.noArg(), message);
    }

    public static void sendToAllTracking(MessageBase<?> message, Entity entity) {
        INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), message);
    }

    static {
        i = 0;
    }
}

