/*
 * Decompiled with CFR 0.152.
 */
package piman.recievermod.network.messages;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import piman.recievermod.Main;
import piman.recievermod.network.messages.MessageBase;

public class MessageAddToInventory
extends MessageBase<MessageAddToInventory> {
    private ItemStack stack;
    private int amount;
    private int slot;

    public MessageAddToInventory() {
    }

    public MessageAddToInventory(ItemStack stack, int amount) {
        this(stack, amount, -1);
    }

    public MessageAddToInventory(Item item, int amount) {
        this(new ItemStack((IItemProvider)item), amount);
    }

    public MessageAddToInventory(ItemStack stack, int amount, int slot) {
        this.stack = stack;
        this.amount = amount;
        this.slot = slot;
    }

    @Override
    public MessageAddToInventory fromBytes(PacketBuffer buf) {
        ItemStack stack = buf.func_150791_c();
        int amount = buf.readInt();
        int slot = buf.readInt();
        return new MessageAddToInventory(stack, amount, slot);
    }

    @Override
    public void toBytes(MessageAddToInventory message, PacketBuffer buf) {
        buf.func_150788_a(message.stack);
        buf.writeInt(message.amount);
        buf.writeInt(message.slot);
    }

    @Override
    public void handleClientSide(MessageAddToInventory message, PlayerEntity player) {
    }

    @Override
    public void handleServerSide(MessageAddToInventory message, PlayerEntity player) {
        ItemStack stack1 = message.stack;
        if (message.slot != -1) {
            if (message.amount < 0) {
                ItemStack stack2 = player.field_71071_by.func_70301_a(message.slot);
                if (stack1.func_77973_b() == stack2.func_77973_b()) {
                    stack2.func_190917_f(message.amount);
                    return;
                }
                System.out.println("Unable to Remove Item From Requested Slot");
            }
            if (message.amount > 0) {
                if (player.field_71071_by.func_70301_a(message.slot).func_190926_b()) {
                    player.field_71071_by.func_70299_a(message.slot, stack1);
                    return;
                }
                System.out.println("Unable to Add Item To Requested Slot");
            }
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack2 = player.field_71071_by.func_70301_a(i);
            if (!ItemStack.func_179545_c((ItemStack)stack1, (ItemStack)stack2) || !ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2)) continue;
            stack2.func_190917_f(message.amount);
            if (stack2.func_190916_E() > stack2.func_77976_d()) {
                ItemStack stack3 = stack2.func_77979_a(stack2.func_77976_d());
                player.field_71071_by.func_70441_a(stack3);
            }
            return;
        }
        Main.LOGGER.info("Unable to Find Stack, slot: {}", (Object)message.slot);
        stack1.func_190920_e(message.amount);
        if (!player.field_71071_by.func_70441_a(stack1)) {
            Main.LOGGER.info("dropping Item");
            player.func_146097_a(stack1, false, true);
        }
    }
}

