/*
 * Decompiled with CFR 0.152.
 */
package piman.recievermod.network.messages;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import piman.recievermod.network.messages.MessageBase;
import piman.recievermod.util.FlashHandler;

public class MessageFlashClient
extends MessageBase<MessageFlashClient> {
    private boolean update;
    private int duration;
    private int dimension;
    private int x;
    private int y;
    private int z;

    public MessageFlashClient() {
    }

    public MessageFlashClient(boolean update, int dimension) {
        this(update, BlockPos.field_177992_a, dimension, 0);
    }

    public MessageFlashClient(boolean update, BlockPos pos, int dimension, int duration) {
        this.update = update;
        this.duration = duration;
        this.dimension = dimension;
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
    }

    @Override
    public MessageFlashClient fromBytes(PacketBuffer buf) {
        MessageFlashClient message = new MessageFlashClient();
        message.update = buf.readBoolean();
        message.duration = buf.readInt();
        message.dimension = buf.readInt();
        message.x = buf.readInt();
        message.y = buf.readInt();
        message.z = buf.readInt();
        return message;
    }

    @Override
    public void toBytes(MessageFlashClient message, PacketBuffer buf) {
        buf.writeBoolean(message.update);
        buf.writeInt(message.duration);
        buf.writeInt(message.dimension);
        buf.writeInt(message.x);
        buf.writeInt(message.y);
        buf.writeInt(message.z);
    }

    @Override
    public void handleClientSide(MessageFlashClient message, PlayerEntity player) {
        if (message.dimension == player.field_71093_bK.func_186068_a()) {
            if (message.update) {
                FlashHandler.Update(message.dimension);
            } else {
                FlashHandler.AddFlash(new BlockPos(message.x, message.y, message.z), message.dimension, message.duration);
            }
        }
    }

    @Override
    public void handleServerSide(MessageFlashClient message, PlayerEntity player) {
    }
}

