/*
 * Decompiled with CFR 0.152.
 */
package piman.recievermod.network.messages;

import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import piman.recievermod.Main;
import piman.recievermod.capabilities.itemdata.ItemDataProvider;
import piman.recievermod.network.NetworkHandler;
import piman.recievermod.network.messages.MessageBase;

public class MessageUpdateNBT
extends MessageBase<MessageUpdateNBT> {
    private ItemStack stack;
    private int slot;
    private CompoundNBT nbt;

    public MessageUpdateNBT() {
    }

    public MessageUpdateNBT(ItemStack stack, int slot, CompoundNBT nbt) {
        this.stack = stack;
        this.slot = slot;
        this.nbt = nbt;
    }

    @Override
    public MessageUpdateNBT fromBytes(PacketBuffer buf) {
        MessageUpdateNBT message = new MessageUpdateNBT();
        message.stack = buf.func_150791_c();
        message.slot = buf.readInt();
        message.nbt = buf.func_150793_b();
        return message;
    }

    @Override
    public void toBytes(MessageUpdateNBT message, PacketBuffer buf) {
        buf.func_150788_a(message.stack);
        buf.writeInt(message.slot);
        buf.func_150786_a(message.nbt);
    }

    @Override
    public void handleClientSide(MessageUpdateNBT message, PlayerEntity player) {
        ItemStack stack1 = player.field_71071_by.func_70301_a(message.slot);
        ItemStack stack2 = message.stack;
        stack1.func_77982_d(stack2.func_196082_o().func_74737_b());
        player.field_70170_p.getCapability(ItemDataProvider.ITEMDATA_CAP).ifPresent(itemData -> {
            CompoundNBT dataTag = itemData.getItemData();
            CompoundNBT itemTag = this.getItemTag(dataTag, stack2.func_196082_o().func_74779_i("UUID"));
            itemTag.func_197643_a(message.nbt);
        });
    }

    @Override
    public void handleServerSide(MessageUpdateNBT message, PlayerEntity player) {
        ItemStack stack1 = message.stack;
        ItemStack stack2 = player.field_71071_by.func_70301_a(message.slot);
        if (stack1.func_77973_b() != stack2.func_77973_b()) {
            stack2 = player.func_184592_cb();
        }
        if (stack1.func_77973_b() != stack2.func_77973_b()) {
            Main.LOGGER.info("Items are not Equal");
            return;
        }
        String[] uuid = new String[]{null};
        short[] status = new short[]{-1};
        for (World world : ServerLifecycleHooks.getCurrentServer().func_212370_w()) {
            ItemStack finalStack = stack2;
            world.getCapability(ItemDataProvider.ITEMDATA_CAP).ifPresent(itemData -> {
                CompoundNBT baseTag = itemData.getItemData();
                CompoundNBT itemTag = null;
                if (uuid[0] == null) {
                    if (message.nbt.func_74779_i("UUID").isEmpty()) {
                        if (!finalStack.func_196082_o().func_74779_i("UUID").isEmpty()) {
                            uuid[0] = finalStack.func_196082_o().func_74779_i("UUID");
                            itemTag = this.getItemTag(baseTag, uuid[0]);
                            status[0] = 0;
                        } else {
                            uuid[0] = UUID.randomUUID().toString();
                            CompoundNBT nbt = new CompoundNBT();
                            nbt.func_74778_a("UUID", uuid[0]);
                            finalStack.func_196082_o().func_197643_a(nbt);
                            Main.LOGGER.info("Set UUID To: {}", (Object)uuid[0]);
                            itemTag = this.getItemTag(baseTag, uuid[0]);
                            itemTag.func_197643_a(message.nbt);
                            itemTag.func_74778_a("UUID", uuid[0]);
                            status[0] = 1;
                        }
                        NetworkHandler.sendToAll(new MessageUpdateNBT(finalStack, message.slot, itemTag));
                    } else {
                        itemTag = this.getItemTag(baseTag, message.nbt.func_74779_i("UUID"));
                        itemTag.func_197643_a(message.nbt);
                        status[0] = 2;
                    }
                } else if (status[0] == 0) {
                    itemTag = this.getItemTag(baseTag, uuid[0]);
                } else if (status[0] == 1) {
                    itemTag = this.getItemTag(baseTag, uuid[0]);
                    itemTag.func_197643_a(message.nbt);
                    itemData.setItemData(baseTag);
                } else if (status[0] == 2) {
                    itemTag = this.getItemTag(baseTag, uuid[0]);
                    itemTag.func_197643_a(message.nbt);
                    itemData.setItemData(baseTag);
                }
            });
        }
    }

    private CompoundNBT getItemTag(CompoundNBT baseTag, String key) {
        CompoundNBT itemTag;
        if (baseTag.func_150297_b(key, 10)) {
            itemTag = baseTag.func_74775_l(key);
        } else {
            itemTag = new CompoundNBT();
            baseTag.func_218657_a(key, (INBT)itemTag);
        }
        return itemTag;
    }
}

