/*
 * Decompiled with CFR 0.152.
 */
package piman.recievermod.tileentity;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import piman.recievermod.block.BlockBulletCrafter;
import piman.recievermod.init.ModTileEntityTypes;
import piman.recievermod.inventory.container.ContainerBulletCrafter;
import piman.recievermod.items.bullets.ItemBulletMediumCasing;
import piman.recievermod.items.crafting.BulletCrafterRecipe;
import piman.recievermod.util.handlers.RegistryEventHandler;

public class TileEntityBulletCrafter
extends TileEntity
implements ITickableTileEntity,
ISidedInventory,
INamedContainerProvider {
    private static final int[] SLOTS_TOP = new int[]{0, 1, 2, 3};
    private static final int[] SLOTS_BOTTOM = new int[]{4};
    private static final int[] SLOTS_SIDES = new int[]{0, 1, 2, 3};
    private NonNullList<ItemStack> ItemStacks = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    private int cookTime;
    private int totalCookTime;
    private String CustomName;
    private IIntArray intArray = new IIntArray(){

        public int func_221476_a(int index) {
            if (index == 0) {
                return TileEntityBulletCrafter.this.cookTime;
            }
            if (index == 1) {
                return TileEntityBulletCrafter.this.totalCookTime;
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            if (index == 0) {
                TileEntityBulletCrafter.this.cookTime = value;
            } else if (index == 1) {
                TileEntityBulletCrafter.this.totalCookTime = value;
            }
        }

        public int func_221478_a() {
            return 2;
        }
    };
    LazyOptional<IItemHandler> handlerTop = LazyOptional.of(() -> new SidedInvWrapper((ISidedInventory)this, Direction.UP));
    LazyOptional<IItemHandler> handlerBottom = LazyOptional.of(() -> new SidedInvWrapper((ISidedInventory)this, Direction.DOWN));
    LazyOptional<IItemHandler> handlerSide = LazyOptional.of(() -> new SidedInvWrapper((ISidedInventory)this, Direction.WEST));

    public TileEntityBulletCrafter() {
        super(ModTileEntityTypes.BULLET_CRAFTER);
    }

    public int func_70302_i_() {
        return this.ItemStacks.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.ItemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.ItemStacks.get(index);
    }

    @Nonnull
    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.ItemStacks, (int)index, (int)count);
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.ItemStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.ItemStacks.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.ItemStacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.totalCookTime = this.getCookTime(stack);
            this.cookTime = 0;
            this.func_70296_d();
        }
    }

    public String getName() {
        return this.hasCustomName() ? this.CustomName : "container.bullet_crafter";
    }

    public boolean hasCustomName() {
        return this.CustomName != null && !this.CustomName.isEmpty();
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.getName(), new Object[0]);
    }

    public void setCustomInventoryName(String p_145951_1_) {
        this.CustomName = p_145951_1_;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.ItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)compound, this.ItemStacks);
        this.cookTime = compound.func_74762_e("CookTime");
        this.totalCookTime = compound.func_74762_e("CookTimeTotal");
        if (compound.func_150297_b("CustomName", 8)) {
            this.CustomName = compound.func_74779_i("CustomName");
        }
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("CookTime", (int)((short)this.cookTime));
        compound.func_74768_a("CookTimeTotal", (int)((short)this.totalCookTime));
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.ItemStacks);
        if (this.hasCustomName()) {
            compound.func_74778_a("CustomName", this.CustomName);
        }
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean isCrafting() {
        return this.cookTime > 0;
    }

    public void func_73660_a() {
        boolean flag = this.isCrafting();
        boolean flag1 = false;
        if (!this.field_145850_b.field_72995_K) {
            ItemStack itemstack = (ItemStack)this.ItemStacks.get(1);
            if (this.isCrafting() || !itemstack.func_190926_b() && !((ItemStack)this.ItemStacks.get(0)).func_190926_b()) {
                BulletCrafterRecipe recipe = this.field_145850_b.func_199532_z().func_215371_a(RegistryEventHandler.BULLET_CRAFTER, (IInventory)this, this.field_145850_b).orElse(null);
                if (!this.isCrafting() && this.canSmelt(recipe)) {
                    flag1 = true;
                    this.totalCookTime = this.getCookTime(itemstack);
                    this.cookTime = 1;
                }
                if (this.isCrafting() && this.canSmelt(recipe)) {
                    ++this.cookTime;
                    if (this.cookTime == this.totalCookTime) {
                        this.cookTime = 0;
                        this.totalCookTime = this.getCookTime((ItemStack)this.ItemStacks.get(0));
                        this.smeltItem(recipe);
                        flag1 = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (!this.isCrafting() && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.totalCookTime);
            }
            if (flag != this.isCrafting()) {
                flag1 = true;
                BlockBulletCrafter.setState(this.isCrafting(), this.field_145850_b, this.field_174879_c);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public int getCookTime(ItemStack stack) {
        return 640;
    }

    private boolean canSmelt(BulletCrafterRecipe recipe) {
        if (recipe == null) {
            return false;
        }
        ItemStack itemstack = recipe.func_77571_b();
        if (itemstack.func_190926_b()) {
            return false;
        }
        ItemStack itemstack1 = (ItemStack)this.ItemStacks.get(4);
        if (itemstack1.func_190926_b()) {
            return true;
        }
        if (!itemstack1.func_77969_a(itemstack)) {
            return false;
        }
        if (itemstack1.func_190916_E() + itemstack.func_190916_E() <= this.func_70297_j_() && itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack1.func_77976_d()) {
            return true;
        }
        return itemstack1.func_190916_E() + itemstack.func_190916_E() <= itemstack.func_77976_d();
    }

    public void smeltItem(BulletCrafterRecipe recipe) {
        if (this.canSmelt(recipe)) {
            List inputs = this.ItemStacks.subList(0, 4);
            NonNullList<Ingredient> ingredients = recipe.func_192400_c();
            ItemStack itemstack1 = recipe.func_77572_b((IInventory)this);
            ItemStack itemstack2 = (ItemStack)this.ItemStacks.get(4);
            if (itemstack2.func_190926_b()) {
                this.ItemStacks.set(4, (Object)itemstack1.func_77946_l());
            } else if (itemstack2.func_77973_b() == itemstack1.func_77973_b()) {
                itemstack2.func_190917_f(itemstack1.func_190916_E());
            }
            for (int i = 0; i < inputs.size(); ++i) {
                ItemStack input = (ItemStack)inputs.get(i);
                recipe.reduceStack((Ingredient)ingredients.get(i), input, this.field_145850_b);
            }
        }
    }

    public boolean func_70300_a(@Nonnull PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 0) {
            return stack.func_77973_b() instanceof ItemBulletMediumCasing;
        }
        if (index == 1) {
            return stack.func_77973_b() == Items.field_151137_ax;
        }
        if (index == 2) {
            return stack.func_77973_b() == Items.field_151016_H;
        }
        if (index == 3) {
            return stack.func_77973_b() == Items.field_151042_j;
        }
        return false;
    }

    @Nonnull
    public int[] func_180463_a(@Nonnull Direction side) {
        if (side == Direction.DOWN) {
            return SLOTS_BOTTOM;
        }
        return side == Direction.UP ? SLOTS_TOP : SLOTS_SIDES;
    }

    public boolean func_180462_a(int index, @Nonnull ItemStack itemStackIn, Direction direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, @Nonnull ItemStack stack, @Nonnull Direction direction) {
        return direction == Direction.DOWN && index == 4;
    }

    @Nullable
    public Container createMenu(int id, @Nonnull PlayerInventory playerInventory, @Nonnull PlayerEntity player) {
        return new ContainerBulletCrafter(id, playerInventory, (IInventory)this, this.intArray);
    }

    public void func_174888_l() {
        this.ItemStacks.clear();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.DOWN) {
                return this.handlerBottom;
            }
            if (facing == Direction.UP) {
                return this.handlerTop;
            }
            return this.handlerSide;
        }
        return super.getCapability(capability, facing);
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public int getTotalCookTime() {
        return this.totalCookTime;
    }
}

