/*
 * Decompiled with CFR 0.152.
 */
package piman.recievermod.util.clientUtils;

import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraft.client.renderer.FaceDirection;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.FaceBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import piman.recievermod.util.clientUtils.TransformationBuilder;

public class BakedQuadBuilder {
    private Vector3f[] positions = new Vector3f[4];
    private Vector4f uv;
    private long color;
    private TextureAtlasSprite texture;
    private Direction face = null;

    public BakedQuadBuilder setPosition(Vector3f position, int index) {
        this.positions[index] = position;
        return this;
    }

    public BakedQuadBuilder setUV(Vector4f uv) {
        this.uv = uv;
        return this;
    }

    public BakedQuadBuilder setColor(long color) {
        this.color = color;
        return this;
    }

    public BakedQuadBuilder setTexture(TextureAtlasSprite texture) {
        this.texture = texture;
        return this;
    }

    public BakedQuadBuilder setFace(Direction face) {
        this.face = face;
        return this;
    }

    public BakedQuadBuilder applyRotation(Vector3f rotation, Vector3f center) {
        Matrix4f points = this.buildPositionMatrix();
        Matrix4f transformation = new TransformationBuilder().add(null, rotation, center, null, 0).buildMatirx();
        points.mul(transformation, points);
        this.resolvePositionMatrix(points);
        return this;
    }

    public BakedQuad build() {
        int[] ints = new int[28];
        int norm = this.calculateNormal(this.buildPositionMatrix());
        for (int i = 0; i < 4; ++i) {
            ints[i * 7 + 0] = Float.floatToRawIntBits(this.positions[i].getX());
            ints[i * 7 + 1] = Float.floatToRawIntBits(this.positions[i].getY());
            ints[i * 7 + 2] = Float.floatToRawIntBits(this.positions[i].getZ());
            ints[i * 7 + 3] = (int)this.color;
            ints[i * 7 + 4] = Float.floatToRawIntBits(this.texture.func_94214_a((double)this.getUPoint(i)));
            ints[i * 7 + 5] = Float.floatToRawIntBits(this.texture.func_94207_b((double)this.getVPoint(i)));
            ints[i * 7 + 6] = norm;
        }
        Direction direction = FaceBakery.func_178410_a((int[])ints);
        return new BakedQuad(ints, -1, direction, this.texture, true, DefaultVertexFormats.field_176599_b);
    }

    private float getUPoint(int i) {
        if (i == 0 || i == 1) {
            return this.uv.x;
        }
        return this.uv.z;
    }

    private float getVPoint(int i) {
        if (i == 0 || i == 3) {
            return this.uv.y;
        }
        return this.uv.w;
    }

    private int calculateNormal(Matrix4f points) {
        float xp = points.m03 - points.m01;
        float yp = points.m13 - points.m11;
        float zp = points.m23 - points.m21;
        float xq = points.m02 - points.m00;
        float yq = points.m12 - points.m10;
        float zq = points.m22 - points.m20;
        float xn = yq * zp - zq * yp;
        float yn = zq * xp - xq * zp;
        float zn = xq * yp - yq * xp;
        float norm = (float)Math.sqrt(xn * xn + yn * yn + zn * zn);
        float SMALL_LENGTH = 1.0E-6f;
        if (norm < 1.0E-6f) {
            norm = 1.0f;
        }
        norm = 1.0f / norm;
        int x = (byte)((xn *= norm) * 127.0f) & 0xFF;
        int y = (byte)((yn *= norm) * 127.0f) & 0xFF;
        int z = (byte)((zn *= norm) * 127.0f) & 0xFF;
        return x | y << 8 | z << 16;
    }

    private void applyFacing(int[] p_178408_1_, Direction p_178408_2_) {
        int[] aint = new int[p_178408_1_.length];
        System.arraycopy(p_178408_1_, 0, aint, 0, p_178408_1_.length);
        float[] afloat = new float[Direction.values().length];
        afloat[FaceDirection.Constants.field_179176_f] = 999.0f;
        afloat[FaceDirection.Constants.field_179178_e] = 999.0f;
        afloat[FaceDirection.Constants.field_179177_d] = 999.0f;
        afloat[FaceDirection.Constants.field_179180_c] = -999.0f;
        afloat[FaceDirection.Constants.field_179179_b] = -999.0f;
        afloat[FaceDirection.Constants.field_179181_a] = -999.0f;
        for (int i = 0; i < 4; ++i) {
            int j = 7 * i;
            float f = Float.intBitsToFloat(aint[j]);
            float f1 = Float.intBitsToFloat(aint[j + 1]);
            float f2 = Float.intBitsToFloat(aint[j + 2]);
            if (f < afloat[FaceDirection.Constants.field_179176_f]) {
                afloat[FaceDirection.Constants.field_179176_f] = f;
            }
            if (f1 < afloat[FaceDirection.Constants.field_179178_e]) {
                afloat[FaceDirection.Constants.field_179178_e] = f1;
            }
            if (f2 < afloat[FaceDirection.Constants.field_179177_d]) {
                afloat[FaceDirection.Constants.field_179177_d] = f2;
            }
            if (f > afloat[FaceDirection.Constants.field_179180_c]) {
                afloat[FaceDirection.Constants.field_179180_c] = f;
            }
            if (f1 > afloat[FaceDirection.Constants.field_179179_b]) {
                afloat[FaceDirection.Constants.field_179179_b] = f1;
            }
            if (!(f2 > afloat[FaceDirection.Constants.field_179181_a])) continue;
            afloat[FaceDirection.Constants.field_179181_a] = f2;
        }
        FaceDirection facedirection = FaceDirection.func_179027_a((Direction)p_178408_2_);
        for (int i1 = 0; i1 < 4; ++i1) {
            int j1 = 7 * i1;
            FaceDirection.VertexInformation facedirection$vertexinformation = facedirection.func_179025_a(i1);
            float f8 = afloat[facedirection$vertexinformation.field_179184_a];
            float f3 = afloat[facedirection$vertexinformation.field_179182_b];
            float f4 = afloat[facedirection$vertexinformation.field_179183_c];
            p_178408_1_[j1] = Float.floatToRawIntBits(f8);
            p_178408_1_[j1 + 1] = Float.floatToRawIntBits(f3);
            p_178408_1_[j1 + 2] = Float.floatToRawIntBits(f4);
            for (int k = 0; k < 4; ++k) {
                int l = 7 * k;
                float f5 = Float.intBitsToFloat(aint[l]);
                float f6 = Float.intBitsToFloat(aint[l + 1]);
                float f7 = Float.intBitsToFloat(aint[l + 2]);
                if (!MathHelper.func_180185_a((float)f8, (float)f5) || !MathHelper.func_180185_a((float)f3, (float)f6) || !MathHelper.func_180185_a((float)f4, (float)f7)) continue;
                p_178408_1_[j1 + 4] = aint[l + 4];
                p_178408_1_[j1 + 4 + 1] = aint[l + 4 + 1];
            }
        }
    }

    private void resolvePositionMatrix(Matrix4f points) {
        for (int i = 0; i < 4; ++i) {
            float[] floats = new float[4];
            points.getColumn(i, floats);
            this.positions[i] = new Vector3f(floats);
        }
    }

    private Matrix4f buildPositionMatrix() {
        Matrix4f points = new Matrix4f();
        for (int i = 0; i < 4; ++i) {
            points.setColumn(i, new Vector4f((Tuple3f)this.positions[i]));
        }
        points.setRow(3, 1.0f, 1.0f, 1.0f, 1.0f);
        return points;
    }
}

