/*
 * Decompiled with CFR 0.152.
 */
package piman.recievermod.util.handlers;

import java.util.HashSet;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import piman.recievermod.client.renderer.model.ModelLoaderRegistry;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientSetupEventHandler {
    @SubscribeEvent
    public static void init(FMLClientSetupEvent event) {
        System.out.println("Setup Event");
    }

    @SubscribeEvent
    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        if (event.getMap().getBasePath().equals("textures")) {
            for (Map.Entry entry : ForgeRegistries.ITEMS.getEntries()) {
                ModelLoaderRegistry.getModelOrLogError(entry, "Could Not Load Model");
            }
            for (Map.Entry entry : ModelLoaderRegistry.getUnbakedModels().entrySet()) {
                ((IUnbakedModel)entry.getValue()).func_209559_a(ModelLoaderRegistry.getUnbakedModels()::get, new HashSet()).forEach(arg_0 -> ((TextureStitchEvent.Pre)event).addSprite(arg_0));
            }
        }
        if (event.getMap().getBasePath().equals("textures/particle")) {
            event.addSprite(Particles.ONE_LOCATION);
            event.addSprite(Particles.TWO_LOCATION);
            event.addSprite(Particles.THREE_LOCATION);
            event.addSprite(Particles.FOUR_LOCATION);
            event.addSprite(Particles.FIVE_LOCATION);
            event.addSprite(Particles.SIX_LOCATION);
            event.addSprite(Particles.SEVEN_LOCATION);
            event.addSprite(Particles.EIGHT_LOCATION);
            event.addSprite(Particles.NINE_LOCATION);
            event.addSprite(Particles.ZERO_LOCATION);
        }
    }

    @SubscribeEvent
    public static void onTextureStitchPost(TextureStitchEvent.Post event) {
        if (event.getMap().getBasePath().equals("textures/particle")) {
            Particles.ONE = event.getMap().func_195424_a(Particles.ONE_LOCATION);
            Particles.TWO = event.getMap().func_195424_a(Particles.TWO_LOCATION);
            Particles.THREE = event.getMap().func_195424_a(Particles.THREE_LOCATION);
            Particles.FOUR = event.getMap().func_195424_a(Particles.FOUR_LOCATION);
            Particles.FIVE = event.getMap().func_195424_a(Particles.FIVE_LOCATION);
            Particles.SIX = event.getMap().func_195424_a(Particles.SIX_LOCATION);
            Particles.SEVEN = event.getMap().func_195424_a(Particles.SEVEN_LOCATION);
            Particles.EIGHT = event.getMap().func_195424_a(Particles.EIGHT_LOCATION);
            Particles.NINE = event.getMap().func_195424_a(Particles.NINE_LOCATION);
            Particles.ZERO = event.getMap().func_195424_a(Particles.ZERO_LOCATION);
        }
    }

    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent event) {
        Map map = event.getModelRegistry();
        for (Map.Entry entry : map.entrySet()) {
            if (!ModelLoaderRegistry.loaded((ResourceLocation)entry.getKey())) continue;
            IUnbakedModel unbakedModel = ModelLoaderRegistry.getLoaded((ResourceLocation)entry.getKey());
            IBakedModel bakedModel = unbakedModel.bake((ModelBakery)event.getModelLoader(), arg_0 -> ((AtlasTexture)Minecraft.func_71410_x().func_147117_R()).func_195424_a(arg_0), (ISprite)ModelRotation.X0_Y0, DefaultVertexFormats.field_176599_b);
            entry.setValue(bakedModel);
        }
    }

    public static class Particles {
        public static final ResourceLocation ONE_LOCATION = new ResourceLocation("receiver", "one");
        public static final ResourceLocation TWO_LOCATION = new ResourceLocation("receiver", "two");
        public static final ResourceLocation THREE_LOCATION = new ResourceLocation("receiver", "three");
        public static final ResourceLocation FOUR_LOCATION = new ResourceLocation("receiver", "four");
        public static final ResourceLocation FIVE_LOCATION = new ResourceLocation("receiver", "five");
        public static final ResourceLocation SIX_LOCATION = new ResourceLocation("receiver", "six");
        public static final ResourceLocation SEVEN_LOCATION = new ResourceLocation("receiver", "seven");
        public static final ResourceLocation EIGHT_LOCATION = new ResourceLocation("receiver", "eight");
        public static final ResourceLocation NINE_LOCATION = new ResourceLocation("receiver", "nine");
        public static final ResourceLocation ZERO_LOCATION = new ResourceLocation("receiver", "zero");
        public static TextureAtlasSprite ONE;
        public static TextureAtlasSprite TWO;
        public static TextureAtlasSprite THREE;
        public static TextureAtlasSprite FOUR;
        public static TextureAtlasSprite FIVE;
        public static TextureAtlasSprite SIX;
        public static TextureAtlasSprite SEVEN;
        public static TextureAtlasSprite EIGHT;
        public static TextureAtlasSprite NINE;
        public static TextureAtlasSprite ZERO;
    }
}

