/*
 * Decompiled with CFR 0.152.
 */
package piman.recievermod.util.handlers;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import piman.recievermod.Main;
import piman.recievermod.client.renderer.model.BBGunLoader;
import piman.recievermod.client.renderer.model.JsonGunLoader;
import piman.recievermod.client.renderer.model.ModelLoaderRegistry;
import piman.recievermod.init.ModBlocks;
import piman.recievermod.init.ModEntities;
import piman.recievermod.init.ModItems;
import piman.recievermod.inventory.container.AmmoContainer;
import piman.recievermod.inventory.container.ContainerBulletCrafter;
import piman.recievermod.items.crafting.BulletCrafterRecipe;
import piman.recievermod.items.crafting.BulletCrafterRecipeSerializer;
import piman.recievermod.tileentity.TileEntityBulletCrafter;
import piman.recievermod.util.SoundsHandler;
import piman.recievermod.world.gen.feature.structure.UndergroundPieces;
import piman.recievermod.world.gen.feature.structure.UndergroundStructure;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RegistryEventHandler {
    public static IStructurePieceType UGTP;
    public static IStructurePieceType UGEV;
    public static IStructurePieceType UGSR;
    public static IStructurePieceType UGBR;
    public static IStructurePieceType UGKT;
    public static IStructurePieceType UGLB;
    public static IStructurePieceType UGCR;
    public static IStructurePieceType UGSC;
    public static IRecipeType<BulletCrafterRecipe> BULLET_CRAFTER;

    @SubscribeEvent
    public static void onModelRegistryEvent(ModelRegistryEvent event) {
        ModelLoaderRegistry.clearModelCache(Minecraft.func_71410_x().func_195551_G());
        Main.LOGGER.info("Registering Model Loaders");
        ModelLoaderRegistry.registerLoader(new BBGunLoader());
        ModelLoaderRegistry.registerLoader(new JsonGunLoader());
        ModelLoaderRegistry.registerItems(ModItems.MODELS);
    }

    @SubscribeEvent
    public static void onBlockRegister(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModBlocks.getBlockArray());
    }

    @SubscribeEvent
    public static void onItemRegister(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModItems.getItemArray());
    }

    @SubscribeEvent
    public static void onTileEntityTypeRegister(RegistryEvent.Register<TileEntityType<?>> event) {
        event.getRegistry().register(TileEntityType.Builder.func_223042_a(TileEntityBulletCrafter::new, (Block[])new Block[]{ModBlocks.BULLET_CRAFTER}).func_206865_a(null).setRegistryName("receiver", "bullet_crafter"));
    }

    @SubscribeEvent
    public static void onRecipeSerializerRegister(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        event.getRegistry().register(new BulletCrafterRecipeSerializer().setRegistryName(new ResourceLocation("receiver", "bullet_crafter")));
        BULLET_CRAFTER = IRecipeType.func_222147_a((String)"bullet_crafter");
    }

    @SubscribeEvent
    public static void onEntityRegister(RegistryEvent.Register<EntityType<?>> event) {
        ModEntities.register();
    }

    @SubscribeEvent
    public static void onSoundRegister(RegistryEvent.Register<SoundEvent> event) {
        SoundsHandler.registerSounds();
    }

    @SubscribeEvent
    public static void onFeatureRegister(RegistryEvent.Register<Feature<?>> event) {
        event.getRegistry().register(new UndergroundStructure(NoFeatureConfig::func_214639_a).setRegistryName("receiver", "underground_structure"));
        UGTP = IStructurePieceType.func_214750_a(UndergroundPieces.TestPiece::new, (String)"UGTP");
        UGEV = IStructurePieceType.func_214750_a(UndergroundPieces.Elevator::new, (String)"UGEV");
        UGSR = IStructurePieceType.func_214750_a(UndergroundPieces.ShootingRange::new, (String)"UGSR");
        UGBR = IStructurePieceType.func_214750_a(UndergroundPieces.Barracks::new, (String)"UGBR");
        UGKT = IStructurePieceType.func_214750_a(UndergroundPieces.Kitchen::new, (String)"UGKT");
        UGLB = IStructurePieceType.func_214750_a(UndergroundPieces.Lab::new, (String)"UGLB");
        UGCR = IStructurePieceType.func_214750_a(UndergroundPieces.CorridorJunction::new, (String)"UGCR");
        UGSC = IStructurePieceType.func_214750_a(UndergroundPieces.Stairs::new, (String)"UGSC");
    }

    @SubscribeEvent
    public static void onContainerTypeRegister(RegistryEvent.Register<ContainerType<?>> event) {
        event.getRegistry().register(new ContainerType(AmmoContainer::new).setRegistryName("receiver", "ammo_container"));
        event.getRegistry().register(new ContainerType(ContainerBulletCrafter::new).setRegistryName("receiver", "bullet_crafter"));
    }
}

