/*
 * Decompiled with CFR 0.152.
 */
package piman.recievermod.world.gen.feature.structure;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.StructureMode;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import piman.recievermod.util.handlers.RegistryEventHandler;

public class UndergroundPieces {

    public static class Stairs
    extends AbstractPiece {
        Template template;

        public Stairs(TemplateManager templateManager, Random rand, int x, int y, int z) {
            super(RegistryEventHandler.UGSC, templateManager, rand, x, y, z);
            this.field_186169_c = Rotation.func_222466_a((Random)rand);
            this.doorLocations.put(this.getDoorLocation(new BlockPos(0, 7, 15), this.field_186169_c), Direction.SOUTH);
            this.doorLocations.put(this.getDoorLocation(new BlockPos(0, 0, 0), this.field_186169_c), Direction.NORTH);
            BlockPos pos = (BlockPos)this.doorLocations.keySet().iterator().next();
            this.pos = this.pos.func_177973_b((Vec3i)pos);
            this.template = templateManager.func_200220_a(new ResourceLocation("receiver", "stairs"));
            this.field_74887_e = this.template.func_215388_b(new PlacementSettings().func_186220_a(this.field_186169_c), this.pos);
        }

        public Stairs(TemplateManager templateManager, CompoundNBT nbt) {
            super(RegistryEventHandler.UGSC, nbt);
            this.doorLocations.put(this.getDoorLocation(new BlockPos(0, 7, 15), this.field_186169_c), Direction.SOUTH);
            this.doorLocations.put(this.getDoorLocation(new BlockPos(0, 0, 0), this.field_186169_c), Direction.NORTH);
            this.template = templateManager.func_200220_a(new ResourceLocation("receiver", "stairs"));
            this.field_74887_e = this.template.func_215388_b(new PlacementSettings().func_186220_a(this.field_186169_c), this.pos);
        }

        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos chunkPosIn) {
            this.template.func_186253_b(worldIn, this.pos, new PlacementSettings().func_186220_a(this.field_186169_c).func_186223_a(structureBoundingBoxIn));
            return true;
        }
    }

    public static class CorridorJunction
    extends AbstractPiece {
        Template template;
        Rotation field_186169_c;
        byte wallmask;
        int level;

        public CorridorJunction(TemplateManager templateManager, Random rand, int level, Rotation rotation, int x, int y, int z, byte wallmask) {
            super(RegistryEventHandler.UGCR, templateManager, rand, x, y, z);
            this.template = templateManager.func_200220_a(new ResourceLocation("receiver", "hallway_junction"));
            this.field_186169_c = rotation;
            this.wallmask = wallmask;
            this.level = level;
            this.field_74887_e = this.template.func_215388_b(new PlacementSettings().func_186220_a(this.field_186169_c), this.pos);
            this.func_186164_a(Direction.SOUTH);
        }

        public CorridorJunction(TemplateManager templateManager, CompoundNBT nbt) {
            super(RegistryEventHandler.UGCR, nbt);
            this.template = templateManager.func_200219_b(new ResourceLocation("receiver", "hallway_junction"));
            this.field_186169_c = Rotation.valueOf((String)nbt.func_74779_i("rotation"));
            this.wallmask = nbt.func_74771_c("wallmask");
            this.level = nbt.func_74762_e("level");
            this.field_74887_e = this.template.func_215388_b(new PlacementSettings().func_186220_a(this.field_186169_c), this.pos);
            this.func_186164_a(Direction.SOUTH);
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("rotation", this.field_186169_c.name());
            tagCompound.func_74774_a("wallmask", this.wallmask);
            tagCompound.func_74768_a("level", this.level);
        }

        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos chunkPosIn) {
            int i;
            int j;
            int i2;
            this.template.func_186253_b(worldIn, this.pos, new PlacementSettings().func_186223_a(structureBoundingBoxIn).func_186220_a(this.field_186169_c));
            if ((this.wallmask & 1) != 0) {
                for (i2 = 0; i2 < 3; ++i2) {
                    for (j = 0; j < 3; ++j) {
                        this.func_175811_a(worldIn, Blocks.field_196828_iC.func_176223_P(), 1 + i2, j + 1, 0, structureBoundingBoxIn);
                    }
                }
            }
            if ((this.wallmask & 2) != 0) {
                for (i2 = 0; i2 < 3; ++i2) {
                    for (j = 0; j < 3; ++j) {
                        this.func_175811_a(worldIn, Blocks.field_196828_iC.func_176223_P(), 4, j + 1, i2 + 1, structureBoundingBoxIn);
                    }
                }
            }
            if ((this.wallmask & 4) != 0) {
                for (i2 = 0; i2 < 3; ++i2) {
                    for (j = 0; j < 3; ++j) {
                        this.func_175811_a(worldIn, Blocks.field_196828_iC.func_176223_P(), 1 + i2, j + 1, 4, structureBoundingBoxIn);
                    }
                }
            }
            if ((this.wallmask & 8) != 0) {
                for (i2 = 0; i2 < 3; ++i2) {
                    for (j = 0; j < 3; ++j) {
                        this.func_175811_a(worldIn, Blocks.field_196828_iC.func_176223_P(), 0, j + 1, i2 + 1, structureBoundingBoxIn);
                    }
                }
            }
            int zombieTries = 5 + this.level;
            int skeletonTries = 2 * this.level;
            int witchTries = -5 + 2 * this.level;
            for (i = 0; i < zombieTries; ++i) {
                if (randomIn.nextInt(50) != 0) continue;
                ZombieEntity zombieEntity = new ZombieEntity(worldIn.func_201672_e());
                zombieEntity.func_70107_b((double)this.func_74865_a(2, 2), (double)this.func_74862_a(1), (double)this.func_74873_b(2, 2));
                zombieEntity.func_110163_bv();
                worldIn.func_217376_c((Entity)zombieEntity);
            }
            for (i = 0; i < skeletonTries; ++i) {
                if (randomIn.nextInt(50) != 0) continue;
                SkeletonEntity skeletonEntity = new SkeletonEntity(EntityType.field_200741_ag, worldIn.func_201672_e());
                skeletonEntity.func_70107_b((double)this.func_74865_a(2, 2), (double)this.func_74862_a(1), (double)this.func_74873_b(2, 2));
                skeletonEntity.func_110163_bv();
                skeletonEntity.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)Items.field_151031_f));
                worldIn.func_217376_c((Entity)skeletonEntity);
            }
            for (i = 0; i < witchTries; ++i) {
                if (randomIn.nextInt(50) != 0) continue;
                WitchEntity witchEntity = new WitchEntity(EntityType.field_200759_ay, worldIn.func_201672_e());
                witchEntity.func_70107_b((double)this.func_74865_a(2, 2), (double)this.func_74862_a(1), (double)this.func_74873_b(2, 2));
                witchEntity.func_110163_bv();
                worldIn.func_217376_c((Entity)witchEntity);
            }
            return true;
        }
    }

    public static class Lab
    extends AbstractPiece {
        Template template;

        public Lab(TemplateManager templateManager, Random rand, int x, int y, int z) {
            super(RegistryEventHandler.UGLB, templateManager, rand, x, y, z);
            this.field_186169_c = Rotation.func_222466_a((Random)rand);
            this.doorLocations.put(this.getDoorLocation(new BlockPos(0, 0, 0), this.field_186169_c), Direction.NORTH);
            this.pos = this.pos.func_177973_b((Vec3i)this.doorLocations.keySet().iterator().next());
            this.template = templateManager.func_200220_a(new ResourceLocation("receiver", "laboratory"));
            this.field_74887_e = this.template.func_215388_b(new PlacementSettings().func_186220_a(this.field_186169_c), this.pos);
        }

        public Lab(TemplateManager templateManager, CompoundNBT nbt) {
            super(RegistryEventHandler.UGLB, nbt);
            this.doorLocations.put(this.getDoorLocation(new BlockPos(0, 0, 0), this.field_186169_c), Direction.NORTH);
            this.template = templateManager.func_200220_a(new ResourceLocation("receiver", "laboratory"));
            this.field_74887_e = this.template.func_215388_b(new PlacementSettings().func_186220_a(this.field_186169_c), this.pos);
        }

        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos chunkPosIn) {
            this.template.func_186253_b(worldIn, this.pos, new PlacementSettings().func_186220_a(this.field_186169_c).func_186223_a(structureBoundingBoxIn));
            return true;
        }
    }

    public static class Kitchen
    extends AbstractPiece {
        Template template;

        public Kitchen(TemplateManager templateManager, Random rand, int x, int y, int z) {
            super(RegistryEventHandler.UGKT, templateManager, rand, x, y, z);
            this.field_186169_c = Rotation.func_222466_a((Random)rand);
            this.doorLocations.put(this.getDoorLocation(new BlockPos(1, 0, 0), this.field_186169_c), Direction.NORTH);
            this.doorLocations.put(this.getDoorLocation(new BlockPos(-4, 0, 10), this.field_186169_c), Direction.WEST);
            this.doorLocations.put(this.getDoorLocation(new BlockPos(-4, 0, 20), this.field_186169_c), Direction.WEST);
            this.doorLocations.put(this.getDoorLocation(new BlockPos(1, 0, 30), this.field_186169_c), Direction.SOUTH);
            BlockPos pos = (BlockPos)this.doorLocations.keySet().iterator().next();
            this.pos = this.pos.func_177973_b((Vec3i)pos);
            this.template = templateManager.func_200220_a(new ResourceLocation("receiver", "kitchen"));
            this.field_74887_e = this.template.func_215388_b(new PlacementSettings().func_186220_a(this.field_186169_c), this.pos);
        }

        public Kitchen(TemplateManager templateManager, CompoundNBT nbt) {
            super(RegistryEventHandler.UGKT, nbt);
            this.doorLocations.put(this.getDoorLocation(new BlockPos(1, 0, 0), this.field_186169_c), Direction.NORTH);
            this.doorLocations.put(this.getDoorLocation(new BlockPos(-4, 0, 10), this.field_186169_c), Direction.WEST);
            this.doorLocations.put(this.getDoorLocation(new BlockPos(-4, 0, 20), this.field_186169_c), Direction.WEST);
            this.doorLocations.put(this.getDoorLocation(new BlockPos(1, 0, 30), this.field_186169_c), Direction.SOUTH);
            this.template = templateManager.func_200220_a(new ResourceLocation("receiver", "kitchen"));
            this.field_74887_e = this.template.func_215388_b(new PlacementSettings().func_186220_a(this.field_186169_c), this.pos);
        }

        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos chunkPosIn) {
            PlacementSettings settings = new PlacementSettings().func_186220_a(this.field_186169_c).func_186223_a(structureBoundingBoxIn).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            if (this.template.func_189962_a(worldIn, this.pos, settings, 2)) {
                this.handleDataMarkers(worldIn, randomIn, this.template, this.pos, settings);
            }
            return true;
        }

        @Override
        protected void handleDataMarker(String function, BlockPos pos, IWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if (function.equals("barrel")) {
                this.func_191080_a(worldIn, sbb, rand, pos, new ResourceLocation("receiver", "kitchen"), (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((IProperty)ChestBlock.field_176459_a, (Comparable)this.field_186169_c.func_185831_a(Direction.WEST)));
            }
        }
    }

    public static class Barracks
    extends AbstractPiece {
        Template template;

        public Barracks(TemplateManager templateManager, Random rand, int x, int y, int z) {
            super(RegistryEventHandler.UGBR, templateManager, rand, x, y, z);
            this.field_186169_c = Rotation.func_222466_a((Random)rand);
            this.template = templateManager.func_200220_a(new ResourceLocation("receiver", "barracks"));
            this.doorLocations.put(this.getDoorLocation(new BlockPos(0, 0, 0), this.field_186169_c), Direction.NORTH);
            BlockPos pos = (BlockPos)this.doorLocations.keySet().iterator().next();
            this.pos = this.pos.func_177973_b((Vec3i)pos);
            this.field_74887_e = this.template.func_215388_b(new PlacementSettings().func_186220_a(this.field_186169_c), this.pos);
        }

        public Barracks(TemplateManager templateManager, CompoundNBT nbt) {
            super(RegistryEventHandler.UGBR, nbt);
            this.template = templateManager.func_200220_a(new ResourceLocation("receiver", "barracks"));
            this.field_186169_c = Rotation.valueOf((String)nbt.func_74779_i("rotation"));
            this.doorLocations.put(this.getDoorLocation(new BlockPos(0, 0, 0), this.field_186169_c), Direction.NORTH);
            this.field_74887_e = this.template.func_215388_b(new PlacementSettings().func_186220_a(this.field_186169_c), this.pos);
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("rotation", this.field_186169_c.name());
        }

        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos chunkPosIn) {
            PlacementSettings settings = new PlacementSettings().func_186220_a(this.field_186169_c).func_186223_a(structureBoundingBoxIn).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.template.func_186253_b(worldIn, this.pos, settings);
            this.handleDataMarkers(worldIn, randomIn, this.template, this.pos, settings);
            return true;
        }

        @Override
        protected void handleDataMarker(String function, BlockPos pos, IWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if (function.equals("chest_left")) {
                this.func_191080_a(worldIn, sbb, rand, pos, new ResourceLocation("receiver", "barracks"), (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((IProperty)ChestBlock.field_176459_a, (Comparable)this.field_186169_c.func_185831_a(Direction.WEST)));
            }
            if (function.equals("chest_right")) {
                this.func_191080_a(worldIn, sbb, rand, pos, new ResourceLocation("receiver", "barracks"), (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((IProperty)ChestBlock.field_176459_a, (Comparable)this.field_186169_c.func_185831_a(Direction.EAST)));
            }
        }
    }

    public static class ShootingRange
    extends AbstractPiece {
        Template shootingRange;

        public ShootingRange(TemplateManager templateManager, Random rand, int x, int y, int z) {
            super(RegistryEventHandler.UGSR, templateManager, rand, x, y, z);
            this.field_186169_c = Rotation.func_222466_a((Random)rand);
            this.doorLocations.put(this.getDoorLocation(new BlockPos(2, 0, 0), this.field_186169_c), Direction.NORTH);
            BlockPos pos = (BlockPos)this.doorLocations.keySet().iterator().next();
            this.pos = this.pos.func_177973_b((Vec3i)pos);
            this.shootingRange = templateManager.func_200220_a(new ResourceLocation("receiver", "shooting_range"));
            this.field_74887_e = this.shootingRange.func_215388_b(new PlacementSettings().func_186220_a(this.field_186169_c), this.pos);
        }

        public ShootingRange(TemplateManager templateManager, CompoundNBT nbt) {
            super(RegistryEventHandler.UGSR, nbt);
            this.shootingRange = templateManager.func_200220_a(new ResourceLocation("receiver", "shooting_range"));
            this.doorLocations.put(this.getDoorLocation(new BlockPos(2, 0, 0), this.field_186169_c), Direction.NORTH);
            this.field_74887_e = this.shootingRange.func_215388_b(new PlacementSettings().func_186220_a(this.field_186169_c), this.pos);
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
        }

        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos chunkPosIn) {
            PlacementSettings settings = new PlacementSettings().func_186220_a(this.field_186169_c).func_186223_a(structureBoundingBoxIn).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.shootingRange.func_186253_b(worldIn, this.pos, settings);
            this.handleDataMarkers(worldIn, randomIn, this.shootingRange, this.pos, settings);
            return true;
        }

        @Override
        protected void handleDataMarker(String function, BlockPos pos, IWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if (function.equals("chest")) {
                this.func_191080_a(worldIn, sbb, rand, pos, new ResourceLocation("receiver", "shooting_range"), (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((IProperty)ChestBlock.field_176459_a, (Comparable)this.field_186169_c.func_185831_a(Direction.SOUTH)));
            }
        }
    }

    public static class Elevator
    extends AbstractPiece {
        Template elevatorTop;
        Template elevatorMid;
        Template elevatorBot;
        Template elevator;
        int height;
        int elevatorLoc;

        public Elevator(TemplateManager templateManager, Random rand, int x, int y, int z) {
            super(RegistryEventHandler.UGEV, templateManager, rand, x, y, z);
            int i;
            this.elevatorTop = templateManager.func_200220_a(new ResourceLocation("receiver", "elevator_top"));
            this.elevatorMid = templateManager.func_200220_a(new ResourceLocation("receiver", "elevator_mid"));
            this.elevatorBot = templateManager.func_200220_a(new ResourceLocation("receiver", "elevator_bot"));
            this.elevator = templateManager.func_200220_a(new ResourceLocation("receiver", "elevator"));
            this.doorLocations.put(new BlockPos(0, 0, 0), Direction.NORTH);
            this.height = rand.nextInt(5) + y / 7 - 6;
            this.elevatorLoc = rand.nextInt(this.height * 7 + 10);
            for (i = 0; i < this.height; ++i) {
                this.doorLocations.put(new BlockPos(0, -7 * (i + 1), 0), Direction.NORTH);
            }
            this.field_74887_e = this.elevatorTop.func_215388_b(new PlacementSettings(), this.pos);
            for (i = 0; i < this.height; ++i) {
                this.field_74887_e.func_78888_b(this.elevatorMid.func_215388_b(new PlacementSettings(), this.pos.func_177982_a(0, -7 * (i + 1), 0)));
            }
            this.field_74887_e.func_78888_b(this.elevatorBot.func_215388_b(new PlacementSettings(), this.pos.func_177982_a(0, -7 * (i + 1) - 2, 0)));
        }

        public Elevator(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(RegistryEventHandler.UGEV, compoundNBT);
            int i;
            this.elevatorTop = templateManager.func_200220_a(new ResourceLocation("receiver", "elevator_top"));
            this.elevatorMid = templateManager.func_200220_a(new ResourceLocation("receiver", "elevator_mid"));
            this.elevatorBot = templateManager.func_200220_a(new ResourceLocation("receiver", "elevator_bot"));
            this.elevator = templateManager.func_200220_a(new ResourceLocation("receiver", "elevator"));
            this.height = compoundNBT.func_74762_e("height");
            this.elevatorLoc = compoundNBT.func_74762_e("elevatorLoc");
            this.field_74887_e = this.elevatorTop.func_215388_b(new PlacementSettings(), this.pos);
            for (i = 0; i < this.height; ++i) {
                this.field_74887_e.func_78888_b(this.elevatorMid.func_215388_b(new PlacementSettings(), this.pos.func_177982_a(0, -7 * (i + 1), 0)));
            }
            this.field_74887_e.func_78888_b(this.elevatorBot.func_215388_b(new PlacementSettings(), this.pos.func_177982_a(0, -7 * (i + 1) - 2, 0)));
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74768_a("height", this.height);
            tagCompound.func_74768_a("elevatorLoc", this.elevatorLoc);
        }

        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos chunkPosIn) {
            int i;
            this.elevatorTop.func_186253_b(worldIn, this.pos, new PlacementSettings().func_186223_a(structureBoundingBoxIn));
            for (i = 0; i < this.height; ++i) {
                this.elevatorMid.func_186253_b(worldIn, this.pos.func_177982_a(0, -7 * (i + 1), 0), new PlacementSettings().func_186223_a(structureBoundingBoxIn));
            }
            this.elevatorBot.func_186253_b(worldIn, this.pos.func_177982_a(0, -7 * (i + 1) - 2, 0), new PlacementSettings().func_186223_a(structureBoundingBoxIn));
            this.elevator.func_186253_b(worldIn, this.pos.func_177982_a(0, -7 * (i + 1) - 2 + this.elevatorLoc, 0), new PlacementSettings().func_186223_a(structureBoundingBoxIn));
            return true;
        }
    }

    public static abstract class AbstractPiece
    extends StructurePiece {
        protected BlockPos pos;
        protected Rotation field_186169_c;
        protected Map<BlockPos, Direction> doorLocations = new LinkedHashMap<BlockPos, Direction>();

        public AbstractPiece(IStructurePieceType type, TemplateManager templateManager, Random rand, int x, int y, int z) {
            super(type, 0);
            this.pos = new BlockPos(x, y, z);
            this.field_186169_c = Rotation.NONE;
        }

        public AbstractPiece(IStructurePieceType type, CompoundNBT nbt) {
            super(type, nbt);
            this.pos = AbstractPiece.readBlockPos(nbt, "pos");
            this.field_186169_c = Rotation.valueOf((String)nbt.func_74779_i("rotation"));
            int i1 = nbt.func_74762_e("doorLocationsSize");
            for (int i = 0; i < i1; ++i) {
                BlockPos location = AbstractPiece.readBlockPos(nbt, i + "location");
                Direction direction = Direction.func_176739_a((String)nbt.func_74779_i(i + "direction"));
                this.doorLocations.put(location, direction);
            }
        }

        protected void handleDataMarkers(IWorld worldIn, Random randomIn, Template template, BlockPos pos, PlacementSettings placeSettings) {
            for (Template.BlockInfo template$blockinfo : template.func_215381_a(pos, placeSettings, Blocks.field_185779_df)) {
                StructureMode structuremode;
                if (template$blockinfo.field_186244_c == null || (structuremode = StructureMode.valueOf((String)template$blockinfo.field_186244_c.func_74779_i("mode"))) != StructureMode.DATA) continue;
                this.handleDataMarker(template$blockinfo.field_186244_c.func_74779_i("metadata"), template$blockinfo.field_186242_a, worldIn, randomIn, placeSettings.func_186213_g());
            }
        }

        protected void handleDataMarker(String function, BlockPos pos, IWorld worldIn, Random rand, MutableBoundingBox sbb) {
        }

        public static <T extends AbstractPiece> AbstractPiece fitPiece(TemplateManager manager, Random rand, int sizeX, int sizeZ, BlockPos center, boolean[][] mask, int tries, Factory<T> factory) {
            Object piece = null;
            block0: while (piece == null && tries-- > 0) {
                int i = rand.nextInt(sizeX) - sizeX / 2;
                int j = rand.nextInt(sizeZ) - sizeZ / 2;
                i = i / 5 * 5;
                j = j / 5 * 5;
                piece = factory.generate(manager, rand, center.func_177958_n() + i, center.func_177956_o(), center.func_177952_p() + j);
                block1: for (int u = piece.field_74887_e.field_78897_a; u < piece.field_74887_e.field_78893_d; ++u) {
                    for (int v = piece.field_74887_e.field_78896_c; v < piece.field_74887_e.field_78892_f; ++v) {
                        int i1 = u - center.func_177958_n() + sizeX / 2;
                        int j1 = v - center.func_177952_p() + sizeZ / 2;
                        if (i1 >= 0 && j1 >= 0 && i1 < sizeX && j1 < sizeZ && mask[i1][j1]) continue;
                        piece = null;
                        break block1;
                    }
                }
                if (piece == null) continue;
                for (BlockPos door : piece.doorLocations.keySet()) {
                    i = piece.pos.func_177958_n() + door.func_177958_n() - center.func_177958_n() + sizeX / 2;
                    j = piece.pos.func_177952_p() + door.func_177952_p() - center.func_177952_p() + sizeZ / 2;
                    for (int u = 0; u < 5; ++u) {
                        for (int v = -4; v < 1; ++v) {
                            int i1 = u + i;
                            int j1 = v + j;
                            if (i1 >= 0 && j1 >= 0 && i1 < sizeX && j1 < sizeZ && door.func_177956_o() >= 0 && mask[i1][j1]) continue;
                            piece = null;
                            continue block0;
                        }
                    }
                }
            }
            return piece;
        }

        protected BlockPos getDoorLocation(BlockPos pos, Rotation rotation) {
            switch (rotation) {
                case NONE: {
                    return pos;
                }
                case CLOCKWISE_90: {
                    return new BlockPos(-pos.func_177952_p(), pos.func_177956_o(), pos.func_177958_n() + 4);
                }
                case CLOCKWISE_180: {
                    return new BlockPos(-pos.func_177958_n() - 4, pos.func_177956_o(), -pos.func_177952_p() + 4);
                }
                case COUNTERCLOCKWISE_90: {
                    return new BlockPos(pos.func_177952_p() - 4, pos.func_177956_o(), -pos.func_177958_n());
                }
            }
            return BlockPos.field_177992_a;
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            AbstractPiece.writeBlockPos(tagCompound, "pos", this.pos);
            tagCompound.func_74778_a("rotation", this.field_186169_c.name());
            int i1 = this.doorLocations.size();
            tagCompound.func_74768_a("doorLocationsSize", this.doorLocations.size());
            int i = 0;
            for (Map.Entry<BlockPos, Direction> entry : this.doorLocations.entrySet()) {
                AbstractPiece.writeBlockPos(tagCompound, i + "location", entry.getKey());
                tagCompound.func_74778_a(i + "direction", entry.getValue().func_176610_l());
                ++i;
            }
        }

        protected static void writeBlockPos(CompoundNBT nbt, String name, BlockPos pos) {
            nbt.func_74768_a(name + "X", pos.func_177958_n());
            nbt.func_74768_a(name + "Y", pos.func_177956_o());
            nbt.func_74768_a(name + "Z", pos.func_177952_p());
        }

        protected static BlockPos readBlockPos(CompoundNBT nbt, String name) {
            return new BlockPos(nbt.func_74762_e(name + "X"), nbt.func_74762_e(name + "Y"), nbt.func_74762_e(name + "Z"));
        }

        public static interface Factory<T extends AbstractPiece> {
            public T generate(TemplateManager var1, Random var2, int var3, int var4, int var5);
        }
    }

    public static class TestPiece
    extends StructurePiece {
        public TestPiece(TemplateManager templateManager, int x, int y, int z) {
            super(RegistryEventHandler.UGTP, new CompoundNBT());
            this.field_74887_e = new MutableBoundingBox(x, y, z, x + 1, y + 1, z + 1);
        }

        public TestPiece(TemplateManager templateManager, CompoundNBT nbt) {
            super(RegistryEventHandler.UGTP, nbt);
        }

        protected void func_143011_b(@Nonnull CompoundNBT tagCompound) {
        }

        public boolean func_74875_a(@Nonnull IWorld worldIn, @Nonnull Random randomIn, @Nonnull MutableBoundingBox structureBoundingBoxIn, @Nonnull ChunkPos chunkPosIn) {
            this.func_175811_a(worldIn, Blocks.field_150478_aa.func_176223_P(), 0, 0, 0, structureBoundingBoxIn);
            return true;
        }
    }
}

