/*
 * Decompiled with CFR 0.152.
 */
package piman.recievermod.world.gen.feature.structure;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.Dynamic;
import io.github.jdiemke.triangulation.DelaunayTriangulator;
import io.github.jdiemke.triangulation.Edge2D;
import io.github.jdiemke.triangulation.NotEnoughPointsException;
import io.github.jdiemke.triangulation.Triangle2D;
import io.github.jdiemke.triangulation.Vector2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.UpgradeData;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.commons.lang3.tuple.Pair;
import piman.recievermod.world.gen.feature.structure.UndergroundPieces;

public class UndergroundStructure
extends Structure<NoFeatureConfig> {
    private static final int BLOCK_SIZE = 20;
    private static final int MIN_DISTANCE = 13;

    public UndergroundStructure(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean func_202372_a(@Nonnull ChunkGenerator<?> chunkGen, @Nonnull Random rand, int chunkPosX, int chunkPosZ) {
        int blockX = chunkPosX / 20;
        int blockZ = chunkPosZ / 20;
        Random blockRand = new Random(chunkGen.func_202089_c() + (long)blockX << 16 + blockZ);
        int offsetX = blockRand.nextInt(7);
        int offsetZ = blockRand.nextInt(7);
        return chunkPosX == blockX * 20 + offsetX && chunkPosZ == blockZ * 20 + offsetZ;
    }

    @Nullable
    public BlockPos func_211405_a(@Nonnull World worldIn, ChunkGenerator<? extends GenerationSettings> chunkGenerator, BlockPos pos, int radius, boolean p_211405_5_) {
        int blockX = (pos.func_177958_n() >> 4) / 20;
        int blockZ = (pos.func_177952_p() >> 4) / 20;
        Random blockRand = new Random(chunkGenerator.func_202089_c() + (long)blockX << 16 + blockZ);
        int offsetX = blockRand.nextInt(7);
        int offsetZ = blockRand.nextInt(7);
        return new BlockPos((blockX * 20 + offsetX) * 16, 0, (blockZ * 20 + offsetZ) * 16);
    }

    @Nonnull
    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    @Nonnull
    public String func_143025_a() {
        return "receiver:underground";
    }

    public int func_202367_b() {
        return 0;
    }

    public static class Start
    extends StructureStart {
        private int sizeX = 201;
        private int sizeZ = 201;
        private int[][] heightMap;
        private List<boolean[][]> heightBitMasks = new ArrayList<boolean[][]>();
        private List<boolean[][]> roomBitMasks = new ArrayList<boolean[][]>();
        private List<boolean[][]> hallwayBitMasks = new ArrayList<boolean[][]>();
        private List<boolean[][]> doorwayBitMasks = new ArrayList<boolean[][]>();
        private static final ImmutableList<UndergroundPieces.AbstractPiece.Factory<?>> specialRooms = ImmutableList.of(UndergroundPieces.Kitchen::new, UndergroundPieces.ShootingRange::new, UndergroundPieces.Lab::new);
        private List<UndergroundPieces.AbstractPiece> rooms = new ArrayList<UndergroundPieces.AbstractPiece>();
        private List<UndergroundPieces.AbstractPiece> corridors = new ArrayList<UndergroundPieces.AbstractPiece>();
        private ChunkGenerator<?> generator;
        private TemplateManager templateManager;
        private BlockPos spawnCenter;
        private boolean didSpawn = false;
        private boolean init = false;

        public Start(Structure<?> structureIn, int chunkX, int chunkZ, Biome biomeIn, MutableBoundingBox boundsIn, int referenceIn, long seed) {
            super(structureIn, chunkX, chunkZ, biomeIn, boundsIn, referenceIn, seed);
            this.heightMap = new int[this.sizeX][this.sizeZ];
        }

        public void func_214625_a(@Nonnull ChunkGenerator<?> generator, @Nonnull TemplateManager templateManagerIn, int chunkX, int chunkZ, @Nonnull Biome biomeIn) {
            this.generator = generator;
            this.templateManager = templateManagerIn;
            this.spawnCenter = new BlockPos(chunkX * 16 + 8, 0, chunkZ * 16 + 8);
            this.spawnCenter = this.spawnCenter.func_177982_a(0, generator.func_222531_c(this.spawnCenter.func_177958_n(), this.spawnCenter.func_177952_p(), Heightmap.Type.OCEAN_FLOOR_WG), 0);
            MutableBoundingBox bbox = MutableBoundingBox.func_78887_a();
            bbox.func_78888_b(new MutableBoundingBox((Vec3i)this.spawnCenter.func_177982_a(-this.sizeX / 2, 0, -this.sizeZ / 2), (Vec3i)this.spawnCenter.func_177982_a(this.sizeX / 2, 0, this.sizeZ / 2)));
            this.field_75074_b = bbox;
            this.init = true;
            try {
                IWorld world = (IWorld)ObfuscationReflectionHelper.findField(ChunkGenerator.class, (String)"field_222540_a").get(generator);
                this.generateComponents(world);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }

        public boolean func_75069_d() {
            return this.init || super.func_75069_d();
        }

        public void generateComponents(IWorld worldIn) {
            int h;
            this.didSpawn = true;
            if (this.spawnCenter == null) {
                System.out.println("WFT is going on");
                return;
            }
            UndergroundPieces.Elevator elevator = new UndergroundPieces.Elevator(this.templateManager, (Random)this.field_214631_d, this.spawnCenter.func_177958_n(), this.spawnCenter.func_177956_o(), this.spawnCenter.func_177952_p());
            this.rooms.add(elevator);
            ArrayList layerPoints = new ArrayList();
            for (h = 0; h <= elevator.height; ++h) {
                this.heightBitMasks.add(new boolean[this.sizeX][this.sizeZ]);
                this.roomBitMasks.add(new boolean[this.sizeX][this.sizeZ]);
                this.hallwayBitMasks.add(new boolean[this.sizeX / 5][this.sizeZ / 5]);
                this.doorwayBitMasks.add(new boolean[this.sizeX][this.sizeZ]);
                layerPoints.add(new HashSet());
            }
            for (h = 0; h <= elevator.height; ++h) {
                ArrayList<UndergroundPieces.AbstractPiece> rooms;
                block27: {
                    int j;
                    rooms = new ArrayList<UndergroundPieces.AbstractPiece>();
                    int area = 0;
                    rooms.add(elevator);
                    this.addRoomToMasks(this.roomBitMasks, elevator, this.spawnCenter);
                    this.addDoorToMasks(this.doorwayBitMasks, elevator, this.spawnCenter);
                    this.generateHeightBitMap(worldIn, this.heightBitMasks.get(h), this.sizeX / 2, this.sizeZ / 2, this.spawnCenter.func_177982_a(0, -1 - 7 * h, 0));
                    for (int i = 0; i < this.sizeX; ++i) {
                        for (int j2 = 0; j2 < this.sizeZ; ++j2) {
                            if (!this.heightBitMasks.get(h)[i][j2]) continue;
                            ++area;
                        }
                    }
                    ArrayList pieces = Lists.newArrayList((Object[])new UndergroundPieces.AbstractPiece.Factory[]{UndergroundPieces.Barracks::new, UndergroundPieces.Barracks::new, UndergroundPieces.Barracks::new, UndergroundPieces.Barracks::new, UndergroundPieces.Barracks::new});
                    pieces.add(specialRooms.get(this.field_214631_d.nextInt(specialRooms.size())));
                    pieces.add(specialRooms.get(this.field_214631_d.nextInt(specialRooms.size())));
                    pieces.add(specialRooms.get(this.field_214631_d.nextInt(specialRooms.size())));
                    if (h < elevator.height) {
                        pieces.add(0, UndergroundPieces.Stairs::new);
                    }
                    while (!pieces.isEmpty()) {
                        boolean[][] mask = new boolean[this.sizeX][this.sizeZ];
                        for (int i = 0; i < this.sizeX; ++i) {
                            for (j = 0; j < this.sizeZ; ++j) {
                                mask[i][j] = this.heightBitMasks.get(h)[i][j] & !this.roomBitMasks.get(h)[i][j] & !this.doorwayBitMasks.get(h)[i][j];
                            }
                        }
                        UndergroundPieces.AbstractPiece room = UndergroundPieces.AbstractPiece.fitPiece(this.templateManager, (Random)this.field_214631_d, this.sizeX, this.sizeZ, this.spawnCenter.func_177982_a(0, -7 - 7 * h, 0), mask, 100, (UndergroundPieces.AbstractPiece.Factory)pieces.remove(0));
                        if (room == null) continue;
                        this.addRoomToMasks(this.roomBitMasks, room, this.spawnCenter);
                        this.addDoorToMasks(this.doorwayBitMasks, room, this.spawnCenter);
                        rooms.add(room);
                    }
                    boolean[][] mask1 = new boolean[this.sizeX][this.sizeZ];
                    for (int i = 0; i < this.sizeX; ++i) {
                        for (j = 0; j < this.sizeZ; ++j) {
                            mask1[i][j] = this.heightBitMasks.get(h)[i][j];
                        }
                    }
                    HashMap<Vector2D, UndergroundPieces.AbstractPiece> locationMap = new HashMap<Vector2D, UndergroundPieces.AbstractPiece>();
                    for (UndergroundPieces.AbstractPiece room : rooms) {
                        int i = room.pos.func_177958_n() - this.spawnCenter.func_177958_n() + this.sizeX / 2;
                        int j3 = room.pos.func_177952_p() - this.spawnCenter.func_177952_p() + this.sizeZ / 2;
                        for (BlockPos pos : room.doorLocations.keySet()) {
                            Vector2D point = new Vector2D(i + pos.func_177958_n(), j3 + pos.func_177952_p());
                            ((Set)layerPoints.get((room.pos.func_177956_o() - this.spawnCenter.func_177956_o() + 1) / -7 - pos.func_177956_o() / 7)).add(point);
                            locationMap.put(point, room);
                        }
                    }
                    ArrayList<Vector2D> points = new ArrayList<Vector2D>((Collection)layerPoints.get(h));
                    try {
                        DelaunayTriangulator triangulator = new DelaunayTriangulator(points);
                        triangulator.triangulate();
                        List<Triangle2D> triangles = triangulator.getTriangles();
                        HashSet<Edge2D> edges = new HashSet<Edge2D>();
                        for (Triangle2D triangle : triangles) {
                            Edge2D edge1 = new Edge2D(triangle.a, triangle.b);
                            Edge2D edge2 = new Edge2D(triangle.b, triangle.c);
                            Edge2D edge3 = new Edge2D(triangle.c, triangle.a);
                            edges.add(edge1);
                            edges.add(edge2);
                            edges.add(edge3);
                        }
                        boolean[][] mask = new boolean[this.sizeX][this.sizeZ];
                        for (int i = 0; i < this.sizeX; ++i) {
                            for (int j4 = 0; j4 < this.sizeZ; ++j4) {
                                mask[i][j4] = this.heightBitMasks.get(h)[i][j4] & !this.roomBitMasks.get(h)[i][j4];
                            }
                        }
                        HashSet<Vector2D> connectedPoints = new HashSet<Vector2D>();
                        for (Edge2D edge : edges) {
                            if (!this.connectDoors(mask, this.hallwayBitMasks.get(h), edge.a, edge.b)) continue;
                            connectedPoints.add(edge.a);
                            connectedPoints.add(edge.b);
                        }
                        locationMap.keySet().retainAll(connectedPoints);
                        rooms.retainAll(locationMap.values());
                    }
                    catch (NotEnoughPointsException e) {
                        if (points.size() != 2) break block27;
                        boolean[][] mask = new boolean[this.sizeX][this.sizeZ];
                        for (int i = 0; i < this.sizeX; ++i) {
                            for (int j5 = 0; j5 < this.sizeZ; ++j5) {
                                mask[i][j5] = this.heightBitMasks.get(h)[i][j5] & !this.roomBitMasks.get(h)[i][j5];
                            }
                        }
                        this.connectDoors(mask, this.hallwayBitMasks.get(h), (Vector2D)points.get(1), (Vector2D)points.get(0));
                    }
                }
                for (int i = 0; i < this.sizeX / 5; ++i) {
                    for (int j = 0; j < this.sizeZ / 5; ++j) {
                        if (!this.hallwayBitMasks.get(h)[i][j]) continue;
                        byte wallmask = 0;
                        if (!this.testMask(this.hallwayBitMasks.get(h), this.sizeX / 5, this.sizeZ / 5, i, j - 1)) {
                            wallmask = (byte)(wallmask | 1);
                        }
                        if (!this.testMask(this.hallwayBitMasks.get(h), this.sizeX / 5, this.sizeZ / 5, i + 1, j)) {
                            wallmask = (byte)(wallmask | 2);
                        }
                        if (!this.testMask(this.hallwayBitMasks.get(h), this.sizeX / 5, this.sizeZ / 5, i, j + 1)) {
                            wallmask = (byte)(wallmask | 4);
                        }
                        if (!this.testMask(this.hallwayBitMasks.get(h), this.sizeX / 5, this.sizeZ / 5, i - 1, j)) {
                            wallmask = (byte)(wallmask | 8);
                        }
                        this.corridors.add(new UndergroundPieces.CorridorJunction(this.templateManager, (Random)this.field_214631_d, h, Rotation.NONE, i * 5 + this.spawnCenter.func_177958_n() - this.sizeX / 2, this.spawnCenter.func_177956_o() - 7 - 7 * h, j * 5 + this.spawnCenter.func_177952_p() - this.sizeZ / 2 + 1, wallmask));
                    }
                }
                this.rooms.addAll(rooms);
            }
            this.field_75075_a.addAll(this.corridors);
            this.field_75075_a.addAll(this.rooms);
            this.func_202500_a();
        }

        public void func_75068_a(@Nonnull IWorld worldIn, @Nonnull Random rand, @Nonnull MutableBoundingBox structurebb, @Nonnull ChunkPos pos) {
            super.func_75068_a(worldIn, rand, structurebb, pos);
        }

        public void addRoomToMasks(List<boolean[][]> masks, UndergroundPieces.AbstractPiece room, BlockPos center) {
            for (int w = (room.func_74874_b().field_78894_e - center.func_177956_o() + 1) / -7; w <= (room.func_74874_b().field_78895_b - center.func_177956_o() + 1) / -7; ++w) {
                if (w < 0 || w >= masks.size()) continue;
                for (int u = room.func_74874_b().field_78897_a + 1; u < room.func_74874_b().field_78893_d; ++u) {
                    for (int v = room.func_74874_b().field_78896_c + 1; v < room.func_74874_b().field_78892_f; ++v) {
                        int i = u - center.func_177958_n() + this.sizeX / 2;
                        int j = v - center.func_177952_p() + this.sizeZ / 2;
                        masks.get((int)w)[i][j] = true;
                    }
                }
            }
        }

        public void addDoorToMasks(List<boolean[][]> masks, UndergroundPieces.AbstractPiece room, BlockPos center) {
            for (BlockPos door : room.doorLocations.keySet()) {
                int w = (room.pos.func_177956_o() - center.func_177956_o() + 1) / -7 - door.func_177956_o() / 7;
                if (w < 0) continue;
                int i1 = room.pos.func_177958_n() - center.func_177958_n() + this.sizeX / 2;
                int j1 = room.pos.func_177952_p() - center.func_177952_p() + this.sizeZ / 2;
                for (int i = 0; i < 5; ++i) {
                    for (int j = -4; j < 1; ++j) {
                        masks.get((int)w)[door.func_177958_n() + i + i1][door.func_177952_p() + j + j1] = true;
                    }
                }
            }
        }

        public boolean connectDoors(boolean[][] mask, boolean[][] hallwayBitMask, Vector2D posA, Vector2D posB) {
            Node end = this.findPath(mask, hallwayBitMask, (int)posA.x, (int)posA.y - 4, (int)posB.x, (int)posB.y - 4);
            if (end == null) {
                return false;
            }
            Node temp = end;
            while (temp != null) {
                hallwayBitMask[temp.i / 5][temp.j / 5] = true;
                temp = temp.prev;
            }
            return true;
        }

        public void generateHeightBitMap(IWorld iWorld, boolean[][] map, int i, int j, BlockPos center) {
            if (i < 0 || j < 0 || i >= this.sizeX || j >= this.sizeZ || map[i][j]) {
                return;
            }
            LinkedList<Pair> queue = new LinkedList<Pair>();
            queue.add(Pair.of((Object)i, (Object)j));
            while (!queue.isEmpty()) {
                Pair p = (Pair)queue.poll();
                BlockPos pos = center.func_177982_a((Integer)p.getLeft() - this.sizeX / 2, 0, (Integer)p.getRight() - this.sizeZ / 2);
                if (this.test(iWorld, map, pos.func_177982_a(1, 0, 0), (Integer)p.getLeft() + 1, (Integer)p.getRight())) {
                    map[((Integer)p.getLeft()).intValue() + 1][((Integer)p.getRight()).intValue()] = true;
                    queue.add(Pair.of((Object)((Integer)p.getLeft() + 1), (Object)p.getRight()));
                }
                if (this.test(iWorld, map, pos.func_177982_a(0, 0, 1), (Integer)p.getLeft(), (Integer)p.getRight() + 1)) {
                    map[((Integer)p.getLeft()).intValue()][((Integer)p.getRight()).intValue() + 1] = true;
                    queue.add(Pair.of((Object)p.getLeft(), (Object)((Integer)p.getRight() + 1)));
                }
                if (this.test(iWorld, map, pos.func_177982_a(-1, 0, 0), (Integer)p.getLeft() - 1, (Integer)p.getRight())) {
                    map[((Integer)p.getLeft()).intValue() - 1][((Integer)p.getRight()).intValue()] = true;
                    queue.add(Pair.of((Object)((Integer)p.getLeft() - 1), (Object)p.getRight()));
                }
                if (!this.test(iWorld, map, pos.func_177982_a(0, 0, -1), (Integer)p.getLeft(), (Integer)p.getRight() - 1)) continue;
                map[((Integer)p.getLeft()).intValue()][((Integer)p.getRight()).intValue() - 1] = true;
                queue.add(Pair.of((Object)p.getLeft(), (Object)((Integer)p.getRight() - 1)));
            }
        }

        private boolean test(IWorld iWorld, boolean[][] mask, BlockPos pos, int i, int j) {
            if (i < 0 || j < 0 || i >= this.sizeX || j >= this.sizeZ || mask[i][j]) {
                return false;
            }
            int height = this.heightMap[i][j];
            if (height == 0) {
                Heightmap heightmap = this.generateHeightMapChunk(iWorld, pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
                for (int i1 = 0; i1 < 16; ++i1) {
                    for (int j1 = 0; j1 < 16; ++j1) {
                        int u = i + i1 - (pos.func_177958_n() & 0xF);
                        int v = j + j1 - (pos.func_177952_p() & 0xF);
                        if (u < 0 || v < 0 || u >= this.sizeX || v >= this.sizeZ) continue;
                        this.heightMap[u][v] = heightmap.func_202273_a(i1, j1) - 1;
                    }
                }
                height = this.heightMap[i][j];
            }
            return height > pos.func_177956_o();
        }

        private Heightmap generateHeightMapChunk(IWorld world, int x, int z) {
            ChunkPrimer chunk = new ChunkPrimer(new ChunkPos(x, z), new UpgradeData(new CompoundNBT()));
            this.generator.func_222539_a((IChunk)chunk);
            this.generator.func_222537_b(world, (IChunk)chunk);
            return chunk.func_217303_b(Heightmap.Type.OCEAN_FLOOR_WG);
        }

        private boolean testMask(boolean[][] mask, int sizeX, int sizeZ, int i, int j) {
            return i >= 0 && j >= 0 && i < sizeX && j < sizeZ && mask[i][j];
        }

        private boolean testMaskArea(boolean[][] mask, int sizeX, int sizeZ, int i, int j, int u, int v) {
            if (i < 0 || j < 0 || i >= sizeX || j >= sizeZ || i + u < 0 || j + v < 0 || i + u >= sizeX || j + v >= sizeZ) {
                return false;
            }
            for (int i1 = 0; i1 < u; ++i1) {
                for (int j1 = 0; j1 < v; ++j1) {
                    if (mask[i + i1][j + j1]) continue;
                    return false;
                }
            }
            return true;
        }

        private Node findPath(boolean[][] mask, boolean[][] hallwayBitMask, int i1, int j1, int i2, int j2) {
            TreeSet<Node> OPEN = new TreeSet<Node>();
            TreeSet<Node> CLOSED = new TreeSet<Node>();
            Node END = new Node(i2, j2);
            OPEN.add(new Node(i1, j1, 0.0f, this.calcHeuristic(hallwayBitMask, null, i1, j1, i2, j2)));
            while (!OPEN.isEmpty()) {
                Node node = (Node)OPEN.pollFirst();
                Node other = new Node(node.i + 5, node.j, this.calcPathCost(hallwayBitMask, node, 5, 0), this.calcHeuristic(hallwayBitMask, node, node.i + 5, node.j, i2, j2), node);
                if (other.equals(END)) {
                    return other;
                }
                if (!CLOSED.contains(other) && this.testMaskArea(mask, this.sizeX, this.sizeZ, other.i, other.j, 5, 5)) {
                    OPEN.add(other);
                }
                if ((other = new Node(node.i, node.j + 5, this.calcPathCost(hallwayBitMask, node, 0, 5), this.calcHeuristic(hallwayBitMask, node, node.i, node.j + 5, i2, j2), node)).equals(END)) {
                    return other;
                }
                if (!CLOSED.contains(other) && this.testMaskArea(mask, this.sizeX, this.sizeZ, other.i, other.j, 5, 5)) {
                    OPEN.add(other);
                }
                if ((other = new Node(node.i - 5, node.j, this.calcPathCost(hallwayBitMask, node, -5, 0), this.calcHeuristic(hallwayBitMask, node, node.i - 5, node.j, i2, j2), node)).equals(END)) {
                    return other;
                }
                if (!CLOSED.contains(other) && this.testMaskArea(mask, this.sizeX, this.sizeZ, other.i, other.j, 5, 5)) {
                    OPEN.add(other);
                }
                if ((other = new Node(node.i, node.j - 5, this.calcPathCost(hallwayBitMask, node, 0, -5), this.calcHeuristic(hallwayBitMask, node, node.i, node.j - 5, i2, j2), node)).equals(END)) {
                    return other;
                }
                if (!CLOSED.contains(other) && this.testMaskArea(mask, this.sizeX, this.sizeZ, other.i, other.j, 5, 5)) {
                    OPEN.add(other);
                }
                CLOSED.add(node);
                if (CLOSED.size() <= this.sizeX / 5 * this.sizeZ / 5) continue;
                return null;
            }
            return null;
        }

        private float calcHeuristic(boolean[][] hallwayBitMask, Node prev, int i1, int j1, int i2, int j2) {
            int distance = (Math.abs(i2 - i1) + Math.abs(j2 - j1)) * (prev != null && this.testMask(hallwayBitMask, this.sizeX / 5, this.sizeZ / 5, i1 / 5, j1 / 5) ? 0 : 1);
            if (prev == null || prev.prev == null) {
                return distance;
            }
            int dx = i1 - prev.i;
            int dy = j1 - prev.j;
            int du = prev.prev.i - prev.i;
            int dv = prev.prev.j - prev.j;
            int cross = Math.abs(du * dy - dv * dx);
            return (float)distance + 0.001f * (float)cross;
        }

        private float calcPathCost(boolean[][] hallwayBitMask, Node prev, int dx, int dy) {
            float distance = (float)(Math.abs(dx) + Math.abs(dy)) * (prev != null && this.testMask(hallwayBitMask, this.sizeX / 5, this.sizeZ / 5, (prev.i + dx) / 5, (prev.j + dy) / 5) ? 0.5f : 1.0f);
            if (prev == null || prev.prev == null) {
                return distance;
            }
            int du = prev.prev.i - prev.i;
            int dv = prev.prev.j - prev.j;
            int cross = Math.abs(du * dy - dv * dx);
            return distance + 0.001f * (float)cross;
        }

        private static class Node
        implements Comparable<Node> {
            public Node prev;
            public float pathWeight;
            public float heuristic;
            public int i;
            public int j;

            public Node(int i, int j) {
                this(i, j, 0.0f, 0.0f);
            }

            public Node(int i, int j, float pathWeight, float heuristic) {
                this.i = i;
                this.j = j;
                this.pathWeight = pathWeight;
                this.heuristic = heuristic;
                this.prev = null;
            }

            public Node(int i, int j, float pathWeight, float heuristic, Node prev) {
                this(i, j, pathWeight, heuristic);
                this.pathWeight += prev.pathWeight;
                this.prev = prev;
            }

            @Override
            public int compareTo(@Nonnull Node other) {
                return other.equals(this) ? 0 : (other.pathWeight + other.heuristic > this.pathWeight + this.heuristic ? -1 : 1);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Node node = (Node)o;
                return this.i == node.i && this.j == node.j;
            }

            public int hashCode() {
                return Objects.hash(this.i, this.j);
            }
        }
    }
}

