/*
 * Decompiled with CFR 0.152.
 */
package com.PiMan.RecieverMod.Items.guns;

import com.PiMan.RecieverMod.Entity.EntityBullet;
import com.PiMan.RecieverMod.Items.ItemBase;
import com.PiMan.RecieverMod.Items.accesories.ItemAccessories;
import com.PiMan.RecieverMod.Packets.MessageShoot;
import com.PiMan.RecieverMod.util.IItemData;
import com.PiMan.RecieverMod.util.ItemDataProvider;
import com.PiMan.RecieverMod.util.handlers.KeyInputHandler;
import com.PiMan.RecieverMod.util.handlers.MiscEventHandler;
import com.PiMan.RecieverMod.util.handlers.NetworkHandler;
import com.PiMan.RecieverMod.util.handlers.RenderPartialTickHandler;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemGun
extends ItemBase {
    private static final IItemPropertyGetter ADS_GETTER = new IItemPropertyGetter(){

        @SideOnly(value=Side.CLIENT)
        public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
            if (entityIn == null || worldIn == null || !worldIn.hasCapability(ItemDataProvider.ITEMDATA_CAP, null) || !stack.func_77942_o()) {
                return 0.0f;
            }
            NBTTagCompound nbt = ((IItemData)worldIn.getCapability(ItemDataProvider.ITEMDATA_CAP, null)).getItemData().func_74775_l(stack.func_77978_p().func_74779_i("UUID"));
            NBTTagCompound oldnbt = nbt.func_74775_l("prev");
            float oldval = oldnbt.func_74767_n("ADS") ? 1.0f : 0.0f;
            float newval = nbt.func_74767_n("ADS") ? 1.0f : 0.0f;
            float pt = RenderPartialTickHandler.renderPartialTick;
            float j = (1.0f - pt) * oldval + pt * newval;
            return j;
        }
    };
    private static final IItemPropertyGetter BULLET_CHAMBERED_GETTER = new IItemPropertyGetter(){

        @SideOnly(value=Side.CLIENT)
        public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
            if (worldIn == null) {
                worldIn = Minecraft.func_71410_x().field_71441_e;
            }
            if (worldIn == null || !worldIn.hasCapability(ItemDataProvider.ITEMDATA_CAP, null) || !stack.func_77942_o()) {
                return 0.0f;
            }
            NBTTagCompound nbt = ((IItemData)worldIn.getCapability(ItemDataProvider.ITEMDATA_CAP, null)).getItemData().func_74775_l(stack.func_77978_p().func_74779_i("UUID"));
            float j = nbt.func_74767_n("BulletChambered") ? 1.0f : 0.0f;
            return j;
        }
    };
    private static final IItemPropertyGetter FIRED_GETTER = new IItemPropertyGetter(){

        public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
            if (entityIn == null || worldIn == null || !worldIn.hasCapability(ItemDataProvider.ITEMDATA_CAP, null) || !stack.func_77942_o()) {
                return 0.0f;
            }
            NBTTagCompound nbt = ((IItemData)worldIn.getCapability(ItemDataProvider.ITEMDATA_CAP, null)).getItemData().func_74775_l(stack.func_77978_p().func_74779_i("UUID"));
            return nbt.func_74767_n("fired") ? 1.0f : 0.0f;
        }
    };
    protected double spreadY;
    protected double spreadX;
    protected double drift;

    public ItemGun(String name) {
        super(name);
        this.field_77777_bU = 1;
        this.func_185043_a(new ResourceLocation("ads"), ADS_GETTER);
        this.func_185043_a(new ResourceLocation("chambered"), BULLET_CHAMBERED_GETTER);
        this.func_185043_a(new ResourceLocation("fired"), FIRED_GETTER);
    }

    public boolean Shoot(NBTTagCompound nbt, EntityLivingBase entityLiving, double damage, float entityAccuracy, float gunAccuracy, int bullets, boolean flag2) {
        return this.Shoot(nbt, entityLiving, damage, entityAccuracy, gunAccuracy, bullets, 1200, flag2);
    }

    public boolean Shoot(NBTTagCompound nbt, EntityLivingBase entityLiving, double damage, float entityAccuracy, float gunAccuracy, int bullets, int life, boolean flag2) {
        if (entityLiving instanceof EntityPlayer) {
            int i;
            EntityPlayer player = (EntityPlayer)entityLiving;
            World world = player.field_70170_p;
            boolean flag1 = player.field_71075_bZ.field_75098_d;
            if (world.field_72995_K) {
                NetworkHandler.sendToServer(new MessageShoot(nbt, damage, entityAccuracy, gunAccuracy, life, bullets, flag2));
            }
            if ((i = ForgeEventFactory.onArrowLoose((ItemStack)player.func_184614_ca(), (World)world, (EntityPlayer)player, (int)20, ((flag1 || nbt.func_74767_n("BulletChambered")) && flag2 ? 1 : 0) != 0)) < 0) {
                System.out.println("ERROR ON EVENT REGISTER");
                return false;
            }
            if ((flag1 || nbt.func_74767_n("BulletChambered")) && flag2) {
                if (!world.field_72995_K) {
                    EntityBullet bulletdummy = new EntityBullet(world, (EntityLivingBase)player);
                    bulletdummy.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 23.0f, entityAccuracy);
                    for (int j = 0; j < bullets; ++j) {
                        EntityBullet bullet = new EntityBullet(world, (EntityLivingBase)player, life);
                        double x = bulletdummy.field_70159_w;
                        double y = bulletdummy.field_70181_x;
                        double z = bulletdummy.field_70179_y;
                        bullet.func_70186_c(x, y, z, MathHelper.func_76133_a((double)(x * x + y * y + z * z)), gunAccuracy);
                        bullet.field_70163_u += 0.1;
                        bullet.func_70243_d(false);
                        bullet.func_70239_b(damage);
                        player.field_70170_p.func_72838_d((Entity)bullet);
                    }
                    world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, this.getShootSound(), SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
                player.field_70125_A = (float)((double)player.field_70125_A + (world.field_73012_v.nextGaussian() * this.spreadY - this.drift));
                player.field_70177_z = (float)((double)player.field_70177_z + world.field_73012_v.nextGaussian() * this.spreadX);
                nbt.func_74757_a("BulletChambered", false);
                return true;
            }
        }
        return false;
    }

    public abstract SoundEvent getShootSound();

    public float getZoomFactor(ItemStack stack) {
        ItemAccessories item;
        if (this.getNBTTag(stack).func_150297_b("Accessories", 10) && (item = (ItemAccessories)Item.func_111206_d((String)this.getNBTTag(stack).func_74775_l("Accessories").func_74779_i("1"))) != null) {
            return item.getZoomFactor();
        }
        return this.getDefaultZoomFactor(stack);
    }

    public abstract float getDefaultZoomFactor(ItemStack var1);

    public boolean hasAccessories(ItemStack stack) {
        return false;
    }

    public boolean hasAccessory(ItemStack stack, int type2) {
        return stack.func_190925_c("Accessories").func_150297_b(Integer.valueOf(type2).toString(), 8) && !stack.func_190925_c("Accessories").func_74779_i(Integer.valueOf(type2).toString()).isEmpty();
    }

    public List<ItemStack> getAccesories(ItemStack stack) {
        if (this.getNBTTag(stack).func_150297_b("Accessories", 10)) {
            NBTTagCompound nbt = stack.func_190925_c("Accessories");
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            Integer i = 0;
            while (i < 9) {
                ItemStack accessory = new ItemStack(Item.func_111206_d((String)nbt.func_74779_i(i.toString())));
                if (accessory != null && !accessory.func_190926_b()) {
                    this.getNBTTag(accessory).func_74757_a("model", true);
                    this.getNBTTag(accessory).func_74778_a("UUID", this.getNBTTag(stack).func_74779_i("UUID"));
                    this.getNBTTag(accessory).func_74783_a("transform", this.getAccessoryTransformInts(((ItemAccessories)accessory.func_77973_b()).getType()));
                    list.add(accessory);
                }
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            return list;
        }
        return null;
    }

    private int[] getAccessoryTransformInts(int type2) {
        int[] ints = new int[16];
        Matrix4f m = this.getAccessoryTransform(type2);
        for (int i = 0; i < 16; ++i) {
            ints[i] = Float.floatToIntBits(m.getElement(i / 4, i % 4));
        }
        return ints;
    }

    public Matrix4f getAccessoryTransform(int type2) {
        Matrix4f m = new Matrix4f();
        m.setIdentity();
        return m;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        EntityPlayer player;
        if (worldIn.field_72995_K && entityIn instanceof EntityPlayer && (player = (EntityPlayer)entityIn).func_184614_ca().equals(stack) && KeyInputHandler.isKeyDown(KeyInputHandler.KeyPresses.Shift)) {
            MiscEventHandler.cancleBob();
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        boolean flag = false;
        if (oldStack.func_77973_b() instanceof ItemGun && newStack.func_77973_b() instanceof ItemGun) {
            ItemGun oldItem = (ItemGun)oldStack.func_77973_b();
            ItemGun newItem = (ItemGun)newStack.func_77973_b();
            flag = oldItem.checkNBTTags(oldStack).func_74779_i("UUID").equals(newItem.checkNBTTags(newStack).func_74779_i("UUID"));
        }
        return slotChanged || !flag;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add("ID: " + ((ItemBase)stack.func_77973_b()).getNBTTag(stack).func_74779_i("UUID"));
    }
}

