/*
 * Decompiled with CFR 0.152.
 */
package com.PiMan.RecieverMod.Packets;

import com.PiMan.RecieverMod.Packets.MessageBase;
import com.PiMan.RecieverMod.Particle.ParticleNumber;
import com.PiMan.RecieverMod.config.ModConfig;
import com.PiMan.RecieverMod.util.handlers.TextureStitcher;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageDamageParticles
extends MessageBase<MessageDamageParticles> {
    private double damage;
    private double posX;
    private double posY;
    private double posZ;

    public MessageDamageParticles() {
    }

    public MessageDamageParticles(double damage, double posX, double posY, double posZ) {
        this.damage = damage;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public void fromBytes(ByteBuf buf) {
        this.damage = buf.readDouble();
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.damage);
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(MessageDamageParticles message, EntityPlayer player) {
        if (ModConfig.damageParticles) {
            Random rand = new Random();
            char[] damage = Integer.valueOf((int)message.damage).toString().toCharArray();
            double y2 = player.field_70163_u;
            double y1 = message.posY;
            double dy = y2 - y1;
            double z2 = player.field_70161_v;
            double z1 = message.posZ;
            double dz = z2 - z1;
            double x2 = player.field_70165_t;
            double x1 = message.posX;
            double dx = x2 - x1;
            double length = Math.sqrt(dz * dz + dx * dx);
            double distance = Math.sqrt(dy * dy + length * length);
            if (distance > ModConfig.damageParticlesDistance) {
                return;
            }
            float scale = (float)(0.4 * distance);
            double r = rand.nextGaussian() / 10.0;
            double vy = 0.1 + rand.nextGaussian() / 50.0;
            double rx = dz / length * 0.2 * r * (double)scale;
            double rz = dx / length * 0.2 * r * (double)scale;
            double vx = dx / length * 0.1 + rx;
            double vz = dz / length * 0.1 - rz;
            for (int i = damage.length - 1; i >= 0; --i) {
                TextureAtlasSprite textureatlassprite;
                double x = message.posX;
                double z = message.posZ;
                x += dz / length * 0.2 * (double)i * (double)scale - dz / length * 0.1 * (double)scale * (double)(damage.length - 1);
                z -= dx / length * 0.2 * (double)i * (double)scale - dx / length * 0.1 * (double)scale * (double)(damage.length - 1);
                int d = damage[i] - 48;
                switch (d) {
                    case 0: {
                        textureatlassprite = TextureStitcher.ZERO;
                        break;
                    }
                    case 1: {
                        textureatlassprite = TextureStitcher.ONE;
                        break;
                    }
                    case 2: {
                        textureatlassprite = TextureStitcher.TWO;
                        break;
                    }
                    case 3: {
                        textureatlassprite = TextureStitcher.THREE;
                        break;
                    }
                    case 4: {
                        textureatlassprite = TextureStitcher.FOUR;
                        break;
                    }
                    case 5: {
                        textureatlassprite = TextureStitcher.FIVE;
                        break;
                    }
                    case 6: {
                        textureatlassprite = TextureStitcher.SIX;
                        break;
                    }
                    case 7: {
                        textureatlassprite = TextureStitcher.SEVEN;
                        break;
                    }
                    case 8: {
                        textureatlassprite = TextureStitcher.EIGHT;
                        break;
                    }
                    case 9: {
                        textureatlassprite = TextureStitcher.NINE;
                        break;
                    }
                    default: {
                        textureatlassprite = null;
                    }
                }
                ParticleNumber particlenumber = new ParticleNumber(player.field_70170_p, x, message.posY, z, vx, vy, vz, scale, textureatlassprite);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particlenumber);
            }
        }
    }

    @Override
    public void handleServerSide(MessageDamageParticles message, EntityPlayer player) {
    }
}

