/*
 * Decompiled with CFR 0.152.
 */
package com.PiMan.RecieverMod.Packets;

import com.PiMan.RecieverMod.Main;
import com.PiMan.RecieverMod.Packets.MessageBase;
import com.PiMan.RecieverMod.util.IItemData;
import com.PiMan.RecieverMod.util.ItemDataProvider;
import com.PiMan.RecieverMod.util.handlers.NetworkHandler;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class MessageUpdateNBT
extends MessageBase<MessageUpdateNBT> {
    private NBTTagCompound stackNBT;
    private int slot;
    private NBTTagCompound nbt;

    public MessageUpdateNBT() {
    }

    public MessageUpdateNBT(ItemStack stack, int slot, NBTTagCompound nbt) {
        this.stackNBT = stack.serializeNBT();
        this.slot = slot;
        this.nbt = nbt;
    }

    public void fromBytes(ByteBuf buf) {
        this.stackNBT = ByteBufUtils.readTag((ByteBuf)buf);
        this.slot = buf.readInt();
        this.nbt = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.stackNBT);
        buf.writeInt(this.slot);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.nbt);
    }

    @Override
    public void handleClientSide(MessageUpdateNBT message, EntityPlayer player) {
        ItemStack stack1 = player.field_71071_by.func_70301_a(message.slot);
        ItemStack stack2 = new ItemStack(message.stackNBT);
        stack1.func_77982_d(this.getStackTag(stack2));
        NBTTagCompound dataTag = ((IItemData)player.field_70170_p.getCapability(ItemDataProvider.ITEMDATA_CAP, null)).getItemData();
        NBTTagCompound itemTag = this.getItemTag(dataTag, this.getStackTag(stack2).func_74779_i("UUID"));
        itemTag.func_179237_a(message.nbt);
        ((IItemData)player.field_70170_p.getCapability(ItemDataProvider.ITEMDATA_CAP, null)).setItemData(dataTag);
    }

    @Override
    public void handleServerSide(MessageUpdateNBT message, EntityPlayer player) {
        ItemStack stack1 = new ItemStack(message.stackNBT);
        ItemStack stack2 = player.field_71071_by.func_70301_a(message.slot);
        if (stack1.func_77973_b() != stack2.func_77973_b()) {
            stack2 = player.func_184592_cb();
        }
        if (stack1.func_77973_b() != stack2.func_77973_b()) {
            Main.LOGGER.info("Items are not Equal");
            return;
        }
        String uuid = null;
        int status = -1;
        for (WorldServer world : FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
            IItemData itemData = (IItemData)world.getCapability(ItemDataProvider.ITEMDATA_CAP, null);
            NBTTagCompound baseTag = itemData.getItemData();
            NBTTagCompound itemTag = null;
            if (uuid == null) {
                if (message.nbt.func_74779_i("UUID").isEmpty()) {
                    if (stack2.func_77942_o() && !stack2.func_77978_p().func_74779_i("UUID").isEmpty()) {
                        uuid = this.getStackTag(stack2).func_74779_i("UUID");
                        itemTag = this.getItemTag(baseTag, uuid);
                        status = 0;
                    } else {
                        uuid = UUID.randomUUID().toString();
                        NBTTagCompound nbt = new NBTTagCompound();
                        nbt.func_74778_a("UUID", uuid);
                        this.getStackTag(stack2).func_179237_a(nbt);
                        Main.LOGGER.info("Set UUID To: {}", (Object)uuid);
                        itemTag = this.getItemTag(baseTag, uuid);
                        itemTag.func_179237_a(message.nbt);
                        itemTag.func_74778_a("UUID", uuid);
                        status = 1;
                        itemData.setItemData(baseTag);
                    }
                    NetworkHandler.sendToAll(new MessageUpdateNBT(stack2, message.slot, itemTag));
                    continue;
                }
                itemTag = this.getItemTag(baseTag, message.nbt.func_74779_i("UUID"));
                itemTag.func_179237_a(message.nbt);
                status = 2;
                itemData.setItemData(baseTag);
                continue;
            }
            if (status == 0) {
                itemTag = this.getItemTag(baseTag, uuid);
                continue;
            }
            if (status == 1) {
                itemTag = this.getItemTag(baseTag, uuid);
                itemTag.func_179237_a(message.nbt);
                itemData.setItemData(baseTag);
                continue;
            }
            if (status != 2) continue;
            itemTag = this.getItemTag(baseTag, uuid);
            itemTag.func_179237_a(message.nbt);
            itemData.setItemData(baseTag);
        }
    }

    private NBTTagCompound getItemTag(NBTTagCompound baseTag, String key) {
        NBTTagCompound itemTag;
        if (baseTag.func_150297_b(key, 10)) {
            itemTag = baseTag.func_74775_l(key);
        } else {
            itemTag = new NBTTagCompound();
            baseTag.func_74782_a(key, (NBTBase)itemTag);
        }
        return itemTag;
    }

    private NBTTagCompound getStackTag(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        return nbt;
    }
}

