/*
 * Decompiled with CFR 0.152.
 */
package com.PiMan.RecieverMod.World.Biomes;

import com.PiMan.RecieverMod.World.Types.Layer.GenLayerAddTypes;
import com.PiMan.RecieverMod.World.Types.Layer.GenLayerBase;
import com.PiMan.RecieverMod.World.Types.Layer.GenLayerSmoothTypes;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.init.Biomes;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.ChunkGeneratorSettings;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerAddIsland;
import net.minecraft.world.gen.layer.GenLayerFuzzyZoom;
import net.minecraft.world.gen.layer.GenLayerRemoveTooMuchOcean;
import net.minecraft.world.gen.layer.GenLayerRiverInit;
import net.minecraft.world.gen.layer.GenLayerRiverMix;
import net.minecraft.world.gen.layer.GenLayerSmooth;
import net.minecraft.world.gen.layer.GenLayerVoronoiZoom;
import net.minecraft.world.gen.layer.GenLayerZoom;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.WorldTypeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BiomeProviderMaze
extends BiomeProvider {
    private ChunkGeneratorSettings settings;
    private GenLayer genBiomes;
    private GenLayer biomeIndexLayer;
    private final BiomeCache biomeCache = new BiomeCache((BiomeProvider)this);
    private final List<Biome> biomesToSpawnIn = Lists.newArrayList((Iterable)allowedBiomes);

    protected BiomeProviderMaze() {
    }

    private BiomeProviderMaze(long seed, WorldType worldTypeIn, String options) {
        this();
        if (worldTypeIn == WorldType.field_180271_f && !options.isEmpty()) {
            this.settings = ChunkGeneratorSettings.Factory.func_177865_a((String)options).func_177864_b();
        }
        GenLayer[] agenlayer = BiomeProviderMaze.initializeAllBiomeGenerators(seed, worldTypeIn, this.settings);
        this.genBiomes = agenlayer[0];
        this.biomeIndexLayer = agenlayer[1];
    }

    private static GenLayer[] initializeAllBiomeGenerators(long seed, WorldType p_180781_2_, ChunkGeneratorSettings p_180781_3_) {
        int i;
        GenLayerBase genlayer = new GenLayerBase(1L);
        genlayer = new GenLayerFuzzyZoom(2000L, (GenLayer)genlayer);
        GenLayerAddIsland genlayeraddisland = new GenLayerAddIsland(1L, (GenLayer)genlayer);
        GenLayerZoom genlayerzoom = new GenLayerZoom(2001L, (GenLayer)genlayeraddisland);
        GenLayerAddIsland genlayeraddisland1 = new GenLayerAddIsland(2L, (GenLayer)genlayerzoom);
        genlayeraddisland1 = new GenLayerAddIsland(50L, (GenLayer)genlayeraddisland1);
        genlayeraddisland1 = new GenLayerAddIsland(70L, (GenLayer)genlayeraddisland1);
        GenLayerRemoveTooMuchOcean genlayerremovetoomuchocean = new GenLayerRemoveTooMuchOcean(2L, (GenLayer)genlayeraddisland1);
        GenLayerAddTypes genlayeraddsnow = new GenLayerAddTypes(2L, (GenLayer)genlayerremovetoomuchocean);
        GenLayerAddIsland genlayeraddisland2 = new GenLayerAddIsland(3L, (GenLayer)genlayeraddsnow);
        Object genlayeredge = new GenLayerZoom(1L, (GenLayer)genlayeraddisland2);
        genlayeredge = new GenLayerSmoothTypes(3L, (GenLayer)genlayeredge, true);
        GenLayerZoom genlayerzoom1 = new GenLayerZoom(2002L, (GenLayer)genlayeredge);
        genlayerzoom1 = new GenLayerZoom(2003L, (GenLayer)genlayerzoom1);
        GenLayerAddIsland genlayeraddisland3 = new GenLayerAddIsland(4L, (GenLayer)genlayerzoom1);
        GenLayer genlayer4 = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)genlayeraddisland3, (int)0);
        int j = i = 4;
        if (p_180781_3_ != null) {
            i = p_180781_3_.field_177780_G;
            j = p_180781_3_.field_177788_H;
        }
        if (p_180781_2_ == WorldType.field_77135_d) {
            i = 6;
        }
        i = 3;
        GenLayer lvt_7_1_ = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)genlayer4, (int)0);
        GenLayerRiverInit genlayerriverinit = new GenLayerRiverInit(100L, lvt_7_1_);
        GenLayer genlayerhills = p_180781_2_.getBiomeLayer(seed, genlayer4, p_180781_3_);
        GenLayer lvt_9_1_ = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)genlayerriverinit, (int)2);
        GenLayer genlayer5 = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)genlayerriverinit, (int)2);
        genlayer5 = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)genlayer5, (int)j);
        GenLayerSmooth genlayersmooth = new GenLayerSmooth(1000L, genlayer5);
        for (int k = 0; k < i; ++k) {
            genlayerhills = new GenLayerZoom((long)(1000 + k), genlayerhills);
            if (k == 0) {
                genlayerhills = new GenLayerAddIsland(3L, genlayerhills);
            }
            if (k != 1 && i != 1) continue;
        }
        GenLayerSmooth genlayersmooth1 = new GenLayerSmooth(1000L, genlayerhills);
        GenLayerRiverMix genlayerrivermix = new GenLayerRiverMix(100L, (GenLayer)genlayersmooth1, (GenLayer)genlayersmooth);
        GenLayerVoronoiZoom genlayer3 = new GenLayerVoronoiZoom(10L, (GenLayer)genlayerrivermix);
        genlayerrivermix.func_75905_a(seed);
        genlayer3.func_75905_a(seed);
        return new GenLayer[]{genlayerrivermix, genlayer3, genlayerrivermix};
    }

    public BiomeProviderMaze(WorldInfo info, WorldType terrainType) {
        this(info.func_76063_b(), terrainType, info.func_82571_y());
    }

    public List<Biome> func_76932_a() {
        return this.biomesToSpawnIn;
    }

    public Biome func_180631_a(BlockPos pos) {
        return this.func_180300_a(pos, null);
    }

    public Biome func_180300_a(BlockPos pos, Biome defaultBiome) {
        return this.biomeCache.func_180284_a(pos.func_177958_n(), pos.func_177952_p(), defaultBiome);
    }

    public float func_76939_a(float p_76939_1_, int p_76939_2_) {
        return p_76939_1_;
    }

    public Biome[] func_76937_a(Biome[] biomes, int x, int z, int width, int height) {
        IntCache.func_76446_a();
        if (biomes == null || biomes.length < width * height) {
            biomes = new Biome[width * height];
        }
        int[] aint = this.genBiomes.func_75904_a(x, z, width, height);
        try {
            for (int i = 0; i < width * height; ++i) {
                biomes[i] = Biome.func_180276_a((int)aint[i], (Biome)Biomes.field_180279_ad);
            }
            return biomes;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Invalid Biome id");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("RawBiomeBlock");
            crashreportcategory.func_71507_a("biomes[] size", (Object)biomes.length);
            crashreportcategory.func_71507_a("x", (Object)x);
            crashreportcategory.func_71507_a("z", (Object)z);
            crashreportcategory.func_71507_a("w", (Object)width);
            crashreportcategory.func_71507_a("h", (Object)height);
            throw new ReportedException(crashreport);
        }
    }

    public Biome[] func_76933_b(@Nullable Biome[] oldBiomeList, int x, int z, int width, int depth) {
        return this.func_76931_a(oldBiomeList, x, z, width, depth, true);
    }

    public Biome[] func_76931_a(@Nullable Biome[] listToReuse, int x, int z, int width, int length, boolean cacheFlag) {
        IntCache.func_76446_a();
        if (listToReuse == null || listToReuse.length < width * length) {
            listToReuse = new Biome[width * length];
        }
        if (cacheFlag && width == 16 && length == 16 && (x & 0xF) == 0 && (z & 0xF) == 0) {
            Biome[] abiome = this.biomeCache.func_76839_e(x, z);
            System.arraycopy(abiome, 0, listToReuse, 0, width * length);
            return listToReuse;
        }
        int[] aint = this.biomeIndexLayer.func_75904_a(x, z, width, length);
        for (int i = 0; i < width * length; ++i) {
            listToReuse[i] = Biome.func_180276_a((int)aint[i], (Biome)Biomes.field_180279_ad);
        }
        return listToReuse;
    }

    public boolean func_76940_a(int x, int z, int radius, List<Biome> allowed) {
        IntCache.func_76446_a();
        int i = x - radius >> 2;
        int j = z - radius >> 2;
        int k = x + radius >> 2;
        int l = z + radius >> 2;
        int i1 = k - i + 1;
        int j1 = l - j + 1;
        int[] aint = this.genBiomes.func_75904_a(i, j, i1, j1);
        try {
            for (int k1 = 0; k1 < i1 * j1; ++k1) {
                Biome biome = Biome.func_150568_d((int)aint[k1]);
                if (allowed.contains(biome)) continue;
                return false;
            }
            return true;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Invalid Biome id");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Layer");
            crashreportcategory.func_71507_a("Layer", (Object)this.genBiomes.toString());
            crashreportcategory.func_71507_a("x", (Object)x);
            crashreportcategory.func_71507_a("z", (Object)z);
            crashreportcategory.func_71507_a("radius", (Object)radius);
            crashreportcategory.func_71507_a("allowed", allowed);
            throw new ReportedException(crashreport);
        }
    }

    @Nullable
    public BlockPos func_180630_a(int x, int z, int range, List<Biome> biomes, Random random) {
        IntCache.func_76446_a();
        int i = x - range >> 2;
        int j = z - range >> 2;
        int k = x + range >> 2;
        int l = z + range >> 2;
        int i1 = k - i + 1;
        int j1 = l - j + 1;
        int[] aint = this.genBiomes.func_75904_a(i, j, i1, j1);
        BlockPos blockpos = null;
        int k1 = 0;
        for (int l1 = 0; l1 < i1 * j1; ++l1) {
            int i2 = i + l1 % i1 << 2;
            int j2 = j + l1 / i1 << 2;
            Biome biome = Biome.func_150568_d((int)aint[l1]);
            if (!biomes.contains(biome) || blockpos != null && random.nextInt(k1 + 1) != 0) continue;
            blockpos = new BlockPos(i2, 0, j2);
            ++k1;
        }
        return blockpos;
    }

    public void func_76938_b() {
        this.biomeCache.func_76838_a();
    }

    public GenLayer[] getModdedBiomeGenerators(WorldType worldType, long seed, GenLayer[] original) {
        WorldTypeEvent.InitBiomeGens event = new WorldTypeEvent.InitBiomeGens(worldType, seed, original);
        MinecraftForge.TERRAIN_GEN_BUS.post((Event)event);
        return event.getNewBiomeGens();
    }

    public boolean func_190944_c() {
        return this.settings != null && this.settings.field_177779_F >= 0;
    }

    public Biome func_190943_d() {
        return this.settings != null && this.settings.field_177779_F >= 0 ? Biome.func_185357_a((int)this.settings.field_177779_F) : null;
    }
}

