/*
 * Decompiled with CFR 0.152.
 */
package com.PiMan.RecieverMod.World.Gen;

import com.PiMan.RecieverMod.World.Biomes.BiomeMaze;
import com.PiMan.RecieverMod.World.Biomes.BiomeWasteland;
import com.PiMan.RecieverMod.World.Gen.ChunkGeneratorReceiver;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class ChunkGeneratorMaze
extends ChunkGeneratorReceiver {
    public static List<ChunkPos> addedStructure = new ArrayList<ChunkPos>();
    private final int floorHeight = 58;
    private final int roofHeight = 64;
    private static final List<IBlockState> DEFAULT_FILLER = new ArrayList<IBlockState>();

    public ChunkGeneratorMaze(World worldIn, long seed, WorldType worldType) {
        super(worldIn, seed, false, false, false, false, "");
        DEFAULT_FILLER.add(Blocks.field_150348_b.func_176223_P());
        this.terrainType = worldType;
        this.world.func_181544_b(0);
    }

    @Override
    public void func_185931_b(int x, int z) {
        BlockFalling.field_149832_M = true;
        int i = x * 16;
        int j = z * 16;
        BlockPos blockpos = new BlockPos(i, 0, j);
        Biome biome = this.world.func_180494_b(blockpos.func_177982_a(16, 0, 16));
        this.rand.setSeed(this.world.func_72905_C());
        long k = this.rand.nextLong() / 2L * 2L + 1L;
        long l = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)x * k + (long)z * l ^ this.world.func_72905_C());
        boolean flag = false;
        ChunkPos chunkpos = new ChunkPos(x, z);
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)flag);
        if (this.mapFeaturesEnabled) {
            if (this.settings.field_177829_w) {
                this.mineshaftGenerator.func_175794_a(this.world, this.rand, chunkpos);
            }
            if (this.settings.field_177831_v) {
                flag = this.villageGenerator.func_175794_a(this.world, this.rand, chunkpos);
            }
            if (this.settings.field_177833_u) {
                this.strongholdGenerator.func_175794_a(this.world, this.rand, chunkpos);
            }
            if (this.settings.field_177854_x) {
                this.scatteredFeatureGenerator.func_175794_a(this.world, this.rand, chunkpos);
            }
            if (this.settings.field_177852_y) {
                this.oceanMonumentGenerator.func_175794_a(this.world, this.rand, chunkpos);
            }
        }
        if (this.terrainFeaturesEnabled) {
            if (biome != Biomes.field_76769_d && biome != Biomes.field_76786_s && this.settings.field_177781_A && !flag && this.rand.nextInt(this.settings.field_177782_B) == 0 && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE)) {
                int i1 = this.rand.nextInt(16) + 8;
                int j1 = this.rand.nextInt(256);
                int k1 = this.rand.nextInt(16) + 8;
                new WorldGenLakes((Block)Blocks.field_150355_j).func_180709_b(this.world, this.rand, blockpos.func_177982_a(i1, j1, k1));
            }
            if (!flag && this.rand.nextInt(this.settings.field_177777_D / 10) == 0 && this.settings.field_177783_C && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA)) {
                int i2 = this.rand.nextInt(16) + 8;
                int l2 = this.rand.nextInt(this.rand.nextInt(248) + 8);
                int k3 = this.rand.nextInt(16) + 8;
                if (l2 < this.world.func_181545_F() || this.rand.nextInt(this.settings.field_177777_D / 8) == 0) {
                    new WorldGenLakes((Block)Blocks.field_150353_l).func_180709_b(this.world, this.rand, blockpos.func_177982_a(i2, l2, k3));
                }
            }
            if (this.settings.field_177837_s && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.DUNGEON)) {
                for (int j2 = 0; j2 < this.settings.field_177835_t; ++j2) {
                    int i3 = this.rand.nextInt(16) + 8;
                    int l3 = this.rand.nextInt(256);
                    int l1 = this.rand.nextInt(16) + 8;
                    new WorldGenDungeons().func_180709_b(this.world, this.rand, blockpos.func_177982_a(i3, l3, l1));
                }
            }
        }
        if (this.decorate) {
            biome.func_180624_a(this.world, this.rand, new BlockPos(i, 0, j));
        }
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            WorldEntitySpawner.func_77191_a((World)this.world, (Biome)biome, (int)(i + 8), (int)(j + 8), (int)16, (int)16, (Random)this.rand);
        }
        blockpos = blockpos.func_177982_a(8, 0, 8);
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ICE)) {
            for (int k2 = 0; k2 < 16; ++k2) {
                for (int j3 = 0; j3 < 16; ++j3) {
                    BlockPos blockpos1 = this.world.func_175725_q(blockpos.func_177982_a(k2, 0, j3));
                    BlockPos blockpos2 = blockpos1.func_177977_b();
                    if (this.world.func_175675_v(blockpos2)) {
                        this.world.func_180501_a(blockpos2, Blocks.field_150432_aD.func_176223_P(), 2);
                    }
                    if (!this.world.func_175708_f(blockpos1, true)) continue;
                    this.world.func_180501_a(blockpos1, Blocks.field_150431_aC.func_176223_P(), 2);
                }
            }
        }
        this.placeFillerBlocks(blockpos);
        this.setWalls(blockpos);
        this.customStructureTest.func_175794_a(this.world, this.rand, chunkpos);
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)flag);
        BlockFalling.field_149832_M = false;
    }

    @Override
    public void setBlocksInChunkFlat(int height, ChunkPrimer primer) {
        for (int i = 0; i < 16; ++i) {
            for (int j = height; j > 0; --j) {
                for (int k = 0; k < 16; ++k) {
                    primer.func_177855_a(i, j, k, STONE);
                }
            }
        }
    }

    @Override
    protected void generateHeightmap(int p_185978_1_, int p_185978_2_, int p_185978_3_) {
        int i = 0;
        int j = 0;
        for (int k = 0; k < 5; ++k) {
            for (int l = 0; l < 5; ++l) {
                float f2 = 0.0f;
                float f3 = 0.0f;
                float f4 = 0.0f;
                int i1 = 2;
                Biome biome = this.biomesForGeneration[k + 2 + (l + 2) * 10];
                for (int j1 = -2; j1 <= 2; ++j1) {
                    for (int k1 = -2; k1 <= 2; ++k1) {
                        Biome biome1 = this.biomesForGeneration[k + j1 + 2 + (l + k1 + 2) * 10];
                        if (!(biome1 instanceof BiomeWasteland)) {
                            biome1 = biome;
                        }
                        float f5 = this.settings.field_177813_n + biome1.func_185355_j() * this.settings.field_177819_m;
                        float f6 = this.settings.field_177843_p + biome1.func_185360_m() * this.settings.field_177815_o;
                        if (this.terrainType == WorldType.field_151360_e && f5 > 0.0f) {
                            f5 = 1.0f + f5 * 2.0f;
                            f6 = 1.0f + f6 * 4.0f;
                        }
                        float f7 = this.biomeWeights[j1 + 2 + (k1 + 2) * 5] / (f5 + 2.0f);
                        if (biome1.func_185355_j() > biome.func_185355_j()) {
                            f7 /= 2.0f;
                        }
                        f2 += f6 * f7;
                        f3 += f5 * f7;
                        f4 += f7;
                    }
                }
                f2 /= f4;
                f3 /= f4;
                f2 = f2 * 0.9f + 0.1f;
                f3 = (f3 * 4.0f - 1.0f) / 8.0f;
                ++j;
                double d8 = f3;
                double d9 = f2;
                d8 = d8 * (double)this.settings.field_177823_k / 8.0;
                double d0 = (double)this.settings.field_177823_k + d8 * 4.0;
                for (int l1 = 0; l1 < 33; ++l1) {
                    double d1 = ((double)l1 - d0) * (double)this.settings.field_177817_l * 128.0 / 256.0 / d9;
                    if (d1 < 0.0) {
                        d1 *= 4.0;
                    }
                    double d5 = -d1;
                    if (l1 > 29) {
                        double d6 = (float)(l1 - 29) / 3.0f;
                        d5 = d5 * (1.0 - d6) + -10.0 * d6;
                    }
                    this.heightMap[i] = d5;
                    ++i;
                }
            }
        }
    }

    private void setFillerBlock(BlockPos blockpos) {
        Biome biome = this.world.func_180494_b(blockpos);
        if (blockpos.func_177956_o() > this.getRoofHeight() - 1) {
            if (biome instanceof BiomeMaze) {
                BiomeMaze biomeroom = (BiomeMaze)biome;
                FILLER = biomeroom.roofBlocks;
            } else {
                FILLER = DEFAULT_FILLER;
            }
        } else if (blockpos.func_177956_o() > this.getFloorHeight() - 1) {
            if (biome instanceof BiomeMaze) {
                BiomeMaze biomeroom = (BiomeMaze)biome;
                FILLER = biomeroom.wallBlocks;
            } else {
                FILLER = DEFAULT_FILLER;
            }
        } else if (blockpos.func_177956_o() == this.getFloorHeight() - 1) {
            if (biome instanceof BiomeMaze) {
                BiomeMaze biomeroom = (BiomeMaze)biome;
                FILLER = biomeroom.floorBlocks;
            } else {
                FILLER = DEFAULT_FILLER;
            }
        } else if (biome instanceof BiomeMaze) {
            BiomeMaze biomeroom = (BiomeMaze)biome;
            FILLER = biomeroom.groundBlocks;
        } else {
            FILLER = DEFAULT_FILLER;
        }
        if (FILLER.isEmpty()) {
            System.out.println("Unable to Get FILLER");
            FILLER = DEFAULT_FILLER;
        }
    }

    @Override
    public void placeFillerBlocks(BlockPos blockpos) {
        for (int k = 0; k < 16; ++k) {
            for (int i = 0; i < 16; ++i) {
                for (int j = 255; j > 0; --j) {
                    BlockPos pos = blockpos.func_177982_a(i, j, k);
                    this.setFillerBlock(pos);
                    try {
                        IBlockState state = this.world.func_180495_p(pos);
                        if (state != STONE) continue;
                        IBlockState blockstate = (IBlockState)FILLER.get(this.rand.nextInt(FILLER.size()));
                        this.world.func_175656_a(pos, blockstate);
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println("Error with j = " + j + " and i = " + i + " and k = " + k);
                    }
                }
            }
        }
    }

    private void setWalls(BlockPos blockpos) {
        int data = this.rand.nextInt(524289);
        BlockPos pos = new BlockPos((Vec3i)blockpos);
        IBlockState AIR = Blocks.field_150350_a.func_176223_P();
        for (int l = 0; l < 9; ++l) {
            for (int w = -1; w <= 1; ++w) {
                for (int j = this.getFloorHeight(); j < this.getRoofHeight(); ++j) {
                    if ((data & 1) == 1) {
                        this.setBlockState(pos.func_177982_a(l, j, w), AIR);
                    }
                    if ((data & 2) == 2) {
                        this.setBlockState(pos.func_177982_a(w, j, l), AIR);
                    }
                    if ((data & 4) == 4) {
                        this.setBlockState(pos.func_177982_a(l, j, w + 4), AIR);
                    }
                    if ((data & 8) == 8) {
                        this.setBlockState(pos.func_177982_a(w + 4, j, l), AIR);
                    }
                    if ((data & 0x10) == 16) {
                        this.setBlockState(pos.func_177982_a(l, j, w + 8), AIR);
                    }
                    if ((data & 0x20) == 32) {
                        this.setBlockState(pos.func_177982_a(w + 8, j, l), AIR);
                    }
                    if ((data & 0x40) == 64) {
                        this.setBlockState(pos.func_177982_a(l + 8, j, w), AIR);
                    }
                    if ((data & 0x80) == 128) {
                        this.setBlockState(pos.func_177982_a(w, j, l + 8), AIR);
                    }
                    if ((data & 0x100) == 256) {
                        this.setBlockState(pos.func_177982_a(l, j, w + 12), AIR);
                    }
                    if ((data & 0x200) == 512) {
                        this.setBlockState(pos.func_177982_a(w + 12, j, l), AIR);
                    }
                    if ((data & 0x400) == 1024) {
                        this.setBlockState(pos.func_177982_a(l + 8, j, w + 4), AIR);
                    }
                    if ((data & 0x800) == 2048) {
                        this.setBlockState(pos.func_177982_a(w + 4, j, l + 8), AIR);
                    }
                    if ((data & 0x1000) == 4096) {
                        this.setBlockState(pos.func_177982_a(l + 8, j, w + 8), AIR);
                    }
                    if ((data & 0x2000) == 8192) {
                        this.setBlockState(pos.func_177982_a(w + 8, j, l + 8), AIR);
                    }
                    if ((data & 0x4000) == 16384) {
                        this.setBlockState(pos.func_177982_a(l, j, w + 16), AIR);
                    }
                    if ((data & 0x8000) == 32768) {
                        this.setBlockState(pos.func_177982_a(w + 16, j, l), AIR);
                    }
                    if ((data & 0x10000) == 65536) {
                        this.setBlockState(pos.func_177982_a(l + 8, j, w + 12), AIR);
                    }
                    if ((data & 0x20000) == 131072) {
                        this.setBlockState(pos.func_177982_a(w + 12, j, l + 8), AIR);
                    }
                    if ((data & 0x40000) == 262144) {
                        this.setBlockState(pos.func_177982_a(l + 8, j, w + 16), AIR);
                    }
                    if ((data & 0x80000) != 524288) continue;
                    this.setBlockState(pos.func_177982_a(w + 16, j, l + 8), AIR);
                }
            }
        }
    }

    private void setBlockState(BlockPos pos, IBlockState state) {
        if (this.customStructureTest.func_175796_a(this.world, pos)) {
            return;
        }
        this.world.func_175656_a(pos, state);
    }

    public int getFloorHeight() {
        return 58;
    }

    public int getRoofHeight() {
        return 64;
    }
}

