/*
 * Decompiled with CFR 0.152.
 */
package com.PiMan.RecieverMod.World.Gen.Structure;

import com.PiMan.RecieverMod.World.Biomes.BiomeOld;
import com.PiMan.RecieverMod.World.Biomes.BiomeWasteland;
import com.PiMan.RecieverMod.World.Gen.Structure.WorldGenStructureComponentTest;
import com.PiMan.RecieverMod.init.BiomeInit;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class MapGenCustomStructureTest
extends MapGenStructure {
    private static final List<Biome> BIOMELIST = Arrays.asList(BiomeInit.WASTELAND, BiomeInit.ABANDONED, BiomeInit.OLD, BiomeInit.NEW);
    private int maxDistanceBetweenScatteredFeatures = 9;
    private final int minDistanceBetweenScatteredFeatures;

    public void func_186125_a(World worldIn, int x, int z, ChunkPrimer primer) {
        super.func_186125_a(worldIn, x, z, primer);
    }

    public MapGenCustomStructureTest() {
        this.minDistanceBetweenScatteredFeatures = 0;
    }

    public MapGenCustomStructureTest(Map<String, String> p_i2061_1_) {
        this();
        for (Map.Entry<String, String> entry : p_i2061_1_.entrySet()) {
            if (!entry.getKey().equals("distance")) continue;
            this.maxDistanceBetweenScatteredFeatures = MathHelper.func_82714_a((String)entry.getValue(), (int)this.maxDistanceBetweenScatteredFeatures, (int)9);
        }
    }

    public String func_143025_a() {
        return "Tower";
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        int i = chunkX;
        int j = chunkZ;
        if (chunkX < 0) {
            chunkX -= this.maxDistanceBetweenScatteredFeatures - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= this.maxDistanceBetweenScatteredFeatures - 1;
        }
        int k = chunkX / this.maxDistanceBetweenScatteredFeatures;
        int l = chunkZ / this.maxDistanceBetweenScatteredFeatures;
        Random random = this.field_75039_c.func_72843_D(k, l, 14357617);
        k *= this.maxDistanceBetweenScatteredFeatures;
        l *= this.maxDistanceBetweenScatteredFeatures;
        if (i == (k += random.nextInt(this.maxDistanceBetweenScatteredFeatures - this.minDistanceBetweenScatteredFeatures)) && j == (l += random.nextInt(this.maxDistanceBetweenScatteredFeatures - this.minDistanceBetweenScatteredFeatures))) {
            Biome biome = this.field_75039_c.func_72959_q().func_180631_a(new BlockPos(i * 16 + 8, 0, j * 16 + 8));
            if (biome == null) {
                return false;
            }
            for (Biome biome1 : BIOMELIST) {
                if (biome != biome1) continue;
                return true;
            }
        }
        return false;
    }

    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
        this.field_75039_c = worldIn;
        return MapGenCustomStructureTest.func_191069_a((World)worldIn, (MapGenStructure)this, (BlockPos)pos, (int)this.maxDistanceBetweenScatteredFeatures, (int)8, (int)14357617, (boolean)false, (int)100, (boolean)findUnexplored);
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Start(this.field_75039_c, this.field_75038_b, chunkX, chunkZ);
    }

    public static class Start
    extends StructureStart {
        public Start() {
        }

        public Start(World worldIn, Random random, int chunkX, int chunkZ) {
            this(worldIn, random, chunkX, chunkZ, worldIn.func_180494_b(new BlockPos(chunkX * 16 + 8, 0, chunkZ * 16 + 8)));
        }

        public Start(World worldIn, Random random, int chunkX, int chunkZ, Biome biomeIn) {
            super(chunkX, chunkZ);
            TemplateManager templatemanager = worldIn.func_72860_G().func_186340_h();
            if (biomeIn instanceof BiomeWasteland) {
                WorldGenStructureComponentTest.Tower structure = null;
                int n = random.nextInt(10);
                switch (n % 2) {
                    case 0: {
                        structure = new WorldGenStructureComponentTest.Tower(templatemanager, "wasteland_tower", new BlockPos(chunkX * 16 + 8, 57, chunkZ * 16 + 8), Rotation.values()[random.nextInt(Rotation.values().length)], true);
                        break;
                    }
                    case 1: {
                        structure = new WorldGenStructureComponentTest.Tower(templatemanager, "wasteland_tower2", new BlockPos(chunkX * 16 + 8, 54, chunkZ * 16 + 8), Rotation.values()[random.nextInt(Rotation.values().length)], true);
                    }
                }
                this.field_75075_a.add(structure);
            } else if (biomeIn instanceof BiomeOld) {
                WorldGenStructureComponentTest.Tower structure = null;
                int n = random.nextInt(10);
                switch (n % 2) {
                    case 0: {
                        structure = new WorldGenStructureComponentTest.Tower(templatemanager, "wasteland_tower", new BlockPos(chunkX * 16 + 8, 57, chunkZ * 16 + 8), Rotation.values()[random.nextInt(Rotation.values().length)], true);
                        break;
                    }
                    case 1: {
                        structure = new WorldGenStructureComponentTest.Tower(templatemanager, "room1", new BlockPos(chunkX * 16 + 8, 57, chunkZ * 16 + 8), Rotation.values()[random.nextInt(Rotation.values().length)], true);
                    }
                }
                this.field_75075_a.add(structure);
            } else {
                this.field_75075_a.add(new WorldGenStructureComponentTest.Tower(templatemanager, "wasteland_tower", new BlockPos(chunkX * 16 + 8, 57, chunkZ * 16 + 8), Rotation.values()[random.nextInt(Rotation.values().length)], true));
            }
            this.func_75072_c();
        }
    }
}

