/*
 * Decompiled with CFR 0.152.
 */
package com.PiMan.RecieverMod.World.Gen.Structure;

import com.PiMan.RecieverMod.World.Gen.Structure.IStructure;
import com.PiMan.RecieverMod.util.handlers.LootTables;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class WorldGenStructure
extends WorldGenerator
implements IStructure {
    public String structureName;
    public PlacementSettings settings;
    private final ResourceLocation TOP;
    private final ResourceLocation BODY;
    private final ResourceLocation BASE;
    private final ResourceLocation BTOP;
    private final ResourceLocation BBODY;
    private final ResourceLocation BBASE;
    private Template top;
    private Template body;
    private Template base;
    private Template btop;
    private Template bbody;
    private Template bbase;
    private StructureBoundingBox size;

    public WorldGenStructure(String name, PlacementSettings settings) {
        this.structureName = name;
        this.settings = settings;
        this.TOP = new ResourceLocation("rm", name + "_tower_top");
        this.BODY = new ResourceLocation("rm", name + "_tower_body");
        this.BASE = new ResourceLocation("rm", name + "_tower_base");
        this.BTOP = new ResourceLocation("rm", name + "_basement_top");
        this.BBODY = new ResourceLocation("rm", name + "_basement_body");
        this.BBASE = new ResourceLocation("rm", name + "_basement_base");
        this.size = new StructureBoundingBox(settings.func_186213_g());
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        this.checkTemplates();
        this.settings.func_186213_g().func_78886_a(position.func_177958_n(), position.func_177956_o(), position.func_177952_p());
        this.generateStructure(worldIn, position, new ChunkPos(position), rand);
        this.settings.func_186223_a(new StructureBoundingBox(this.size));
        return true;
    }

    private void generateStructure(World world, BlockPos pos, ChunkPos chunkpos, Random rand) {
        BlockPos blockpos;
        int i;
        PlacementSettings decaySettings = this.settings.func_186217_a().func_189946_a(0.6f);
        this.checkTemplates();
        int u = rand.nextInt(3) + 1;
        int d = rand.nextInt(3) + 2;
        this.placeBlocks(this.top, world, rand, pos.func_177982_a(0, 12 * u + 9, 0), this.settings, null);
        this.placeBlocks(this.btop, world, rand, pos.func_177982_a(0, -3, 0), decaySettings, new DecayProcessor(pos.func_177982_a(0, -3, 0), this.settings));
        for (i = 0; i < d; ++i) {
            blockpos = pos.func_177982_a(0, -12 * (i + 1) - 3, 0);
            this.placeBlocks(this.bbody, world, rand, blockpos, decaySettings, new DecayProcessor(blockpos, decaySettings));
        }
        this.placeBlocks(this.bbase, world, rand, pos.func_177982_a(0, -12 * d - 6, 0), this.settings, null);
        this.placeBlocks(this.base, world, rand, pos, this.settings, null);
        for (i = 0; i < u; ++i) {
            blockpos = pos.func_177982_a(0, 12 * i + 9, 0);
            this.placeBlocks(this.body, world, rand, blockpos, this.settings, null);
        }
    }

    private void checkTemplates() {
        TemplateManager manager = worldserver.func_184163_y();
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (this.top == null) {
            this.top = manager.func_189942_b(server, this.TOP);
        }
        if (this.body == null) {
            this.body = manager.func_189942_b(server, this.BODY);
        }
        if (this.base == null) {
            this.base = manager.func_189942_b(server, this.BASE);
        }
        if (this.btop == null) {
            this.btop = manager.func_189942_b(server, this.BTOP);
        }
        if (this.bbody == null) {
            this.bbody = manager.func_189942_b(server, this.BBODY);
        }
        if (this.bbase == null) {
            this.bbase = manager.func_189942_b(server, this.BBASE);
        }
    }

    private void placeBlocks(Template template, World world, Random rand, BlockPos pos, PlacementSettings settings, ITemplateProcessor processor) {
        if (processor != null) {
            template.func_189960_a(world, pos, processor, settings, 2);
        } else {
            template.func_186253_b(world, pos, settings);
        }
        Map map = template.func_186258_a(pos, settings);
        for (Map.Entry entry : map.entrySet()) {
            String s = (String)entry.getValue();
            this.handleDataMarker(s, (BlockPos)entry.getKey(), world, rand, settings.func_186213_g());
        }
    }

    protected void handleDataMarker(String function, BlockPos pos, World worldIn, Random rand, StructureBoundingBox sbb) {
        if (function.equals("main")) {
            TileEntity tileentity;
            BlockPos blockpos = pos.func_177977_b();
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            if (sbb.func_175898_b((Vec3i)blockpos) && (tileentity = worldIn.func_175625_s(blockpos)) instanceof TileEntityChest) {
                ((TileEntityChest)tileentity).func_189404_a(LootTables.TOWER_MAIN, rand.nextLong());
            }
        } else if (function.equals("secondary")) {
            TileEntity tileentity;
            BlockPos blockpos = pos.func_177977_b();
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            if (sbb.func_175898_b((Vec3i)blockpos) && (tileentity = worldIn.func_175625_s(blockpos)) instanceof TileEntityChest) {
                ((TileEntityChest)tileentity).func_189404_a(LootTableList.field_186429_k, rand.nextLong());
            }
        }
    }

    private class DecayProcessor
    implements ITemplateProcessor {
        private final float chance;
        private final Random random;

        public DecayProcessor(BlockPos pos, PlacementSettings settings) {
            this.chance = settings.func_189948_f();
            this.random = settings.func_189947_a(pos.func_177982_a(pos.func_177956_o(), 0, pos.func_177956_o()));
        }

        @Nullable
        public Template.BlockInfo func_189943_a(World worldIn, BlockPos pos, Template.BlockInfo blockInfoIn) {
            return this.chance < 1.0f && this.random.nextFloat() > this.chance ? new Template.BlockInfo(blockInfoIn.field_186242_a, Blocks.field_150350_a.func_176223_P(), blockInfoIn.field_186244_c) : blockInfoIn;
        }
    }
}

