/*
 * Decompiled with CFR 0.152.
 */
package com.PiMan.RecieverMod.World.Gen.Structure;

import com.PiMan.RecieverMod.World.Gen.Structure.Feature;
import com.PiMan.RecieverMod.init.BiomeInit;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTableList;

public class WorldGenStructureComponentTest {
    public static void registerScatteredFeaturePieces() {
        MapGenStructureIO.func_143031_a(Tower.class, (String)"WTower");
    }

    public static class Tower
    extends Feature {
        private String name;
        private Rotation rotation;
        private boolean overwrite;
        private static Map<Biome, IBlockState> baseBlocks = new HashMap<Biome, IBlockState>();
        private static Map<Biome, IBlockState> stairBlocks;
        private static Map<Biome, IBlockState> stairFloorBlocks;
        private static Map<Biome, IBlockState> highlightBlocks;
        private static Map<Biome, IBlockState> floorHighlightBlocks;
        private static Map<Biome, IBlockState> slabBlocks;

        public Tower() {
        }

        public Tower(TemplateManager templateManager, String name, BlockPos pos, Rotation rot, boolean overwriteIn) {
            super(0);
            this.name = name;
            this.field_186178_c = pos;
            this.rotation = rot;
            this.overwrite = overwriteIn;
            this.loadTemplate(templateManager, name);
        }

        protected void func_186173_a(Template templateIn, BlockPos pos, PlacementSettings settings) {
            super.func_186173_a(templateIn, pos, settings);
            switch (this.field_186177_b.func_186215_c()) {
                case NONE: {
                    --this.field_74887_e.field_78893_d;
                    --this.field_74887_e.field_78892_f;
                    break;
                }
                case CLOCKWISE_180: {
                    ++this.field_74887_e.field_78897_a;
                    ++this.field_74887_e.field_78896_c;
                    break;
                }
                case CLOCKWISE_90: {
                    ++this.field_74887_e.field_78897_a;
                    --this.field_74887_e.field_78892_f;
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    --this.field_74887_e.field_78893_d;
                    ++this.field_74887_e.field_78896_c;
                    break;
                }
            }
        }

        private void loadTemplate(TemplateManager templateManager, String name) {
            Template template = templateManager.func_186237_a((MinecraftServer)null, new ResourceLocation("rm", name));
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            this.field_186177_b.func_186223_a(structureBoundingBoxIn);
            if (this.name.equals("wasteland_tower")) {
                TemplateManager manager = worldIn.func_72860_G().func_186340_h();
                Template template1 = manager.func_186237_a(worldIn.func_73046_m(), new ResourceLocation("rm", this.name + "/" + this.name + "_base"));
                Template template2 = manager.func_186237_a(worldIn.func_73046_m(), new ResourceLocation("rm", this.name + "/" + this.name + "_body"));
                Template template3 = manager.func_186237_a(worldIn.func_73046_m(), new ResourceLocation("rm", this.name + "/" + this.name + "_top"));
                BlockPos pos = new BlockPos((Vec3i)this.field_186178_c);
                Biome biome = worldIn.func_180494_b(pos);
                template1.func_189960_a(worldIn, pos, (ITemplateProcessor)new PlacementProcessor(pos, this.field_186177_b, biome), this.field_186177_b, 2);
                pos = pos.func_177982_a(0, template1.func_186259_a().func_177956_o(), 0);
                template2.func_189960_a(worldIn, pos, (ITemplateProcessor)new PlacementProcessor(pos, this.field_186177_b, biome), this.field_186177_b, 2);
                pos = pos.func_177982_a(0, template2.func_186259_a().func_177956_o(), 0);
                template2.func_189960_a(worldIn, pos, (ITemplateProcessor)new PlacementProcessor(pos, this.field_186177_b, biome), this.field_186177_b, 2);
                pos = pos.func_177982_a(0, template2.func_186259_a().func_177956_o(), 0);
                template2.func_189960_a(worldIn, pos, (ITemplateProcessor)new PlacementProcessor(pos, this.field_186177_b, biome), this.field_186177_b, 2);
                pos = pos.func_177982_a(0, template2.func_186259_a().func_177956_o(), 0);
                template2.func_189960_a(worldIn, pos, (ITemplateProcessor)new PlacementProcessor(pos, this.field_186177_b, biome), this.field_186177_b, 2);
                pos = pos.func_177982_a(0, template2.func_186259_a().func_177956_o(), 0);
                template3.func_189960_a(worldIn, pos, (ITemplateProcessor)new PlacementProcessor(pos, this.field_186177_b, biome), this.field_186177_b, 2);
                return true;
            }
            this.field_186176_a.func_189962_a(worldIn, this.field_186178_c, this.field_186177_b, 18);
            Map map = this.field_186176_a.func_186258_a(this.field_186178_c, this.field_186177_b);
            for (Map.Entry entry : map.entrySet()) {
                String s = (String)entry.getValue();
                this.func_186175_a(s, (BlockPos)entry.getKey(), worldIn, randomIn, structureBoundingBoxIn);
            }
            return true;
        }

        @Override
        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74778_a("name", this.name);
            tagCompound.func_74778_a("Rot", this.rotation.name());
            tagCompound.func_74757_a("OW", this.overwrite);
        }

        @Override
        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager manager) {
            super.func_143011_b(tagCompound, manager);
            this.rotation = Rotation.valueOf((String)tagCompound.func_74779_i("Rot"));
            this.overwrite = tagCompound.func_74767_n("OW");
            this.name = tagCompound.func_74779_i("name");
            this.loadTemplate(manager, this.name);
        }

        protected void func_186175_a(String function, BlockPos pos, World worldIn, Random rand, StructureBoundingBox sbb) {
            TileEntity tileentity;
            BlockPos blockpos;
            if (function.startsWith("Chest") && sbb.func_175898_b((Vec3i)(blockpos = pos.func_177977_b())) && (tileentity = worldIn.func_175625_s(blockpos)) instanceof TileEntityChest) {
                ((TileEntityChest)tileentity).func_189404_a(LootTableList.field_186421_c, rand.nextLong());
            }
        }

        static {
            baseBlocks.put(BiomeInit.WASTELAND, Blocks.field_150322_A.func_176203_a(2));
            baseBlocks.put(BiomeInit.ABANDONED, Blocks.field_150417_aV.func_176203_a(2));
            baseBlocks.put(BiomeInit.OLD, Blocks.field_150417_aV.func_176203_a(0));
            baseBlocks.put(BiomeInit.NEW, Blocks.field_192443_dR.func_176203_a(8));
            stairBlocks = new HashMap<Biome, IBlockState>();
            stairBlocks.put(BiomeInit.WASTELAND, Blocks.field_150372_bz.func_176223_P());
            stairBlocks.put(BiomeInit.ABANDONED, Blocks.field_150446_ar.func_176223_P());
            stairBlocks.put(BiomeInit.OLD, Blocks.field_150390_bg.func_176223_P());
            stairBlocks.put(BiomeInit.NEW, Blocks.field_150370_cb.func_176223_P());
            stairFloorBlocks = new HashMap<Biome, IBlockState>();
            stairFloorBlocks.put(BiomeInit.WASTELAND, Blocks.field_150322_A.func_176203_a(0));
            stairFloorBlocks.put(BiomeInit.ABANDONED, Blocks.field_150347_e.func_176223_P());
            stairFloorBlocks.put(BiomeInit.OLD, Blocks.field_150417_aV.func_176203_a(0));
            stairFloorBlocks.put(BiomeInit.NEW, Blocks.field_192443_dR.func_176203_a(0));
            highlightBlocks = new HashMap<Biome, IBlockState>();
            highlightBlocks.put(BiomeInit.WASTELAND, Blocks.field_150322_A.func_176203_a(1));
            highlightBlocks.put(BiomeInit.ABANDONED, Blocks.field_150417_aV.func_176203_a(1));
            highlightBlocks.put(BiomeInit.OLD, Blocks.field_150417_aV.func_176203_a(3));
            highlightBlocks.put(BiomeInit.NEW, Blocks.field_192443_dR.func_176203_a(0));
            floorHighlightBlocks = new HashMap<Biome, IBlockState>();
            floorHighlightBlocks.put(BiomeInit.WASTELAND, Blocks.field_150354_m.func_176223_P());
            floorHighlightBlocks.put(BiomeInit.ABANDONED, Blocks.field_150417_aV.func_176203_a(2));
            floorHighlightBlocks.put(BiomeInit.OLD, Blocks.field_150417_aV.func_176203_a(0));
            floorHighlightBlocks.put(BiomeInit.NEW, Blocks.field_192443_dR.func_176203_a(0));
            slabBlocks = new HashMap<Biome, IBlockState>();
            slabBlocks.put(BiomeInit.WASTELAND, Blocks.field_150333_U.func_176203_a(9));
            slabBlocks.put(BiomeInit.ABANDONED, Blocks.field_150333_U.func_176203_a(11));
            slabBlocks.put(BiomeInit.OLD, Blocks.field_150333_U.func_176203_a(8));
            slabBlocks.put(BiomeInit.NEW, Blocks.field_150333_U.func_176203_a(15));
        }

        private class PlacementProcessor
        implements ITemplateProcessor {
            private float chance;
            private Random rand;
            private Biome biome;

            public PlacementProcessor(BlockPos pos, PlacementSettings settings, Biome biome) {
                this.chance = settings.func_189948_f();
                this.rand = settings.func_189947_a(pos);
                this.biome = biome;
            }

            public Template.BlockInfo func_189943_a(World worldIn, BlockPos pos, Template.BlockInfo blockInfoIn) {
                IBlockState state2;
                IBlockState state = blockInfoIn.field_186243_b;
                if (state.equals(Blocks.field_150322_A.func_176203_a(2))) {
                    IBlockState state22 = (IBlockState)baseBlocks.get(this.biome);
                    if (state22 != null) {
                        blockInfoIn = new Template.BlockInfo(blockInfoIn.field_186242_a, state22, blockInfoIn.field_186244_c);
                    }
                } else if (state.func_177230_c().equals(Blocks.field_150372_bz)) {
                    IBlockState state23 = (IBlockState)stairBlocks.get(this.biome);
                    if (state23 != null) {
                        state23 = state23.func_177230_c().func_176203_a(state.func_177230_c().func_176201_c(state));
                        blockInfoIn = new Template.BlockInfo(blockInfoIn.field_186242_a, state23, blockInfoIn.field_186244_c);
                    }
                } else if (state.equals(Blocks.field_150322_A.func_176203_a(0))) {
                    IBlockState state24 = (IBlockState)stairFloorBlocks.get(this.biome);
                    if (state24 != null) {
                        blockInfoIn = new Template.BlockInfo(blockInfoIn.field_186242_a, state24, blockInfoIn.field_186244_c);
                    }
                } else if (state.equals(Blocks.field_150322_A.func_176203_a(1))) {
                    IBlockState state25 = (IBlockState)highlightBlocks.get(this.biome);
                    if (state25 != null) {
                        blockInfoIn = new Template.BlockInfo(blockInfoIn.field_186242_a, state25, blockInfoIn.field_186244_c);
                    }
                } else if (state.equals(Blocks.field_150354_m.func_176223_P())) {
                    IBlockState state26 = (IBlockState)floorHighlightBlocks.get(this.biome);
                    if (state26 != null) {
                        blockInfoIn = new Template.BlockInfo(blockInfoIn.field_186242_a, state26, blockInfoIn.field_186244_c);
                    }
                } else if (state.equals(Blocks.field_150333_U.func_176203_a(9)) && (state2 = (IBlockState)slabBlocks.get(this.biome)) != null) {
                    blockInfoIn = new Template.BlockInfo(blockInfoIn.field_186242_a, state2, blockInfoIn.field_186244_c);
                }
                return this.chance < 1.0f && this.rand.nextFloat() > this.chance ? new Template.BlockInfo(blockInfoIn.field_186242_a, Blocks.field_150350_a.func_176223_P(), blockInfoIn.field_186244_c) : blockInfoIn;
            }
        }
    }
}

