/*
 * Decompiled with CFR 0.152.
 */
package com.PiMan.RecieverMod.World.Types.Layer;

import com.PiMan.RecieverMod.init.BiomeInit;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGeneratorSettings;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraftforge.common.BiomeManager;

public class GenLayerMaze
extends GenLayer {
    private List<BiomeManager.BiomeEntry>[] biomes = new ArrayList[BiomeManager.BiomeType.values().length];
    private final ChunkGeneratorSettings settings;

    public GenLayerMaze(long p_i45560_1_, GenLayer p_i45560_3_, WorldType p_i45560_4_, ChunkGeneratorSettings p_i45560_5_) {
        super(p_i45560_1_);
        this.field_75909_a = p_i45560_3_;
        for (BiomeManager.BiomeType type2 : BiomeManager.BiomeType.values()) {
            int idx = type2.ordinal();
            if (this.biomes[idx] == null) {
                this.biomes[idx] = new ArrayList<BiomeManager.BiomeEntry>();
            }
            this.biomes[idx].clear();
        }
        int desertIdx = BiomeManager.BiomeType.DESERT.ordinal();
        int warmIdx = BiomeManager.BiomeType.WARM.ordinal();
        int coolIdx = BiomeManager.BiomeType.COOL.ordinal();
        int icyIdx = BiomeManager.BiomeType.ICY.ordinal();
        this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(BiomeInit.WASTELAND, 30));
        this.biomes[warmIdx].add(new BiomeManager.BiomeEntry(BiomeInit.ABANDONED, 30));
        this.biomes[warmIdx].add(new BiomeManager.BiomeEntry(BiomeInit.ABANDONEDROOF, 10));
        this.biomes[coolIdx].add(new BiomeManager.BiomeEntry(BiomeInit.OLD, 30));
        this.biomes[coolIdx].add(new BiomeManager.BiomeEntry(BiomeInit.OLDROOF, 10));
        this.biomes[icyIdx].add(new BiomeManager.BiomeEntry(BiomeInit.NEW, 30));
        this.biomes[icyIdx].add(new BiomeManager.BiomeEntry(BiomeInit.NEWROOF, 10));
        this.settings = p_i45560_4_ == WorldType.field_77136_e ? null : p_i45560_5_;
    }

    public int[] func_75904_a(int areaX, int areaY, int areaWidth, int areaHeight) {
        int[] aint = this.field_75909_a.func_75904_a(areaX, areaY, areaWidth, areaHeight);
        int[] aint1 = IntCache.func_76445_a((int)(areaWidth * areaHeight));
        for (int i = 0; i < areaHeight; ++i) {
            for (int j = 0; j < areaWidth; ++j) {
                this.func_75903_a(j + areaX, i + areaY);
                int k = aint[j + i * areaWidth];
                int l = (k & 0xF00) >> 8;
                if ((k &= 0xFFFFF0FF) == 1) {
                    aint1[j + i * areaWidth] = Biome.func_185362_a((Biome)this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT).biome);
                    continue;
                }
                if (k == 2) {
                    aint1[j + i * areaWidth] = Biome.func_185362_a((Biome)this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM).biome);
                    continue;
                }
                if (k == 3) {
                    aint1[j + i * areaWidth] = Biome.func_185362_a((Biome)this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL).biome);
                    continue;
                }
                if (k != 4) continue;
                aint1[j + i * areaWidth] = Biome.func_185362_a((Biome)this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.ICY).biome);
            }
        }
        return aint1;
    }

    protected BiomeManager.BiomeEntry getWeightedBiomeEntry(BiomeManager.BiomeType type2) {
        List<BiomeManager.BiomeEntry> biomeList = this.biomes[type2.ordinal()];
        int totalWeight = WeightedRandom.func_76272_a(biomeList);
        int weight = BiomeManager.isTypeListModded((BiomeManager.BiomeType)type2) ? this.func_75902_a(totalWeight) : this.func_75902_a(totalWeight / 10) * 10;
        return (BiomeManager.BiomeEntry)WeightedRandom.func_180166_a(biomeList, (int)weight);
    }
}

