/*
 * Decompiled with CFR 0.152.
 */
package com.PiMan.RecieverMod.util;

import com.PiMan.RecieverMod.Main;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockPart;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.BlockPartRotation;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.block.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.MapModelState;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.ITransformation;
import net.minecraftforge.common.model.Models;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.util.vector.Vector3f;

public class IModelClip
implements IModel {
    private static IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
    public static final IModelClip MODEL = new IModelClip();
    @Nullable
    private ResourceLocation baseLocation;
    private ModelBlock baseModel;

    public IModelClip() {
        this(null);
    }

    public IModelClip(@Nullable ResourceLocation baseLocation) {
        BufferedReader reader;
        this.baseLocation = baseLocation;
        ModelBlock model = null;
        if (baseLocation != null && (reader = IModelClip.getModelReader(baseLocation)) != null) {
            model = ModelBlock.func_178307_a((Reader)reader);
        }
        this.baseModel = model;
    }

    public Collection<ResourceLocation> getTextures() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (this.baseLocation != null) {
            for (String texture : this.baseModel.field_178318_c.values()) {
                builder.add((Object)new ResourceLocation(texture));
            }
        }
        return builder.build();
    }

    public ResourceLocation getTexture() {
        return new ResourceLocation("rm", "items/1911");
    }

    public Collection<ResourceLocation> getDependencies() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)this.baseLocation);
        List<ResourceLocation> list = IModelClip.getParts(this.baseLocation);
        if (list != null) {
            builder.addAll(list);
        }
        return builder.build();
    }

    public Collection<ResourceLocation> getDependenciesForMap() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)this.baseLocation);
        List<ResourceLocation> list = IModelClip.getParts(this.baseLocation);
        int i = 0;
        for (ResourceLocation location : list) {
            while (list.contains(location)) {
                location = new ResourceLocation(location.toString() + "-");
            }
            list.set(i++, location);
        }
        if (list != null) {
            builder.addAll(list);
        }
        return builder.build();
    }

    public IModel getMissingModel() {
        return ModelLoaderRegistry.getMissingModel();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap transformMap = PerspectiveMapWrapper.getTransforms((ItemCameraTransforms)this.baseModel.func_181682_g());
        ClipOverrideHandler overrides = ClipOverrideHandler.INSTANCE;
        ArrayList<ResourceLocation> locations = new ArrayList<ResourceLocation>();
        locations.add(this.baseLocation);
        locations.addAll(this.getDependenciesForMap());
        ArrayList<IBakedModel> models = new ArrayList<IBakedModel>();
        for (ResourceLocation location : locations) {
            IBakedModel model = this.bakeModelPart(state, format, bakedTextureGetter, location);
            models.add(model);
        }
        return new BakedModelClip(this, models, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)PerspectiveMapWrapper.getTransforms((ItemCameraTransforms)this.baseModel.func_181682_g()), bakedTextureGetter.apply(this.getTexture()), format, overrides, Maps.newHashMap());
    }

    public IBakedModel bakeModelPart(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, ResourceLocation location) {
        if (state instanceof MapModelState) {
            state = ((MapModelState)state).getState((Object)location);
        }
        ModelBlock model = null;
        if (location != null) {
            try {
                InputStream in = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("rm", "models/item/" + location.func_110623_a().replace("-", "") + ".json")).func_110527_b();
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                model = ModelBlock.func_178307_a((Reader)reader);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!Attributes.moreSpecific((VertexFormat)format, (VertexFormat)Attributes.DEFAULT_BAKED_FORMAT)) {
            throw new IllegalArgumentException("can't bake vanilla models to the format that doesn't fit into the default one: " + format);
        }
        if (model == null) {
            return this.getMissingModel().bake(this.getMissingModel().getDefaultState(), format, bakedTextureGetter);
        }
        ArrayList newTransforms = Lists.newArrayList();
        for (int i = 0; i < model.func_178298_a().size(); ++i) {
            newTransforms.add(state.apply(Optional.empty()).orElse(TRSRTransformation.identity()));
        }
        ItemCameraTransforms transforms = model.func_181682_g();
        EnumMap tMap = Maps.newEnumMap(ItemCameraTransforms.TransformType.class);
        tMap.putAll(PerspectiveMapWrapper.getTransforms((ItemCameraTransforms)transforms));
        tMap.putAll(PerspectiveMapWrapper.getTransforms((IModelState)state));
        SimpleModelState perState = new SimpleModelState(ImmutableMap.copyOf((Map)tMap));
        return this.bakeNormal(model, (IModelState)perState, state, newTransforms, format, bakedTextureGetter, false);
    }

    public IBakedModel bakeNormal(ModelBlock model, IModelState perState, IModelState modelState, List<TRSRTransformation> newTransforms, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, boolean uvLocked) {
        TRSRTransformation baseState = modelState.apply(Optional.empty()).orElse(TRSRTransformation.identity());
        TextureAtlasSprite particle = bakedTextureGetter.apply(new ResourceLocation(model.func_178308_c("particle")));
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(model, model.func_187967_g()).func_177646_a(particle);
        for (int i = 0; i < model.func_178298_a().size(); ++i) {
            if (modelState.apply(Optional.of(Models.getHiddenModelPart((ImmutableList)ImmutableList.of((Object)Integer.toString(i))))).isPresent()) continue;
            BlockPart part = (BlockPart)model.func_178298_a().get(i);
            TRSRTransformation transformation = baseState;
            if (newTransforms.get(i) != null) {
                transformation = newTransforms.get(i);
                BlockPartRotation rot = part.field_178237_d;
                if (rot == null) {
                    rot = new BlockPartRotation(new Vector3f(), EnumFacing.Axis.Y, 0.0f, false);
                }
                part = new BlockPart(part.field_178241_a, part.field_178239_b, part.field_178240_c, rot, part.field_178238_e);
            }
            for (Map.Entry e : part.field_178240_c.entrySet()) {
                TextureAtlasSprite textureatlassprite1 = bakedTextureGetter.apply(new ResourceLocation(model.func_178308_c(((BlockPartFace)e.getValue()).field_178242_d)));
                if (((BlockPartFace)e.getValue()).field_178244_b == null || !TRSRTransformation.isInteger((Matrix4f)transformation.getMatrix())) {
                    builder.func_177648_a(this.makeBakedQuad(part, (BlockPartFace)e.getValue(), textureatlassprite1, (EnumFacing)e.getKey(), (ITransformation)transformation, uvLocked));
                    continue;
                }
                builder.func_177650_a(baseState.rotate(((BlockPartFace)e.getValue()).field_178244_b), this.makeBakedQuad(part, (BlockPartFace)e.getValue(), textureatlassprite1, (EnumFacing)e.getKey(), (ITransformation)transformation, uvLocked));
            }
        }
        return new PerspectiveMapWrapperGun(builder.func_177645_b(), perState);
    }

    public IModelClip process(ImmutableMap<String, String> customData) {
        return new IModelClip(this.baseLocation);
    }

    public IModelClip retexture(ImmutableMap<String, String> textures) {
        ResourceLocation base = this.baseLocation;
        if (textures.containsKey((Object)"base")) {
            base = new ResourceLocation((String)textures.get((Object)"base"));
        }
        return new IModelClip(base);
    }

    protected static BufferedReader getModelReader(ResourceLocation modelLocation) {
        if (modelLocation.func_110623_a().contains("model")) {
            return null;
        }
        try {
            InputStream in = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("rm", "models/item/" + modelLocation.func_110623_a() + ".json")).func_110527_b();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            return reader;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected ResourceLocation getModelLocation(ResourceLocation location) {
        return new ResourceLocation(location.func_110624_b(), "models/" + location.func_110623_a() + ".json");
    }

    public static List<ResourceLocation> getParts(ResourceLocation loc) {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        Gson gson = new Gson();
        try {
            InputStream in;
            BufferedReader reader;
            JsonElement je;
            JsonObject json;
            JsonArray modelArray;
            ResourceLocation location = new ResourceLocation("rm", loc.func_110623_a() + ".json");
            if (!location.func_110623_a().contains("models/item/")) {
                location = new ResourceLocation("rm", "models/item/" + location.func_110623_a());
            }
            if ((modelArray = (JsonArray)(json = (je = (JsonElement)gson.fromJson((Reader)(reader = new BufferedReader(new InputStreamReader(in = Minecraft.func_71410_x().func_110442_L().func_110536_a(location).func_110527_b()))), JsonElement.class)).getAsJsonObject()).get("submodels")) != null) {
                for (Object modelobject : modelArray) {
                    JsonObject jsonmodel = (JsonObject)modelobject;
                    ResourceLocation modelLocation = new ResourceLocation(jsonmodel.get("model").getAsString());
                    JsonObject predicates = jsonmodel.getAsJsonObject("predicates");
                    for (Map.Entry entry : predicates.entrySet()) {
                        JsonArray array = ((JsonElement)entry.getValue()).getAsJsonArray();
                        for (int i = 0; i < array.size(); ++i) {
                            if (array.get(i).getAsJsonObject().get("value").isJsonPrimitive() && array.get(i).getAsJsonObject().getAsJsonPrimitive("value").getAsString().equals("default")) continue;
                            list.add(modelLocation);
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    protected BakedQuad makeBakedQuad(BlockPart p_177589_1_, BlockPartFace p_177589_2_, TextureAtlasSprite p_177589_3_, EnumFacing p_177589_4_, ITransformation p_177589_5_, boolean p_177589_6_) {
        return new FaceBakery().makeBakedQuad(p_177589_1_.field_178241_a, p_177589_1_.field_178239_b, p_177589_2_, p_177589_3_, p_177589_4_, p_177589_5_, p_177589_1_.field_178237_d, p_177589_6_, p_177589_1_.field_178238_e);
    }

    private static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> getBaseTransforms(JsonObject json, ItemStack stack, World world, EntityLivingBase entity, BakedModelClip model) {
        ImmutableMap transformMap = PerspectiveMapWrapper.getTransforms((ItemCameraTransforms)((BakedModelClip)model).parent.baseModel.func_181682_g());
        ImmutableMap.Builder transformBuilder = ImmutableMap.builder();
        JsonObject baseTransforms = json.getAsJsonObject("basetransformation");
        if (baseTransforms == null) {
            return null;
        }
        JsonObject predicates = baseTransforms.getAsJsonObject("predicates");
        if (predicates == null) {
            System.out.println("ERROR: BASE PREDICATES NOT FOUND");
        } else {
            for (Map.Entry entry : predicates.entrySet()) {
                String name = (String)entry.getKey();
                if (((JsonElement)entry.getValue()).isJsonObject()) {
                    JsonObject predicate = (JsonObject)entry.getValue();
                    IItemPropertyGetter iitempropertygetter = stack.func_77973_b().func_185045_a(new ResourceLocation(name));
                    if (predicate == null) {
                        System.out.println("ERROR: PREDICATE IS NULL");
                        continue;
                    }
                    for (ItemCameraTransforms.TransformType typeName : ItemCameraTransforms.TransformType.values()) {
                        if (transformMap.get((Object)typeName) == null) {
                            transformBuilder.put((Object)typeName, (Object)TRSRTransformation.identity());
                            continue;
                        }
                        TRSRTransformation transform = TRSRTransformation.identity();
                        JsonArray type2 = predicate.getAsJsonArray(typeName.toString());
                        if (type2 != null) {
                            for (Object predicateObject : type2) {
                                JsonObject itemProperty = (JsonObject)predicateObject;
                                if (!itemProperty.get("value").isJsonPrimitive()) {
                                    System.out.println("ERROR: PROPERTY IS NOT JSONPRIMITIVE");
                                    continue;
                                }
                                if (iitempropertygetter == null) {
                                    System.out.println("ERROR: ITEMPROPERTY NOT FOUND");
                                    continue;
                                }
                                JsonPrimitive valuePrimitive = itemProperty.getAsJsonPrimitive("value");
                                if (valuePrimitive.isNumber()) {
                                    float value = valuePrimitive.getAsFloat();
                                    if (!((double)Math.abs(value - iitempropertygetter.func_185085_a(stack, world, entity)) < 0.001)) continue;
                                    JsonObject jsonTransform = itemProperty.getAsJsonObject("transformation");
                                    JsonArray jsonTranslate = jsonTransform.getAsJsonArray("translation");
                                    javax.vecmath.Vector3f translate = null;
                                    if (jsonTranslate != null) {
                                        float[] floats = new float[3];
                                        int i = 0;
                                        for (JsonElement element : jsonTranslate) {
                                            floats[i++] = element.getAsFloat();
                                        }
                                        translate = new javax.vecmath.Vector3f(floats);
                                    }
                                    JsonArray jsonRotate = jsonTransform.getAsJsonArray("rotation");
                                    Quat4f rotLeft = null;
                                    if (jsonRotate != null) {
                                        float[] floats = new float[4];
                                        int i = 0;
                                        for (JsonElement element : jsonRotate) {
                                            floats[i++] = element.getAsFloat();
                                        }
                                        floats[3] = 1.0f;
                                        rotLeft = new Quat4f(floats);
                                    }
                                    JsonArray jsonScale = jsonTransform.getAsJsonArray("scale");
                                    javax.vecmath.Vector3f scale = null;
                                    if (jsonScale != null) {
                                        float[] floats = new float[3];
                                        int i = 0;
                                        for (JsonElement element : jsonScale) {
                                            floats[i++] = element.getAsFloat();
                                        }
                                        scale = new javax.vecmath.Vector3f(floats);
                                    }
                                    transform = transform.compose(TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(translate, rotLeft, scale, null)));
                                    continue;
                                }
                                System.out.println("ERROR: PREDICATE VALUE TYPE IS NOT SUPPORTED");
                            }
                        }
                        transformBuilder.put((Object)typeName, (Object)((TRSRTransformation)transformMap.get((Object)typeName)).compose(transform));
                    }
                    transformMap = transformBuilder.build();
                    transformBuilder = ImmutableMap.builder();
                    continue;
                }
                System.out.println("ERROR: " + name + " IS NOT A JSONOBJECT");
            }
        }
        return transformMap;
    }

    private static List<TRSRTransformation> getSubTransformations(JsonObject json, ItemStack stack, World world, EntityLivingBase entity) {
        ArrayList<TRSRTransformation> transformations = new ArrayList<TRSRTransformation>();
        JsonArray submodels = json.getAsJsonArray("submodels");
        if (submodels != null) {
            for (Object submodelObject : submodels) {
                JsonObject submodel = (JsonObject)submodelObject;
                JsonObject predicates = submodel.getAsJsonObject("predicates");
                if (predicates != null) {
                    for (Map.Entry entry : predicates.entrySet()) {
                        String name = (String)entry.getKey();
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            JsonArray predicate = (JsonArray)entry.getValue();
                            IItemPropertyGetter iitempropertygetter = stack.func_77973_b().func_185045_a(new ResourceLocation(name));
                            if (iitempropertygetter == null) {
                                System.out.println("ERROR: PROPERTY DOES NOT EXIST");
                                continue;
                            }
                            if (predicate == null) {
                                System.out.println("ERROR: PREDICATE IS NULL");
                                continue;
                            }
                            TRSRTransformation defaultTransform = new TRSRTransformation(null, null, null, null);
                            for (Object predicateObject : predicate) {
                                JsonObject itemProperty = (JsonObject)predicateObject;
                                if (!itemProperty.get("value").isJsonPrimitive()) {
                                    System.out.println("ERROR: PROPERTY IS NOT JSONPRIMITIVE");
                                    continue;
                                }
                                JsonPrimitive valuePrimitive = itemProperty.getAsJsonPrimitive("value");
                                if (valuePrimitive.isString() && valuePrimitive.getAsString().matches("default")) {
                                    JsonObject jsonTransform = itemProperty.getAsJsonObject("transformation");
                                    JsonArray jsonTranslate = jsonTransform.getAsJsonArray("translation");
                                    javax.vecmath.Vector3f translate = null;
                                    if (jsonTranslate != null) {
                                        float[] floats = new float[3];
                                        int i = 0;
                                        for (JsonElement element : jsonTranslate) {
                                            floats[i++] = element.getAsFloat();
                                        }
                                        translate = new javax.vecmath.Vector3f(floats);
                                    }
                                    JsonArray jsonRotate = jsonTransform.getAsJsonArray("rotation");
                                    Quat4f rotLeft = null;
                                    if (jsonRotate != null) {
                                        float[] floats = new float[4];
                                        int i = 0;
                                        for (JsonElement element : jsonRotate) {
                                            floats[i++] = element.getAsFloat();
                                        }
                                        floats[3] = 1.0f;
                                        rotLeft = new Quat4f(floats);
                                    }
                                    JsonArray jsonScale = jsonTransform.getAsJsonArray("scale");
                                    Iterator scale = null;
                                    if (jsonScale != null) {
                                        float[] floats = new float[3];
                                        int i = 0;
                                        for (JsonElement element : jsonScale) {
                                            floats[i++] = element.getAsFloat();
                                        }
                                        scale = new javax.vecmath.Vector3f(floats);
                                    }
                                    defaultTransform = new TRSRTransformation(translate, rotLeft, (javax.vecmath.Vector3f)scale, null);
                                    continue;
                                }
                                if (valuePrimitive.isNumber()) {
                                    float value = valuePrimitive.getAsFloat();
                                    if (iitempropertygetter.func_185085_a(stack, world, entity) >= value) {
                                        JsonObject jsonTransform = itemProperty.getAsJsonObject("transformation");
                                        JsonArray jsonTranslate = jsonTransform.getAsJsonArray("translation");
                                        javax.vecmath.Vector3f translate = null;
                                        if (jsonTranslate != null) {
                                            float[] floats = new float[3];
                                            int i = 0;
                                            for (JsonElement element : jsonTranslate) {
                                                floats[i++] = element.getAsFloat();
                                            }
                                            translate = new javax.vecmath.Vector3f(floats);
                                        }
                                        JsonArray jsonRotate = jsonTransform.getAsJsonArray("rotation");
                                        Quat4f rotLeft = null;
                                        if (jsonRotate != null) {
                                            float[] floats = new float[4];
                                            int i = 0;
                                            for (JsonElement element : jsonRotate) {
                                                floats[i++] = element.getAsFloat();
                                            }
                                            floats[3] = 1.0f;
                                            rotLeft = new Quat4f(floats);
                                        }
                                        JsonArray jsonScale = jsonTransform.getAsJsonArray("scale");
                                        javax.vecmath.Vector3f scale = null;
                                        if (jsonScale != null) {
                                            float[] floats = new float[3];
                                            int i = 0;
                                            for (JsonElement element : jsonScale) {
                                                floats[i++] = element.getAsFloat();
                                            }
                                            scale = new javax.vecmath.Vector3f(floats);
                                        }
                                        TRSRTransformation transform = TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(translate, rotLeft, scale, null));
                                        transformations.add(transform);
                                        continue;
                                    }
                                    transformations.add(defaultTransform);
                                    continue;
                                }
                                System.out.println("ERROR: PREDICATE VALUE TYPE IS NOT SUPPORTED");
                            }
                            continue;
                        }
                        System.out.println("ERROR: " + name + " IS NOT A JSONARRAY");
                    }
                    continue;
                }
                System.out.println("ERROR: JSON MISSING PREDICATES");
            }
        } else {
            System.out.println("ERROR: JSON MISSING SUBMODELS");
        }
        return transformations;
    }

    public static List<String> getPredicates(JsonObject json) {
        ArrayList<String> names = new ArrayList<String>();
        JsonArray submodels = json.getAsJsonArray("submodels");
        for (Object submodelObject : submodels) {
            JsonObject submodel = (JsonObject)submodelObject;
            JsonObject predicates = submodel.getAsJsonObject("predicates");
            for (Map.Entry entry : predicates.entrySet()) {
                String name = (String)entry.getKey();
                names.add(name);
            }
        }
        return names;
    }

    private static final class BakedModelClip
    implements IBakedModel {
        private final IModelClip parent;
        private final List<IBakedModel> models;
        private ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
        private final TextureAtlasSprite particle;
        private final VertexFormat format;
        private final ItemOverrideList overrides;
        private final Map<String, IBakedModel> cache;

        public BakedModelClip(IModelClip parent, List<IBakedModel> models, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, TextureAtlasSprite particle, VertexFormat format, ItemOverrideList overrides, Map<String, IBakedModel> cache) {
            this.parent = parent;
            this.models = models;
            this.transforms = transforms;
            this.particle = particle;
            this.format = format;
            this.overrides = overrides;
            this.cache = cache;
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            for (IBakedModel model : this.models) {
                quads.addAll(model.func_188616_a(state, side, rand));
            }
            return quads;
        }

        public boolean func_177555_b() {
            return false;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.particle;
        }

        public ItemOverrideList func_188617_f() {
            return this.overrides;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type2) {
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)type2);
        }

        public void setCameraTransforms(ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms) {
            this.transforms = transforms;
        }
    }

    public static class PerspectiveMapWrapperGun
    extends PerspectiveMapWrapper {
        private ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;

        public PerspectiveMapWrapperGun(IBakedModel parent, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms) {
            super(parent, transforms);
            this.transforms = transforms;
        }

        public PerspectiveMapWrapperGun(IBakedModel parent, IModelState state) {
            this(parent, PerspectiveMapWrapperGun.getTransforms(state));
        }

        public static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> getTransforms(IModelState state) {
            EnumMap map = new EnumMap(ItemCameraTransforms.TransformType.class);
            for (ItemCameraTransforms.TransformType type2 : ItemCameraTransforms.TransformType.values()) {
                Optional tr = state.apply(Optional.of(type2));
                if (!tr.isPresent()) continue;
                map.put(type2, tr.get());
            }
            return ImmutableMap.copyOf(map);
        }
    }

    private static class ClipOverrideHandler
    extends ItemOverrideList {
        public static final ClipOverrideHandler INSTANCE = new ClipOverrideHandler();

        public ClipOverrideHandler() {
            super((List)ImmutableList.of());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            Gson gson = new Gson();
            BakedModelClip model = (BakedModelClip)originalModel;
            BufferedReader reader = IModelClip.getModelReader(model.parent.baseLocation);
            JsonElement je = (JsonElement)gson.fromJson((Reader)reader, JsonElement.class);
            if (je == null) {
                System.out.println("ERROR: JSON IS NULL");
                return originalModel;
            }
            JsonObject json = je.getAsJsonObject();
            List<String> names = IModelClip.getPredicates(json);
            String Key = "";
            for (String name : names) {
                IItemPropertyGetter iitempropertygetter = stack.func_77973_b().func_185045_a(new ResourceLocation(name));
                if (iitempropertygetter == null) {
                    System.out.println("ERROR: ITEM PROPERTY: " + name + " IS NULL");
                    continue;
                }
                Key = Key.concat(Float.valueOf(iitempropertygetter.func_185085_a(stack, world, entity)).toString());
            }
            if (!model.cache.containsKey(Key)) {
                IModelClip parent = model.parent;
                Function<ResourceLocation, TextureAtlasSprite> textureGetter = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                HashMap<MapModelState.Wrapper, SimpleModelState> map = new HashMap<MapModelState.Wrapper, SimpleModelState>();
                ArrayList<TRSRTransformation> transformations = new ArrayList<TRSRTransformation>();
                transformations.add(TRSRTransformation.identity());
                transformations.addAll(IModelClip.getSubTransformations(json, stack, world, entity));
                int i = 0;
                for (ResourceLocation location2 : parent.getDependenciesForMap()) {
                    HashMap map2 = new HashMap();
                    for (ItemCameraTransforms.TransformType type2 : ItemCameraTransforms.TransformType.values()) {
                        map2.put(type2, transformations.get(i));
                    }
                    map.put(MapModelState.wrap((Object)location2), new SimpleModelState(ImmutableMap.copyOf(map2), Optional.ofNullable(transformations.get(i))));
                    ++i;
                }
                MapModelState state = new MapModelState(map);
                IBakedModel bakedModel = parent.bake((IModelState)state, model.format, textureGetter);
                model.cache.put(Key, bakedModel);
            }
            BakedModelClip newModel = (BakedModelClip)model.cache.get(Key);
            ImmutableMap baseTransforms = IModelClip.getBaseTransforms(json, stack, world, entity, model);
            if (baseTransforms != null) {
                newModel.setCameraTransforms((ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)baseTransforms);
            }
            return newModel;
        }
    }

    public static enum ClipModelLoader implements ICustomModelLoader
    {
        INSTANCE;


        public void func_110549_a(IResourceManager resourceManager) {
        }

        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.func_110624_b().equals("rm") && modelLocation.func_110623_a().contains("_clip_");
        }

        public IModel loadModel(ResourceLocation modelLocation) throws Exception {
            Main.LOGGER.info("Loading Model: " + modelLocation);
            return new IModelClip(modelLocation);
        }
    }
}

