/*
 * Decompiled with CFR 0.152.
 */
package com.PiMan.RecieverMod.util;

import com.PiMan.RecieverMod.Items.guns.ItemGun;
import com.PiMan.RecieverMod.Main;
import com.PiMan.RecieverMod.util.IItemData;
import com.PiMan.RecieverMod.util.ItemDataProvider;
import com.PiMan.RecieverMod.util.ModelTest;
import com.PiMan.RecieverMod.util.TransformationBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockPart;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.BlockPartRotation;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.MapModelState;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.animation.ModelBlockAnimation;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.ITransformation;
import net.minecraftforge.common.model.Models;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.util.vector.Vector3f;

public class IModelGun
implements IModel {
    private static IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
    public static final IModelGun MODEL = new IModelGun();
    @Nullable
    private ResourceLocation baseLocation;
    private ModelBlock baseModel;

    public IModelGun() {
        this(null);
    }

    public IModelGun(@Nullable ResourceLocation baseLocation) {
        this.baseLocation = baseLocation;
        ModelBlock model = null;
        if (baseLocation != null) {
            BufferedReader reader = IModelGun.getModelReader(baseLocation);
            if (reader != null) {
                model = ModelBlock.func_178307_a((Reader)reader);
            } else {
                Main.LOGGER.error("Unable to get Model");
            }
            try {
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.baseModel = model;
    }

    public Collection<ResourceLocation> getTextures() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (this.baseLocation != null) {
            for (String texture : this.baseModel.field_178318_c.values()) {
                builder.add((Object)new ResourceLocation(texture));
            }
        }
        return builder.build();
    }

    public ResourceLocation getTexture() {
        return new ResourceLocation("rm", "items/1911");
    }

    public Collection<ResourceLocation> getDependencies() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)this.baseLocation);
        List<ResourceLocation> list = ModelTest.getParts(this.baseLocation);
        if (list != null) {
            builder.addAll(list);
        }
        return builder.build();
    }

    public Collection<ResourceLocation> getDependenciesForMap() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)this.baseLocation);
        List<ResourceLocation> list = IModelGun.getParts(this.baseLocation);
        int i = 0;
        for (ResourceLocation location : list) {
            while (list.contains(location)) {
                location = new ResourceLocation(location.toString() + "-");
            }
            list.set(i++, location);
        }
        if (list != null) {
            builder.addAll(list);
        }
        return builder.build();
    }

    public static List<ResourceLocation> getParts(ResourceLocation loc) {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        Gson gson = new Gson();
        try {
            ResourceLocation location = new ResourceLocation("rm", loc.func_110623_a() + ".json");
            if (!location.func_110623_a().contains("models/item/")) {
                location = new ResourceLocation("rm", "models/item/" + location.func_110623_a());
            }
            InputStream in = Minecraft.func_71410_x().func_110442_L().func_110536_a(location).func_110527_b();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            JsonElement je = (JsonElement)gson.fromJson((Reader)reader, JsonElement.class);
            reader.close();
            JsonObject json = je.getAsJsonObject();
            JsonArray modelArray = (JsonArray)json.get("submodels");
            if (modelArray != null) {
                for (Object modelobject : modelArray) {
                    JsonObject jsonmodel = (JsonObject)modelobject;
                    ResourceLocation modelLocation = new ResourceLocation(jsonmodel.get("model").getAsString());
                    JsonObject predicates = jsonmodel.getAsJsonObject("predicates");
                    list.add(modelLocation);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    public IModel getMissingModel() {
        return ModelLoaderRegistry.getMissingModel();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap transformMap = PerspectiveMapWrapper.getTransforms((ItemCameraTransforms)this.baseModel.func_181682_g());
        GunOverrideHandler overrides = GunOverrideHandler.INSTANCE;
        ArrayList<ResourceLocation> locations = new ArrayList<ResourceLocation>();
        locations.addAll(this.getDependenciesForMap());
        ArrayList<IBakedModel> models = new ArrayList<IBakedModel>();
        for (ResourceLocation location : locations) {
            IBakedModel model = this.bakeModelPart(state, format, bakedTextureGetter, location);
            models.add(model);
        }
        return new BakedModelGun(this, models, Maps.newHashMap((Map)PerspectiveMapWrapper.getTransforms((ItemCameraTransforms)this.baseModel.func_181682_g())), bakedTextureGetter.apply(this.getTexture()), format, overrides, Maps.newHashMap());
    }

    public IBakedModel bakeModelPart(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, ResourceLocation location) {
        if (state instanceof MapModelState) {
            state = ((MapModelState)state).getState((Object)location);
        }
        String modelPath = location.func_110623_a();
        if (location.func_110623_a().startsWith("models/")) {
            modelPath = modelPath.substring("models/".length());
        }
        ResourceLocation armatureLocation = new ResourceLocation(location.func_110624_b(), "armatures/" + modelPath + ".json");
        ModelBlockAnimation animation = ModelBlockAnimation.loadVanillaAnimation((IResourceManager)resourceManager, (ResourceLocation)armatureLocation);
        ModelBlock model = null;
        if (location != null) {
            try {
                InputStream in = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("rm", "models/item/" + location.func_110623_a().replace("-", "") + ".json")).func_110527_b();
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                model = ModelBlock.func_178307_a((Reader)reader);
                reader.close();
            }
            catch (IOException e) {
                System.out.println("Unable to find model: " + location);
                e.printStackTrace();
            }
        }
        if (!Attributes.moreSpecific((VertexFormat)format, (VertexFormat)Attributes.DEFAULT_BAKED_FORMAT)) {
            throw new IllegalArgumentException("can't bake vanilla models to the format that doesn't fit into the default one: " + format);
        }
        if (model == null) {
            Main.LOGGER.error("Could Not Get Model For {}", (Object)location);
            return this.getMissingModel().bake(this.getMissingModel().getDefaultState(), format, bakedTextureGetter);
        }
        ArrayList newTransforms = Lists.newArrayList();
        for (int i = 0; i < model.func_178298_a().size(); ++i) {
            newTransforms.add(state.apply(Optional.empty()).orElse(TRSRTransformation.identity()));
        }
        ItemCameraTransforms transforms = model.func_181682_g();
        EnumMap tMap = Maps.newEnumMap(ItemCameraTransforms.TransformType.class);
        tMap.putAll(PerspectiveMapWrapper.getTransforms((ItemCameraTransforms)transforms));
        tMap.putAll(PerspectiveMapWrapper.getTransforms((IModelState)state));
        SimpleModelState perState = new SimpleModelState(ImmutableMap.copyOf((Map)tMap));
        return this.bakeNormal(model, (IModelState)perState, state, newTransforms, format, bakedTextureGetter, false);
    }

    public IBakedModel bakeNormal(ModelBlock model, IModelState perState, IModelState modelState, List<TRSRTransformation> newTransforms, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, boolean uvLocked) {
        TRSRTransformation baseState = modelState.apply(Optional.empty()).orElse(TRSRTransformation.identity());
        TextureAtlasSprite particle = bakedTextureGetter.apply(new ResourceLocation(model.func_178308_c("particle")));
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(model, model.func_187967_g()).func_177646_a(particle);
        for (int i = 0; i < model.func_178298_a().size(); ++i) {
            if (modelState.apply(Optional.of(Models.getHiddenModelPart((ImmutableList)ImmutableList.of((Object)Integer.toString(i))))).isPresent()) continue;
            BlockPart part = (BlockPart)model.func_178298_a().get(i);
            TRSRTransformation transformation = baseState;
            if (newTransforms.get(i) != null) {
                transformation = newTransforms.get(i);
                BlockPartRotation rot = part.field_178237_d;
                if (rot == null) {
                    rot = new BlockPartRotation(new Vector3f(), EnumFacing.Axis.Y, 0.0f, false);
                }
                part = new BlockPart(part.field_178241_a, part.field_178239_b, part.field_178240_c, rot, part.field_178238_e);
            }
            for (Map.Entry e : part.field_178240_c.entrySet()) {
                TextureAtlasSprite textureatlassprite1 = bakedTextureGetter.apply(new ResourceLocation(model.func_178308_c(((BlockPartFace)e.getValue()).field_178242_d)));
                if (((BlockPartFace)e.getValue()).field_178244_b == null || !TRSRTransformation.isInteger((Matrix4f)transformation.getMatrix())) {
                    builder.func_177648_a(this.makeBakedQuad(part, (BlockPartFace)e.getValue(), textureatlassprite1, (EnumFacing)e.getKey(), (ITransformation)transformation, uvLocked));
                    continue;
                }
                builder.func_177650_a(baseState.rotate(((BlockPartFace)e.getValue()).field_178244_b), this.makeBakedQuad(part, (BlockPartFace)e.getValue(), textureatlassprite1, (EnumFacing)e.getKey(), (ITransformation)transformation, uvLocked));
            }
        }
        return new PerspectiveMapWrapperGun(builder.func_177645_b(), perState);
    }

    public IModelGun process(ImmutableMap<String, String> customData) {
        return new IModelGun(this.baseLocation);
    }

    public IModelGun retexture(ImmutableMap<String, String> textures) {
        ResourceLocation base = this.baseLocation;
        if (textures.containsKey((Object)"base")) {
            base = new ResourceLocation((String)textures.get((Object)"base"));
        }
        return new IModelGun(base);
    }

    protected static BufferedReader getModelReader(ResourceLocation modelLocation) {
        if (modelLocation.func_110623_a().contains("models")) {
            return null;
        }
        try {
            InputStream in = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("rm", "models/item/" + modelLocation.func_110623_a() + ".json")).func_110527_b();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            return reader;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected ResourceLocation getModelLocation(ResourceLocation location) {
        return new ResourceLocation(location.func_110624_b(), "models/" + location.func_110623_a() + ".json");
    }

    protected BakedQuad makeBakedQuad(BlockPart p_177589_1_, BlockPartFace p_177589_2_, TextureAtlasSprite p_177589_3_, EnumFacing p_177589_4_, ITransformation p_177589_5_, boolean p_177589_6_) {
        return new FaceBakery().makeBakedQuad(p_177589_1_.field_178241_a, p_177589_1_.field_178239_b, p_177589_2_, p_177589_3_, p_177589_4_, p_177589_5_, p_177589_1_.field_178237_d, p_177589_6_, p_177589_1_.field_178238_e);
    }

    private static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> getBaseTransforms(JsonObject json, ItemStack stack, World world, EntityLivingBase entity, BakedModelGun model) {
        ImmutableMap transformMap = PerspectiveMapWrapper.getTransforms((ItemCameraTransforms)((BakedModelGun)model).parent.baseModel.func_181682_g());
        ImmutableMap.Builder transformBuilder = ImmutableMap.builder();
        JsonObject baseTransforms = json.getAsJsonObject("basetransformation");
        if (baseTransforms == null) {
            return null;
        }
        JsonObject predicates = baseTransforms.getAsJsonObject("predicates");
        if (predicates == null) {
            System.out.println("ERROR: BASE PREDICATES NOT FOUND");
        } else {
            for (Map.Entry entry : predicates.entrySet()) {
                String name = (String)entry.getKey();
                if (((JsonElement)entry.getValue()).isJsonObject()) {
                    JsonObject predicate = (JsonObject)entry.getValue();
                    IItemPropertyGetter iitempropertygetter = stack.func_77973_b().func_185045_a(new ResourceLocation(name));
                    if (predicate == null) {
                        System.out.println("ERROR: PREDICATE IS NULL");
                        continue;
                    }
                    for (ItemCameraTransforms.TransformType typeName : ItemCameraTransforms.TransformType.values()) {
                        boolean flag = false;
                        javax.vecmath.Vector3f[] defaultTransform = new javax.vecmath.Vector3f[]{new javax.vecmath.Vector3f(), new javax.vecmath.Vector3f(), new javax.vecmath.Vector3f(), new javax.vecmath.Vector3f(1.0f, 1.0f, 1.0f)};
                        if (transformMap.get((Object)typeName) == null) {
                            transformBuilder.put((Object)typeName, (Object)TRSRTransformation.identity());
                            continue;
                        }
                        TransformationBuilder transform = new TransformationBuilder();
                        JsonArray type2 = predicate.getAsJsonArray(typeName.toString());
                        if (type2 != null) {
                            for (Object predicateObject : type2) {
                                float[] floats;
                                Iterator scale;
                                Iterator center;
                                JsonArray jsonCenter;
                                float[] floats2;
                                Iterator rotate;
                                JsonArray jsonRotate;
                                float[] floats3;
                                Iterator translate;
                                JsonArray jsonTranslate;
                                JsonObject jsonTransform;
                                JsonPrimitive orderPrimitive;
                                JsonObject itemProperty = (JsonObject)predicateObject;
                                if (!itemProperty.get("value").isJsonPrimitive()) {
                                    System.out.println("ERROR: PROPERTY IS NOT JSONPRIMITIVE");
                                    continue;
                                }
                                if (iitempropertygetter == null) {
                                    System.out.println("ERROR: ITEMPROPERTY NOT FOUND");
                                    continue;
                                }
                                JsonPrimitive valuePrimitive = itemProperty.getAsJsonPrimitive("value");
                                if (valuePrimitive.isNumber()) {
                                    float value = valuePrimitive.getAsFloat();
                                    if (!((double)Math.abs(value - iitempropertygetter.func_185085_a(stack, world, entity)) < 0.001)) continue;
                                    flag = true;
                                    orderPrimitive = itemProperty.getAsJsonPrimitive("order");
                                    int order = 0;
                                    if (orderPrimitive != null) {
                                        order = orderPrimitive.getAsInt();
                                    }
                                    jsonTransform = itemProperty.getAsJsonObject("transformation");
                                    jsonTranslate = jsonTransform.getAsJsonArray("translation");
                                    translate = null;
                                    if (jsonTranslate != null) {
                                        floats3 = new float[3];
                                        int i = 0;
                                        for (JsonElement element : jsonTranslate) {
                                            floats3[i++] = element.getAsFloat();
                                        }
                                        translate = new javax.vecmath.Vector3f(floats3);
                                    }
                                    jsonRotate = jsonTransform.getAsJsonArray("rotation");
                                    rotate = null;
                                    if (jsonRotate != null) {
                                        floats2 = new float[3];
                                        int i = 0;
                                        for (JsonElement element : jsonRotate) {
                                            floats2[i++] = element.getAsFloat();
                                        }
                                        rotate = new javax.vecmath.Vector3f(floats2);
                                    }
                                    jsonCenter = jsonTransform.getAsJsonArray("center");
                                    center = null;
                                    if (jsonCenter != null) {
                                        float[] floats4 = new float[3];
                                        int i = 0;
                                        for (JsonElement element : jsonCenter) {
                                            floats4[i++] = element.getAsFloat();
                                        }
                                        center = new javax.vecmath.Vector3f(floats4);
                                    }
                                    JsonArray jsonScale = jsonTransform.getAsJsonArray("scale");
                                    scale = null;
                                    if (jsonScale != null) {
                                        floats = new float[3];
                                        int i = 0;
                                        for (JsonElement element : jsonScale) {
                                            floats[i++] = element.getAsFloat();
                                        }
                                        scale = new javax.vecmath.Vector3f(floats);
                                    }
                                    transform.add((javax.vecmath.Vector3f)translate, (javax.vecmath.Vector3f)rotate, (javax.vecmath.Vector3f)center, (javax.vecmath.Vector3f)scale, order);
                                    continue;
                                }
                                if (valuePrimitive.isString() && valuePrimitive.getAsString().matches("default")) {
                                    JsonObject jsonTransform2 = itemProperty.getAsJsonObject("transformation");
                                    JsonArray jsonTranslate2 = jsonTransform2.getAsJsonArray("translation");
                                    javax.vecmath.Vector3f translate2 = null;
                                    if (jsonTranslate2 != null) {
                                        float[] floats5 = new float[3];
                                        int i = 0;
                                        for (JsonElement element : jsonTranslate2) {
                                            floats5[i++] = element.getAsFloat();
                                        }
                                        translate2 = new javax.vecmath.Vector3f(floats5);
                                    }
                                    JsonArray jsonRotate2 = jsonTransform2.getAsJsonArray("rotation");
                                    javax.vecmath.Vector3f rotate2 = null;
                                    if (jsonRotate2 != null) {
                                        float[] floats6 = new float[3];
                                        int i = 0;
                                        for (JsonElement element : jsonRotate2) {
                                            floats6[i++] = element.getAsFloat();
                                        }
                                        rotate2 = new javax.vecmath.Vector3f(floats6);
                                    }
                                    JsonArray jsonCenter2 = jsonTransform2.getAsJsonArray("center");
                                    javax.vecmath.Vector3f center2 = null;
                                    if (jsonCenter2 != null) {
                                        float[] floats7 = new float[3];
                                        int i = 0;
                                        for (JsonElement element : jsonCenter2) {
                                            floats7[i++] = element.getAsFloat();
                                        }
                                        center2 = new javax.vecmath.Vector3f(floats7);
                                    }
                                    JsonArray jsonScale = jsonTransform2.getAsJsonArray("scale");
                                    Iterator scale2 = null;
                                    if (jsonScale != null) {
                                        float[] floats8 = new float[3];
                                        int i = 0;
                                        for (Object element : jsonScale) {
                                            floats8[i++] = element.getAsFloat();
                                        }
                                        scale2 = new javax.vecmath.Vector3f(floats8);
                                    }
                                    defaultTransform[0] = translate2;
                                    defaultTransform[1] = rotate2;
                                    defaultTransform[2] = center2;
                                    defaultTransform[3] = scale2;
                                    continue;
                                }
                                if (valuePrimitive.isString() && valuePrimitive.getAsString().matches("variable")) {
                                    flag = true;
                                    float modifier = iitempropertygetter.func_185085_a(stack, world, entity);
                                    orderPrimitive = itemProperty.getAsJsonPrimitive("order");
                                    int order = 0;
                                    if (orderPrimitive != null) {
                                        order = orderPrimitive.getAsInt();
                                    }
                                    jsonTransform = itemProperty.getAsJsonObject("transformation");
                                    jsonTranslate = jsonTransform.getAsJsonArray("translation");
                                    translate = null;
                                    if (jsonTranslate != null) {
                                        floats3 = new float[3];
                                        int i = 0;
                                        for (JsonElement element : jsonTranslate) {
                                            floats3[i++] = element.getAsFloat() * modifier;
                                        }
                                        translate = new javax.vecmath.Vector3f(floats3);
                                    }
                                    jsonRotate = jsonTransform.getAsJsonArray("rotation");
                                    rotate = null;
                                    if (jsonRotate != null) {
                                        floats2 = new float[3];
                                        int i = 0;
                                        for (JsonElement element : jsonRotate) {
                                            floats2[i++] = element.getAsFloat() * modifier;
                                        }
                                        rotate = new javax.vecmath.Vector3f(floats2);
                                    }
                                    jsonCenter = jsonTransform.getAsJsonArray("center");
                                    center = null;
                                    if (jsonCenter != null) {
                                        Object element;
                                        float[] floats9 = new float[3];
                                        int i = 0;
                                        element = jsonCenter.iterator();
                                        while (element.hasNext()) {
                                            JsonElement element2 = (JsonElement)element.next();
                                            floats9[i++] = element2.getAsFloat();
                                        }
                                        center = new javax.vecmath.Vector3f(floats9);
                                    }
                                    JsonArray jsonScale = jsonTransform.getAsJsonArray("scale");
                                    scale = null;
                                    if (jsonScale != null) {
                                        floats = new float[3];
                                        int i = 0;
                                        for (JsonElement element : jsonScale) {
                                            floats[i++] = element.getAsFloat() * modifier;
                                        }
                                        scale = new javax.vecmath.Vector3f(floats);
                                    }
                                    transform.add((javax.vecmath.Vector3f)translate, (javax.vecmath.Vector3f)rotate, (javax.vecmath.Vector3f)center, (javax.vecmath.Vector3f)scale, order);
                                    continue;
                                }
                                System.out.println("ERROR: PREDICATE VALUE TYPE IS NOT SUPPORTED");
                            }
                            if (!flag) {
                                transform.add(defaultTransform[0], defaultTransform[1], defaultTransform[2], defaultTransform[3], 0);
                            }
                        }
                        transformBuilder.put((Object)typeName, (Object)((TRSRTransformation)transformMap.get((Object)typeName)).compose(transform.build()));
                    }
                    transformMap = transformBuilder.build();
                    transformBuilder = ImmutableMap.builder();
                    continue;
                }
                System.out.println("ERROR: " + name + " IS NOT A JSONOBJECT");
            }
        }
        return transformMap;
    }

    private static List<TRSRTransformation> getSubTransformations(JsonObject json, ItemStack stack, World world, EntityLivingBase entity) {
        ArrayList<TRSRTransformation> transformations = new ArrayList<TRSRTransformation>();
        JsonArray submodels = json.getAsJsonArray("submodels");
        if (submodels != null) {
            for (Object submodelObject : submodels) {
                JsonObject submodel = (JsonObject)submodelObject;
                JsonObject predicates = submodel.getAsJsonObject("predicates");
                TransformationBuilder finalTransform = new TransformationBuilder();
                if (predicates != null) {
                    for (Map.Entry entry : predicates.entrySet()) {
                        String name = (String)entry.getKey();
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            JsonArray predicate = (JsonArray)entry.getValue();
                            IItemPropertyGetter iitempropertygetter = stack.func_77973_b().func_185045_a(new ResourceLocation(name));
                            if (iitempropertygetter == null && !name.equals("none")) {
                                System.out.println("ERROR: " + name + " PROPERTY DOES NOT EXIST");
                                continue;
                            }
                            if (predicate == null) {
                                System.out.println("ERROR: PREDICATE IS NULL");
                                continue;
                            }
                            boolean flag = false;
                            javax.vecmath.Vector3f[] defaultTransform = new javax.vecmath.Vector3f[]{new javax.vecmath.Vector3f(), new javax.vecmath.Vector3f(), new javax.vecmath.Vector3f(), new javax.vecmath.Vector3f(1.0f, 1.0f, 1.0f)};
                            for (Object predicateObject : predicate) {
                                float[] floats;
                                Iterator scale;
                                Iterator center;
                                JsonArray jsonCenter;
                                float[] floats2;
                                Iterator rotate;
                                JsonArray jsonRotate;
                                float[] floats3;
                                Iterator translate;
                                JsonArray jsonTranslate;
                                JsonObject jsonTransform;
                                JsonPrimitive orderPrimitive;
                                JsonObject itemProperty = (JsonObject)predicateObject;
                                if (!itemProperty.get("value").isJsonPrimitive()) {
                                    System.out.println("ERROR: PROPERTY IS NOT JSONPRIMITIVE");
                                    continue;
                                }
                                JsonPrimitive valuePrimitive = itemProperty.getAsJsonPrimitive("value");
                                if (valuePrimitive.isNumber()) {
                                    float value = valuePrimitive.getAsFloat();
                                    if (!((double)Math.abs(value - iitempropertygetter.func_185085_a(stack, world, entity)) < 0.001)) continue;
                                    flag = true;
                                    orderPrimitive = itemProperty.getAsJsonPrimitive("order");
                                    int order = 0;
                                    if (orderPrimitive != null) {
                                        order = orderPrimitive.getAsInt();
                                    }
                                    jsonTransform = itemProperty.getAsJsonObject("transformation");
                                    jsonTranslate = jsonTransform.getAsJsonArray("translation");
                                    translate = null;
                                    if (jsonTranslate != null) {
                                        floats3 = new float[3];
                                        int i = 0;
                                        for (JsonElement element : jsonTranslate) {
                                            floats3[i++] = element.getAsFloat();
                                        }
                                        translate = new javax.vecmath.Vector3f(floats3);
                                    }
                                    jsonRotate = jsonTransform.getAsJsonArray("rotation");
                                    rotate = null;
                                    if (jsonRotate != null) {
                                        floats2 = new float[3];
                                        int i = 0;
                                        for (JsonElement element : jsonRotate) {
                                            floats2[i++] = element.getAsFloat();
                                        }
                                        rotate = new javax.vecmath.Vector3f(floats2);
                                    }
                                    jsonCenter = jsonTransform.getAsJsonArray("center");
                                    center = null;
                                    if (jsonCenter != null) {
                                        float[] floats4 = new float[3];
                                        int i = 0;
                                        for (JsonElement element : jsonCenter) {
                                            floats4[i++] = element.getAsFloat();
                                        }
                                        center = new javax.vecmath.Vector3f(floats4);
                                    }
                                    JsonArray jsonScale = jsonTransform.getAsJsonArray("scale");
                                    scale = null;
                                    if (jsonScale != null) {
                                        floats = new float[3];
                                        int i = 0;
                                        for (JsonElement element : jsonScale) {
                                            floats[i++] = element.getAsFloat();
                                        }
                                        scale = new javax.vecmath.Vector3f(floats);
                                    }
                                    finalTransform.add((javax.vecmath.Vector3f)translate, (javax.vecmath.Vector3f)rotate, (javax.vecmath.Vector3f)center, (javax.vecmath.Vector3f)scale, order);
                                    continue;
                                }
                                if (valuePrimitive.isString() && valuePrimitive.getAsString().matches("default")) {
                                    JsonObject jsonTransform2 = itemProperty.getAsJsonObject("transformation");
                                    JsonArray jsonTranslate2 = jsonTransform2.getAsJsonArray("translation");
                                    javax.vecmath.Vector3f translate2 = null;
                                    if (jsonTranslate2 != null) {
                                        float[] floats5 = new float[3];
                                        int i = 0;
                                        for (JsonElement element : jsonTranslate2) {
                                            floats5[i++] = element.getAsFloat();
                                        }
                                        translate2 = new javax.vecmath.Vector3f(floats5);
                                    }
                                    JsonArray jsonRotate2 = jsonTransform2.getAsJsonArray("rotation");
                                    javax.vecmath.Vector3f rotate2 = null;
                                    if (jsonRotate2 != null) {
                                        float[] floats6 = new float[3];
                                        int i = 0;
                                        for (JsonElement element : jsonRotate2) {
                                            floats6[i++] = element.getAsFloat();
                                        }
                                        rotate2 = new javax.vecmath.Vector3f(floats6);
                                    }
                                    JsonArray jsonCenter2 = jsonTransform2.getAsJsonArray("center");
                                    javax.vecmath.Vector3f center2 = null;
                                    if (jsonCenter2 != null) {
                                        float[] floats7 = new float[3];
                                        int i = 0;
                                        for (JsonElement element : jsonCenter2) {
                                            floats7[i++] = element.getAsFloat();
                                        }
                                        center2 = new javax.vecmath.Vector3f(floats7);
                                    }
                                    JsonArray jsonScale = jsonTransform2.getAsJsonArray("scale");
                                    Iterator scale2 = null;
                                    if (jsonScale != null) {
                                        float[] floats8 = new float[3];
                                        int i = 0;
                                        for (Object element : jsonScale) {
                                            floats8[i++] = element.getAsFloat();
                                        }
                                        scale2 = new javax.vecmath.Vector3f(floats8);
                                    }
                                    defaultTransform[0] = translate2;
                                    defaultTransform[1] = rotate2;
                                    defaultTransform[2] = center2;
                                    defaultTransform[3] = scale2;
                                    continue;
                                }
                                if (valuePrimitive.isString() && valuePrimitive.getAsString().matches("variable")) {
                                    flag = true;
                                    float modifier = iitempropertygetter.func_185085_a(stack, world, entity);
                                    orderPrimitive = itemProperty.getAsJsonPrimitive("order");
                                    int order = 0;
                                    if (orderPrimitive != null) {
                                        order = orderPrimitive.getAsInt();
                                    }
                                    jsonTransform = itemProperty.getAsJsonObject("transformation");
                                    jsonTranslate = jsonTransform.getAsJsonArray("translation");
                                    translate = null;
                                    if (jsonTranslate != null) {
                                        floats3 = new float[3];
                                        int i = 0;
                                        for (JsonElement element : jsonTranslate) {
                                            floats3[i++] = element.getAsFloat() * modifier;
                                        }
                                        translate = new javax.vecmath.Vector3f(floats3);
                                    }
                                    jsonRotate = jsonTransform.getAsJsonArray("rotation");
                                    rotate = null;
                                    if (jsonRotate != null) {
                                        floats2 = new float[3];
                                        int i = 0;
                                        for (JsonElement element : jsonRotate) {
                                            floats2[i++] = element.getAsFloat() * modifier;
                                        }
                                        rotate = new javax.vecmath.Vector3f(floats2);
                                    }
                                    jsonCenter = jsonTransform.getAsJsonArray("center");
                                    center = null;
                                    if (jsonCenter != null) {
                                        Object element;
                                        float[] floats9 = new float[3];
                                        int i = 0;
                                        element = jsonCenter.iterator();
                                        while (element.hasNext()) {
                                            JsonElement element2 = (JsonElement)element.next();
                                            floats9[i++] = element2.getAsFloat();
                                        }
                                        center = new javax.vecmath.Vector3f(floats9);
                                    }
                                    JsonArray jsonScale = jsonTransform.getAsJsonArray("scale");
                                    scale = null;
                                    if (jsonScale != null) {
                                        floats = new float[3];
                                        int i = 0;
                                        for (JsonElement element : jsonScale) {
                                            floats[i++] = element.getAsFloat() * modifier;
                                        }
                                        scale = new javax.vecmath.Vector3f(floats);
                                    }
                                    finalTransform.add((javax.vecmath.Vector3f)translate, (javax.vecmath.Vector3f)rotate, (javax.vecmath.Vector3f)center, (javax.vecmath.Vector3f)scale, order);
                                    continue;
                                }
                                System.out.println("ERROR: PREDICATE VALUE TYPE IS NOT SUPPORTED");
                            }
                            if (flag && !name.equals("none")) continue;
                            finalTransform.add(defaultTransform[0], defaultTransform[1], defaultTransform[2], defaultTransform[3], 0);
                            continue;
                        }
                        System.out.println("ERROR: " + name + " IS NOT A JSONARRAY");
                    }
                } else {
                    System.out.println("ERROR: JSON MISSING PREDICATES");
                }
                transformations.add(finalTransform.build());
            }
        } else {
            System.out.println("ERROR: JSON MISSING SUBMODELS");
        }
        return transformations;
    }

    public static List<String> getPredicates(JsonObject json) {
        ArrayList<String> names = new ArrayList<String>();
        JsonArray submodels = json.getAsJsonArray("submodels");
        for (Object submodelObject : submodels) {
            JsonObject submodel = (JsonObject)submodelObject;
            JsonObject predicates = submodel.getAsJsonObject("predicates");
            for (Map.Entry entry : predicates.entrySet()) {
                String name = (String)entry.getKey();
                names.add(name);
            }
        }
        return names;
    }

    private static final class BakedModelGun
    implements IBakedModel {
        private final IModelGun parent;
        private final List<IBakedModel> models;
        private List<BakedQuad> quads = new ArrayList<BakedQuad>();
        private Map<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
        private List<TRSRTransformation> subTransforms = new ArrayList<TRSRTransformation>();
        private final TextureAtlasSprite particle;
        private final VertexFormat format;
        private final ItemOverrideList overrides;
        private final Map<String, IBakedModel> cache;
        private final List<IBakedModel> accessoryModels = new ArrayList<IBakedModel>();

        public BakedModelGun(IModelGun parent, List<IBakedModel> models, Map<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, TextureAtlasSprite particle, VertexFormat format, ItemOverrideList overrides, Map<String, IBakedModel> cache) {
            this.parent = parent;
            this.models = models;
            this.transforms = transforms;
            this.particle = particle;
            this.format = format;
            this.overrides = overrides;
            this.cache = cache;
        }

        public void setSubTransforms(List<TRSRTransformation> subTransformations) {
            this.subTransforms = new ArrayList<TRSRTransformation>();
            this.subTransforms.add(TRSRTransformation.identity());
            this.subTransforms.addAll(subTransformations);
        }

        public void addAccessories(List<ItemStack> list) {
            for (ItemStack stack : list) {
                IBakedModel model;
                int[] ints = stack.func_77978_p().func_74759_k("transform");
                float[] floats = new float[16];
                for (int i = 0; i < 16; ++i) {
                    floats[i] = Float.intBitsToFloat(ints[i]);
                }
                TRSRTransformation subtransform = new TRSRTransformation(new Matrix4f(floats));
                if (this.cache.containsKey(stack.toString())) {
                    model = this.cache.get(stack.toString());
                } else {
                    model = Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, null, null);
                    this.cache.put(stack.toString(), model);
                }
                this.subTransforms.add(subtransform);
                for (Map.Entry<ItemCameraTransforms.TransformType, TRSRTransformation> entry : this.transforms.entrySet()) {
                    NBTTagCompound datatag;
                    NBTTagCompound itemtag;
                    if (entry.getKey() != ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND && entry.getKey() != ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND || !(itemtag = (datatag = ((IItemData)Minecraft.func_71410_x().field_71441_e.getCapability(ItemDataProvider.ITEMDATA_CAP, null)).getItemData()).func_74775_l(stack.func_77978_p().func_74779_i("UUID"))).func_74767_n("ADS")) continue;
                    entry.setValue(TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation((Matrix4f)model.handlePerspective(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND).getRight())).compose(subtransform.inverse()));
                }
                if (this.models.contains(model)) continue;
                this.models.add(model);
            }
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            Long start = System.nanoTime();
            this.quads.clear();
            if (this.subTransforms == null) {
                return this.quads;
            }
            if (this.subTransforms.size() <= this.models.size()) {
                for (int i = 0; i < this.subTransforms.size(); ++i) {
                    for (BakedQuad quad : this.models.get(i).func_188616_a(state, side, rand)) {
                        int[] data = (int[])quad.func_178209_a().clone();
                        Matrix4f points = new Matrix4f();
                        Matrix4f transformation = this.subTransforms.get(i).getMatrix();
                        if (transformation == TRSRTransformation.identity().getMatrix()) {
                            this.quads.add(quad);
                            continue;
                        }
                        points.m00 = Float.intBitsToFloat(data[0]);
                        points.m10 = Float.intBitsToFloat(data[1]);
                        points.m20 = Float.intBitsToFloat(data[2]);
                        points.m30 = 1.0f;
                        points.m01 = Float.intBitsToFloat(data[7]);
                        points.m11 = Float.intBitsToFloat(data[8]);
                        points.m21 = Float.intBitsToFloat(data[9]);
                        points.m31 = 1.0f;
                        points.m02 = Float.intBitsToFloat(data[14]);
                        points.m12 = Float.intBitsToFloat(data[15]);
                        points.m22 = Float.intBitsToFloat(data[16]);
                        points.m32 = 1.0f;
                        points.m03 = Float.intBitsToFloat(data[21]);
                        points.m13 = Float.intBitsToFloat(data[22]);
                        points.m23 = Float.intBitsToFloat(data[23]);
                        points.m33 = 1.0f;
                        points.mul(transformation, points);
                        int norm = this.calculateNormal(points);
                        data[0] = Float.floatToRawIntBits(points.m00);
                        data[1] = Float.floatToRawIntBits(points.m10);
                        data[2] = Float.floatToRawIntBits(points.m20);
                        data[6] = norm;
                        data[7] = Float.floatToRawIntBits(points.m01);
                        data[8] = Float.floatToRawIntBits(points.m11);
                        data[9] = Float.floatToRawIntBits(points.m21);
                        data[13] = norm;
                        data[14] = Float.floatToRawIntBits(points.m02);
                        data[15] = Float.floatToRawIntBits(points.m12);
                        data[16] = Float.floatToRawIntBits(points.m22);
                        data[20] = norm;
                        data[21] = Float.floatToRawIntBits(points.m03);
                        data[22] = Float.floatToRawIntBits(points.m13);
                        data[23] = Float.floatToRawIntBits(points.m23);
                        data[27] = norm;
                        BakedQuad newQuad = new BakedQuad(data, quad.func_178211_c(), quad.func_178210_d(), quad.func_187508_a(), quad.shouldApplyDiffuseLighting(), quad.getFormat());
                        this.quads.add(newQuad);
                    }
                }
            }
            if (this.quads.size() > 0) {
                // empty if block
            }
            return this.quads;
        }

        private int calculateNormal(Matrix4f points) {
            float xp = points.m03 - points.m01;
            float yp = points.m13 - points.m11;
            float zp = points.m23 - points.m21;
            float xq = points.m02 - points.m00;
            float yq = points.m12 - points.m10;
            float zq = points.m22 - points.m20;
            float xn = yq * zp - zq * yp;
            float yn = zq * xp - xq * zp;
            float zn = xq * yp - yq * xp;
            float norm = (float)Math.sqrt(xn * xn + yn * yn + zn * zn);
            float SMALL_LENGTH = 1.0E-4f;
            if (norm < 1.0E-4f) {
                norm = 1.0f;
            }
            norm = 1.0f / norm;
            int x = (byte)((xn *= norm) * 127.0f) & 0xFF;
            int y = (byte)((yn *= norm) * 127.0f) & 0xFF;
            int z = (byte)((zn *= norm) * 127.0f) & 0xFF;
            return x | y << 8 | z << 16;
        }

        public boolean func_177555_b() {
            return false;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.particle;
        }

        public ItemOverrideList func_188617_f() {
            return this.overrides;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type2) {
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, (ImmutableMap)ImmutableMap.copyOf(this.transforms), (ItemCameraTransforms.TransformType)type2);
        }

        public void setCameraTransforms(ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms) {
            this.transforms = Maps.newHashMap(transforms);
        }
    }

    public static class PerspectiveMapWrapperGun
    extends PerspectiveMapWrapper {
        private ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;

        public PerspectiveMapWrapperGun(IBakedModel parent, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms) {
            super(parent, transforms);
            this.transforms = transforms;
        }

        public PerspectiveMapWrapperGun(IBakedModel parent, IModelState state) {
            this(parent, PerspectiveMapWrapperGun.getTransforms(state));
        }

        public static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> getTransforms(IModelState state) {
            EnumMap map = new EnumMap(ItemCameraTransforms.TransformType.class);
            for (ItemCameraTransforms.TransformType type2 : ItemCameraTransforms.TransformType.values()) {
                Optional tr = state.apply(Optional.of(type2));
                if (!tr.isPresent()) continue;
                map.put(type2, tr.get());
            }
            return ImmutableMap.copyOf(map);
        }
    }

    private static class GunOverrideHandler
    extends ItemOverrideList {
        public static final GunOverrideHandler INSTANCE = new GunOverrideHandler();

        public GunOverrideHandler() {
            super((List)ImmutableList.of());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            List<ItemStack> accessories;
            BakedModelGun model = (BakedModelGun)originalModel;
            BufferedReader reader = IModelGun.getModelReader(model.parent.baseLocation);
            Gson gson = new Gson();
            JsonElement je = null;
            try {
                je = (JsonElement)gson.fromJson((Reader)reader, JsonElement.class);
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                // empty catch block
            }
            try {
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (je == null) {
                System.out.println("ERROR: JSON IS NULL");
                return originalModel;
            }
            JsonObject json = je.getAsJsonObject();
            model.setSubTransforms(IModelGun.getSubTransformations(json, stack, world, entity));
            ImmutableMap baseTransforms = IModelGun.getBaseTransforms(json, stack, world, entity, model);
            if (baseTransforms != null) {
                model.setCameraTransforms((ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)baseTransforms);
            }
            if ((accessories = ((ItemGun)stack.func_77973_b()).getAccesories(stack)) != null) {
                model.addAccessories(accessories);
            }
            return model;
        }
    }

    public static enum GunModelLoader implements ICustomModelLoader
    {
        INSTANCE;


        public void func_110549_a(IResourceManager resourceManager) {
        }

        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation instanceof ModelResourceLocation && modelLocation.func_110624_b().equals("rm") && modelLocation.func_110623_a().startsWith("_gun_");
        }

        public IModel loadModel(ResourceLocation modelLocation) throws Exception {
            Main.LOGGER.info("Loading Model: " + modelLocation);
            return new IModelGun(modelLocation);
        }
    }
}

