/*
 * Decompiled with CFR 0.152.
 */
package com.PiMan.RecieverMod.util;

import com.PiMan.RecieverMod.Main;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraftforge.common.model.TRSRTransformation;

public class TransformationBuilder {
    Map<Integer, Vector3f> scales = new TreeMap<Integer, Vector3f>();
    Map<Integer, Vector3f> rotations = new TreeMap<Integer, Vector3f>();
    Map<Integer, Vector3f> centers = new TreeMap<Integer, Vector3f>();
    Map<Integer, Vector3f> translations = new TreeMap<Integer, Vector3f>();

    public void add(Vector3f translation, Vector3f rotation, Vector3f center, Vector3f scale, int order) {
        if (scale == null) {
            scale = new Vector3f(1.0f, 1.0f, 1.0f);
        }
        if (rotation == null) {
            rotation = new Vector3f();
        }
        if (center == null) {
            center = new Vector3f();
        }
        if (translation == null) {
            translation = new Vector3f();
        }
        Vector3f replaced = this.scales.put(order, scale);
        this.rotations.put(order, rotation);
        this.centers.put(order, center);
        this.translations.put(order, translation);
        if (replaced != null) {
            Main.LOGGER.warn("Transorm was replaced");
        }
    }

    public TRSRTransformation build() {
        ArrayList<Matrix4f> matrixList = new ArrayList<Matrix4f>();
        for (int i : this.scales.keySet()) {
            Vector3f scale = this.scales.get(i);
            Vector3f rotation = this.rotations.get(i);
            Vector3f center = this.centers.get(i);
            Vector3f translation = this.translations.get(i);
            Matrix4f ST = this.matrixFromScaleAndTranslation(scale, translation);
            Matrix4f C1 = this.matrixFromScaleAndTranslation(new Vector3f(1.0f, 1.0f, 1.0f), center);
            center.scale(-1.0f);
            Matrix4f C2 = this.matrixFromScaleAndTranslation(new Vector3f(1.0f, 1.0f, 1.0f), center);
            Matrix4f R = this.matrixFromRotationDegrees(rotation);
            Matrix4f Final = new Matrix4f();
            Final.setIdentity();
            Final.mul(ST, Final);
            Final.mul(C2, Final);
            Final.mul(R, Final);
            Final.mul(C1, Final);
            matrixList.add(Final);
        }
        Matrix4f matrix = new Matrix4f();
        matrix.setIdentity();
        for (Matrix4f t : matrixList) {
            matrix.mul(t, matrix);
        }
        return TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(matrix));
    }

    private Matrix4f matrixFromScaleAndTranslation(Vector3f scale, Vector3f translation) {
        Matrix4f t = new Matrix4f();
        t.m00 = scale.x;
        t.m10 = 0.0f;
        t.m20 = 0.0f;
        t.m30 = 0.0f;
        t.m01 = 0.0f;
        t.m11 = scale.y;
        t.m21 = 0.0f;
        t.m31 = 0.0f;
        t.m02 = 0.0f;
        t.m12 = 0.0f;
        t.m22 = scale.z;
        t.m32 = 0.0f;
        t.m03 = translation.x;
        t.m13 = translation.y;
        t.m23 = translation.z;
        t.m33 = 1.0f;
        return t;
    }

    private Matrix4f matrixFromRotationDegrees(Vector3f rotation) {
        rotation.scale((float)Math.PI / 180);
        Matrix4f tx = new Matrix4f();
        Matrix4f ty = new Matrix4f();
        Matrix4f tz = new Matrix4f();
        tx.setIdentity();
        ty.setIdentity();
        tz.setIdentity();
        tx.m11 = (float)Math.cos(rotation.x);
        tx.m21 = (float)Math.sin(rotation.x);
        tx.m12 = (float)(-Math.sin(rotation.x));
        tx.m22 = (float)Math.cos(rotation.x);
        ty.m00 = (float)Math.cos(rotation.y);
        ty.m20 = (float)Math.sin(rotation.y);
        ty.m02 = (float)(-Math.sin(rotation.y));
        ty.m22 = (float)Math.cos(rotation.y);
        tz.m00 = (float)Math.cos(rotation.z);
        tz.m10 = (float)(-Math.sin(rotation.z));
        tz.m01 = (float)Math.sin(rotation.z);
        tz.m11 = (float)Math.cos(rotation.z);
        Matrix4f M = new Matrix4f();
        M.setIdentity();
        M.mul(ty, M);
        M.mul(tx, M);
        M.mul(tz, M);
        return M;
    }
}

