/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import me.swirtzly.regeneration.common.advancements.BaseTrigger;
import me.swirtzly.regeneration.common.advancements.TriggerManager;
import me.swirtzly.regeneration.handlers.RegenObjects;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.LocationPredicate;
import net.minecraft.advancements.criterion.PositionTrigger;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.biome.Biome;

public class AdvancementCreation
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final List<Advancement> advancements = new ArrayList<Advancement>();
    private final DataGenerator generator;
    private Advancement lastAdvancement;

    public AdvancementCreation(DataGenerator generatorIn) {
        this.generator = generatorIn;
    }

    private static Path getPath(Path pathIn, Advancement advancementIn) {
        return pathIn.resolve("data/" + advancementIn.func_192067_g().func_110624_b() + "/advancements/" + advancementIn.func_192067_g().func_110623_a() + ".json");
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        Path path = this.generator.func_200391_b();
        this.createAdvancement("first_regen", new ItemStack((IItemProvider)RegenObjects.Items.FOB_WATCH.get()), new BaseTrigger.Instance(TriggerManager.FIRST_REGENERATION.func_192163_a()));
        this.createAdvancement("change_refusal", new ItemStack((IItemProvider)RegenObjects.Blocks.HAND_JAR.get()), new BaseTrigger.Instance(TriggerManager.CHANGE_REFUSAL.func_192163_a()));
        this.createAdvancement("critical_period", new ItemStack((IItemProvider)RegenObjects.Items.FOB_WATCH.get()), new BaseTrigger.Instance(TriggerManager.CRITICAL.func_192163_a()));
        this.createAdvancement("timelord_trade", new ItemStack((IItemProvider)RegenObjects.Items.ROBES_CHEST.get()), new BaseTrigger.Instance(TriggerManager.TIMELORD_TRADE.func_192163_a()));
        this.createAdvancement("gallifrey", new ItemStack((IItemProvider)RegenObjects.Items.SEAL.get()), (ICriterionInstance)PositionTrigger.Instance.func_203932_a((LocationPredicate)LocationPredicate.func_204010_a((Biome)((Biome)RegenObjects.GallifreyBiomes.REDLANDS.get()))));
        this.createAdvancement("robes", new ItemStack((IItemProvider)RegenObjects.Items.ROBES_CHEST.get()), (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{() -> (Item)RegenObjects.Items.ROBES_HEAD.get(), () -> (Item)RegenObjects.Items.ROBES_CHEST.get()}));
        this.createAdvancement("gallifreyan_weapon", new ItemStack((IItemProvider)RegenObjects.Items.PISTOL.get()), (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{() -> (Item)RegenObjects.Items.PISTOL.get(), () -> (Item)RegenObjects.Items.RIFLE.get()}));
        for (Advancement adv : advancements) {
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)adv.func_192075_a().func_200273_b(), (Path)AdvancementCreation.getPath(path, adv));
        }
    }

    public String func_200397_b() {
        return "Advancements";
    }

    public Advancement create(String name, String title, ItemStack display, ICriterionInstance ... inst) {
        Advancement.Builder adv = Advancement.Builder.func_200278_a().func_203902_a((IItemProvider)display.func_77973_b(), (ITextComponent)new TranslationTextComponent("advancements.regeneration.title." + title, new Object[0]), (ITextComponent)new TranslationTextComponent("advancements.regeneration.desc." + title, new Object[0]), new ResourceLocation("regeneration:textures/gui/roundel.png"), FrameType.TASK, true, true, false);
        int i = 0;
        for (ICriterionInstance in : inst) {
            adv = adv.func_200275_a(i + "", in);
            ++i;
        }
        if (this.lastAdvancement != null) {
            adv.func_203905_a(this.lastAdvancement);
        }
        return adv.func_192056_a(new ResourceLocation("regeneration", name));
    }

    public Advancement createAdvancement(String name, ItemStack display, ICriterionInstance inst) {
        Advancement advance = this.create(name, name, display, inst);
        advancements.add(advance);
        this.lastAdvancement = advance;
        return advance;
    }
}

