/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class LootTableCreation
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;

    public LootTableCreation(DataGenerator gen) {
        this.generator = gen;
    }

    public static Path getPath(Path path, ResourceLocation rl) {
        return path.resolve("data/" + rl.func_110624_b() + "/loot_tables/blocks/" + rl.func_110623_a() + ".json");
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        Path path = this.generator.func_200391_b();
        for (Block block : ForgeRegistries.BLOCKS.getValues()) {
            if (!block.getRegistryName().func_110624_b().equalsIgnoreCase("regeneration")) continue;
            this.generateSelfTable(block, cache, path);
        }
    }

    public String func_200397_b() {
        return "Loot Tables";
    }

    public void generateSelfTable(Block block, DirectoryCache cache, Path base) throws IOException {
        this.generateTable(cache, LootTableCreation.getPath(base, block.getRegistryName()), () -> this.createBlockDropSelf(block));
    }

    public void generateTable(DirectoryCache cache, Path path, Supplier<JsonElement> element) throws IOException {
        IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)element.get(), (Path)path);
    }

    public JsonElement createBlockDropGuarenteed(Block block, ResourceLocation drop) {
        JsonObject root = new JsonObject();
        root.add("type", (JsonElement)new JsonPrimitive("minecraft:block"));
        JsonArray pool = new JsonArray();
        JsonObject first = new JsonObject();
        first.add("name", (JsonElement)new JsonPrimitive(block.getRegistryName().toString()));
        first.add("rolls", (JsonElement)new JsonPrimitive((Number)1));
        JsonArray entries = new JsonArray();
        JsonObject entry = new JsonObject();
        entry.add("type", (JsonElement)new JsonPrimitive("minecraft:item"));
        entry.add("name", (JsonElement)new JsonPrimitive(drop.toString()));
        entries.add((JsonElement)entry);
        first.add("entries", (JsonElement)entries);
        pool.add((JsonElement)first);
        root.add("pools", (JsonElement)pool);
        return root;
    }

    public JsonElement createBlockDropSelf(Block block) {
        return this.createBlockDropGuarenteed(block, block.getRegistryName());
    }
}

