/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.CommandDispatcher;
import java.io.IOException;
import me.swirtzly.data.AdvancementCreation;
import me.swirtzly.data.BlockTagCreation;
import me.swirtzly.data.ItemsTagCreation;
import me.swirtzly.data.LangCreation;
import me.swirtzly.data.LootTableCreation;
import me.swirtzly.data.RecipeCreation;
import me.swirtzly.regeneration.RegenConfig;
import me.swirtzly.regeneration.client.rendering.entity.ItemOverrideRenderer;
import me.swirtzly.regeneration.client.rendering.entity.LaserRenderer;
import me.swirtzly.regeneration.client.rendering.entity.TimelordRenderer;
import me.swirtzly.regeneration.common.advancements.TriggerManager;
import me.swirtzly.regeneration.common.capability.IRegen;
import me.swirtzly.regeneration.common.capability.RegenCap;
import me.swirtzly.regeneration.common.capability.RegenStorage;
import me.swirtzly.regeneration.common.commands.RegenCommand;
import me.swirtzly.regeneration.common.entity.LaserEntity;
import me.swirtzly.regeneration.common.entity.OverrideEntity;
import me.swirtzly.regeneration.common.entity.TimelordEntity;
import me.swirtzly.regeneration.common.skin.HandleSkins;
import me.swirtzly.regeneration.common.traits.TraitManager;
import me.swirtzly.regeneration.compat.TardisCompat;
import me.swirtzly.regeneration.handlers.CommonHandler;
import me.swirtzly.regeneration.handlers.RegenObjects;
import me.swirtzly.regeneration.handlers.acting.ActingForwarder;
import me.swirtzly.regeneration.network.NetworkDispatcher;
import me.swirtzly.regeneration.proxy.ClientProxy;
import me.swirtzly.regeneration.proxy.CommonProxy;
import me.swirtzly.regeneration.proxy.Proxy;
import me.swirtzly.regeneration.util.common.PlayerUtil;
import me.swirtzly.regeneration.util.common.RegenUtil;
import net.minecraft.command.CommandSource;
import net.minecraft.data.IDataProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="regeneration")
public class Regeneration {
    public static final String MODID = "regeneration";
    public static final String NAME = "Regeneration";
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static Regeneration INSTANCE;
    public static Logger LOG;
    public static Proxy proxy;

    public Regeneration() {
        INSTANCE = this;
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new CommonHandler());
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, RegenConfig.COMMON_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, RegenConfig.CLIENT_SPEC);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(OverrideEntity.class, ItemOverrideRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(TimelordEntity.class, TimelordRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(LaserEntity.class, LaserRenderer::new);
    }

    private void setup(FMLCommonSetupEvent event) {
        proxy.preInit();
        CapabilityManager.INSTANCE.register(IRegen.class, (Capability.IStorage)new RegenStorage(), RegenCap::new);
        ActingForwarder.init();
        TriggerManager.init();
        RegenObjects.GallifreyBiomes.registerBiomeTypes();
        if (ModList.get().isLoaded("tardis")) {
            TardisCompat.addTardisCompat();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onNewRegistries(RegistryEvent.NewRegistry e) {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        RegenObjects.Blocks.BLOCKS.register(eventBus);
        RegenObjects.Blocks.BLOCK_ITEMS.register(eventBus);
        RegenObjects.Items.ITEMS.register(eventBus);
        RegenObjects.Sounds.SOUNDS.register(eventBus);
        RegenObjects.EntityEntries.ENTITIES.register(eventBus);
        RegenObjects.Tiles.TILES.register(eventBus);
        RegenObjects.Containers.CONTAINERS.register(eventBus);
        RegenObjects.ChunkGeneratorTypes.CHUNK_GENERATOR_TYPES.register(eventBus);
        RegenObjects.GallifreyBiomes.BIOMES.register(eventBus);
        RegenObjects.Dimensions.DIMENSIONS.register(eventBus);
    }

    @SubscribeEvent
    public void gatherData(GatherDataEvent e) {
        e.getGenerator().func_200390_a((IDataProvider)new LangCreation(e.getGenerator()));
        e.getGenerator().func_200390_a((IDataProvider)new RecipeCreation(e.getGenerator()));
        e.getGenerator().func_200390_a((IDataProvider)new ItemsTagCreation(e.getGenerator()));
        e.getGenerator().func_200390_a((IDataProvider)new BlockTagCreation(e.getGenerator()));
        e.getGenerator().func_200390_a((IDataProvider)new LootTableCreation(e.getGenerator()));
        e.getGenerator().func_200390_a((IDataProvider)new AdvancementCreation(e.getGenerator()));
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        proxy.init();
        NetworkDispatcher.init();
        TraitManager.init();
    }

    private void processIMC(InterModProcessEvent event) {
        proxy.postInit();
        PlayerUtil.createPostList();
        RegenUtil.TIMELORD_NAMES = RegenUtil.downloadNames();
        new Thread(() -> {
            try {
                HandleSkins.downloadTimelordSkins();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }, "Regeneration Timelord Download Daemon").start();
    }

    @SubscribeEvent
    public void onServerStart(FMLServerStartingEvent event) {
        RegenCommand.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
    }

    static {
        LOG = LogManager.getLogger((String)NAME);
        proxy = (Proxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    }
}

