/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.client.animation;

import com.mojang.blaze3d.platform.GlStateManager;
import me.swirtzly.animateme.AnimationManager;
import me.swirtzly.regeneration.common.capability.RegenCap;
import me.swirtzly.regeneration.common.item.FobWatchItem;
import me.swirtzly.regeneration.handlers.RegenObjects;
import me.swirtzly.regeneration.util.common.PlayerUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.HandSide;

public class GeneralAnimations
implements AnimationManager.IAnimate {
    public static void copyAnglesToWear(BipedModel modelBiped) {
    }

    public static void makeZombieArms(BipedModel modelBiped) {
        modelBiped.field_178723_h.field_78796_g = -0.1f + modelBiped.field_78116_c.field_78796_g - 0.4f;
        modelBiped.field_178724_i.field_78796_g = 0.1f + modelBiped.field_78116_c.field_78796_g;
        modelBiped.field_178723_h.field_78795_f = -1.5707964f + modelBiped.field_78116_c.field_78795_f;
        modelBiped.field_178724_i.field_78795_f = -1.5707964f + modelBiped.field_78116_c.field_78795_f;
    }

    @Override
    public void preRenderCallback(LivingRenderer renderer, LivingEntity entity) {
        RegenCap.get((Entity)entity).ifPresent(data -> {
            boolean isWearingChest;
            if (!(renderer.func_217764_d() instanceof BipedModel)) {
                return;
            }
            BipedModel modelPlayer = (BipedModel)renderer.func_217764_d();
            boolean bl = isWearingChest = entity.func_184582_a(EquipmentSlotType.CHEST).func_77973_b() == RegenObjects.Items.GUARD_CHEST.get();
            if (data.hasDroppedHand() && data.getState() == PlayerUtil.RegenState.POST) {
                modelPlayer.field_178723_h.field_78807_k = data.getCutoffHand() == HandSide.RIGHT;
                modelPlayer.field_178724_i.field_78807_k = data.getCutoffHand() == HandSide.LEFT;
            } else if (entity.func_110124_au() == Minecraft.func_71410_x().field_71439_g.func_110124_au()) {
                boolean isFirstPerson = Minecraft.func_71410_x().field_71474_y.field_74320_O == 0;
                modelPlayer.field_178724_i.field_78807_k = !isFirstPerson && isWearingChest;
                boolean bl2 = modelPlayer.field_178723_h.field_78807_k = !isFirstPerson && isWearingChest;
            }
            if (data.getState() == PlayerUtil.RegenState.POST && PlayerUtil.isAboveZeroGrid(entity)) {
                GlStateManager.rotatef((float)15.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
        });
    }

    @Override
    public void animateEntity(BipedModel modelBiped, LivingEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean isOpen;
        ItemStack stack = entity.func_184614_ca();
        ItemStack offStack = entity.func_184592_cb();
        if (stack.func_77973_b() instanceof FobWatchItem) {
            boolean bl = isOpen = FobWatchItem.getOpen(stack) == 1;
            if (isOpen) {
                GeneralAnimations.makeZombieArms(modelBiped);
                GeneralAnimations.copyAnglesToWear(modelBiped);
            }
        }
        if (offStack.func_77973_b() instanceof FobWatchItem) {
            boolean bl = isOpen = FobWatchItem.getOpen(stack) == 1;
            if (isOpen) {
                GeneralAnimations.makeZombieArms(modelBiped);
                GeneralAnimations.copyAnglesToWear(modelBiped);
            }
        }
        RegenCap.get((Entity)entity).ifPresent(data -> {
            if (data.isSyncingToJar()) {
                GeneralAnimations.makeZombieArms(modelBiped);
                modelBiped.field_78116_c.field_78795_f = (float)Math.toRadians(45.0);
                GeneralAnimations.copyAnglesToWear(modelBiped);
            }
            if (data.getState() == PlayerUtil.RegenState.POST && PlayerUtil.isAboveZeroGrid(entity)) {
                modelBiped.field_78116_c.field_78795_f = (float)Math.toRadians(0.0);
                modelBiped.field_78116_c.field_78796_g = (float)Math.toRadians(0.0);
                modelBiped.field_78116_c.field_78808_h = (float)Math.toRadians(0.0);
            }
        });
    }
}

