/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.client.gui;

import java.awt.Color;
import me.swirtzly.regeneration.Regeneration;
import me.swirtzly.regeneration.client.gui.parts.ColorSliderWidget;
import me.swirtzly.regeneration.client.gui.parts.ContainerBlank;
import me.swirtzly.regeneration.common.capability.RegenCap;
import me.swirtzly.regeneration.common.types.RegenType;
import me.swirtzly.regeneration.network.NetworkDispatcher;
import me.swirtzly.regeneration.network.messages.UpdateColorMessage;
import me.swirtzly.regeneration.util.client.ClientUtil;
import me.swirtzly.regeneration.util.client.RenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiSlider;

public class ColorScreen
extends ContainerScreen
implements GuiSlider.ISlider {
    private static final ResourceLocation background = new ResourceLocation("regeneration", "textures/gui/customizer_background.png");
    private static ColorSliderWidget slidePrimaryRed;
    private static ColorSliderWidget slidePrimaryGreen;
    private static ColorSliderWidget slidePrimaryBlue;
    private static ColorSliderWidget slideSecondaryRed;
    private static ColorSliderWidget slideSecondaryGreen;
    private static ColorSliderWidget slideSecondaryBlue;
    private TextFieldWidget inputPrimaryColor;
    private TextFieldWidget inputSecondColor;
    private Vec3d initialPrimary;
    private Vec3d initialSecondary;

    public ColorScreen() {
        super((Container)new ContainerBlank(), null, (ITextComponent)new TranslationTextComponent("Regeneration", new Object[0]));
        this.field_146999_f = 176;
        this.field_147000_g = 186;
    }

    public void init() {
        super.init();
        int cx = (this.width - this.field_146999_f) / 2;
        int cy = (this.height - this.field_147000_g) / 2;
        RegenCap.get((Entity)this.minecraft.field_71439_g).ifPresent(data -> {
            this.initialPrimary = data.getPrimaryColor();
            this.initialSecondary = data.getSecondaryColor();
        });
        float primaryRed = (float)this.initialPrimary.field_72450_a;
        float primaryGreen = (float)this.initialPrimary.field_72448_b;
        float primaryBlue = (float)this.initialPrimary.field_72449_c;
        float secondaryRed = (float)this.initialSecondary.field_72450_a;
        float secondaryGreen = (float)this.initialSecondary.field_72448_b;
        float secondaryBlue = (float)this.initialSecondary.field_72449_c;
        int btnW = 60;
        int btnH = 18;
        int sliderW = 70;
        int sliderH = 20;
        this.addButton((Widget)new GuiButtonExt(cx + 25, cy + 125, 60, 18, new TranslationTextComponent("regeneration.gui.undo", new Object[0]).func_150254_d(), button -> {
            slidePrimaryRed.setValue(this.initialPrimary.field_72450_a);
            slidePrimaryGreen.setValue(this.initialPrimary.field_72448_b);
            slidePrimaryBlue.setValue(this.initialPrimary.field_72449_c);
            slideSecondaryRed.setValue(this.initialSecondary.field_72450_a);
            slideSecondaryGreen.setValue(this.initialSecondary.field_72448_b);
            slideSecondaryBlue.setValue(this.initialSecondary.field_72449_c);
        }));
        this.minecraft.field_195559_v.func_197967_a(true);
        this.inputPrimaryColor = new TextFieldWidget(this.font, cx + 25, cy + 21, 60, 18, this.inputPrimaryColor, I18n.func_135052_a((String)"Input", (Object[])new Object[0]));
        this.inputSecondColor = new TextFieldWidget(this.font, cx + 90, cy + 21, 60, 18, this.inputPrimaryColor, I18n.func_135052_a((String)"Input", (Object[])new Object[0]));
        this.children.add(this.inputPrimaryColor);
        this.children.add(this.inputSecondColor);
        this.addButton((Widget)new GuiButtonExt(cx + 25, cy + 145, 60, 18, new TranslationTextComponent("regeneration.gui.input_color", new Object[0]).func_150254_d(), button -> {
            float blue;
            float green;
            float red;
            Color color;
            String primaryColorText = this.inputPrimaryColor.func_146179_b();
            String secondColourText = this.inputSecondColor.func_146179_b();
            if (!primaryColorText.startsWith("#") && !primaryColorText.isEmpty()) {
                primaryColorText = "#" + primaryColorText;
                this.inputPrimaryColor.func_146180_a(primaryColorText);
            }
            if (!secondColourText.startsWith("#") && !secondColourText.isEmpty()) {
                secondColourText = "#" + secondColourText;
                this.inputSecondColor.func_146180_a(secondColourText);
            }
            try {
                color = Color.decode(primaryColorText);
                red = (float)color.getRed() / 255.0f;
                green = (float)color.getGreen() / 255.0f;
                blue = (float)color.getBlue() / 255.0f;
                slidePrimaryRed.setValue(red);
                slidePrimaryGreen.setValue(green);
                slidePrimaryBlue.setValue(blue);
                this.onChangeSliderValue(null);
            }
            catch (Exception e) {
                Regeneration.LOG.error(primaryColorText + ", is not a valid Color! [Primary Colour]");
            }
            try {
                color = Color.decode(secondColourText);
                red = (float)color.getRed() / 255.0f;
                green = (float)color.getGreen() / 255.0f;
                blue = (float)color.getBlue() / 255.0f;
                slideSecondaryRed.setValue(red);
                slideSecondaryGreen.setValue(green);
                slideSecondaryBlue.setValue(blue);
                this.onChangeSliderValue(null);
            }
            catch (Exception e) {
                Regeneration.LOG.error(secondColourText + ", is not a valid Color! [Secondary Colour]");
            }
        }));
        this.addButton((Widget)new GuiButtonExt(cx + 90, cy + 145, 60, 18, new TranslationTextComponent("regeneration.gui.close", new Object[0]).func_150254_d(), button -> Minecraft.func_71410_x().func_147108_a(null)));
        this.addButton((Widget)new GuiButtonExt(cx + 90, cy + 125, 60, 18, new TranslationTextComponent("regeneration.gui.default", new Object[0]).func_150254_d(), button -> {
            RegenCap.get((Entity)Minecraft.func_71410_x().field_71439_g).ifPresent(data -> {
                RegenType regenType = data.getRegenType().create();
                slidePrimaryRed.setValue(regenType.getDefaultPrimaryColor().field_72450_a);
                slidePrimaryGreen.setValue(regenType.getDefaultPrimaryColor().field_72448_b);
                slidePrimaryBlue.setValue(regenType.getDefaultPrimaryColor().field_72449_c);
                slideSecondaryRed.setValue(regenType.getDefaultSecondaryColor().field_72450_a);
                slideSecondaryGreen.setValue(regenType.getDefaultSecondaryColor().field_72448_b);
                slideSecondaryBlue.setValue(regenType.getDefaultSecondaryColor().field_72449_c);
            });
            this.onChangeSliderValue(null);
        }));
        slidePrimaryRed = new ColorSliderWidget(cx + 10, cy + 65, 70, 20, new TranslationTextComponent("regeneration.gui.red", new Object[0]).func_150254_d(), "", 0.0, 1.0, primaryRed, true, true, button -> {}, this);
        slidePrimaryGreen = new ColorSliderWidget(cx + 10, cy + 84, 70, 20, new TranslationTextComponent("regeneration.gui.green", new Object[0]).func_150254_d(), "", 0.0, 1.0, primaryGreen, true, true, p_onPress_1_ -> {}, this);
        slidePrimaryBlue = new ColorSliderWidget(cx + 10, cy + 103, 70, 20, new TranslationTextComponent("regeneration.gui.blue", new Object[0]).func_150254_d(), "", 0.0, 1.0, primaryBlue, true, true, p_onPress_1_ -> {}, this);
        slideSecondaryRed = new ColorSliderWidget(cx + 96, cy + 65, 70, 20, new TranslationTextComponent("regeneration.gui.red", new Object[0]).func_150254_d(), "", 0.0, 1.0, secondaryRed, true, true, p_onPress_1_ -> {}, this);
        slideSecondaryGreen = new ColorSliderWidget(cx + 96, cy + 84, 70, 20, new TranslationTextComponent("regeneration.gui.green", new Object[0]).func_150254_d(), "", 0.0, 1.0, secondaryGreen, true, true, p_onPress_1_ -> {}, this);
        slideSecondaryBlue = new ColorSliderWidget(cx + 96, cy + 103, 70, 20, new TranslationTextComponent("regeneration.gui.blue", new Object[0]).func_150254_d(), "", 0.0, 1.0, secondaryBlue, true, true, p_onPress_1_ -> {}, this);
        this.addButton((Widget)slidePrimaryRed);
        this.addButton((Widget)slidePrimaryGreen);
        this.addButton((Widget)slidePrimaryBlue);
        this.addButton((Widget)slideSecondaryRed);
        this.addButton((Widget)slideSecondaryGreen);
        this.addButton((Widget)slideSecondaryBlue);
        this.func_212928_a((IGuiEventListener)this.inputPrimaryColor);
        this.func_212928_a((IGuiEventListener)this.inputSecondColor);
        this.inputPrimaryColor.func_146180_a(ClientUtil.colorToHex(new Color((float)slidePrimaryRed.getValue(), (float)slidePrimaryGreen.getValue(), (float)slidePrimaryBlue.getValue())));
        this.inputSecondColor.func_146180_a(ClientUtil.colorToHex(new Color((float)slideSecondaryRed.getValue(), (float)slideSecondaryGreen.getValue(), (float)slideSecondaryBlue.getValue())));
    }

    public boolean charTyped(char p_charTyped_1_, int p_charTyped_2_) {
        return this.inputPrimaryColor.charTyped(p_charTyped_1_, p_charTyped_2_) || this.inputSecondColor.charTyped(p_charTyped_1_, p_charTyped_2_);
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_) || this.inputPrimaryColor.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_) || this.inputSecondColor.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public void render(int p_render_1_, int p_render_2_, float p_render_3_) {
        super.render(p_render_1_, p_render_2_, p_render_3_);
        this.inputPrimaryColor.render(p_render_1_, p_render_2_, p_render_3_);
        this.inputSecondColor.render(p_render_1_, p_render_2_, p_render_3_);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.renderBackground();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(background);
        this.blit(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        int cx = (this.width - this.field_146999_f) / 2;
        int cy = (this.height - this.field_147000_g) / 2;
        RenderUtil.drawRect(cx + 10, cy + 44, cx + 81, cy + 61, 0.1f, 0.1f, 0.1f, 1.0f);
        RenderUtil.drawRect(cx + 11, cy + 45, cx + 80, cy + 60, (float)slidePrimaryRed.getValue(), (float)slidePrimaryGreen.getValue(), (float)slidePrimaryBlue.getValue(), 1.0f);
        RenderUtil.drawRect(cx + 95, cy + 44, cx + 166, cy + 61, 0.1f, 0.1f, 0.1f, 1.0f);
        RenderUtil.drawRect(cx + 96, cy + 45, cx + 165, cy + 60, (float)slideSecondaryRed.getValue(), (float)slideSecondaryGreen.getValue(), (float)slideSecondaryBlue.getValue(), 1.0f);
        Vec3d primaryColor = new Vec3d((double)((float)slidePrimaryRed.getValue()), (double)((float)slidePrimaryGreen.getValue()), (double)((float)slidePrimaryBlue.getValue()));
        Vec3d secondaryColor = new Vec3d((double)((float)slideSecondaryRed.getValue()), (double)((float)slideSecondaryGreen.getValue()), (double)((float)slideSecondaryBlue.getValue()));
        RegenCap.get((Entity)this.minecraft.field_71439_g).ifPresent(cap -> {
            String str = new TranslationTextComponent("regeneration.gui.primary", new Object[0]).func_150254_d();
            int length = this.minecraft.field_71466_p.func_78256_a(str);
            this.font.func_211126_b(str, (float)(cx + 45 - length / 2), (float)(cy + 49), RenderUtil.calculateColorBrightness(primaryColor) > 0.179 ? 0 : 0xFFFFFF);
            str = new TranslationTextComponent("regeneration.gui.secondary", new Object[0]).func_150254_d();
            length = this.minecraft.field_71466_p.func_78256_a(str);
            this.font.func_211126_b(str, (float)(cx + 131 - length / 2), (float)(cy + 49), RenderUtil.calculateColorBrightness(secondaryColor) > 0.179 ? 0 : 0xFFFFFF);
        });
    }

    public void onChangeSliderValue(GuiSlider slider) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74776_a("PrimaryRed", (float)slidePrimaryRed.getValue());
        nbt.func_74776_a("PrimaryGreen", (float)slidePrimaryGreen.getValue());
        nbt.func_74776_a("PrimaryBlue", (float)slidePrimaryBlue.getValue());
        nbt.func_74776_a("SecondaryRed", (float)slideSecondaryRed.getValue());
        nbt.func_74776_a("SecondaryGreen", (float)slideSecondaryGreen.getValue());
        nbt.func_74776_a("SecondaryBlue", (float)slideSecondaryBlue.getValue());
        NetworkDispatcher.sendToServer(new UpdateColorMessage(nbt));
        this.inputPrimaryColor.func_146180_a(ClientUtil.colorToHex(new Color((float)slidePrimaryRed.getValue(), (float)slidePrimaryGreen.getValue(), (float)slidePrimaryBlue.getValue())));
        this.inputSecondColor.func_146180_a(ClientUtil.colorToHex(new Color((float)slideSecondaryRed.getValue(), (float)slideSecondaryGreen.getValue(), (float)slideSecondaryBlue.getValue())));
    }

    public void tick() {
        this.inputPrimaryColor.func_146178_a();
        this.inputSecondColor.func_146178_a();
    }
}

