/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Color;
import java.io.File;
import java.util.List;
import me.swirtzly.regeneration.client.gui.ColorScreen;
import me.swirtzly.regeneration.client.gui.parts.ContainerBlank;
import me.swirtzly.regeneration.client.skinhandling.SkinManipulation;
import me.swirtzly.regeneration.common.capability.RegenCap;
import me.swirtzly.regeneration.common.skin.HandleSkins;
import me.swirtzly.regeneration.network.NetworkDispatcher;
import me.swirtzly.regeneration.network.messages.NextSkinMessage;
import me.swirtzly.regeneration.util.client.ClientUtil;
import me.swirtzly.regeneration.util.client.RenderUtil;
import me.swirtzly.regeneration.util.client.TexUtil;
import me.swirtzly.regeneration.util.common.PlayerUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.config.GuiButtonExt;

public class SkinChoiceScreen
extends ContainerScreen {
    private static final ResourceLocation background = new ResourceLocation("regeneration", "textures/gui/customizer_background.png");
    public static boolean isAlex = true;
    private static ResourceLocation PLAYER_TEXTURE = DefaultPlayerSkin.func_177335_a();
    private static final TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
    private static List<File> skins = null;
    private static int position = 0;
    private static final PlayerModel ALEX_MODEL = new PlayerModel(0.1f, true);
    private static final PlayerModel STEVE_MODEL = new PlayerModel(0.1f, false);
    private static PlayerUtil.EnumChoices choices = null;
    private float rotation = 0.0f;

    public SkinChoiceScreen() {
        super((Container)new ContainerBlank(), null, (ITextComponent)new TranslationTextComponent("Regeneration", new Object[0]));
        this.field_146999_f = 176;
        this.field_147000_g = 186;
    }

    public static void updateModels() {
        isAlex = skins.get(position).toPath().startsWith(HandleSkins.SKIN_DIRECTORY_ALEX.toPath().toString());
        choices = isAlex ? PlayerUtil.EnumChoices.ALEX : PlayerUtil.EnumChoices.STEVE;
    }

    public void init() {
        super.init();
        int cx = (this.width - this.field_146999_f) / 2;
        int cy = (this.height - this.field_147000_g) / 2;
        int btnW = 60;
        int btnH = 18;
        this.rotation = 0.0f;
        position = 0;
        GuiButtonExt btnNext = new GuiButtonExt(cx + 25, cy + 75, 20, 20, new TranslationTextComponent("regeneration.gui.previous", new Object[0]).func_150254_d(), new Button.IPressable(){

            public void onPress(Button button) {
                if (!PLAYER_TEXTURE.equals((Object)Minecraft.func_71410_x().field_71439_g.func_110306_p())) {
                    if (position >= skins.size() - 1) {
                        position = 0;
                    } else {
                        position++;
                    }
                    textureManager.func_147645_c(PLAYER_TEXTURE);
                    PLAYER_TEXTURE = TexUtil.fileTotexture((File)skins.get(position));
                    SkinChoiceScreen.updateModels();
                }
            }
        });
        GuiButtonExt btnPrevious = new GuiButtonExt(cx + 130, cy + 75, 20, 20, new TranslationTextComponent("regeneration.gui.next", new Object[0]).func_150254_d(), new Button.IPressable(){

            public void onPress(Button button) {
                if (!PLAYER_TEXTURE.equals((Object)Minecraft.func_71410_x().field_71439_g.func_110306_p())) {
                    if (position > 0) {
                        position--;
                    } else {
                        position = skins.size() - 1;
                    }
                    textureManager.func_147645_c(PLAYER_TEXTURE);
                    PLAYER_TEXTURE = TexUtil.fileTotexture((File)skins.get(position));
                    SkinChoiceScreen.updateModels();
                }
            }
        });
        GuiButtonExt btnBack = new GuiButtonExt(cx + 25, cy + 145, 60, 18, new TranslationTextComponent("regeneration.gui.back", new Object[0]).func_150254_d(), new Button.IPressable(){

            public void onPress(Button button) {
                Minecraft.func_71410_x().func_147108_a((Screen)new ColorScreen());
            }
        });
        GuiButtonExt btnOpenFolder = new GuiButtonExt(cx + 90, cy + 145, 60, 18, new TranslationTextComponent("regeneration.gui.open_folder", new Object[0]).func_150254_d(), new Button.IPressable(){

            public void onPress(Button button) {
                Util.func_110647_a().func_195641_a(HandleSkins.SKIN_DIRECTORY);
            }
        });
        GuiButtonExt btnSave = new GuiButtonExt(cx + 90, cy + 125, 60, 18, new TranslationTextComponent("regeneration.gui.save", new Object[0]).func_150254_d(), new Button.IPressable(){

            public void onPress(Button button) {
                SkinChoiceScreen.updateModels();
                NetworkDispatcher.sendToServer(new NextSkinMessage(HandleSkins.imageToPixelData((File)skins.get(position)), isAlex));
            }
        });
        GuiButtonExt btnResetSkin = new GuiButtonExt(cx + 25, cy + 125, 60, 18, new TranslationTextComponent("regeneration.gui.reset_skin", new Object[0]).func_150254_d(), new Button.IPressable(){

            public void onPress(Button button) {
                ClientUtil.sendSkinResetPacket();
            }
        });
        this.addButton((Widget)btnNext);
        this.addButton((Widget)btnPrevious);
        this.addButton((Widget)btnOpenFolder);
        this.addButton((Widget)btnBack);
        this.addButton((Widget)btnSave);
        this.addButton((Widget)btnResetSkin);
        RegenCap.get((Entity)this.minecraft.field_71439_g).ifPresent(data -> {
            choices = data.getPreferredModel();
        });
        skins = SkinManipulation.listAllSkins(choices);
        PLAYER_TEXTURE = TexUtil.fileTotexture(skins.get(position));
        RegenCap.get((Entity)Minecraft.func_71410_x().field_71439_g).ifPresent(data -> {
            choices = data.getPreferredModel();
        });
        SkinChoiceScreen.updateModels();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.renderBackground();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(background);
        this.blit(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        GlStateManager.pushMatrix();
        SkinChoiceScreen.ALEX_MODEL.field_217114_e = false;
        SkinChoiceScreen.STEVE_MODEL.field_217114_e = false;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(PLAYER_TEXTURE);
        switch (choices) {
            case ALEX: {
                RenderUtil.drawModelToGui((EntityModel)ALEX_MODEL, this.width / 2, this.height / 2 - 50, 1.0f, this.rotation);
                break;
            }
            case STEVE: {
                RenderUtil.drawModelToGui((EntityModel)STEVE_MODEL, this.width / 2, this.height / 2 - 50, 1.0f, this.rotation);
                break;
            }
            case EITHER: {
                RenderUtil.drawModelToGui((EntityModel)ALEX_MODEL, this.width / 2 - 40, this.height / 2 - 50, 1.0f, this.rotation);
                RenderUtil.drawModelToGui((EntityModel)STEVE_MODEL, this.width / 2 + 40, this.height / 2 - 50, 1.0f, this.rotation);
            }
        }
        GlStateManager.popMatrix();
        this.drawCenteredString(Minecraft.func_71410_x().field_71466_p, new TranslationTextComponent("regeneration.gui.current_skin", new Object[0]).func_150261_e(), this.width / 2, this.height / 2 + 5, Color.WHITE.getRGB());
        this.drawCenteredString(Minecraft.func_71410_x().field_71466_p, new TranslationTextComponent(skins.get(position).getName().replaceAll(".png", ""), new Object[0]).func_150261_e(), this.width / 2, this.height / 2 + 15, Color.WHITE.getRGB());
    }

    public void render(int p_render_1_, int p_render_2_, float p_render_3_) {
        super.render(p_render_1_, p_render_2_, p_render_3_);
        this.rotation += 1.0f;
        if (this.rotation > 360.0f) {
            this.rotation = 0.0f;
        }
    }
}

