/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.client.image;

import com.mojang.blaze3d.platform.TextureUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ImageDownloader
extends SimpleTexture {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final AtomicInteger TEXTURE_DOWNLOADER_THREAD_ID = new AtomicInteger(0);
    @Nullable
    private final File cacheFile;
    private final String imageUrl;
    @Nullable
    private final IImageBuffer imageBuffer;
    @Nullable
    private Thread imageThread;
    private volatile boolean textureUploaded;

    public ImageDownloader(@Nullable File cacheFileIn, String imageUrlIn, ResourceLocation textureResourceLocation, @Nullable IImageBuffer imageBufferIn) {
        super(textureResourceLocation);
        this.cacheFile = cacheFileIn;
        this.imageUrl = imageUrlIn;
        this.imageBuffer = imageBufferIn;
    }

    public static boolean isAlexSkin(BufferedImage image) {
        return ImageDownloader.hasAlpha(55, 20, image) && ImageDownloader.hasAlpha(55, 21, image) && ImageDownloader.hasAlpha(55, 22, image) && ImageDownloader.hasAlpha(55, 23, image) && ImageDownloader.hasAlpha(55, 24, image) && ImageDownloader.hasAlpha(55, 25, image) && ImageDownloader.hasAlpha(55, 26, image) && ImageDownloader.hasAlpha(55, 27, image) && ImageDownloader.hasAlpha(55, 28, image) && ImageDownloader.hasAlpha(55, 29, image) && ImageDownloader.hasAlpha(55, 30, image) && ImageDownloader.hasAlpha(55, 31, image) && ImageDownloader.hasAlpha(54, 20, image) && ImageDownloader.hasAlpha(54, 21, image) && ImageDownloader.hasAlpha(54, 22, image) && ImageDownloader.hasAlpha(54, 23, image) && ImageDownloader.hasAlpha(54, 24, image) && ImageDownloader.hasAlpha(54, 25, image) && ImageDownloader.hasAlpha(54, 26, image) && ImageDownloader.hasAlpha(54, 27, image) && ImageDownloader.hasAlpha(54, 28, image) && ImageDownloader.hasAlpha(54, 29, image) && ImageDownloader.hasAlpha(54, 30, image) && ImageDownloader.hasAlpha(54, 31, image) || ImageDownloader.hasAlpha(46, 52, image) && ImageDownloader.hasAlpha(46, 53, image) && ImageDownloader.hasAlpha(46, 54, image) && ImageDownloader.hasAlpha(46, 54, image) && ImageDownloader.hasAlpha(46, 55, image) && ImageDownloader.hasAlpha(46, 56, image) && ImageDownloader.hasAlpha(46, 57, image) && ImageDownloader.hasAlpha(46, 58, image) && ImageDownloader.hasAlpha(46, 59, image) && ImageDownloader.hasAlpha(46, 60, image) && ImageDownloader.hasAlpha(46, 61, image) && ImageDownloader.hasAlpha(46, 63, image) && ImageDownloader.hasAlpha(46, 53, image);
    }

    public static boolean hasAlpha(int x, int y, BufferedImage image) {
        int pixel = image.getRGB(x, y);
        return pixel >> 24 == 0 || (pixel & 0xFFFFFF) == 0;
    }

    private void uploadImage(NativeImage nativeImageIn) {
        TextureUtil.prepareImage((int)this.func_110552_b(), (int)nativeImageIn.func_195702_a(), (int)nativeImageIn.func_195714_b());
        nativeImageIn.func_195697_a(0, 0, 0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(NativeImage nativeImageIn) {
        if (this.imageBuffer != null) {
            this.imageBuffer.func_152634_a();
        }
        ImageDownloader imageDownloader = this;
        synchronized (imageDownloader) {
            this.uploadImage(nativeImageIn);
            this.textureUploaded = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_195413_a(IResourceManager manager) throws IOException {
        if (!this.textureUploaded) {
            ImageDownloader imageDownloader = this;
            synchronized (imageDownloader) {
                super.func_195413_a(manager);
                this.textureUploaded = true;
            }
        }
        if (this.imageThread == null) {
            if (this.cacheFile != null && this.cacheFile.isFile()) {
                LOGGER.debug("Loading http texture from local cache ({})", (Object)this.cacheFile);
                try (NativeImage nativeimage = null;){
                    nativeimage = NativeImage.func_195713_a((InputStream)new FileInputStream(this.cacheFile));
                    if (this.imageBuffer != null) {
                        nativeimage = this.imageBuffer.func_195786_a(nativeimage);
                    }
                    this.setImage(nativeimage);
                }
            } else {
                this.loadTextureFromServer();
            }
        }
    }

    protected void loadTextureFromServer() {
        this.imageThread = new Thread("Texture Downloader #" + TEXTURE_DOWNLOADER_THREAD_ID.incrementAndGet()){

            @Override
            public void run() {
                HttpURLConnection httpurlconnection = null;
                LOGGER.debug("Downloading http texture from {} to {}", (Object)ImageDownloader.this.imageUrl, (Object)ImageDownloader.this.cacheFile);
                try {
                    httpurlconnection = (HttpURLConnection)new URL(ImageDownloader.this.imageUrl).openConnection(Minecraft.func_71410_x().func_110437_J());
                    httpurlconnection.setDoInput(true);
                    httpurlconnection.setDoOutput(false);
                    httpurlconnection.connect();
                    if (httpurlconnection.getResponseCode() / 100 == 2) {
                        InputStream inputstream;
                        if (ImageDownloader.this.cacheFile != null) {
                            FileUtils.copyInputStreamToFile((InputStream)httpurlconnection.getInputStream(), (File)ImageDownloader.this.cacheFile);
                            inputstream = new FileInputStream(ImageDownloader.this.cacheFile);
                        } else {
                            inputstream = httpurlconnection.getInputStream();
                        }
                        Minecraft.func_71410_x().func_222817_e(() -> {
                            NativeImage nativeimage = null;
                            try {
                                nativeimage = NativeImage.func_195713_a((InputStream)inputstream);
                                if (ImageDownloader.this.imageBuffer != null) {
                                    nativeimage = ImageDownloader.this.imageBuffer.func_195786_a(nativeimage);
                                }
                            }
                            catch (IOException ioexception) {
                                LOGGER.warn("Error while loading the skin texture", (Throwable)ioexception);
                            }
                            finally {
                                if (nativeimage != null) {
                                    nativeimage.close();
                                }
                                IOUtils.closeQuietly((InputStream)inputstream);
                            }
                        });
                        return;
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("Couldn't download http texture", (Throwable)exception);
                    return;
                }
                finally {
                    if (httpurlconnection != null) {
                        httpurlconnection.disconnect();
                    }
                }
            }
        };
        this.imageThread.setDaemon(true);
        this.imageThread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(LOGGER));
        this.imageThread.start();
    }
}

