/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.client.rendering.entity;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nullable;
import me.swirtzly.regeneration.RegenConfig;
import me.swirtzly.regeneration.client.rendering.layers.HandsLayer;
import me.swirtzly.regeneration.client.rendering.layers.RegenerationLayer;
import me.swirtzly.regeneration.client.rendering.model.TimelordGuardModel;
import me.swirtzly.regeneration.client.rendering.model.TimelordModel;
import me.swirtzly.regeneration.client.skinhandling.SkinManipulation;
import me.swirtzly.regeneration.common.capability.IRegen;
import me.swirtzly.regeneration.common.capability.RegenCap;
import me.swirtzly.regeneration.common.entity.TimelordEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.HeadLayer;
import net.minecraft.client.renderer.entity.layers.HeldItemLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.entity.model.RendererModel;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;

public class TimelordRenderer
extends LivingRenderer<TimelordEntity, BipedModel<TimelordEntity>> {
    public static EntityModel<TimelordEntity> mainModel = new TimelordModel();
    public static EntityModel<TimelordEntity> councilModel = new TimelordModel();
    public static EntityModel<TimelordEntity> guardModel = new TimelordGuardModel();
    public static PlayerModel<TimelordEntity> bipedModel = new PlayerModel(0.05f, true);
    public static ResourceLocation TIMELORD = new ResourceLocation("regeneration", "textures/entity/timelords/timelord/timelord_villager.png");
    public static HashMap<UUID, ResourceLocation> TIMELORDS = new HashMap();

    public TimelordRenderer(EntityRendererManager entityRendererManager) {
        super(entityRendererManager, (EntityModel)new BipedModel(), 0.1f);
        this.func_177094_a(new RegenerationLayer(this));
        this.func_177094_a(new HandsLayer((IEntityRenderer)this));
        this.func_177094_a((LayerRenderer)new HeldItemLayer((IEntityRenderer)this));
        this.func_177094_a((LayerRenderer)new ArrowLayer((LivingRenderer)this));
        this.func_177094_a((LayerRenderer)new HeadLayer((IEntityRenderer)this));
        this.func_177094_a((LayerRenderer)new BipedArmorLayer((IEntityRenderer)this, new BipedModel(0.5f), new BipedModel(1.0f)));
    }

    public static ResourceLocation getTimelordFace(TimelordEntity timelordEntity) {
        IRegen data = (IRegen)RegenCap.get((Entity)timelordEntity).orElseGet(null);
        if (timelordEntity.isVillagerModel().booleanValue()) {
            return TIMELORD;
        }
        if (data.getAnimationTicks() > 100) {
            TIMELORDS.remove(timelordEntity.func_110124_au());
        }
        if (TIMELORDS.containsKey(timelordEntity.func_110124_au())) {
            return TIMELORDS.get(timelordEntity.func_110124_au());
        }
        NativeImage bufferedImage = SkinManipulation.decodeToImage(data.getEncodedSkin());
        if (bufferedImage == null) {
            return DefaultPlayerSkin.func_177335_a();
        }
        ResourceLocation location = Minecraft.func_71410_x().func_110434_K().func_110578_a("timelord_", new DynamicTexture(bufferedImage));
        TIMELORDS.put(timelordEntity.func_110124_au(), location);
        return location;
    }

    protected void renderModel(TimelordEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        boolean flag1;
        switch (entitylivingbaseIn.getTimelordType()) {
            case GUARD: {
                mainModel = guardModel;
                break;
            }
            case COUNCIL: {
                mainModel = councilModel;
            }
        }
        this.field_77045_g = (BipedModel)mainModel;
        boolean flag = this.func_193115_c((LivingEntity)entitylivingbaseIn);
        boolean bl = flag1 = !flag && !entitylivingbaseIn.func_98034_c((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
        if (flag || flag1) {
            if (!this.func_180548_c((Entity)entitylivingbaseIn)) {
                return;
            }
            if (flag1) {
                GlStateManager.setProfile((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
            }
            if (!entitylivingbaseIn.isVillagerModel().booleanValue()) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TimelordRenderer.getTimelordFace(entitylivingbaseIn));
                TimelordRenderer.bipedModel.field_217114_e = false;
                for (RendererModel rendererModel : TimelordRenderer.bipedModel.field_78092_r) {
                    rendererModel.field_78807_k = true;
                }
                TimelordRenderer.bipedModel.field_78116_c.field_78807_k = false;
                TimelordRenderer.bipedModel.field_178720_f.field_78807_k = (Boolean)RegenConfig.CLIENT.renderTimelordHeadwear.get() == false;
                bipedModel.func_212844_a_((LivingEntity)entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
                bipedModel.func_78088_a((LivingEntity)entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getEntityTexture(entitylivingbaseIn));
            ((BipedModel)this.field_77045_g).func_212844_a_((LivingEntity)entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
            ((BipedModel)this.field_77045_g).func_78088_a((LivingEntity)entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
            if (flag1) {
                GlStateManager.unsetProfile((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
            }
        }
    }

    @Nullable
    protected ResourceLocation getEntityTexture(TimelordEntity entity) {
        switch (entity.getTimelordType()) {
            case COUNCIL: {
                return new ResourceLocation("regeneration", "textures/entity/timelords/timelord/timelord_council.png");
            }
            case GUARD: {
                return new ResourceLocation("regeneration", "textures/entity/timelords/guards/timelord_guard.png");
            }
        }
        return null;
    }
}

