/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.client.rendering.layers;

import com.mojang.blaze3d.platform.GlStateManager;
import me.swirtzly.regeneration.client.rendering.layers.RegenerationLayer;
import me.swirtzly.regeneration.client.rendering.types.ATypeRenderer;
import me.swirtzly.regeneration.common.capability.RegenCap;
import me.swirtzly.regeneration.util.common.PlayerUtil;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.HandSide;

public class HandsLayer
extends LayerRenderer {
    private final IEntityRenderer livingEntityRenderer;

    public HandsLayer(IEntityRenderer livingEntityRendererIn) {
        super(livingEntityRendererIn);
        this.livingEntityRenderer = livingEntityRendererIn;
    }

    public void func_212842_a_(Entity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        GlStateManager.pushMatrix();
        LivingEntity entitylivingbaseIn = (LivingEntity)entity;
        RegenCap.get((Entity)entitylivingbaseIn).ifPresent(data -> {
            if (this.livingEntityRenderer.func_217764_d().field_217114_e) {
                GlStateManager.translatef((float)0.0f, (float)0.75f, (float)0.0f);
                GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
            }
            if (data.areHandsGlowing()) {
                this.renderHand(entitylivingbaseIn, HandSide.LEFT, EnumHandRenderType.GRACE);
                this.renderHand(entitylivingbaseIn, HandSide.RIGHT, EnumHandRenderType.GRACE);
            }
            if (data.getState() == PlayerUtil.RegenState.REGENERATING || data.isSyncingToJar()) {
                this.renderHand(entitylivingbaseIn, HandSide.LEFT, EnumHandRenderType.REGEN);
                this.renderHand(entitylivingbaseIn, HandSide.RIGHT, EnumHandRenderType.REGEN);
            }
        });
        GlStateManager.popMatrix();
    }

    private void renderHand(LivingEntity player, HandSide handSide, EnumHandRenderType type) {
        GlStateManager.pushMatrix();
        RegenCap.get((Entity)player).ifPresent(data -> {
            if (player.func_70093_af()) {
                GlStateManager.translatef((float)0.0f, (float)0.2f, (float)0.0f);
            }
            this.translateToHand(handSide);
            boolean flag = handSide == HandSide.LEFT;
            GlStateManager.translatef((float)((float)(flag ? -1 : 1) / 25.0f), (float)0.125f, (float)-0.625f);
            GlStateManager.translated((double)0.0, (double)-0.05, (double)0.6);
            if (type == EnumHandRenderType.GRACE) {
                RegenerationLayer.renderGlowingHands(player, data, 1.5f, handSide);
            }
            if (type == EnumHandRenderType.REGEN) {
                ((ATypeRenderer)data.getRegenType().create().getRenderer()).renderHand(player, handSide, (LivingRenderer)this.livingEntityRenderer);
            }
        });
        GlStateManager.popMatrix();
    }

    protected void translateToHand(HandSide handSide) {
        ((BipedModel)this.livingEntityRenderer.func_217764_d()).func_187073_a(0.0625f, handSide);
    }

    public boolean func_177142_b() {
        return false;
    }

    public static enum EnumHandRenderType {
        REGEN,
        GRACE;

    }
}

