/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.client.rendering.tiles;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.HashMap;
import me.swirtzly.regeneration.client.rendering.model.HandModel;
import me.swirtzly.regeneration.client.skinhandling.SkinManipulation;
import me.swirtzly.regeneration.common.item.HandItem;
import me.swirtzly.regeneration.common.tiles.HandInJarTile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.util.ResourceLocation;

public class HandTileRenderer
extends TileEntityRenderer<HandInJarTile> {
    private static final ResourceLocation TEXTURE_STEVE = new ResourceLocation("textures/entity/steve.png");
    private static final ResourceLocation TEXTURE_ALEX = new ResourceLocation("textures/entity/alex.png");
    public static HashMap<HandInJarTile, ResourceLocation> TEXTURES = new HashMap();
    public static EntityModel STEVE_ARM = new HandModel(false);
    public static EntityModel ALEX_ARM = new HandModel(true);

    public void render(HandInJarTile tileEntityIn, double x, double y, double z, float partialTicks, int destroyStage) {
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)x, (double)y, (double)z);
        if (tileEntityIn.hasHand()) {
            String handType = HandItem.getSkinType(tileEntityIn.getHand());
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getOrCreateTexture(tileEntityIn));
            GlStateManager.rotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.translated((double)0.5, (double)-1.5, (double)-0.5);
            if (handType.equals("ALEX")) {
                ALEX_ARM.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            } else {
                STEVE_ARM.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            }
        } else {
            TEXTURES.remove((Object)tileEntityIn);
        }
        GlStateManager.popMatrix();
    }

    public ResourceLocation getOrCreateTexture(HandInJarTile tileEntityHandInJar) {
        if (HandItem.getTextureString(tileEntityHandInJar.getHand()).equalsIgnoreCase("NONE")) {
            boolean isAlex = HandItem.getSkinType(tileEntityHandInJar.getHand()).equalsIgnoreCase("ALEX");
            return isAlex ? TEXTURE_ALEX : TEXTURE_STEVE;
        }
        if (!TEXTURES.containsKey((Object)tileEntityHandInJar)) {
            NativeImage image = SkinManipulation.decodeToImage(HandItem.getTextureString(tileEntityHandInJar.getHand()));
            ResourceLocation res = Minecraft.func_71410_x().func_110434_K().func_110578_a("hand_", new DynamicTexture(image));
            TEXTURES.put(tileEntityHandInJar, res);
            return res;
        }
        return TEXTURES.get((Object)tileEntityHandInJar);
    }
}

