/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.client.rendering.types;

import com.mojang.blaze3d.platform.GlStateManager;
import me.swirtzly.regeneration.client.rendering.types.ATypeRenderer;
import me.swirtzly.regeneration.common.capability.IRegen;
import me.swirtzly.regeneration.common.capability.RegenCap;
import me.swirtzly.regeneration.common.types.FieryType;
import me.swirtzly.regeneration.common.types.RegenTypes;
import me.swirtzly.regeneration.util.client.RenderUtil;
import me.swirtzly.regeneration.util.common.PlayerUtil;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.ModList;

public class FieryRenderer
extends ATypeRenderer<FieryType> {
    public static final FieryRenderer INSTANCE = new FieryRenderer();

    public static void renderOverlay(LivingRenderer renderer, LivingEntity entityPlayer, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        RegenCap.get((Entity)entityPlayer).ifPresent(data -> {
            GlStateManager.pushMatrix();
            RenderUtil.setLightmapTextureCoords(240.0f, 240.0f);
            GlStateManager.disableLighting();
            GlStateManager.enableBlend();
            GlStateManager.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            GlStateManager.blendFunc((int)770, (int)1);
            Vec3d color = data.getPrimaryColor();
            float opacity = MathHelper.func_76131_a((float)(MathHelper.func_76126_a((float)(((float)entityPlayer.field_70173_aa + partialTicks) / 10.0f)) * 0.1f + 0.1f), (float)0.11f, (float)1.0f);
            GlStateManager.color4f((float)((float)color.field_72450_a), (float)((float)color.field_72448_b), (float)((float)color.field_72449_c), (float)opacity);
            renderer.func_217764_d().func_78088_a((Entity)entityPlayer, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            RenderUtil.restoreLightMap();
            GlStateManager.enableLighting();
            GlStateManager.disableBlend();
            GlStateManager.popMatrix();
        });
    }

    public static void renderCone(LivingEntity entityPlayer, float scale, float scale2, Vec3d color) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        for (int i = 0; i < 8; ++i) {
            GlStateManager.pushMatrix();
            GlStateManager.rotatef((float)(entityPlayer.field_70173_aa * 4 + i * 45), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.scalef((float)1.0f, (float)1.0f, (float)0.65f);
            vertexBuffer.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            vertexBuffer.func_181662_b(0.0, 0.0, 0.0).func_181666_a((float)color.field_72450_a, (float)color.field_72448_b, (float)color.field_72449_c, 55.0f).func_181675_d();
            vertexBuffer.func_181662_b(-0.266 * (double)scale, (double)scale, (double)(-0.5f * scale)).func_181666_a((float)color.field_72450_a, (float)color.field_72448_b, (float)color.field_72449_c, 55.0f).func_181675_d();
            vertexBuffer.func_181662_b(0.266 * (double)scale, (double)scale, (double)(-0.5f * scale)).func_181666_a((float)color.field_72450_a, (float)color.field_72448_b, (float)color.field_72449_c, 55.0f).func_181675_d();
            vertexBuffer.func_181662_b(0.0, (double)scale2, (double)(1.0f * scale)).func_181666_a((float)color.field_72450_a, (float)color.field_72448_b, (float)color.field_72449_c, 55.0f).func_181675_d();
            vertexBuffer.func_181662_b(-0.266 * (double)scale, (double)scale, (double)(-0.5f * scale)).func_181666_a((float)color.field_72450_a, (float)color.field_72448_b, (float)color.field_72449_c, 55.0f).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.popMatrix();
        }
    }

    private static void renderConeAtArms(LivingEntity player, HandSide side) {
        GlStateManager.pushMatrix();
        RegenCap.get((Entity)player).ifPresent(data -> {
            double x = data.getRegenType().create().getAnimationProgress((IRegen)data);
            double p = 109.89010989010987;
            double r = 0.09890109890109888;
            double f = p * Math.pow(x, 2.0) - r;
            float cf = MathHelper.func_76131_a((float)((float)f), (float)0.0f, (float)1.0f);
            float primaryScale = data.isSyncingToJar() ? 100.0f : cf * 4.0f;
            float secondaryScale = data.isSyncingToJar() ? 100.0f : cf * 6.4f;
            CompoundNBT style = data.getStyle();
            Vec3d primaryColor = new Vec3d((double)style.func_74760_g("PrimaryRed"), (double)style.func_74760_g("PrimaryGreen"), (double)style.func_74760_g("PrimaryBlue"));
            Vec3d secondaryColor = new Vec3d((double)style.func_74760_g("SecondaryRed"), (double)style.func_74760_g("SecondaryGreen"), (double)style.func_74760_g("SecondaryBlue"));
            GlStateManager.pushTextureAttributes();
            GlStateManager.disableTexture();
            GlStateManager.enableAlphaTest();
            GlStateManager.enableBlend();
            GlStateManager.blendFunc((int)GlStateManager.SourceFactor.SRC_ALPHA.value, (int)GlStateManager.SourceFactor.CONSTANT_ALPHA.value);
            GlStateManager.depthMask((boolean)true);
            RenderUtil.setLightmapTextureCoords(65.0f, 65.0f);
            if (data.isSyncingToJar()) {
                GlStateManager.rotatef((float)-20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (ModList.get().isLoaded("quark")) {
                double animationProgress = data.getAnimationTicks();
                float armRotY = (float)animationProgress * 1.5f;
                float armRotZ = (float)animationProgress * 1.5f;
                if (armRotY > 90.0f) {
                    armRotY = 90.0f;
                }
                if (armRotZ > 95.0f) {
                    armRotZ = 95.0f;
                }
                GlStateManager.translatef((float)0.0f, (float)0.1f, (float)0.0f);
                GlStateManager.rotated((double)(side == HandSide.LEFT ? (double)armRotZ : (double)(-armRotZ)), (double)0.0, (double)0.0, (double)1.0);
                GlStateManager.rotated((double)(side == HandSide.LEFT ? (double)armRotY : (double)(-armRotY)), (double)0.0, (double)1.0, (double)0.0);
            }
            FieryRenderer.renderCone(player, primaryScale, primaryScale, primaryColor);
            FieryRenderer.renderCone(player, secondaryScale, secondaryScale * 1.5f, secondaryColor);
            RenderUtil.restoreLightMap();
            GlStateManager.depthMask((boolean)false);
            GlStateManager.disableBlend();
            GlStateManager.disableAlphaTest();
            GlStateManager.color4f((float)255.0f, (float)255.0f, (float)255.0f, (float)255.0f);
            GlStateManager.enableTexture();
            GlStateManager.popAttributes();
        });
        GlStateManager.popMatrix();
    }

    @Override
    public void renderHand(LivingEntity player, HandSide handSide, LivingRenderer render) {
        if (!ModList.get().isLoaded("quark")) {
            FieryRenderer.renderConeAtArms(player, handSide);
        }
    }

    @Override
    protected void onRenderPre(FieryType type, RenderPlayerEvent.Pre event, IRegen capability) {
    }

    @Override
    protected void onRenderPost(FieryType type, RenderPlayerEvent.Post event, IRegen capability) {
    }

    @Override
    public void onRenderLayer(FieryType type, LivingRenderer renderLivingBase, IRegen capability, LivingEntity entityPlayer, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        GlStateManager.pushTextureAttributes();
        GlStateManager.disableTexture();
        GlStateManager.enableAlphaTest();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GlStateManager.depthMask((boolean)true);
        RenderUtil.setLightmapTextureCoords(65.0f, 65.0f);
        CompoundNBT style = capability.getStyle();
        Vec3d primaryColor = new Vec3d((double)style.func_74760_g("PrimaryRed"), (double)style.func_74760_g("PrimaryGreen"), (double)style.func_74760_g("PrimaryBlue"));
        Vec3d secondaryColor = new Vec3d((double)style.func_74760_g("SecondaryRed"), (double)style.func_74760_g("SecondaryGreen"), (double)style.func_74760_g("SecondaryBlue"));
        double x = type.getAnimationProgress(capability);
        double p = 109.89010989010987;
        double r = 0.09890109890109888;
        double f = p * Math.pow(x, 2.0) - r;
        float cf = MathHelper.func_76131_a((float)((float)f), (float)0.0f, (float)1.0f);
        float primaryScale = cf * 4.0f;
        float secondaryScale = cf * 6.4f;
        GlStateManager.pushMatrix();
        if (renderLivingBase.func_217764_d() instanceof BipedModel) {
            BipedModel player = (BipedModel)renderLivingBase.func_217764_d();
            player.field_78116_c.func_78794_c(scale);
        }
        GlStateManager.translatef((float)0.0f, (float)0.09f, (float)0.0f);
        GlStateManager.rotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        FieryRenderer.renderCone(entityPlayer, primaryScale / 1.6f, primaryScale * 0.75f, primaryColor);
        FieryRenderer.renderCone(entityPlayer, secondaryScale / 1.6f, secondaryScale / 1.5f, secondaryColor);
        GlStateManager.popMatrix();
        if (!capability.isSyncingToJar()) {
            FieryRenderer.renderOverlay(renderLivingBase, entityPlayer, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
        }
        RenderUtil.restoreLightMap();
        GlStateManager.depthMask((boolean)false);
        GlStateManager.disableBlend();
        GlStateManager.disableAlphaTest();
        GlStateManager.color4f((float)255.0f, (float)255.0f, (float)255.0f, (float)255.0f);
        GlStateManager.enableTexture();
        GlStateManager.popAttributes();
        if (ModList.get().isLoaded("quark")) {
            FieryRenderer.renderConeAtArms(entityPlayer, HandSide.LEFT);
            FieryRenderer.renderConeAtArms(entityPlayer, HandSide.RIGHT);
        }
    }

    @Override
    public void preRenderCallback(LivingRenderer renderer, LivingEntity entity) {
    }

    @Override
    public void animateEntity(BipedModel playerModel, LivingEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        RegenCap.get((Entity)entity).ifPresent(data -> {
            if (data.getState() == PlayerUtil.RegenState.REGENERATING && data.getRegenType() == RegenTypes.FIERY) {
                double animationProgress = data.getAnimationTicks();
                double arm_shake = entity.func_70681_au().nextDouble();
                float armRotY = (float)animationProgress * 1.5f;
                float armRotZ = (float)animationProgress * 1.5f;
                float headRot = (float)animationProgress * 1.5f;
                if (armRotY > 90.0f) {
                    armRotY = 90.0f;
                }
                if (armRotZ > 95.0f) {
                    armRotZ = 95.0f;
                }
                if (headRot > 45.0f) {
                    headRot = 45.0f;
                }
                playerModel.field_178724_i.field_78796_g = 0.0f;
                playerModel.field_178723_h.field_78796_g = 0.0f;
                playerModel.field_178724_i.field_78795_f = 0.0f;
                playerModel.field_178723_h.field_78795_f = 0.0f;
                playerModel.field_178724_i.field_78808_h = (float)(-Math.toRadians((double)armRotZ + arm_shake));
                playerModel.field_178723_h.field_78808_h = (float)Math.toRadians((double)armRotZ + arm_shake);
                playerModel.field_178724_i.field_78796_g = (float)(-Math.toRadians(armRotY));
                playerModel.field_178723_h.field_78796_g = (float)Math.toRadians(armRotY);
                playerModel.field_78115_e.field_78795_f = 0.0f;
                playerModel.field_78115_e.field_78796_g = 0.0f;
                playerModel.field_78115_e.field_78808_h = 0.0f;
                playerModel.field_178722_k.field_78796_g = 0.0f;
                playerModel.field_178721_j.field_78796_g = 0.0f;
                playerModel.field_178722_k.field_78795_f = 0.0f;
                playerModel.field_178721_j.field_78795_f = 0.0f;
                playerModel.field_178722_k.field_78808_h = (float)(-Math.toRadians(5.0));
                playerModel.field_178721_j.field_78808_h = (float)Math.toRadians(5.0);
                playerModel.field_78116_c.field_78795_f = (float)Math.toRadians(-headRot);
                playerModel.field_78116_c.field_78796_g = (float)Math.toRadians(0.0);
                playerModel.field_78116_c.field_78808_h = (float)Math.toRadians(0.0);
            }
        });
    }
}

