/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.client.skinhandling;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.platform.GlStateManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import me.swirtzly.regeneration.RegenConfig;
import me.swirtzly.regeneration.Regeneration;
import me.swirtzly.regeneration.client.image.ImageDownloadBuffer;
import me.swirtzly.regeneration.client.rendering.types.ATypeRenderer;
import me.swirtzly.regeneration.client.skinhandling.SkinInfo;
import me.swirtzly.regeneration.common.capability.IRegen;
import me.swirtzly.regeneration.common.capability.RegenCap;
import me.swirtzly.regeneration.common.skin.HandleSkins;
import me.swirtzly.regeneration.common.types.RegenType;
import me.swirtzly.regeneration.handlers.RegenObjects;
import me.swirtzly.regeneration.network.NetworkDispatcher;
import me.swirtzly.regeneration.network.messages.UpdateSkinMessage;
import me.swirtzly.regeneration.util.client.ClientUtil;
import me.swirtzly.regeneration.util.client.TexUtil;
import me.swirtzly.regeneration.util.common.PlayerUtil;
import me.swirtzly.regeneration.util.common.RegenUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

@OnlyIn(value=Dist.CLIENT)
public class SkinManipulation {
    public static final Map<UUID, SkinInfo> PLAYER_SKINS = new HashMap<UUID, SkinInfo>();

    public static NativeImage decodeToImage(String base64String) {
        if (base64String.equalsIgnoreCase(RegenUtil.NO_SKIN)) {
            return null;
        }
        try {
            return NativeImage.func_195713_a((InputStream)new ByteArrayInputStream(Base64.getMimeDecoder().decode(base64String.replaceAll("-", ""))));
        }
        catch (IOException ioe) {
            Regeneration.LOG.error("ERROR MAKING IMAGE FOR: " + base64String);
            throw new UncheckedIOException(ioe);
        }
    }

    private static SkinInfo getSkinInfo(AbstractClientPlayerEntity player, IRegen data) {
        ResourceLocation resourceLocation;
        SkinInfo.SkinType skinType = SkinInfo.SkinType.ALEX;
        if (data == null) {
            return new SkinInfo((PlayerEntity)player, null, SkinManipulation.getSkinType((PlayerEntity)player, true));
        }
        String skin = data.getEncodedSkin();
        if (RegenUtil.NO_SKIN.equalsIgnoreCase(skin)) {
            skin = TexUtil.getEncodedMojangSkin(player);
        }
        if (skin.equals("CRASH ME")) {
            resourceLocation = TexUtil.getSkinFromGameProfile(player.func_146103_bH());
        } else {
            NativeImage nativeImage = SkinManipulation.decodeToImage(skin);
            if (nativeImage == null) {
                return new SkinInfo((PlayerEntity)player, null, SkinManipulation.getSkinType((PlayerEntity)player, true));
            }
            nativeImage = ImageDownloadBuffer.convert(nativeImage);
            DynamicTexture tex = new DynamicTexture(nativeImage);
            resourceLocation = Minecraft.func_71410_x().func_110434_K().func_110578_a(player.func_200200_C_().func_150261_e().toLowerCase() + "_skin_" + System.currentTimeMillis(), tex);
        }
        skinType = data.getSkinType();
        return new SkinInfo((PlayerEntity)player, resourceLocation, skinType);
    }

    public static SkinInfo.SkinType getSkinType(PlayerEntity player, boolean forceMojang) {
        Map map = Minecraft.func_71410_x().func_152342_ad().func_152788_a(player.func_146103_bH());
        if (map.isEmpty()) {
            map = Minecraft.func_71410_x().func_152347_ac().getTextures(Minecraft.func_71410_x().func_152347_ac().fillProfileProperties(player.func_146103_bH(), false), false);
        }
        MinecraftProfileTexture profile = (MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN);
        AtomicReference<SkinInfo.SkinType> skinType = new AtomicReference<SkinInfo.SkinType>();
        skinType.set(SkinInfo.SkinType.ALEX);
        RegenCap.get((Entity)player).ifPresent(data -> {
            if (data.getEncodedSkin().equalsIgnoreCase(RegenUtil.NO_SKIN) || forceMojang) {
                if (profile == null) {
                    skinType.set(SkinInfo.SkinType.STEVE);
                }
                if (profile != null && profile.getMetadata("model") == null) {
                    skinType.set(SkinInfo.SkinType.STEVE);
                }
            } else {
                skinType.set(data.getSkinType());
            }
        });
        return (SkinInfo.SkinType)((Object)skinType.get());
    }

    public static void setPlayerSkin(AbstractClientPlayerEntity player, ResourceLocation texture) {
        if (player.func_110306_p() == texture) {
            return;
        }
        NetworkPlayerInfo playerInfo = player.field_175157_a;
        if (playerInfo == null) {
            return;
        }
        Map playerTextures = playerInfo.field_187107_a;
        playerTextures.put(MinecraftProfileTexture.Type.SKIN, texture);
        if (texture == null) {
            ObfuscationReflectionHelper.setPrivateValue(NetworkPlayerInfo.class, (Object)playerInfo, (Object)false, (int)4);
        }
    }

    public static void setPlayerSkinType(AbstractClientPlayerEntity player, SkinInfo.SkinType skinType) {
        if (skinType.getMojangType().equals(player.func_175154_l())) {
            return;
        }
        NetworkPlayerInfo playerInfo = player.field_175157_a;
        if (playerInfo == null) {
            return;
        }
        ObfuscationReflectionHelper.setPrivateValue(NetworkPlayerInfo.class, (Object)playerInfo, (Object)skinType.getMojangType(), (int)5);
    }

    public static List<File> listAllSkins(PlayerUtil.EnumChoices choices) {
        ArrayList<File> resultList = new ArrayList<File>();
        File directory = null;
        switch (choices) {
            case EITHER: {
                directory = HandleSkins.SKIN_DIRECTORY;
                break;
            }
            case ALEX: {
                directory = HandleSkins.SKIN_DIRECTORY_ALEX;
                break;
            }
            case STEVE: {
                directory = HandleSkins.SKIN_DIRECTORY_STEVE;
            }
        }
        try {
            Files.find(Paths.get(directory.toString(), new String[0]), Integer.MAX_VALUE, (filePath, fileAttr) -> fileAttr.isRegularFile(), new FileVisitOption[0]).forEach(file -> resultList.add(file.toFile()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return resultList;
    }

    public static void sendSkinUpdate(Random random, PlayerEntity player) {
        if (Minecraft.func_71410_x().field_71439_g.func_110124_au() != player.func_110124_au()) {
            return;
        }
        RegenCap.get((Entity)player).ifPresent(data -> {
            if (((Boolean)RegenConfig.CLIENT.changeMySkin.get()).booleanValue()) {
                String pixelData = RegenUtil.NO_SKIN;
                File skin = null;
                if (data.getNextSkin().equalsIgnoreCase(RegenUtil.NO_SKIN)) {
                    boolean isAlex = data.getPreferredModel().isAlex();
                    skin = HandleSkins.chooseRandomSkin(random, isAlex);
                    Regeneration.LOG.info(skin + " was selected");
                    pixelData = HandleSkins.imageToPixelData(skin);
                    NetworkDispatcher.sendToServer(new UpdateSkinMessage(pixelData, isAlex));
                } else {
                    pixelData = data.getNextSkin();
                    NetworkDispatcher.sendToServer(new UpdateSkinMessage(pixelData, data.getNextSkinType().getMojangType().equals("slim")));
                }
            } else {
                ClientUtil.sendSkinResetPacket();
            }
        });
    }

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Pre renderPlayerEvent) {
        boolean isWearingLeggings;
        boolean isWearingChest;
        AbstractClientPlayerEntity player = (AbstractClientPlayerEntity)renderPlayerEvent.getPlayer();
        PlayerModel model = (PlayerModel)renderPlayerEvent.getRenderer().func_217764_d();
        model.field_78115_e.field_78807_k = isWearingChest = player.func_184582_a(EquipmentSlotType.CHEST).func_77973_b() == RegenObjects.Items.GUARD_CHEST.get();
        model.field_178730_v.field_78807_k = isWearingChest;
        model.field_178734_a.field_78807_k = isWearingChest;
        model.field_178732_b.field_78807_k = isWearingChest;
        model.field_178731_d.field_78807_k = isWearingLeggings = player.func_184582_a(EquipmentSlotType.LEGS).func_77973_b() == RegenObjects.Items.GUARD_LEGGINGS.get();
        model.field_178733_c.field_78807_k = isWearingLeggings;
        RegenCap.get((Entity)player).ifPresent(cap -> {
            if (cap.getState() == PlayerUtil.RegenState.POST && PlayerUtil.isAboveZeroGrid((LivingEntity)player)) {
                float floatingOffset = MathHelper.func_76134_b((float)((float)player.field_70173_aa * 0.1f)) * -0.09f + 0.5f;
                GlStateManager.translated((double)0.0, (double)floatingOffset, (double)0.0);
            }
            if (player.field_70173_aa < 20) {
                PLAYER_SKINS.remove(player.func_110124_au());
            }
            if (cap.getState() != PlayerUtil.RegenState.REGENERATING) {
                SkinInfo skin = PLAYER_SKINS.get(player.func_110124_au());
                if (skin != null) {
                    SkinManipulation.setPlayerSkin(player, skin.getTextureLocation());
                    SkinManipulation.setPlayerSkinType(player, skin.getSkintype());
                } else {
                    this.createSkinData(player, RegenCap.get((Entity)player));
                }
            }
            Minecraft.func_71410_x().func_213165_a(() -> {
                boolean isMidRegeneration;
                boolean bl = isMidRegeneration = cap.getState() == PlayerUtil.RegenState.REGENERATING && cap.getAnimationTicks() >= 100;
                if (isMidRegeneration || player.field_70173_aa < 10) {
                    this.createSkinData(player, RegenCap.get((Entity)player));
                }
            });
            if (cap.getState() == PlayerUtil.RegenState.REGENERATING) {
                RegenType typeInstance = cap.getRegenType().create();
                Object typeRenderer = typeInstance.getRenderer();
                ((ATypeRenderer)typeRenderer).onRenderPre(typeInstance, renderPlayerEvent, (IRegen)cap);
            }
        });
    }

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Post renderPlayerEventPost) {
        AbstractClientPlayerEntity player = (AbstractClientPlayerEntity)renderPlayerEventPost.getPlayer();
        RegenCap.get((Entity)player).ifPresent(cap -> {
            if (cap.getState() == PlayerUtil.RegenState.REGENERATING) {
                RegenType type = cap.getRegenType().create();
                Object typeRenderer = type.getRenderer();
                ((ATypeRenderer)typeRenderer).onRenderPost(type, renderPlayerEventPost, (IRegen)cap);
            }
        });
    }

    private void createSkinData(AbstractClientPlayerEntity player, LazyOptional<IRegen> cap) {
        cap.ifPresent(data -> Minecraft.func_71410_x().func_213165_a(() -> {
            SkinInfo skinInfo = SkinManipulation.getSkinInfo(player, data);
            SkinManipulation.setPlayerSkin(player, skinInfo.getTextureLocation());
            SkinManipulation.setPlayerSkinType(player, skinInfo.getSkintype());
            PLAYER_SKINS.put(player.func_146103_bH().getId(), skinInfo);
        }));
    }
}

