/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.client.sound;

import me.swirtzly.regeneration.Regeneration;
import me.swirtzly.regeneration.common.capability.IRegen;
import me.swirtzly.regeneration.common.capability.RegenCap;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL11;
import org.lwjgl.openal.EXTEfx;

public final class ReverbHandler {
    private static final Minecraft MC = Minecraft.func_71410_x();
    private static boolean available;
    private static boolean setup;
    private static int auxEffectSlot;

    public static void onPlaySound(int soundId) {
        if (!setup) {
            ReverbHandler.setupEffects();
            setup = true;
        }
        if (available && ReverbHandler.shouldEcho()) {
            AL11.alSource3i((int)soundId, (int)131078, (int)auxEffectSlot, (int)0, (int)0);
        }
    }

    private static void setupEffects() {
        available = AL.getCapabilities().ALC_EXT_EFX;
        if (!available) {
            Regeneration.LOG.warn("Unable to setup reverb effects, AL EFX not supported!");
            return;
        }
        auxEffectSlot = EXTEfx.alGenAuxiliaryEffectSlots();
        EXTEfx.alAuxiliaryEffectSloti((int)auxEffectSlot, (int)3, (int)1);
        int reverbEffectSlot = EXTEfx.alGenEffects();
        EXTEfx.alEffecti((int)reverbEffectSlot, (int)32769, (int)32768);
        EXTEfx.alEffectf((int)reverbEffectSlot, (int)6, (float)6.0f);
        EXTEfx.alAuxiliaryEffectSloti((int)auxEffectSlot, (int)1, (int)reverbEffectSlot);
    }

    private static boolean shouldEcho() {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return false;
        }
        IRegen data = (IRegen)RegenCap.get((Entity)Minecraft.func_71410_x().field_71439_g).orElse(null);
        if (data != null) {
            return data.getState().isGraceful();
        }
        return false;
    }

    static {
        ((IReloadableResourceManager)MC.func_195551_G()).func_219534_a((IFutureReloadListener)((ISelectiveResourceReloadListener)(manager, predicate) -> {
            setup = false;
        }));
    }
}

