/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.common.block;

import javax.annotation.Nullable;
import me.swirtzly.regeneration.RegenConfig;
import me.swirtzly.regeneration.common.capability.IRegen;
import me.swirtzly.regeneration.common.capability.RegenCap;
import me.swirtzly.regeneration.common.tiles.ArchTile;
import me.swirtzly.regeneration.compat.ArchHelper;
import me.swirtzly.regeneration.handlers.RegenObjects;
import me.swirtzly.regeneration.util.common.ICompatObject;
import me.swirtzly.regeneration.util.common.PlayerUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ArchBlock
extends DirectionalBlock
implements ICompatObject {
    public ArchBlock(Block.Properties properties) {
        super(properties);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_208619_r() {
        return true;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)field_176387_N, (Comparable)context.func_196010_d().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_176387_N});
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)field_176387_N, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)field_176387_N)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)field_176387_N)));
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return false;
        }
        ItemStack mainHandItem = player.func_184614_ca();
        ItemStack headItem = player.func_184582_a(EquipmentSlotType.HEAD);
        IRegen cap = (IRegen)RegenCap.get((Entity)player).orElse(null);
        int regensLeftInHand = ArchHelper.getRegenerations(mainHandItem);
        if (mainHandItem.func_190926_b()) {
            return false;
        }
        if (handIn == Hand.MAIN_HAND && cap.getState() == PlayerUtil.RegenState.ALIVE) {
            if (mainHandItem.func_77973_b() == this.func_199767_j() || mainHandItem.func_77973_b() == Item.func_150898_a((Block)((Block)RegenObjects.Blocks.HAND_JAR.get()))) {
                PlayerUtil.sendMessage((LivingEntity)player, new TranslationTextComponent("regeneration.messages.item_invalid", new Object[0]), true);
                return true;
            }
            if (cap.getRegenerationsLeft() > 0 && regensLeftInHand == 0) {
                int stored = cap.getRegenerationsLeft();
                ArchHelper.storeRegenerations(mainHandItem, cap.getRegenerationsLeft());
                cap.extractRegeneration(cap.getRegenerationsLeft());
                PlayerUtil.sendMessage((LivingEntity)player, new TranslationTextComponent("regeneration.messages.stored_item", new Object[]{stored, new TranslationTextComponent(mainHandItem.func_77977_a(), new Object[0])}), true);
                worldIn.func_217377_a(pos, false);
                cap.synchronise();
                return true;
            }
            if (cap.getRegenerationsLeft() >= 0 && regensLeftInHand > 0) {
                int needed = (Integer)RegenConfig.COMMON.regenCapacity.get() - cap.getRegenerationsLeft();
                int used = Math.min(regensLeftInHand, needed);
                ArchHelper.storeRegenerations(mainHandItem, regensLeftInHand - used);
                PlayerUtil.sendMessage((LivingEntity)player, new TranslationTextComponent("regeneration.messages.item_taken_regens", new Object[]{used, new TranslationTextComponent(mainHandItem.func_77977_a(), new Object[0])}), true);
                worldIn.func_217377_a(pos, false);
                cap.receiveRegenerations(used);
                cap.synchronise();
                return true;
            }
            PlayerUtil.sendMessage((LivingEntity)player, new TranslationTextComponent("regeneration.messages.regen_fail", new Object[0]), true);
        }
        return super.func_220051_a(state, worldIn, pos, player, handIn, hit);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ArchTile();
    }
}

