/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.common.block;

import javax.annotation.Nullable;
import me.swirtzly.regeneration.common.capability.IRegen;
import me.swirtzly.regeneration.common.capability.RegenCap;
import me.swirtzly.regeneration.common.tiles.HandInJarTile;
import me.swirtzly.regeneration.handlers.RegenObjects;
import me.swirtzly.regeneration.util.common.PlayerUtil;
import me.swirtzly.regeneration.util.common.RegenShapes;
import me.swirtzly.regeneration.util.common.VoxelShapeUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class BlockHandInJar
extends DirectionalBlock {
    public static final VoxelShape NORTH = RegenShapes.getJarShape();
    public static final VoxelShape EAST = VoxelShapeUtils.rotate(RegenShapes.getJarShape(), Rotation.CLOCKWISE_90);
    public static final VoxelShape SOUTH = VoxelShapeUtils.rotate(RegenShapes.getJarShape(), Rotation.CLOCKWISE_180);
    public static final VoxelShape WEST = VoxelShapeUtils.rotate(RegenShapes.getJarShape(), Rotation.COUNTERCLOCKWISE_90);
    public static final DirectionProperty CFACING = DirectionProperty.func_177712_a((String)"facing", facing -> facing != Direction.UP && facing != Direction.DOWN);

    public BlockHandInJar() {
        super(Block.Properties.func_200945_a((Material)Material.field_76233_E).func_200948_a(1.25f, 10.0f));
    }

    public static Direction getFacingFromEntity(BlockPos clickedBlock, LivingEntity entity) {
        Direction direction = Direction.func_176737_a((float)((float)(entity.field_70165_t - (double)clickedBlock.func_177958_n())), (float)((float)(entity.field_70163_u - (double)clickedBlock.func_177956_o())), (float)((float)(entity.field_70161_v - (double)clickedBlock.func_177952_p())));
        if (direction == Direction.UP || direction == Direction.DOWN) {
            return Direction.NORTH;
        }
        return direction;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        if (entity != null) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)CFACING, (Comparable)BlockHandInJar.getFacingFromEntity(pos, entity)), 2);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((IProperty)CFACING)) {
            case EAST: {
                return EAST;
            }
            case SOUTH: {
                return SOUTH;
            }
            case WEST: {
                return WEST;
            }
        }
        return NORTH;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{CFACING});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)super.func_196258_a(context).func_206870_a((IProperty)CFACING, (Comparable)context.func_195999_j().func_174811_aO().func_176734_d());
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return false;
        }
        if (worldIn.func_175625_s(pos) instanceof HandInJarTile) {
            HandInJarTile jar = (HandInJarTile)worldIn.func_175625_s(pos);
            boolean dataThere = RegenCap.get((Entity)player).isPresent();
            if (dataThere) {
                IRegen data = (IRegen)RegenCap.get((Entity)player).orElseGet(null);
                if (jar.getLindosAmont() >= 100 && data.getState() == PlayerUtil.RegenState.ALIVE && player.func_70093_af() && jar.hasHand()) {
                    PlayerUtil.lookAt(jar.func_174877_v().func_177958_n(), jar.func_174877_v().func_177956_o(), jar.func_174877_v().func_177952_p(), player);
                    jar.setLindosAmont(jar.getLindosAmont() - 100);
                    data.receiveRegenerations(1);
                    data.setSyncingFromJar(true);
                    jar.destroyHand();
                    worldIn.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (SoundEvent)RegenObjects.Sounds.HAND_GLOW.get(), SoundCategory.PLAYERS, 1.0f, 0.7f);
                    data.synchronise();
                    jar.sendUpdates();
                    return true;
                }
                if (data.getState() != PlayerUtil.RegenState.REGENERATING && !player.func_70093_af()) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)jar, (BlockPos)jar.func_174877_v());
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new HandInJarTile();
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_208619_r() {
        return true;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        HandInJarTile te = (HandInJarTile)worldIn.func_175625_s(pos);
        if (state.hasTileEntity() && state.func_177230_c() != newState.func_177230_c()) {
            worldIn.func_175713_t(pos);
        }
    }
}

