/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.common.capability;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import me.swirtzly.regeneration.RegenConfig;
import me.swirtzly.regeneration.Regeneration;
import me.swirtzly.regeneration.client.skinhandling.SkinInfo;
import me.swirtzly.regeneration.common.advancements.TriggerManager;
import me.swirtzly.regeneration.common.capability.IRegen;
import me.swirtzly.regeneration.common.capability.IStateManager;
import me.swirtzly.regeneration.common.traits.TraitManager;
import me.swirtzly.regeneration.common.types.RegenTypes;
import me.swirtzly.regeneration.handlers.RegenObjects;
import me.swirtzly.regeneration.handlers.acting.ActingForwarder;
import me.swirtzly.regeneration.network.NetworkDispatcher;
import me.swirtzly.regeneration.network.messages.SyncDataMessage;
import me.swirtzly.regeneration.network.messages.SyncRegenDataToClientMessage;
import me.swirtzly.regeneration.util.common.PlayerUtil;
import me.swirtzly.regeneration.util.common.RegenUtil;
import me.swirtzly.regeneration.util.common.RegenerationScheduledAction;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.Effect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import org.apache.commons.lang3.tuple.Pair;

public class RegenCap
implements IRegen {
    @CapabilityInject(value=IRegen.class)
    public static final Capability<IRegen> CAPABILITY = null;
    public static final ResourceLocation CAP_REGEN_ID = new ResourceLocation("regeneration", "regeneration");
    private final LivingEntity player;
    private final StateManager stateManager;
    private ResourceLocation traitLocation = new ResourceLocation("regeneration", "boring");
    private String deathSource = "";
    private boolean didSetup = false;
    private boolean traitActive = true;
    private PlayerUtil.RegenState state = PlayerUtil.RegenState.ALIVE;
    private String encodedSkin = RegenUtil.NO_SKIN;
    private String nextSkin = RegenUtil.NO_SKIN;
    private RegenTypes regenType = RegenTypes.FIERY;
    private HandSide cutOffHand = HandSide.LEFT;
    private SkinInfo.SkinType skinType = SkinInfo.SkinType.ALEX;
    private SkinInfo.SkinType nextSkinType = SkinInfo.SkinType.ALEX;
    private PlayerUtil.EnumChoices preferredModel = PlayerUtil.EnumChoices.EITHER;
    private float primaryRed = 0.93f;
    private float primaryGreen = 0.61f;
    private float primaryBlue = 0.0f;
    private float secondaryRed = 1.0f;
    private float secondaryGreen = 0.5f;
    private float secondaryBlue = 0.18f;
    private int ticksAnimating = 0;
    private int regenerationsLeft = 0;
    private boolean hasDroppedHand = false;
    private boolean syncingToJar = false;
    private boolean handsAreGlowingClient;

    public RegenCap() {
        this.player = null;
        this.stateManager = null;
    }

    public RegenCap(LivingEntity player) {
        this.player = player;
        this.stateManager = !player.field_70170_p.field_72995_K ? new StateManager() : null;
    }

    @Nonnull
    public static LazyOptional<IRegen> get(Entity player) {
        return player.getCapability(CAPABILITY, null);
    }

    @Override
    public void tick() {
        if (!this.didSetup && this.player.field_70170_p.field_72995_K && this.player.field_70170_p.field_73011_w.func_186058_p() != null && this.player.field_70170_p.field_73011_w.func_186058_p().getRegistryName() != null) {
            NetworkDispatcher.INSTANCE.sendToServer((Object)new SyncDataMessage((Entity)this.player));
            this.didSetup = true;
        }
        if (PlayerUtil.isAboveZeroGrid(this.player) && this.state == PlayerUtil.RegenState.POST) {
            for (Effect potion : PlayerUtil.POTIONS) {
                this.player.func_195063_d(potion);
            }
        }
        if (!this.player.field_70170_p.field_72995_K) {
            if (this.isSyncingToJar() && this.ticksAnimating >= 250) {
                this.setSyncingFromJar(false);
                this.ticksAnimating = 0;
                this.synchronise();
            } else if (this.isSyncingToJar()) {
                PlayerUtil.setPerspective((ServerPlayerEntity)this.player, true, false);
            }
        }
        this.ticksAnimating = this.state != PlayerUtil.RegenState.REGENERATING && !this.isSyncingToJar() ? 0 : ++this.ticksAnimating;
        if (this.getRegenerationsLeft() > (Integer)RegenConfig.COMMON.regenCapacity.get() && !((Boolean)RegenConfig.COMMON.infiniteRegeneration.get()).booleanValue()) {
            this.regenerationsLeft = (Integer)RegenConfig.COMMON.regenCapacity.get();
            Regeneration.LOG.info("Correcting the amount of Regenerations {} has, from {} to {}", (Object)this.player.func_200200_C_(), (Object)this.getRegenerationsLeft(), RegenConfig.COMMON.regenCapacity.get());
        }
        TraitManager.getDnaEntry(this.getTrait()).onUpdate(this);
        if (!this.player.field_70170_p.field_72995_K && this.state != PlayerUtil.RegenState.ALIVE && this.stateManager != null) {
            this.stateManager.tick();
        }
        if (this.state == PlayerUtil.RegenState.REGENERATING) {
            this.regenType.create().onUpdateMidRegen(this);
        }
    }

    @Override
    public void synchronise() {
        if (this.player != null && this.player.field_70170_p.field_72995_K) {
            throw new IllegalStateException("Don't sync client -> server");
        }
        this.handsAreGlowingClient = this.state.isGraceful() && this.stateManager.handGlowTimer.getTransition() == PlayerUtil.RegenState.Transition.HAND_GLOW_TRIGGER;
        CompoundNBT nbt = this.serializeNBT();
        nbt.func_82580_o("stateManager");
        NetworkDispatcher.sendPacketToDimension(this.player.field_71093_bK, new SyncRegenDataToClientMessage((Entity)this.player, nbt));
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("state", this.state.toString());
        nbt.func_74768_a("regenerationsLeft", this.regenerationsLeft);
        nbt.func_218657_a("style", (INBT)this.getStyle());
        if (this.regenType != null) {
            nbt.func_74778_a("regen_type", this.regenType.getRegistryName().toString());
        } else {
            this.regenType = RegenTypes.FIERY;
        }
        nbt.func_74778_a("encoded_data", this.encodedSkin);
        nbt.func_74778_a("skinType", this.skinType.name());
        nbt.func_74778_a("preferredModel", this.preferredModel.name());
        nbt.func_74757_a("handsAreGlowing", this.handsAreGlowingClient);
        if (this.traitLocation != null) {
            nbt.func_74778_a("regen_dna", this.traitLocation.toString());
        } else {
            nbt.func_74778_a("regen_dna", TraitManager.DNA_BORING.getRegistryName().toString());
        }
        nbt.func_74757_a("traitActive", this.traitActive);
        nbt.func_74768_a("ticks_animating", this.ticksAnimating);
        nbt.func_74757_a("jar", this.syncingToJar);
        if (!this.player.field_70170_p.field_72995_K) {
            nbt.func_218657_a("stateManager", (INBT)this.stateManager.serializeNBT());
        }
        nbt.func_74778_a("nextSkinType", this.nextSkinType.name());
        nbt.func_74778_a("nextSkin", this.nextSkin);
        nbt.func_74778_a("cutOffHand", this.cutOffHand.name());
        nbt.func_74757_a("hasCutOff", this.hasDroppedHand);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.regenerationsLeft = Math.min((Integer)RegenConfig.COMMON.regenCapacity.get(), nbt.func_74762_e(nbt.func_74764_b("livesLeft") ? "livesLeft" : "regenerationsLeft"));
        if (nbt.func_74764_b("skinType")) {
            this.setSkinType(nbt.func_74779_i("skinType"));
        } else {
            this.setSkinType(RegenUtil.isSlimSkin(this.player.func_110124_au()) ? "ALEX" : "STEVE");
        }
        if (nbt.func_74764_b("preferredModel")) {
            this.setPreferredModel(nbt.func_74779_i("preferredModel"));
        } else {
            this.setPreferredModel("ALEX");
        }
        if (nbt.func_74764_b("regenerationsLeft")) {
            this.regenerationsLeft = nbt.func_74762_e("regenerationsLeft");
        }
        if (nbt.func_74764_b("traitActive")) {
            this.setDnaActive(nbt.func_74767_n("traitAlive"));
        } else {
            this.setDnaActive(true);
        }
        if (nbt.func_74764_b("regen_dna")) {
            this.setTrait(new ResourceLocation(nbt.func_74779_i("regen_dna")));
        } else {
            this.setTrait(TraitManager.DNA_BORING.getRegistryName());
        }
        if (nbt.func_74764_b("handsAreGlowing")) {
            this.handsAreGlowingClient = nbt.func_74767_n("handsAreGlowing");
        }
        if (nbt.func_74764_b("ticks_animating")) {
            this.ticksAnimating = nbt.func_74762_e("ticks_animating");
        }
        this.setStyle((CompoundNBT)nbt.func_74781_a("style"));
        if (nbt.func_74764_b("regen_type")) {
            this.setRegenType((RegenTypes)RegenTypes.REGISTRY.getValue(new ResourceLocation(nbt.func_74779_i("regen_type"))));
        }
        this.state = nbt.func_74764_b("state") ? PlayerUtil.RegenState.valueOf(nbt.func_74779_i("state")) : PlayerUtil.RegenState.ALIVE;
        this.setEncodedSkin(nbt.func_74779_i("encoded_data"));
        if (nbt.func_74764_b("stateManager") && this.stateManager != null) {
            this.stateManager.deserializeNBT((CompoundNBT)nbt.func_74781_a("stateManager"));
        }
        if (nbt.func_74764_b("jar")) {
            this.syncingToJar = nbt.func_74767_n("jar");
        }
        if (nbt.func_74764_b("nextSkin")) {
            this.nextSkin = nbt.func_74779_i("nextSkin");
        }
        if (nbt.func_74764_b("nextSkinType")) {
            this.nextSkinType = SkinInfo.SkinType.valueOf(nbt.func_74779_i("nextSkinType"));
        }
        if (nbt.func_74764_b("cutOffhand")) {
            this.cutOffHand = HandSide.valueOf((String)nbt.func_74779_i("cutOffHand"));
        }
        if (nbt.func_74764_b("hasCutOff")) {
            this.hasDroppedHand = nbt.func_74767_n("hasCutOff");
        }
    }

    @Override
    public int getRegenerationsLeft() {
        return this.regenerationsLeft;
    }

    @Override
    @Deprecated
    public void setRegenerationsLeft(int amount) {
        this.regenerationsLeft = amount;
    }

    @Override
    public LivingEntity getLivingEntity() {
        return this.player;
    }

    @Override
    public String getEncodedSkin() {
        return this.encodedSkin;
    }

    @Override
    public void setEncodedSkin(String string) {
        this.encodedSkin = string;
    }

    @Override
    public CompoundNBT getStyle() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74776_a("PrimaryRed", this.primaryRed);
        nbt.func_74776_a("PrimaryGreen", this.primaryGreen);
        nbt.func_74776_a("PrimaryBlue", this.primaryBlue);
        nbt.func_74776_a("SecondaryRed", this.secondaryRed);
        nbt.func_74776_a("SecondaryGreen", this.secondaryGreen);
        nbt.func_74776_a("SecondaryBlue", this.secondaryBlue);
        return nbt;
    }

    @Override
    public void setStyle(CompoundNBT nbt) {
        this.primaryRed = nbt.func_74760_g("PrimaryRed");
        this.primaryGreen = nbt.func_74760_g("PrimaryGreen");
        this.primaryBlue = nbt.func_74760_g("PrimaryBlue");
        this.secondaryRed = nbt.func_74760_g("SecondaryRed");
        this.secondaryGreen = nbt.func_74760_g("SecondaryGreen");
        this.secondaryBlue = nbt.func_74760_g("SecondaryBlue");
    }

    @Override
    public Vec3d getPrimaryColor() {
        return new Vec3d((double)this.primaryRed, (double)this.primaryGreen, (double)this.primaryBlue);
    }

    @Override
    public Vec3d getSecondaryColor() {
        return new Vec3d((double)this.secondaryRed, (double)this.secondaryGreen, (double)this.secondaryBlue);
    }

    @Override
    public void receiveRegenerations(int amount) {
        this.regenerationsLeft = ((Boolean)RegenConfig.COMMON.infiniteRegeneration.get()).booleanValue() ? (Integer)RegenConfig.COMMON.regenCapacity.get() : (this.regenerationsLeft += amount);
        this.synchronise();
    }

    @Override
    public void extractRegeneration(int amount) {
        this.regenerationsLeft = ((Boolean)RegenConfig.COMMON.infiniteRegeneration.get()).booleanValue() ? (Integer)RegenConfig.COMMON.regenCapacity.get() : (this.regenerationsLeft -= amount);
        this.synchronise();
    }

    @Override
    public SkinInfo.SkinType getSkinType() {
        return this.skinType;
    }

    @Override
    public void setSkinType(String skinType) {
        this.skinType = SkinInfo.SkinType.valueOf(skinType);
    }

    @Override
    public PlayerUtil.EnumChoices getPreferredModel() {
        return this.preferredModel;
    }

    @Override
    public void setPreferredModel(String skinType) {
        this.preferredModel = PlayerUtil.EnumChoices.valueOf(skinType);
    }

    @Override
    public boolean areHandsGlowing() {
        return this.handsAreGlowingClient;
    }

    @Override
    public String getDeathSource() {
        return this.deathSource;
    }

    @Override
    public void setDeathSource(String source) {
        this.deathSource = source;
    }

    @Override
    public ResourceLocation getTrait() {
        return this.traitLocation;
    }

    @Override
    public void setTrait(ResourceLocation resgitryName) {
        this.traitLocation = resgitryName;
    }

    @Override
    public boolean isDnaActive() {
        return this.traitActive;
    }

    @Override
    public void setDnaActive(boolean alive) {
        this.traitActive = alive;
    }

    @Override
    public int getAnimationTicks() {
        return this.ticksAnimating;
    }

    @Override
    public void setAnimationTicks(int ticks) {
        this.ticksAnimating = ticks;
    }

    @Override
    public void setSyncingFromJar(boolean syncing) {
        this.syncingToJar = syncing;
    }

    @Override
    public boolean isSyncingToJar() {
        return this.syncingToJar;
    }

    @Override
    public SkinInfo.SkinType getNextSkinType() {
        return this.nextSkinType;
    }

    @Override
    public void setNextSkinType(SkinInfo.SkinType skinType) {
        this.nextSkinType = skinType;
    }

    @Override
    public String getNextSkin() {
        return this.nextSkin;
    }

    @Override
    public void setNextSkin(String encodedSkin) {
        this.nextSkin = encodedSkin;
    }

    @Override
    public boolean hasDroppedHand() {
        return this.hasDroppedHand;
    }

    @Override
    public void setDroppedHand(boolean droppedHand) {
        this.hasDroppedHand = droppedHand;
    }

    @Override
    public HandSide getCutoffHand() {
        return this.cutOffHand;
    }

    @Override
    public void setCutOffHand(HandSide side) {
        this.cutOffHand = side;
    }

    @Override
    public IStateManager getStateManager() {
        return this.stateManager;
    }

    @Override
    public PlayerUtil.RegenState getState() {
        return this.state;
    }

    @Override
    public RegenTypes getRegenType() {
        return this.regenType;
    }

    @Override
    public void setRegenType(RegenTypes type) {
        this.regenType = type;
    }

    @Override
    public void triggerRegeneration() {
        if (this.player.field_70170_p.field_72995_K) {
            throw new IllegalStateException("Triggering regeneration via capability instance on the client side");
        }
        this.stateManager.triggerRegeneration();
    }

    public class StateManager
    implements IStateManager {
        private final Map<PlayerUtil.RegenState.Transition, Runnable> transitionCallbacks = new HashMap<PlayerUtil.RegenState.Transition, Runnable>();
        private RegenerationScheduledAction nextTransition;
        private RegenerationScheduledAction handGlowTimer;

        private StateManager() {
            this.transitionCallbacks.put(PlayerUtil.RegenState.Transition.ENTER_CRITICAL, this::enterCriticalPhase);
            this.transitionCallbacks.put(PlayerUtil.RegenState.Transition.CRITICAL_DEATH, this::midSequenceKill);
            this.transitionCallbacks.put(PlayerUtil.RegenState.Transition.FINISH_REGENERATION, this::finishRegeneration);
            this.transitionCallbacks.put(PlayerUtil.RegenState.Transition.END_POST, this::endPost);
            Runnable err = () -> {
                throw new IllegalStateException("Can't use HAND_GLOW_* transitions as state transitions");
            };
            this.transitionCallbacks.put(PlayerUtil.RegenState.Transition.HAND_GLOW_START, err);
            this.transitionCallbacks.put(PlayerUtil.RegenState.Transition.HAND_GLOW_TRIGGER, err);
        }

        private void scheduleTransitionInTicks(PlayerUtil.RegenState.Transition transition, long inTicks) {
            if (this.nextTransition != null && this.nextTransition.getTicksLeft() > 0L) {
                throw new IllegalStateException("Overwriting non-completed/cancelled transition: \n Attempted Transition: " + transition.name() + "\n Current: " + this.nextTransition.transition.name() + "\n Affected Player: " + RegenCap.this.player.func_200200_C_());
            }
            if (transition == PlayerUtil.RegenState.Transition.HAND_GLOW_START || transition == PlayerUtil.RegenState.Transition.HAND_GLOW_TRIGGER) {
                throw new IllegalStateException("Can't use HAND_GLOW_* transitions as state transitions");
            }
            this.nextTransition = new RegenerationScheduledAction(transition, RegenCap.this.player, this.transitionCallbacks.get((Object)transition), inTicks);
        }

        private void scheduleTransitionInSeconds(PlayerUtil.RegenState.Transition transition, long inSeconds) {
            this.scheduleTransitionInTicks(transition, inSeconds * 20L);
        }

        private void scheduleNextHandGlow() {
            if (RegenCap.this.state.isGraceful() && this.handGlowTimer.getTicksLeft() > 0L) {
                throw new IllegalStateException("Overwriting running hand-glow timer with new next hand glow");
            }
            this.handGlowTimer = new RegenerationScheduledAction(PlayerUtil.RegenState.Transition.HAND_GLOW_START, RegenCap.this.player, this::scheduleHandGlowTrigger, (Integer)RegenConfig.COMMON.handGlowInterval.get() * 20);
            RegenCap.this.synchronise();
        }

        private void scheduleHandGlowTrigger() {
            if (RegenCap.this.state.isGraceful() && this.handGlowTimer.getTicksLeft() > 0L) {
                throw new IllegalStateException("Overwriting running hand-glow timer with trigger timer prematurely");
            }
            this.handGlowTimer = new RegenerationScheduledAction(PlayerUtil.RegenState.Transition.HAND_GLOW_TRIGGER, RegenCap.this.player, this::triggerRegeneration, (Integer)RegenConfig.COMMON.handGlowTriggerDelay.get() * 20);
            ActingForwarder.onHandsStartGlowing(RegenCap.this);
            RegenCap.this.synchronise();
        }

        @Override
        public boolean onKilled(DamageSource source) {
            if (source == DamageSource.field_76368_d || source == DamageSource.field_191291_g) {
                return false;
            }
            if (RegenCap.this.state == PlayerUtil.RegenState.ALIVE) {
                if (!RegenCap.this.canRegenerate()) {
                    return false;
                }
                this.scheduleTransitionInSeconds(PlayerUtil.RegenState.Transition.ENTER_CRITICAL, ((Integer)RegenConfig.COMMON.gracePhaseLength.get()).intValue());
                this.scheduleHandGlowTrigger();
                RegenCap.this.state = PlayerUtil.RegenState.GRACE;
                RegenCap.this.synchronise();
                ActingForwarder.onEnterGrace(RegenCap.this);
                return true;
            }
            if (RegenCap.this.state == PlayerUtil.RegenState.GRACE || RegenCap.this.state == PlayerUtil.RegenState.GRACE_CRIT) {
                this.triggerRegeneration();
                return true;
            }
            if (RegenCap.this.state == PlayerUtil.RegenState.REGENERATING) {
                this.nextTransition.cancel();
                this.midSequenceKill();
                return false;
            }
            if (RegenCap.this.state == PlayerUtil.RegenState.POST) {
                RegenCap.this.state = PlayerUtil.RegenState.ALIVE;
                this.nextTransition.cancel();
                this.midSequenceKill();
                return false;
            }
            throw new IllegalStateException("Unknown state: " + (Object)((Object)RegenCap.this.state));
        }

        @Override
        public void onPunchEntity(LivingHurtEvent event) {
            LivingEntity entity = event.getEntityLiving();
            if (RegenCap.this.state.isGraceful() && entity.func_110143_aJ() < entity.func_110138_aP() && RegenCap.this.areHandsGlowing() && RegenCap.this.player.func_70093_af()) {
                float healthNeeded = entity.func_110138_aP() - entity.func_110143_aJ();
                entity.func_70691_i(healthNeeded);
                if (RegenCap.this.player instanceof PlayerEntity) {
                    PlayerUtil.sendMessage(RegenCap.this.player, new TranslationTextComponent("regeneration.messages.healed", new Object[]{entity.func_200200_C_()}), true);
                }
                event.setAmount(0.0f);
                RegenCap.this.player.func_70097_a(RegenObjects.REGEN_DMG_HEALING, healthNeeded);
            }
        }

        @Override
        public void onPunchBlock(PlayerInteractEvent.LeftClickBlock e) {
            if (RegenCap.this.getState().isGraceful() && RegenCap.this.areHandsGlowing()) {
                BlockState block = e.getWorld().func_180495_p(e.getPos());
                if (block.func_177230_c() == Blocks.field_150433_aE || block.func_177230_c() == Blocks.field_196604_cC) {
                    e.getWorld().func_184133_a(null, e.getPos(), SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                this.handGlowTimer.cancel();
                this.scheduleNextHandGlow();
                if (!((RegenCap)RegenCap.this).player.field_70170_p.field_72995_K && RegenCap.this.player instanceof PlayerEntity) {
                    TriggerManager.CHANGE_REFUSAL.trigger((ServerPlayerEntity)RegenCap.this.player);
                    PlayerUtil.sendMessage(RegenCap.this.player, new TranslationTextComponent("regeneration.messages.regen_delayed", new Object[0]), true);
                }
                e.setCanceled(true);
            }
        }

        private void tick() {
            if (((RegenCap)RegenCap.this).player.field_70170_p.field_72995_K) {
                throw new IllegalStateException("Ticking state manager on the client");
            }
            if (RegenCap.this.state == PlayerUtil.RegenState.ALIVE) {
                throw new IllegalStateException("Ticking dormant state manager (state == ALIVE)");
            }
            if (RegenCap.this.state.isGraceful()) {
                this.handGlowTimer.tick();
            }
            ActingForwarder.onRegenTick(RegenCap.this);
            this.nextTransition.tick();
            if (RegenCap.this.state == PlayerUtil.RegenState.POST) {
                ActingForwarder.onPerformingPost(RegenCap.this);
            }
        }

        private void triggerRegeneration() {
            RegenCap.this.state = PlayerUtil.RegenState.REGENERATING;
            if (((Boolean)RegenConfig.COMMON.sendRegenDeathMessages.get()).booleanValue() && RegenCap.this.getLivingEntity() instanceof PlayerEntity) {
                TranslationTextComponent text = new TranslationTextComponent("regeneration.messages.regen_chat_message", new Object[]{RegenCap.this.player.func_200200_C_()});
                text.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new StringTextComponent(RegenCap.this.getDeathSource())));
                PlayerUtil.sendMessageToAll(text);
            }
            this.nextTransition.cancel();
            if (RegenCap.this.state.isGraceful()) {
                this.handGlowTimer.cancel();
            }
            this.scheduleTransitionInTicks(PlayerUtil.RegenState.Transition.FINISH_REGENERATION, RegenCap.this.regenType.create().getAnimationLength());
            ActingForwarder.onRegenTrigger(RegenCap.this);
            RegenCap.this.regenType.create().onStartRegeneration(RegenCap.this);
            RegenCap.this.synchronise();
        }

        private void enterCriticalPhase() {
            RegenCap.this.state = PlayerUtil.RegenState.GRACE_CRIT;
            this.scheduleTransitionInSeconds(PlayerUtil.RegenState.Transition.CRITICAL_DEATH, ((Integer)RegenConfig.COMMON.criticalPhaseLength.get()).intValue());
            ActingForwarder.onGoCritical(RegenCap.this);
            RegenCap.this.synchronise();
        }

        private void midSequenceKill() {
            RegenCap.this.state = PlayerUtil.RegenState.ALIVE;
            this.nextTransition = null;
            this.handGlowTimer = null;
            RegenCap.this.regenType.create().onFinishRegeneration(RegenCap.this);
            if (RegenCap.this.state == PlayerUtil.RegenState.GRACE_CRIT) {
                RegenCap.this.player.func_70097_a(RegenObjects.REGEN_DMG_CRITICAL, 2.1474836E9f);
            } else {
                RegenCap.this.player.func_70097_a(RegenObjects.REGEN_DMG_KILLED, 2.1474836E9f);
            }
            RegenCap.this.setTrait(TraitManager.DNA_BORING.getRegistryName());
            if (((Boolean)RegenConfig.COMMON.loseRegensOnDeath.get()).booleanValue()) {
                RegenCap.this.extractRegeneration(RegenCap.this.getRegenerationsLeft());
            }
            RegenCap.this.synchronise();
        }

        private void endPost() {
            RegenCap.this.state = PlayerUtil.RegenState.ALIVE;
            RegenCap.this.synchronise();
            this.nextTransition = null;
            if (RegenCap.this.player instanceof PlayerEntity) {
                PlayerUtil.sendMessage(RegenCap.this.player, new TranslationTextComponent("regeneration.messages.post_ended", new Object[0]), true);
            }
            RegenCap.this.setDroppedHand(false);
        }

        private void finishRegeneration() {
            RegenCap.this.state = PlayerUtil.RegenState.POST;
            this.scheduleTransitionInSeconds(PlayerUtil.RegenState.Transition.END_POST, ((RegenCap)RegenCap.this).player.field_70170_p.field_73012_v.nextInt(300));
            this.handGlowTimer = null;
            RegenCap.this.regenType.create().onFinishRegeneration(RegenCap.this);
            ActingForwarder.onRegenFinish(RegenCap.this);
            RegenCap.this.synchronise();
        }

        @Override
        @Deprecated
        public Pair<PlayerUtil.RegenState.Transition, Long> getScheduledEvent() {
            return this.nextTransition == null ? null : Pair.of((Object)((Object)this.nextTransition.transition), (Object)this.nextTransition.getTicksLeft());
        }

        @Override
        @Deprecated
        public void fastForward() {
            while (!this.nextTransition.tick()) {
            }
        }

        @Override
        @Deprecated
        public void fastForwardHandGlow() {
            while (!this.handGlowTimer.tick()) {
            }
        }

        @Override
        public double getStateProgress() {
            return this.nextTransition.getProgress();
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT nbt = new CompoundNBT();
            if (this.nextTransition != null && this.nextTransition.getTicksLeft() >= 0L) {
                nbt.func_74778_a("transitionId", this.nextTransition.transition.toString());
                nbt.func_74772_a("transitionInTicks", this.nextTransition.getTicksLeft());
            }
            if (this.handGlowTimer != null && this.handGlowTimer.getTicksLeft() >= 0L) {
                nbt.func_74778_a("handGlowState", this.handGlowTimer.transition.toString());
                nbt.func_74772_a("handGlowScheduledTicks", this.handGlowTimer.getTicksLeft());
            }
            return nbt;
        }

        public void deserializeNBT(CompoundNBT nbt) {
            if (nbt.func_74764_b("transitionId")) {
                this.scheduleTransitionInTicks(PlayerUtil.RegenState.Transition.valueOf(nbt.func_74779_i("transitionId")), nbt.func_74763_f("transitionInTicks"));
            }
            if (nbt.func_74764_b("handGlowState")) {
                Runnable callback;
                PlayerUtil.RegenState.Transition transition = PlayerUtil.RegenState.Transition.valueOf(nbt.func_74779_i("handGlowState"));
                if (transition == PlayerUtil.RegenState.Transition.HAND_GLOW_START) {
                    callback = this::scheduleHandGlowTrigger;
                } else if (transition == PlayerUtil.RegenState.Transition.HAND_GLOW_TRIGGER) {
                    callback = this::triggerRegeneration;
                } else {
                    throw new IllegalStateException("Illegal hand glow timer transition");
                }
                this.handGlowTimer = new RegenerationScheduledAction(transition, RegenCap.this.player, callback, nbt.func_74763_f("handGlowScheduledTicks"));
            }
        }
    }
}

