/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.common.dimension;

import javax.annotation.Nullable;
import me.swirtzly.regeneration.common.dimension.util.GallifreyBiomeProviderNew;
import me.swirtzly.regeneration.common.dimension.util.GallifreyanSkyRenderer;
import me.swirtzly.regeneration.handlers.RegenObjects;
import net.minecraft.block.BlockState;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.ChunkGeneratorType;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.IRenderHandler;

public class GallifreyDimension
extends Dimension {
    public GallifreyDimension(World worldIn, DimensionType typeIn) {
        super(worldIn, typeIn);
    }

    public ChunkGenerator<?> func_186060_c() {
        OverworldGenSettings gensettings = new OverworldGenSettings();
        GallifreyBiomeProviderNew biomes = new GallifreyBiomeProviderNew(this.field_76579_a, RegenObjects.GallifreyBiomes.getBiomes());
        return ((ChunkGeneratorType)RegenObjects.ChunkGeneratorTypes.GALLIFREY_CHUNKS.get()).create(this.field_76579_a, (BiomeProvider)biomes, (GenerationSettings)gensettings);
    }

    public void resetRainAndThunder() {
        this.field_76579_a.func_72912_H().func_76080_g(0);
        this.field_76579_a.func_72912_H().func_76084_b(false);
        this.field_76579_a.func_72912_H().func_76090_f(0);
        this.field_76579_a.func_72912_H().func_76069_a(false);
    }

    public void updateWeather(Runnable defaultLogic) {
        super.updateWeather(defaultLogic);
    }

    public BlockPos func_206920_a(ChunkPos chunkPosIn, boolean checkValid) {
        for (int i = chunkPosIn.func_180334_c(); i <= chunkPosIn.func_180332_e(); ++i) {
            for (int j = chunkPosIn.func_180333_d(); j <= chunkPosIn.func_180330_f(); ++j) {
                BlockPos blockpos = this.func_206921_a(i, j, checkValid);
                if (blockpos == null) continue;
                return blockpos;
            }
        }
        return null;
    }

    public BlockPos func_206921_a(int posX, int posZ, boolean checkValid) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(posX, 0, posZ);
        Biome biome = this.field_76579_a.func_180494_b((BlockPos)blockpos$mutableblockpos);
        BlockState blockstate = biome.func_203944_q().func_204108_a();
        if (checkValid && !blockstate.func_177230_c().func_203417_a(BlockTags.field_205599_H)) {
            return null;
        }
        Chunk chunk = this.field_76579_a.func_212866_a_(posX >> 4, posZ >> 4);
        int i = chunk.func_201576_a(Heightmap.Type.MOTION_BLOCKING, posX & 0xF, posZ & 0xF);
        if (i < 0) {
            return null;
        }
        if (chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE, posX & 0xF, posZ & 0xF) > chunk.func_201576_a(Heightmap.Type.OCEAN_FLOOR, posX & 0xF, posZ & 0xF)) {
            return null;
        }
        for (int j = i + 1; j >= 0; --j) {
            blockpos$mutableblockpos.func_181079_c(posX, j, posZ);
            BlockState blockstate1 = this.field_76579_a.func_180495_p((BlockPos)blockpos$mutableblockpos);
            if (!blockstate1.func_204520_s().func_206888_e()) break;
            if (!blockstate1.equals((Object)blockstate)) continue;
            return blockpos$mutableblockpos.func_177984_a().func_185334_h();
        }
        return null;
    }

    public float func_76563_a(long worldTime, float partialTicks) {
        double d0 = MathHelper.func_181162_h((double)((double)worldTime / 24000.0 - 0.25));
        double d1 = 0.5 - Math.cos(d0 * Math.PI) / 2.0;
        return (float)(d0 * 2.0 + d1) / 3.0f;
    }

    public boolean func_76569_d() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3d func_76562_b(float celestialAngle, float partialTicks) {
        float f = MathHelper.func_76134_b((float)(celestialAngle * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        float f1 = 0.7f;
        float f2 = 0.4f;
        float f3 = 0.2f;
        return new Vec3d((double)(f1 *= f * 0.94f + 0.06f), (double)(f2 *= f * 0.94f + 0.06f), (double)(f3 *= f * 0.91f + 0.09f));
    }

    public boolean func_76567_e() {
        return true;
    }

    public boolean func_76568_b(int x, int z) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_76561_g() {
        return true;
    }

    public Vec3d getSkyColor(BlockPos cameraPos, float partialTicks) {
        float f10;
        float f = this.field_76579_a.func_72826_c(partialTicks);
        float f1 = MathHelper.func_76134_b((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f1 = MathHelper.func_76131_a((float)f1, (float)0.0f, (float)1.0f);
        int i = ForgeHooksClient.getSkyBlendColour((World)this.field_76579_a, (BlockPos)cameraPos);
        float f3 = 0.7f;
        float f4 = 0.4f;
        float f5 = 0.2f;
        f3 *= f1;
        f4 *= f1;
        f5 *= f1;
        float f6 = this.field_76579_a.func_72867_j(partialTicks);
        if (f6 > 0.0f) {
            float f7 = (f3 * 0.3f + f4 * 0.59f + f5 * 0.11f) * 0.6f;
            float f8 = 1.0f - f6 * 0.75f;
            f3 = f3 * f8 + f7 * (1.0f - f8);
            f4 = f4 * f8 + f7 * (1.0f - f8);
            f5 = f5 * f8 + f7 * (1.0f - f8);
        }
        if ((f10 = this.field_76579_a.func_72819_i(partialTicks)) > 0.0f) {
            float f11 = (f3 * 0.3f + f4 * 0.59f + f5 * 0.11f) * 0.2f;
            float f9 = 1.0f - f10 * 0.75f;
            f3 = f3 * f9 + f11 * (1.0f - f9);
            f4 = f4 * f9 + f11 * (1.0f - f9);
            f5 = f5 * f9 + f11 * (1.0f - f9);
        }
        if (this.field_76579_a.func_175658_ac() > 0) {
            float f12 = (float)this.field_76579_a.func_175658_ac() - partialTicks;
            if (f12 > 1.0f) {
                f12 = 1.0f;
            }
            f3 = f3 * (1.0f - (f12 *= 0.45f)) + 0.8f * f12;
            f4 = f4 * (1.0f - f12) + 0.8f * f12;
            f5 = f5 * (1.0f - f12) + 1.0f * f12;
        }
        return new Vec3d((double)f3, (double)f4, (double)f5);
    }

    @Nullable
    public IRenderHandler getSkyRenderer() {
        return GallifreyanSkyRenderer.getInstance();
    }

    @Nullable
    public IRenderHandler getCloudRenderer() {
        return null;
    }

    public float func_76571_f() {
        return 150.0f;
    }

    public Vec3d getCloudColor(float partialTicks) {
        return new Vec3d(0.9, 0.3, 0.1);
    }

    public boolean func_191066_m() {
        return true;
    }

    public long getSeed() {
        return -3968030346439409757L;
    }

    @Nullable
    public MusicTicker.MusicType getMusicType() {
        return null;
    }
}

