/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.common.dimension.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.LongFunction;
import javax.annotation.Nullable;
import me.swirtzly.regeneration.handlers.RegenObjects;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.LazyAreaLayerContext;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.carver.CaveWorldCarver;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.layer.IslandLayer;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.VoroniZoomLayer;
import net.minecraft.world.gen.layer.ZoomLayer;
import net.minecraft.world.gen.layer.traits.IC0Transformer;

public class GallifreyBiomeProviderNew
extends BiomeProvider {
    private final Layer genBiomes;
    private final Layer biomeFactoryLayer;
    private final Biome[] biomes;

    public GallifreyBiomeProviderNew(World world, Biome[] dimensionBiomes) {
        Layer[] aLayer = this.makeTheWorld(world.func_72905_C());
        this.genBiomes = aLayer[0];
        this.biomeFactoryLayer = aLayer[1];
        for (final Biome biome : this.biomes = dimensionBiomes) {
            biome.func_203609_a(GenerationStage.Carving.AIR, Biome.func_203606_a((WorldCarver)new CaveWorldCarver(ProbabilityConfig::func_214645_a, 256){
                {
                    super(x0, x1);
                    this.field_222718_j = ImmutableSet.of((Object)Blocks.field_150346_d.func_176223_P().func_177230_c(), (Object)biome.func_205401_q().func_215452_a().func_204108_a().func_177230_c(), (Object)biome.func_205401_q().func_215452_a().func_204109_b().func_177230_c());
                }
            }, (ICarverConfig)new ProbabilityConfig(0.14285715f)));
        }
    }

    private Layer[] makeTheWorld(long seed) {
        LongFunction<IExtendedNoiseRandom> contextFactory = l -> new LazyAreaLayerContext(25, seed, l);
        IAreaFactory parentLayer = IslandLayer.INSTANCE.func_202823_a(contextFactory.apply(1L));
        IAreaFactory biomeLayer = new BiomeLayerCustom(RegenObjects.GallifreyBiomes.getBiomes()).func_202713_a(contextFactory.apply(200L), parentLayer);
        biomeLayer = ZoomLayer.NORMAL.func_202713_a(contextFactory.apply(1000L), biomeLayer);
        biomeLayer = ZoomLayer.NORMAL.func_202713_a(contextFactory.apply(1001L), biomeLayer);
        biomeLayer = ZoomLayer.NORMAL.func_202713_a(contextFactory.apply(1002L), biomeLayer);
        biomeLayer = ZoomLayer.NORMAL.func_202713_a(contextFactory.apply(1003L), biomeLayer);
        biomeLayer = ZoomLayer.NORMAL.func_202713_a(contextFactory.apply(1004L), biomeLayer);
        biomeLayer = ZoomLayer.NORMAL.func_202713_a(contextFactory.apply(1005L), biomeLayer);
        IAreaFactory voronoizoom = VoroniZoomLayer.INSTANCE.func_202713_a(contextFactory.apply(10L), biomeLayer);
        return new Layer[]{new Layer(biomeLayer), new Layer(voronoizoom)};
    }

    public Biome func_201545_a(int x, int y) {
        return this.biomeFactoryLayer.func_215738_a(x, y);
    }

    public Biome func_222366_b(int p_222366_1_, int p_222366_2_) {
        return this.genBiomes.func_215738_a(p_222366_1_, p_222366_2_);
    }

    public Biome[] func_201537_a(int x, int z, int width, int length, boolean cacheFlag) {
        return this.biomeFactoryLayer.func_202833_a(x, z, width, length);
    }

    public Set<Biome> func_201538_a(int centerX, int centerZ, int sideLength) {
        int i = centerX - sideLength >> 2;
        int j = centerZ - sideLength >> 2;
        int k = centerX + sideLength >> 2;
        int l = centerZ + sideLength >> 2;
        int i1 = k - i + 1;
        int j1 = l - j + 1;
        HashSet set = Sets.newHashSet();
        Collections.addAll(set, this.genBiomes.func_202833_a(i, j, i1, j1));
        return set;
    }

    @Nullable
    public BlockPos func_180630_a(int x, int z, int range, List<Biome> biomes, Random random) {
        int i = x - range >> 2;
        int j = z - range >> 2;
        int k = x + range >> 2;
        int l = z + range >> 2;
        int i1 = k - i + 1;
        int j1 = l - j + 1;
        Biome[] abiome = this.genBiomes.func_202833_a(i, j, i1, j1);
        BlockPos blockpos = null;
        int k1 = 0;
        for (int l1 = 0; l1 < i1 * j1; ++l1) {
            int i2 = i + l1 % i1 << 2;
            int j2 = j + l1 / i1 << 2;
            if (!biomes.contains(abiome[l1])) continue;
            if (blockpos == null || random.nextInt(k1 + 1) == 0) {
                blockpos = new BlockPos(i2, 0, j2);
            }
            ++k1;
        }
        return blockpos;
    }

    public boolean func_205004_a(Structure<?> structureIn) {
        return this.field_205005_a.computeIfAbsent(structureIn, p_205006_1_ -> {
            for (Biome biome : this.biomes) {
                if (!biome.func_201858_a(p_205006_1_)) continue;
                return true;
            }
            return false;
        });
    }

    public Set<BlockState> func_205706_b() {
        if (this.field_205707_b.isEmpty()) {
            for (Biome biome : this.biomes) {
                this.field_205707_b.add(biome.func_203944_q().func_204108_a());
            }
        }
        return this.field_205707_b;
    }

    public static class BiomeLayerCustom
    implements IC0Transformer {
        private final Biome[] biomes;

        public BiomeLayerCustom(Biome[] biomes) {
            this.biomes = biomes;
        }

        public int func_202726_a(INoiseRandom context, int value) {
            return Registry.field_212624_m.func_148757_b((Object)this.biomes[context.func_202696_a(this.biomes.length)]);
        }
    }
}

