/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.common.dimension.util;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Random;
import me.swirtzly.regeneration.common.dimension.biomes.GallifrayanWastelands;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.IRenderHandler;

public class GallifreyanSkyRenderer
implements IRenderHandler {
    private static final ResourceLocation MOON_PHASES_TEXTURES = new ResourceLocation("textures/environment/moon_phases.png");
    private static final ResourceLocation OG = new ResourceLocation("textures/environment/sun.png");
    private static GallifreyanSkyRenderer INSTANCE;
    private final TextureManager renderEngine = Minecraft.func_71410_x().func_110434_K();
    private final VertexFormat vertexBufferFormat;
    private final boolean vboEnabled;
    private VertexBuffer starVBO;
    private VertexBuffer skyVBO;
    private VertexBuffer sky2VBO;
    private int starGLCallList = -1;
    private int glSkyList = -1;
    private int glSkyList2 = -1;

    public GallifreyanSkyRenderer() {
        this.vboEnabled = Minecraft.func_71410_x().field_71474_y.field_225307_E;
        this.vertexBufferFormat = new VertexFormat();
        this.vertexBufferFormat.func_181721_a(new VertexFormatElement(0, VertexFormatElement.Type.FLOAT, VertexFormatElement.Usage.POSITION, 3));
        this.generateStars();
        this.generateSky();
        this.generateSky2();
    }

    public static GallifreyanSkyRenderer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new GallifreyanSkyRenderer();
        }
        return INSTANCE;
    }

    private void generateStars() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        if (this.starVBO != null) {
            this.starVBO.func_177362_c();
        }
        if (this.starGLCallList >= 0) {
            GLAllocation.func_74523_b((int)this.starGLCallList);
            this.starGLCallList = -1;
        }
        if (this.vboEnabled) {
            this.starVBO = new VertexBuffer(this.vertexBufferFormat);
            this.renderStars(bufferbuilder);
            bufferbuilder.func_178977_d();
            bufferbuilder.func_178965_a();
            this.starVBO.func_181722_a(bufferbuilder.func_178966_f());
        } else {
            this.starGLCallList = GLAllocation.func_74526_a((int)1);
            GlStateManager.pushMatrix();
            GlStateManager.newList((int)this.starGLCallList, (int)4864);
            this.renderStars(bufferbuilder);
            tessellator.func_78381_a();
            GlStateManager.endList();
            GlStateManager.popMatrix();
        }
    }

    private void renderStars(BufferBuilder bufferBuilderIn) {
        Random random = new Random(10842L);
        bufferBuilderIn.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (int i = 0; i < 1500; ++i) {
            double d0 = random.nextFloat() * 2.0f - 1.0f;
            double d1 = random.nextFloat() * 2.0f - 1.0f;
            double d2 = random.nextFloat() * 2.0f - 1.0f;
            double d3 = 0.15f + random.nextFloat() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (d0 *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d0, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = random.nextDouble() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d17 = 0.0;
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d20 = 0.0;
                double d21 = d18 * d16 - d19 * d15;
                double d22 = d19 * d16 + d18 * d15;
                double d23 = d21 * d12 + 0.0 * d13;
                double d24 = 0.0 * d12 - d21 * d13;
                double d25 = d24 * d9 - d22 * d10;
                double d26 = d22 * d9 + d24 * d10;
                bufferBuilderIn.func_181662_b(d5 + d25, d6 + d23, d7 + d26).func_181675_d();
            }
        }
    }

    private void generateSky2() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        if (this.sky2VBO != null) {
            this.sky2VBO.func_177362_c();
        }
        if (this.glSkyList2 >= 0) {
            GLAllocation.func_74523_b((int)this.glSkyList2);
            this.glSkyList2 = -1;
        }
        if (this.vboEnabled) {
            this.sky2VBO = new VertexBuffer(this.vertexBufferFormat);
            this.renderSky(bufferbuilder, -16.0f, true);
            bufferbuilder.func_178977_d();
            bufferbuilder.func_178965_a();
            this.sky2VBO.func_181722_a(bufferbuilder.func_178966_f());
        } else {
            this.glSkyList2 = GLAllocation.func_74526_a((int)1);
            GlStateManager.newList((int)this.glSkyList2, (int)4864);
            this.renderSky(bufferbuilder, -16.0f, true);
            tessellator.func_78381_a();
            GlStateManager.endList();
        }
    }

    private void generateSky() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        if (this.skyVBO != null) {
            this.skyVBO.func_177362_c();
        }
        if (this.glSkyList >= 0) {
            GLAllocation.func_74523_b((int)this.glSkyList);
            this.glSkyList = -1;
        }
        if (this.vboEnabled) {
            this.skyVBO = new VertexBuffer(this.vertexBufferFormat);
            this.renderSky(bufferbuilder, 16.0f, false);
            bufferbuilder.func_178977_d();
            bufferbuilder.func_178965_a();
            this.skyVBO.func_181722_a(bufferbuilder.func_178966_f());
        } else {
            this.glSkyList = GLAllocation.func_74526_a((int)1);
            GlStateManager.newList((int)this.glSkyList, (int)4864);
            this.renderSky(bufferbuilder, 16.0f, false);
            tessellator.func_78381_a();
            GlStateManager.endList();
        }
    }

    private void renderSky(BufferBuilder bufferBuilderIn, float posY, boolean reverseX) {
        bufferBuilderIn.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (int k = -384; k <= 384; k += 50) {
            for (int l = -384; l <= 384; l += 50) {
                float f = k;
                float f1 = k + 50;
                if (reverseX) {
                    f1 = k;
                    f = k + 50;
                }
                bufferBuilderIn.func_181662_b((double)f, (double)posY, (double)l).func_181675_d();
                bufferBuilderIn.func_181662_b((double)f1, (double)posY, (double)l).func_181675_d();
                bufferBuilderIn.func_181662_b((double)f1, (double)posY, (double)(l + 50)).func_181675_d();
                bufferBuilderIn.func_181662_b((double)f, (double)posY, (double)(l + 50)).func_181675_d();
            }
        }
    }

    public void render(int ticks, float partialTicks, ClientWorld world, Minecraft mc) {
        ClientPlayerEntity player;
        GlStateManager.disableTexture();
        Vec3d vec3d = world.func_217382_a(mc.func_175606_aa().func_180425_c(), partialTicks);
        float f = (float)vec3d.field_72450_a;
        float f1 = (float)vec3d.field_72448_b;
        float f2 = (float)vec3d.field_72449_c;
        GlStateManager.color3f((float)f, (float)f1, (float)f2);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.depthMask((boolean)false);
        GlStateManager.enableFog();
        GlStateManager.color3f((float)f, (float)f1, (float)f2);
        if (this.vboEnabled) {
            this.skyVBO.func_177359_a();
            GlStateManager.enableClientState((int)32884);
            GlStateManager.vertexPointer((int)3, (int)5126, (int)12, (int)0);
            this.skyVBO.func_177358_a(7);
            VertexBuffer.func_177361_b();
            GlStateManager.disableClientState((int)32884);
        } else {
            GlStateManager.callList((int)this.glSkyList);
        }
        GlStateManager.disableFog();
        GlStateManager.disableAlphaTest();
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderHelper.func_74518_a();
        float[] afloat = world.field_73011_w.func_76560_a(world.func_72826_c(partialTicks), partialTicks);
        if (afloat != null) {
            GlStateManager.disableTexture();
            GlStateManager.shadeModel((int)7425);
            GlStateManager.pushMatrix();
            GlStateManager.rotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.rotatef((float)(MathHelper.func_76126_a((float)world.func_72929_e(partialTicks)) < 0.0f ? 180.0f : 0.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            float f6 = afloat[0];
            float f7 = afloat[1];
            float f8 = afloat[2];
            bufferbuilder.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            bufferbuilder.func_181662_b(0.0, 100.0, 0.0).func_181666_a(f6, f7, f8, afloat[3]).func_181675_d();
            for (int j2 = 0; j2 <= 16; ++j2) {
                float f21 = (float)j2 * ((float)Math.PI * 2) / 16.0f;
                float f12 = MathHelper.func_76126_a((float)f21);
                float f13 = MathHelper.func_76134_b((float)f21);
                bufferbuilder.func_181662_b((double)(f12 * 120.0f), (double)(f13 * 120.0f), (double)(-f13 * 40.0f * afloat[3])).func_181666_a(afloat[0], afloat[1], afloat[2], 0.0f).func_181675_d();
            }
            tessellator.func_78381_a();
            GlStateManager.popMatrix();
            GlStateManager.shadeModel((int)7424);
        }
        GlStateManager.enableTexture();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.pushMatrix();
        float f16 = 1.0f - world.func_72867_j(partialTicks);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f16);
        GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)(world.func_72826_c(partialTicks) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        float f17 = 30.0f;
        GlStateManager.pushMatrix();
        this.renderEngine.func_110577_a(OG);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)(-f17), 100.0, (double)(-f17)).func_187315_a(0.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)f17, 100.0, (double)(-f17)).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)f17, 100.0, (double)f17).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)(-f17), 100.0, (double)f17).func_187315_a(0.0, 1.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)34.0f, (float)0.0f, (float)0.0f);
        GlStateManager.translatef((float)0.0f, (float)0.0f, (float)-18.0f);
        this.renderEngine.func_110577_a(OG);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)(-f17), 100.0, (double)(-f17)).func_187315_a(0.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)f17, 100.0, (double)(-f17)).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)f17, 100.0, (double)f17).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)(-f17), 100.0, (double)f17).func_187315_a(0.0, 1.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.popMatrix();
        f17 = 20.0f;
        this.renderEngine.func_110577_a(MOON_PHASES_TEXTURES);
        int k1 = world.func_72853_d();
        int i2 = k1 % 4;
        int k2 = k1 / 4 % 2;
        float f22 = (float)(i2 + 0) / 4.0f;
        float f23 = (float)(k2 + 0) / 2.0f;
        float f24 = (float)(i2 + 1) / 4.0f;
        float f14 = (float)(k2 + 1) / 2.0f;
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)(-f17), -100.0, (double)f17).func_187315_a((double)f24, (double)f14).func_181675_d();
        bufferbuilder.func_181662_b((double)f17, -100.0, (double)f17).func_187315_a((double)f22, (double)f14).func_181675_d();
        bufferbuilder.func_181662_b((double)f17, -100.0, (double)(-f17)).func_187315_a((double)f22, (double)f23).func_181675_d();
        bufferbuilder.func_181662_b((double)(-f17), -100.0, (double)(-f17)).func_187315_a((double)f24, (double)f23).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.disableTexture();
        float f15 = world.func_72880_h(partialTicks) * f16;
        if (f15 > 0.0f) {
            GlStateManager.color4f((float)f15, (float)f15, (float)f15, (float)f15);
            if (this.vboEnabled) {
                this.starVBO.func_177359_a();
                GlStateManager.enableClientState((int)32884);
                GlStateManager.vertexPointer((int)3, (int)5126, (int)12, (int)0);
                this.starVBO.func_177358_a(7);
                VertexBuffer.func_177361_b();
                GlStateManager.disableClientState((int)32884);
            } else {
                GlStateManager.callList((int)this.starGLCallList);
            }
        }
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.disableBlend();
        GlStateManager.enableAlphaTest();
        GlStateManager.enableFog();
        GlStateManager.popMatrix();
        GlStateManager.disableTexture();
        GlStateManager.color3f((float)0.0f, (float)0.0f, (float)0.0f);
        double d3 = mc.field_71439_g.func_174824_e((float)partialTicks).field_72448_b - world.func_72919_O();
        if (d3 < 0.0) {
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)0.0f, (float)12.0f, (float)0.0f);
            if (this.vboEnabled) {
                this.sky2VBO.func_177359_a();
                GlStateManager.enableClientState((int)32884);
                GlStateManager.vertexPointer((int)3, (int)5126, (int)12, (int)0);
                this.sky2VBO.func_177358_a(7);
                VertexBuffer.func_177361_b();
                GlStateManager.disableClientState((int)32884);
            } else {
                GlStateManager.callList((int)this.glSkyList2);
            }
            GlStateManager.popMatrix();
            float f19 = -((float)(d3 + 65.0));
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            bufferbuilder.func_181662_b(-1.0, (double)f19, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(1.0, (double)f19, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(-1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(-1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(1.0, (double)f19, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(-1.0, (double)f19, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(1.0, (double)f19, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(1.0, (double)f19, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(-1.0, (double)f19, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(-1.0, (double)f19, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(-1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(-1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(-1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(-1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            tessellator.func_78381_a();
        }
        if (player.field_70170_p.func_180494_b((player = Minecraft.func_71410_x().field_71439_g).func_180425_c()) instanceof GallifrayanWastelands) {
            f = 0.14f;
            f1 = 0.15f;
            f2 = 0.22f;
        }
        if (!world.field_73011_w.func_76561_g()) {
            GlStateManager.color3f((float)(f * 0.2f + 0.04f), (float)(f1 * 0.2f + 0.04f), (float)(f2 * 0.6f + 0.1f));
        } else {
            GlStateManager.color3f((float)f, (float)f1, (float)f2);
        }
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)0.0f, (float)(-((float)(d3 - 16.0))), (float)0.0f);
        GlStateManager.callList((int)this.glSkyList2);
        GlStateManager.popMatrix();
        GlStateManager.enableTexture();
        GlStateManager.depthMask((boolean)true);
    }
}

