/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.common.entity;

import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import me.swirtzly.regeneration.common.advancements.TriggerManager;
import me.swirtzly.regeneration.common.capability.IRegen;
import me.swirtzly.regeneration.common.capability.RegenCap;
import me.swirtzly.regeneration.common.entity.LaserEntity;
import me.swirtzly.regeneration.common.entity.ai.TimelordMelee;
import me.swirtzly.regeneration.common.item.GunItem;
import me.swirtzly.regeneration.common.skin.HandleSkins;
import me.swirtzly.regeneration.common.trades.TimelordTrades;
import me.swirtzly.regeneration.common.types.RegenTypes;
import me.swirtzly.regeneration.handlers.RegenObjects;
import me.swirtzly.regeneration.util.common.PlayerUtil;
import me.swirtzly.regeneration.util.common.RegenUtil;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TradeWithPlayerGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.stats.Stats;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class TimelordEntity
extends AbstractVillagerEntity
implements IRangedAttackMob {
    private static final DataParameter<String> TYPE = EntityDataManager.func_187226_a(TimelordEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Boolean> SWINGING_ARMS = EntityDataManager.func_187226_a(TimelordEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> VILLAGER = EntityDataManager.func_187226_a(TimelordEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private final SwimmerPathNavigator waterNavigator;
    private final GroundPathNavigator groundNavigator;

    public TimelordEntity(World world) {
        this((EntityType<TimelordEntity>)((EntityType)RegenObjects.EntityEntries.TIMELORD.get()), world);
    }

    public TimelordEntity(EntityType<TimelordEntity> entityEntityType, World world) {
        super(entityEntityType, world);
        this.waterNavigator = new SwimmerPathNavigator((MobEntity)this, world);
        this.groundNavigator = new GroundPathNavigator((MobEntity)this, world);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(VILLAGER, (Object)false);
        this.func_184212_Q().func_187214_a(TYPE, (Object)(this.field_70146_Z.nextBoolean() ? TimelordType.COUNCIL.name() : TimelordType.GUARD.name()));
        this.func_184212_Q().func_187214_a(SWINGING_ARMS, (Object)false);
    }

    public void func_205343_av() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70613_aW() && this.func_70090_H()) {
                this.field_70699_by = this.waterNavigator;
                this.func_204711_a(true);
            } else {
                this.field_70699_by = this.groundNavigator;
                this.func_204711_a(false);
            }
        }
    }

    public void setSwingingArms(boolean swingingArms) {
        this.func_184212_Q().func_187227_b(SWINGING_ARMS, (Object)swingingArms);
    }

    public boolean isSwingingArms() {
        return (Boolean)this.func_184212_Q().func_187225_a(SWINGING_ARMS);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new TradeWithPlayerGoal((AbstractVillagerEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new TimelordMelee(this, 1.2f, true));
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        if (this.getTimelordType() == TimelordType.GUARD) {
            this.field_70714_bg.func_75776_a(1, (Goal)new RangedAttackGoal((IRangedAttackMob)this, 1.25, 15, 20.0f));
        }
        this.func_175456_n();
    }

    protected void func_175456_n() {
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[]{TimelordEntity.class}));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, ZombieEntity.class, false));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, SkeletonEntity.class, false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(2.0);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (!worldIn.func_201670_d()) {
            if (this.getTimelordType() == TimelordType.GUARD) {
                this.func_184611_a(Hand.MAIN_HAND, new ItemStack(this.field_70146_Z.nextBoolean() ? (IItemProvider)RegenObjects.Items.PISTOL.get() : (IItemProvider)RegenObjects.Items.RIFLE.get()));
            }
            RegenCap.get((Entity)this).ifPresent(data -> {
                data.receiveRegenerations(worldIn.func_201674_k().nextInt(12));
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74776_a("PrimaryRed", (float)this.field_70146_Z.nextInt(255) / 255.0f);
                nbt.func_74776_a("PrimaryGreen", (float)this.field_70146_Z.nextInt(255) / 255.0f);
                nbt.func_74776_a("PrimaryBlue", (float)this.field_70146_Z.nextInt(255) / 255.0f);
                nbt.func_74776_a("SecondaryRed", (float)this.field_70146_Z.nextInt(255) / 255.0f);
                nbt.func_74776_a("SecondaryGreen", (float)this.field_70146_Z.nextInt(255) / 255.0f);
                nbt.func_74776_a("SecondaryBlue", (float)this.field_70146_Z.nextInt(255) / 255.0f);
                data.setStyle(nbt);
                data.setRegenType(this.field_70146_Z.nextBoolean() ? RegenTypes.FIERY : RegenTypes.HARTNELL);
                this.initSkin((IRegen)data);
                data.synchronise();
            });
        }
        this.func_200203_b((ITextComponent)new StringTextComponent(RegenUtil.TIMELORD_NAMES[this.field_70146_Z.nextInt(RegenUtil.TIMELORD_NAMES.length)]));
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void initSkin(IRegen data) {
        File file = HandleSkins.chooseRandomTimelordSkin(this.field_70170_p.field_73012_v);
        data.setEncodedSkin(HandleSkins.imageToPixelData(file));
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        if (this.func_184614_ca().func_77973_b() instanceof GunItem) {
            GunItem gunItem = (GunItem)this.func_184614_ca().func_77973_b();
            LaserEntity laserEntity = new LaserEntity((EntityType)RegenObjects.EntityEntries.LASER.get(), (LivingEntity)this, this.field_70170_p);
            laserEntity.setColor(new Vec3d(1.0, 0.0, 0.0));
            laserEntity.setDamage(gunItem.getDamage());
            double d0 = target.field_70165_t - this.field_70165_t;
            double d1 = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 3.0f) - laserEntity.field_70163_u;
            double d2 = target.field_70161_v - this.field_70161_v;
            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            laserEntity.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4);
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.func_184614_ca().func_77973_b() == RegenObjects.Items.PISTOL.get() ? (SoundEvent)RegenObjects.Sounds.STASER.get() : (SoundEvent)RegenObjects.Sounds.RIFLE.get(), SoundCategory.NEUTRAL, 0.5f, 0.4f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
            this.field_70170_p.func_217376_c((Entity)laserEntity);
        }
    }

    public void setTimelordType(TimelordType type) {
        this.func_184212_Q().func_187227_b(TYPE, (Object)type.name());
    }

    public TimelordType getTimelordType() {
        String type = (String)this.func_184212_Q().func_187225_a(TYPE);
        for (TimelordType value : TimelordType.values()) {
            if (!value.name().equals(type)) continue;
            return value;
        }
        return TimelordType.GUARD;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        RegenCap.get((Entity)this).ifPresent(data -> {
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70173_aa < 20) {
                    data.synchronise();
                }
                if (data.getState() == PlayerUtil.RegenState.REGENERATING) {
                    if (data.getAnimationTicks() == 100) {
                        this.setVillager(false);
                        this.initSkin((IRegen)data);
                    }
                    this.func_94061_f(true);
                    this.func_184224_h(true);
                } else {
                    this.func_94061_f(false);
                    this.func_184224_h(false);
                }
            }
        });
    }

    public Boolean isVillagerModel() {
        return (Boolean)this.func_184212_Q().func_187225_a(VILLAGER);
    }

    public void setVillager(boolean villager) {
        this.func_184212_Q().func_187227_b(VILLAGER, (Object)villager);
    }

    @Nullable
    public AgeableEntity func_90011_a(AgeableEntity ageable) {
        return null;
    }

    protected void func_213713_b(MerchantOffer merchantOffer) {
        if (merchantOffer.func_222221_q()) {
            int i = 3 + this.field_70146_Z.nextInt(4);
            this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, i));
        }
    }

    public boolean func_213705_dZ() {
        return false;
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        if (this.getTimelordType() == TimelordType.COUNCIL) {
            boolean flag;
            if (!this.field_70170_p.field_72995_K) {
                TriggerManager.TIMELORD_TRADE.trigger((ServerPlayerEntity)player);
            }
            AtomicBoolean atomicBoolean = new AtomicBoolean();
            atomicBoolean.set(false);
            RegenCap.get((Entity)this).ifPresent(data -> {
                if (data.getState() == PlayerUtil.RegenState.REGENERATING) {
                    atomicBoolean.set(true);
                }
            });
            if (atomicBoolean.get()) {
                return true;
            }
            ItemStack itemstack = player.func_184586_b(hand);
            boolean bl = flag = itemstack.func_77973_b() == Items.field_151057_cb;
            if (flag) {
                itemstack.func_111282_a(player, (LivingEntity)this, hand);
                return true;
            }
            if (itemstack.func_77973_b() != Items.field_196172_da && this.func_70089_S() && !this.func_213716_dX() && !this.func_70631_g_()) {
                if (hand == Hand.MAIN_HAND) {
                    player.func_195066_a(Stats.field_188074_H);
                }
                if (this.func_213706_dY().isEmpty()) {
                    return super.func_184645_a(player, hand);
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70932_a_(player);
                    this.func_213707_a(player, this.func_145748_c_(), 1);
                }
                return true;
            }
            return super.func_184645_a(player, hand);
        }
        return super.func_184645_a(player, hand);
    }

    public void func_174812_G() {
        this.func_70106_y();
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("villager", this.isVillagerModel().booleanValue());
        compound.func_74778_a("timelord_type", this.getTimelordType().name());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setVillager(compound.func_74767_n("villager"));
        if (compound.func_74764_b("timelord_type")) {
            this.setTimelordType(TimelordType.valueOf(compound.func_74779_i("timelord_type")));
        }
    }

    protected void func_213712_ef() {
        VillagerTrades.ITrade[] trades;
        if (this.getTimelordType() == TimelordType.COUNCIL && (trades = TimelordTrades.genTrades()) != null) {
            MerchantOffers merchantoffers = this.func_213706_dY();
            this.func_213717_a(merchantoffers, trades, 5);
        }
    }

    public static enum TimelordType {
        COUNCIL("timelord"),
        GUARD("guards");

        private final String name;

        private TimelordType(String guard) {
            this.name = guard;
        }

        public String getName() {
            return this.name;
        }
    }
}

