/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.common.item;

import me.swirtzly.regeneration.RegenConfig;
import me.swirtzly.regeneration.Regeneration;
import me.swirtzly.regeneration.common.capability.IRegen;
import me.swirtzly.regeneration.common.capability.RegenCap;
import me.swirtzly.regeneration.common.entity.OverrideEntity;
import me.swirtzly.regeneration.common.item.ItemGroups;
import me.swirtzly.regeneration.common.item.SolidItem;
import me.swirtzly.regeneration.handlers.RegenObjects;
import me.swirtzly.regeneration.util.client.ClientUtil;
import me.swirtzly.regeneration.util.common.PlayerUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class FobWatchItem
extends SolidItem {
    public FobWatchItem() {
        super(new Item.Properties().setNoRepair().func_200916_a(ItemGroups.REGEN_TAB).func_200917_a(1));
        this.func_185043_a(new ResourceLocation("open"), (stack, worldIn, entityIn) -> {
            if (FobWatchItem.getStackTag(stack) == null || !FobWatchItem.getStackTag(stack).func_74764_b("open")) {
                return 0.0f;
            }
            return FobWatchItem.getOpen(stack);
        });
        this.func_185043_a(new ResourceLocation("engrave"), (stack, worldIn, entityIn) -> {
            if (FobWatchItem.getStackTag(stack) == null || !FobWatchItem.getStackTag(stack).func_74764_b("engrave")) {
                return 0.0f;
            }
            return FobWatchItem.getEngrave(stack);
        });
    }

    public static CompoundNBT getStackTag(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new CompoundNBT());
            stack.func_77978_p().func_74768_a("open", 0);
            stack.func_77978_p().func_74768_a("engrave", field_77697_d.nextInt(2));
        }
        return stack.func_77978_p();
    }

    public static int getEngrave(ItemStack stack) {
        return FobWatchItem.getStackTag(stack).func_74762_e("engrave");
    }

    public static void setEngrave(ItemStack stack, int engrave) {
        FobWatchItem.getStackTag(stack).func_74768_a("engrave", engrave);
    }

    public static int getOpen(ItemStack stack) {
        return FobWatchItem.getStackTag(stack).func_74762_e("open");
    }

    public static void setOpen(ItemStack stack, int amount) {
        FobWatchItem.getStackTag(stack).func_74768_a("open", amount);
    }

    public void func_77622_d(ItemStack stack, World worldIn, PlayerEntity playerIn) {
        super.func_77622_d(stack, worldIn, playerIn);
        stack.func_196085_b(0);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new CompoundNBT());
            stack.func_77978_p().func_74757_a("live", true);
        } else {
            stack.func_77978_p().func_74757_a("live", true);
        }
        if (FobWatchItem.getOpen(stack) == 1 && entityIn.field_70173_aa % 600 == 0) {
            FobWatchItem.setOpen(stack, 0);
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        IRegen cap = (IRegen)RegenCap.get((Entity)player).orElseGet(null);
        if (!player.func_70093_af()) {
            if (stack.func_77952_i() == ((Integer)RegenConfig.COMMON.regenCapacity.get()).intValue()) {
                return this.msgUsageFailed(player, "regeneration.messages.transfer.empty_watch", stack);
            }
            if (cap.getRegenerationsLeft() == ((Integer)RegenConfig.COMMON.regenCapacity.get()).intValue()) {
                return this.msgUsageFailed(player, "regeneration.messages.transfer.max_regens", stack);
            }
            int supply = (Integer)RegenConfig.COMMON.regenCapacity.get() - stack.func_77952_i();
            int needed = (Integer)RegenConfig.COMMON.regenCapacity.get() - cap.getRegenerationsLeft();
            int used = Math.min(supply, needed);
            if (cap.canRegenerate()) {
                FobWatchItem.setOpen(stack, 1);
                if (world.field_72995_K) {
                    PlayerUtil.sendMessage((LivingEntity)player, new TranslationTextComponent("regeneration.messages.gained_regens", new Object[]{used}), true);
                }
            } else if (!world.field_72995_K) {
                FobWatchItem.setOpen(stack, 1);
            } else {
                PlayerUtil.sendMessage((LivingEntity)player, new TranslationTextComponent("regeneration.messages.now_timelord", new Object[0]), true);
            }
            if (used < 0) {
                Regeneration.LOG.warn(player.func_200200_C_() + ": Fob watch used <0 regens (supply: " + supply + ", needed:" + needed + ", used:" + used + ", capacity:" + RegenConfig.COMMON.regenCapacity.get() + ", damage:" + stack.func_77952_i() + ", regens:" + cap.getRegenerationsLeft());
            }
            stack.func_196085_b(stack.func_77952_i() + used);
            if (world.field_72995_K) {
                FobWatchItem.setOpen(stack, 1);
                ClientUtil.playPositionedSoundRecord((SoundEvent)RegenObjects.Sounds.FOB_WATCH.get(), 1.0f, 2.0f);
            } else {
                cap.receiveRegenerations(used);
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        if (!cap.canRegenerate()) {
            return this.msgUsageFailed(player, "regeneration.messages.transfer.no_regens", stack);
        }
        if (cap.getState() != PlayerUtil.RegenState.ALIVE) {
            return this.msgUsageFailed(player, "regeneration.messages.not_alive", stack);
        }
        if (stack.func_77952_i() == 0) {
            return this.msgUsageFailed(player, "regeneration.messages.transfer.full_watch", stack);
        }
        stack.func_196085_b(stack.func_77952_i() - 1);
        PlayerUtil.sendMessage((LivingEntity)player, "regeneration.messages.transfer.success", true);
        if (world.field_72995_K) {
            ClientUtil.playPositionedSoundRecord(SoundEvents.field_187646_bt, 5.0f, 2.0f);
        } else {
            FobWatchItem.setOpen(stack, 1);
            cap.extractRegeneration(1);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    private ActionResult<ItemStack> msgUsageFailed(PlayerEntity player, String message, ItemStack stack) {
        PlayerUtil.sendMessage((LivingEntity)player, message, true);
        return ActionResult.newResult((ActionResultType)ActionResultType.FAIL, (Object)stack);
    }

    @Override
    public boolean onSolidEntityItemUpdate(OverrideEntity itemOverride) {
        if (!itemOverride.field_70170_p.field_72995_K) {
            return false;
        }
        ItemStack itemStack = itemOverride.getItem();
        if (itemStack.func_77973_b() == this && itemStack.func_77952_i() != ((Integer)RegenConfig.COMMON.regenCapacity.get()).intValue() && (itemOverride.field_70173_aa % 5000 == 0 || itemOverride.field_70173_aa == 2)) {
            ClientUtil.playSound((Object)itemOverride, ((SoundEvent)RegenObjects.Sounds.FOB_WATCH_DIALOGUE.get()).getRegistryName(), SoundCategory.AMBIENT, false, () -> !itemOverride.func_70089_S(), 1.5f);
        }
        return true;
    }

    public int getMaxDamage(ItemStack stack) {
        return (Integer)RegenConfig.COMMON.regenCapacity.get();
    }
}

