/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.common.item;

import me.swirtzly.regeneration.common.entity.LaserEntity;
import me.swirtzly.regeneration.common.entity.OverrideEntity;
import me.swirtzly.regeneration.common.item.ItemGroups;
import me.swirtzly.regeneration.common.item.SolidItem;
import me.swirtzly.regeneration.handlers.RegenObjects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class GunItem
extends SolidItem {
    private final int cooldown;
    private final float damage;

    public GunItem(int shotsPerRound, int cooldown, float damage) {
        super(new Item.Properties().func_200916_a(ItemGroups.REGEN_TAB).func_200918_c(shotsPerRound).setNoRepair());
        this.cooldown = cooldown;
        this.damage = damage;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        return super.func_195939_a(context);
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof PlayerEntity) {
            PlayerEntity playerIn = (PlayerEntity)entityLiving;
            if (stack.func_77952_i() < stack.func_77958_k() && !playerIn.func_184811_cZ().func_185141_a((Item)this)) {
                worldIn.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, this == RegenObjects.Items.PISTOL.get() ? (SoundEvent)RegenObjects.Sounds.STASER.get() : (SoundEvent)RegenObjects.Sounds.RIFLE.get(), SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
                playerIn.func_184811_cZ().func_185145_a((Item)this, this.cooldown);
                this.setDamage(stack, this.getDamage(stack) + 1);
                if (!worldIn.field_72995_K) {
                    LaserEntity entity = new LaserEntity((EntityType)RegenObjects.EntityEntries.LASER.get(), (LivingEntity)playerIn, playerIn.field_70170_p);
                    entity.setColor(new Vec3d(1.0, 0.0, 0.0));
                    entity.setDamage(this.damage);
                    entity.func_184538_a((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, 0.0f, 1.5f, 1.0f);
                    worldIn.func_217376_c((Entity)entity);
                }
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        playerIn.func_184598_c(handIn);
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (entityIn.field_70173_aa % 100 == 0 && this.getDamage(stack) > 0) {
            this.setDamage(stack, this.getDamage(stack) - 1);
        }
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new CompoundNBT());
            stack.func_77978_p().func_74757_a("live", true);
        } else {
            stack.func_77978_p().func_74757_a("live", true);
        }
    }

    public float getDamage() {
        return this.damage;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    @Override
    public boolean onSolidEntityItemUpdate(OverrideEntity entity) {
        return super.onSolidEntityItemUpdate(entity);
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        return false;
    }
}

