/*
 * Decompiled with CFR 0.152.
 */
package me.swirtzly.regeneration.common.item;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import javax.annotation.Nullable;
import me.swirtzly.regeneration.client.skinhandling.SkinInfo;
import me.swirtzly.regeneration.common.item.ItemGroups;
import me.swirtzly.regeneration.common.traits.TraitManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.UsernameCache;

public class HandItem
extends Item {
    public HandItem() {
        super(new Item.Properties().func_200917_a(1).setNoRepair().func_200916_a(ItemGroups.REGEN_TAB));
        this.func_185043_a(new ResourceLocation("skin_type"), (stack, worldIn, entityIn) -> HandItem.getSkinType(stack).equals("ALEX") ? 1.0f : 0.0f);
    }

    public static void setTimeCreated(ItemStack stack, long created) {
        HandItem.getStackTag(stack).func_74772_a("created", created);
    }

    public static long getTimeCreated(ItemStack stack) {
        return HandItem.getStackTag(stack).func_74763_f("created");
    }

    public static void setTextureString(ItemStack stack, String encodedTexture) {
        HandItem.getStackTag(stack).func_74778_a("encodedTexture", encodedTexture);
    }

    public static String getTextureString(ItemStack stack) {
        return HandItem.getStackTag(stack).func_74779_i("encodedTexture");
    }

    public static void setSkinType(ItemStack stack, String skinType) {
        HandItem.getStackTag(stack).func_74778_a("skinType", skinType);
    }

    public static String getSkinType(ItemStack stack) {
        return HandItem.getStackTag(stack).func_74779_i("skinType");
    }

    public static void setTrait(ItemStack stack, String trait) {
        HandItem.getStackTag(stack).func_74778_a("trait", trait);
    }

    public static String getTrait(ItemStack stack) {
        return HandItem.getStackTag(stack).func_74779_i("trait");
    }

    public static void setOwner(ItemStack stack, UUID owner) {
        HandItem.getStackTag(stack).func_186854_a("owner", owner);
    }

    public static UUID getOwner(ItemStack stack) {
        return HandItem.getStackTag(stack).func_186857_a("owner");
    }

    public static CompoundNBT getStackTag(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new CompoundNBT());
            stack.func_77978_p().func_74778_a("encodedTexture", "NONE");
            stack.func_77978_p().func_74778_a("skinType", SkinInfo.SkinType.ALEX.name());
            stack.func_77978_p().func_186854_a("owner", UUID.fromString("96511168-1bb3-4ff0-a894-271e42606a39"));
            stack.func_77978_p().func_74772_a("created", 0L);
            stack.func_77978_p().func_74778_a("trait", TraitManager.DNA_BORING.getRegistryName().toString());
        }
        return stack.func_77978_p();
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return new TranslationTextComponent("item.regeneration.hand", new Object[]{UsernameCache.getLastKnownUsername((UUID)HandItem.getOwner(stack))});
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        Date date = new Date(HandItem.getTimeCreated(stack));
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/YYYY @ HH:mm");
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        String dateFormatted = formatter.format(date);
        tooltip.add((ITextComponent)new TranslationTextComponent("nbt.regeneration.created", new Object[]{dateFormatted}));
        tooltip.add((ITextComponent)new TranslationTextComponent(TraitManager.getDnaEntry(new ResourceLocation(HandItem.getTrait(stack))).getLangKey(), new Object[0]));
    }
}

